/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.render;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.animation.IAnimationTimer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lnet/barribob/boss/render/FrameLimiter;", "", "", "framesPerUnit", "Lnet/barribob/boss/animation/IAnimationTimer;", "timer", "<init>", "(FLnet/barribob/boss/animation/IAnimationTimer;)V", "", "canDoFrame", "()Z", "minimumFrameDelta", "F", "", "previousTime", "D", "getPreviousTime", "()D", "setPreviousTime", "(D)V", "Lnet/barribob/boss/animation/IAnimationTimer;", "BOMD"})
public final class FrameLimiter {
    @NotNull
    private final IAnimationTimer timer;
    private final float minimumFrameDelta;
    private double previousTime;

    public FrameLimiter(float framesPerUnit, @NotNull IAnimationTimer timer) {
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        this.timer = timer;
        this.minimumFrameDelta = 1.0f / framesPerUnit;
    }

    public final double getPreviousTime() {
        return this.previousTime;
    }

    public final void setPreviousTime(double d) {
        this.previousTime = d;
    }

    public final boolean canDoFrame() {
        double currentTick = this.timer.getCurrentTick();
        double frameDelta = currentTick - this.previousTime;
        if (frameDelta >= (double)this.minimumFrameDelta) {
            this.previousTime = currentTick;
            return true;
        }
        return false;
    }
}

