/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.util;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IBetterDragonFight;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1511;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import org.jetbrains.annotations.Nullable;

public class EndCrystalUtils {
    private static final int BEI_CRYSTAL_RADIUS = 7;
    private static final int VANILLA_CRYSTAL_RADIUS = 2;

    public static List<class_1511> checkForBEIRespawnCrystals(@Nullable class_1937 level, class_2338 centerPos) {
        ArrayList foundCrystals = Lists.newArrayList();
        if (level == null) {
            return foundCrystals;
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_238 crystalCheckbox = new class_238(centerPos.method_10079(direction, 7));
            List crystalsInDirection = level.method_18467(class_1511.class, crystalCheckbox);
            foundCrystals.addAll(crystalsInDirection);
        }
        return foundCrystals;
    }

    public static List<class_1511> checkForVanillaRespawnCrystals(@Nullable class_1937 level, IBetterDragonFight dragonFight, class_2338 portalPos) {
        class_2338 centerPos = portalPos.method_10087(2);
        if (!dragonFight.hasDragonEverSpawned() && !BetterEndIslandCommon.CONFIG.spawnCentralTowerInitially) {
            centerPos = centerPos.method_10086(4);
        } else if (dragonFight.hasDragonEverSpawned() && !BetterEndIslandCommon.CONFIG.spawnCentralTowerInitially && !BetterEndIslandCommon.CONFIG.spawnCentralTowerOnResummon) {
            centerPos = centerPos.method_10086(4);
        }
        ArrayList foundCrystals = Lists.newArrayList();
        if (level == null) {
            return foundCrystals;
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_238 crystalCheckbox = new class_238(centerPos.method_10079(direction, 2));
            List crystalsInDirection = level.method_18467(class_1511.class, crystalCheckbox);
            foundCrystals.addAll(crystalsInDirection);
        }
        return foundCrystals;
    }
}

