/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.mixin;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.DragonRespawnStage;
import com.yungnickyoung.minecraft.betterendisland.world.IBetterDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterEndPodiumFeature;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterEndSpawnPlatformFeature;
import com.yungnickyoung.minecraft.betterendisland.world.util.EndCrystalUtils;
import com.yungnickyoung.minecraft.betterendisland.world.util.EndSpikeUtils;
import com.yungnickyoung.minecraft.betterendisland.world.util.ExitPortalUtils;
import com.yungnickyoung.minecraft.betterendisland.world.util.WorldgenUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2700;
import net.minecraft.class_2876;
import net.minecraft.class_2881;
import net.minecraft.class_3033;
import net.minecraft.class_3037;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_9829;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2881.class})
public abstract class EndDragonFightMixin
implements IBetterDragonFight {
    @Shadow
    @Final
    private class_3213 field_13119;
    @Shadow
    private boolean field_13115;
    @Shadow
    private int field_13122;
    @Shadow
    @Final
    private class_3218 field_13108;
    @Shadow
    private boolean field_13111;
    @Shadow
    @Nullable
    private List<class_1511> field_13109;
    @Shadow
    private int field_13118;
    @Shadow
    @Nullable
    private class_2338 field_13117;
    @Shadow
    @Nullable
    private UUID field_13116;
    @Shadow
    private int field_13107;
    @Shadow
    private int field_13105;
    @Shadow
    private boolean field_13114;
    @Shadow
    private int field_13106;
    @Shadow
    @Nullable
    private class_2876 field_13120;
    @Shadow
    @Final
    private ObjectArrayList<Integer> field_13121;
    @Unique
    private DragonRespawnStage bei$dragonRespawnStage;
    @Unique
    private boolean bei$isFirstExitPortalSpawn = true;
    @Unique
    private boolean bei$hasDragonEverSpawned;
    @Unique
    private int bei$numTimesDragonKilled = 0;

    @Shadow
    public abstract void method_12524();

    @Shadow
    public abstract void method_12522();

    @Shadow
    protected abstract void method_12520();

    @Shadow
    protected abstract boolean method_12533();

    @Shadow
    protected abstract void method_12525();

    @Shadow
    protected abstract void method_12535();

    @Shadow
    protected abstract class_1510 method_12523();

    @Shadow
    @Nullable
    protected abstract class_2700.class_2702 method_12531();

    @Shadow
    protected abstract void method_12529(List<class_1511> var1);

    @Shadow
    protected abstract boolean method_12514();

    @Shadow
    protected abstract void method_12519();

    @Inject(method={"<init>(Lnet/minecraft/server/level/ServerLevel;JLnet/minecraft/world/level/dimension/end/EndDragonFight$Data;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="RETURN")})
    public void betterendisland_EndDragonFight(class_3218 level, long seed, class_2881.class_8576 data, class_2338 origin, CallbackInfo ci) {
        if (data.comp_1543()) {
            this.bei$dragonRespawnStage = DragonRespawnStage.START;
        }
        this.field_13119.method_14091(false);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_tickFight(CallbackInfo ci) {
        this.field_13119.method_14091(!this.field_13115 && this.bei$hasDragonEverSpawned);
        if (++this.field_13122 >= 20) {
            this.method_12520();
            this.field_13122 = 0;
        }
        if (!this.field_13119.method_14092().isEmpty()) {
            this.field_13108.method_14178().method_17297(class_3230.field_17264, new class_1923(0, 0), 9, (Object)class_3902.field_17274);
            boolean isArenaLoaded = this.method_12533();
            if (this.field_13111 && isArenaLoaded) {
                this.scanForInitialState();
                this.field_13111 = false;
            }
            if (this.bei$dragonRespawnStage != null) {
                if (this.field_13109 == null && isArenaLoaded) {
                    this.bei$dragonRespawnStage = null;
                    this.method_12522();
                }
                this.bei$dragonRespawnStage.tick(this.field_13108, (class_2881)this, this.field_13109, this.field_13118++);
            }
            if (!this.field_13115) {
                if ((this.field_13116 == null || ++this.field_13107 >= 1200) && isArenaLoaded && this.bei$hasDragonEverSpawned) {
                    this.method_12525();
                    this.field_13107 = 0;
                }
                if (++this.field_13105 >= 100 && isArenaLoaded) {
                    this.method_12535();
                    this.field_13105 = 0;
                }
            }
        } else {
            this.field_13108.method_14178().method_17300(class_3230.field_17264, new class_1923(0, 0), 9, (Object)class_3902.field_17274);
        }
        ci.cancel();
    }

    @Override
    @Unique
    public void reset(boolean forcePortalPosReset) {
        List dragons = this.field_13108.method_18776();
        dragons.forEach(class_1297::method_31472);
        this.field_13119.method_5408(0.0f);
        this.field_13119.method_14091(false);
        if (this.field_13117 == null || this.field_13117.method_10264() < 5 || forcePortalPosReset) {
            BetterEndIslandCommon.LOGGER.info("Tried to reset, but need to find the portal first.");
            if (this.field_13117 == null) {
                BetterEndIslandCommon.LOGGER.info("Portal location is currently null.");
            } else if (this.field_13117.method_10264() < 5) {
                BetterEndIslandCommon.LOGGER.info("Portal location is currently too low: {}", (Object)this.field_13117.method_10264());
            } else {
                BetterEndIslandCommon.LOGGER.info("Forcing portal position reset...");
            }
            this.method_12531();
            if (this.field_13117 == null || this.field_13117.method_10264() < 5 || forcePortalPosReset) {
                if (this.field_13117 == null) {
                    BetterEndIslandCommon.LOGGER.info("Portal location is still null. Placing manually...");
                } else if (this.field_13117.method_10264() < 5) {
                    BetterEndIslandCommon.LOGGER.info("Portal location is still too low: {}. Placing manually...", (Object)this.field_13117.method_10264());
                }
                this.field_13117 = new class_2338(0, WorldgenUtils.getSurfacePosAt((class_1937)this.field_13108, 0, 0), 0);
                while (this.field_13108.method_8320(this.field_13117).method_27852(class_2246.field_9987) && this.field_13117.method_10264() > this.field_13108.method_8615()) {
                    this.field_13117 = this.field_13117.method_10074();
                }
                if (this.field_13117.method_10264() < 5) {
                    BetterEndIslandCommon.LOGGER.info("Portal was still placed too low! Force placing at y=65...");
                    this.field_13117 = new class_2338(this.field_13117.method_10263(), 65, this.field_13117.method_10260());
                }
            }
        }
        this.field_13116 = null;
        this.field_13115 = false;
        this.field_13114 = false;
        this.bei$isFirstExitPortalSpawn = false;
        this.bei$hasDragonEverSpawned = false;
        this.bei$numTimesDragonKilled = 0;
        this.bei$dragonRespawnStage = null;
        this.field_13120 = null;
        this.field_13118 = 0;
        this.field_13111 = true;
        this.field_13122 = 0;
        this.field_13107 = 0;
        this.field_13106 = 0;
        this.field_13105 = 0;
        if (this.field_13109 != null) {
            this.field_13109.forEach(class_1297::method_31472);
        }
        this.field_13109 = null;
        List<class_1511> remainingSummoningCrystals = EndCrystalUtils.checkForBEIRespawnCrystals((class_1937)this.field_13108, this.field_13117.method_10086(1));
        remainingSummoningCrystals.forEach(class_1297::method_31472);
        remainingSummoningCrystals = EndCrystalUtils.checkForVanillaRespawnCrystals((class_1937)this.field_13108, this, this.field_13117);
        remainingSummoningCrystals.forEach(class_1297::method_31472);
        List allSpikes = class_3310.method_14506((class_5281)this.field_13108);
        for (class_3310.class_3181 spike : allSpikes) {
            for (class_1511 crystal : this.field_13108.method_18467(class_1511.class, spike.method_13968())) {
                crystal.method_31472();
            }
        }
        if (BetterEndIslandCommon.CONFIG.spawnCentralTowerInitially) {
            endPodiumFeature = new BetterEndPodiumFeature(true, false, false);
            class_2338 spawnPos = this.field_13117.method_10087(5);
            endPodiumFeature.method_40163((class_3037)class_3037.field_13603, (class_5281)this.field_13108, this.field_13108.method_14178().method_12129(), class_5819.method_43047(), spawnPos);
        } else {
            endPodiumFeature = new class_3033(false);
            if (endPodiumFeature.method_40163((class_3037)class_3037.field_13603, (class_5281)this.field_13108, this.field_13108.method_14178().method_12129(), class_5819.method_43047(), this.field_13117)) {
                int $$2 = class_3532.method_38788((int)4, (int)16);
                this.field_13108.method_14178().field_17254.method_53685(new class_1923(this.field_13117), $$2);
            }
        }
        EndSpikeUtils.removeVanillaPillars(this.field_13108);
        EndSpikeUtils.resetSpikes(this.field_13108, allSpikes);
        class_2338 platformPos = class_3218.field_25144.method_10074();
        if (BetterEndIslandCommon.CONFIG.useVanillaSpawnPlatform) {
            class_9829.method_61118((class_5425)this.field_13108, (class_2338)platformPos, (boolean)false);
        } else {
            BetterEndSpawnPlatformFeature.place((class_5425)this.field_13108, platformPos, false);
        }
        for (int i = 0; i < 20; ++i) {
            int x = class_3532.method_15357((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            int z = class_3532.method_15357((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            class_2338 gatePos = new class_2338(x, 75, z);
            class_2338.method_10097((class_2338)gatePos.method_10069(-1, -4, -1), (class_2338)gatePos.method_10069(1, 4, 1)).forEach(pos -> this.field_13108.method_8501(pos, class_2246.field_10124.method_9564()));
        }
        this.field_13121.clear();
        this.field_13121.addAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
        class_156.method_43028(this.field_13121, (class_5819)class_5819.method_43049((long)this.field_13108.method_8412()));
    }

    @Unique
    private void scanForInitialState() {
        BetterEndIslandCommon.LOGGER.info("Scanning for legacy world dragon fight...");
        boolean hasActiveExitPortal = this.method_12514();
        if (hasActiveExitPortal) {
            BetterEndIslandCommon.LOGGER.info("Found that the dragon has been killed in this world already.");
            this.field_13114 = true;
        } else {
            BetterEndIslandCommon.LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.field_13114 = false;
            if (this.method_12531() == null) {
                ExitPortalUtils.spawnPortal(this, this.field_13108, false, false);
            }
        }
        List dragons = this.field_13108.method_18776();
        if (dragons.isEmpty()) {
            this.field_13115 = true;
        } else {
            class_1510 dragon = (class_1510)dragons.get(0);
            this.field_13116 = dragon.method_5667();
            BetterEndIslandCommon.LOGGER.info("Found that there's a dragon still alive ({})", (Object)dragon);
            this.field_13115 = false;
            if (!hasActiveExitPortal) {
                BetterEndIslandCommon.LOGGER.info("But we didn't have a portal, so let's remove the dragon.");
                dragon.method_31472();
                this.field_13116 = null;
            }
        }
        if (!this.field_13114 && this.field_13115) {
            this.field_13115 = false;
        }
    }

    @Inject(method={"onCrystalDestroyed"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_onCrystalDestroyed(class_1511 crystal, class_1282 damageSource, CallbackInfo ci) {
        if (this.bei$dragonRespawnStage != null && this.field_13109 != null && this.field_13109.contains(crystal)) {
            BetterEndIslandCommon.LOGGER.info("Aborting dragon respawn sequence");
            this.bei$dragonRespawnStage = null;
            this.field_13118 = 0;
            this.method_12524();
        } else {
            this.method_12535();
            class_1297 dragonEntity = this.field_13108.method_14190(this.field_13116);
            if (dragonEntity instanceof class_1510) {
                ((class_1510)dragonEntity).method_6828(crystal, crystal.method_24515(), damageSource);
            }
        }
        ci.cancel();
    }

    @Inject(method={"tryRespawn"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_tryRespawn(CallbackInfo ci) {
        if (this.field_13115 && this.bei$dragonRespawnStage == null) {
            this.spawnDragon(false);
        }
        ci.cancel();
    }

    @Override
    @Unique
    public void doInitialDragonSpawn() {
        BetterEndIslandCommon.LOGGER.info("Starting initial dragon fight!");
        this.spawnDragon(true);
    }

    @Unique
    private void spawnDragon(boolean isInitialSpawn) {
        List<class_1511> allCrystals;
        class_2338 portalPos = this.field_13117;
        if (portalPos == null) {
            BetterEndIslandCommon.LOGGER.info("Tried to respawn, but need to find the portal first.");
            class_2700.class_2702 portalPatternMatch = this.method_12531();
            if (portalPatternMatch == null) {
                BetterEndIslandCommon.LOGGER.info("Couldn't find a portal, so we made one.");
                ExitPortalUtils.spawnPortal(this, this.field_13108, false, false);
                ExitPortalUtils.spawnPortal(this, this.field_13108, true, true);
            } else {
                BetterEndIslandCommon.LOGGER.info("Found the exit portal & saved its location for next time.");
            }
            portalPos = this.field_13117;
        }
        if ((allCrystals = EndCrystalUtils.checkForBEIRespawnCrystals((class_1937)this.field_13108, portalPos.method_10086(1))).size() != 4 && (allCrystals = EndCrystalUtils.checkForVanillaRespawnCrystals((class_1937)this.field_13108, this, portalPos)).size() != 4) {
            if (isInitialSpawn) {
                BetterEndIslandCommon.LOGGER.info("Unable to find all 4 summoning crystals. This shouldn't happen!");
            }
            return;
        }
        if (isInitialSpawn) {
            BetterEndIslandCommon.LOGGER.info("Found all crystals, starting initial dragon spawn.");
        } else {
            BetterEndIslandCommon.LOGGER.info("Found all crystals, respawning dragon.");
        }
        this.method_12529(allCrystals);
    }

    @Inject(method={"respawnDragon"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterendisland_respawnDragon(List<class_1511> crystals, CallbackInfo ci) {
        if ((this.field_13115 || !this.bei$hasDragonEverSpawned) && this.bei$dragonRespawnStage == null) {
            this.bei$dragonRespawnStage = DragonRespawnStage.START;
            this.field_13118 = 0;
            this.field_13109 = crystals;
        }
        ci.cancel();
    }

    @Inject(method={"resetSpikeCrystals"}, at={@At(value="RETURN")})
    public void betterendisland_resetSpikeCrystals(CallbackInfo ci) {
        if (this.field_13109 != null) {
            for (class_1511 crystal : this.field_13109) {
                crystal.method_5684(false);
                crystal.method_6837(null);
            }
        }
    }

    @Inject(method={"setDragonKilled"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_setDragonKilled(class_1510 dragon, CallbackInfo ci) {
        if (dragon.method_5667().equals(this.field_13116)) {
            this.field_13119.method_5408(0.0f);
            this.field_13119.method_14091(false);
            if (this.bei$numTimesDragonKilled == 0 && !BetterEndIslandCommon.CONFIG.spawnCentralTowerInitially && BetterEndIslandCommon.CONFIG.spawnCentralTowerOnResummon) {
                ExitPortalUtils.spawnPortal(this, this.field_13108, false, false);
            }
            ExitPortalUtils.spawnPortal(this, this.field_13108, true, true);
            this.field_13108.method_8437(null, (double)this.field_13117.method_10263(), (double)this.field_13117.method_10264(), (double)this.field_13117.method_10260(), 6.0f, class_1937.class_7867.field_40888);
            this.method_12519();
            if (!this.field_13114 || BetterEndIslandCommon.moreDragonEggs || BetterEndIslandCommon.CONFIG.resummonedDragonDropsEgg) {
                this.field_13108.method_8501(this.field_13117.method_10084(), class_2246.field_10081.method_9564());
            }
            int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
            List spikes = class_3310.method_14506((class_5281)this.field_13108);
            spikes.forEach(spike -> {
                int crystalY = topY + ((IEndSpike)spike).getCrystalYOffset();
                this.field_13108.method_8652(new class_2338(spike.method_13966(), crystalY - 1, spike.method_13967()), class_2246.field_10540.method_9564(), 3);
            });
            this.field_13114 = true;
            this.field_13115 = true;
            ++this.bei$numTimesDragonKilled;
        }
        ci.cancel();
    }

    @Override
    @Unique
    public void advanceRespawnStage(DragonRespawnStage nextStage) {
        if (this.bei$dragonRespawnStage == null) {
            throw new IllegalStateException("Better Dragon respawn isn't in progress, can't skip ahead in the respawn process.");
        }
        this.field_13118 = 0;
        nextStage.onStart(this.field_13108, this);
    }

    @Override
    @Unique
    public void tickBellSound() {
        if (!BetterEndIslandCommon.CONFIG.playBellSound) {
            return;
        }
        if (!this.bei$hasDragonEverSpawned || this.bei$dragonRespawnStage != null) {
            int soundY;
            long gameTime = this.field_13108.method_8510();
            int n = soundY = this.field_13117 == null ? 80 : this.field_13117.method_10264() + 15;
            if (gameTime % 100L == 0L) {
                this.field_13108.method_8396(null, new class_2338(0, soundY, 0), class_3417.field_17265, class_3419.field_15254, 24.0f, 0.5f);
                this.field_13108.method_8396(null, new class_2338(0, soundY, 0), class_3417.field_19167, class_3419.field_15254, 4.0f, 0.9f);
            }
            if (gameTime % 300L == 0L) {
                this.field_13108.method_8396(null, new class_2338(0, 80, 0), class_3417.field_19167, class_3419.field_15254, 24.0f, 0.8f);
            }
        }
    }

    @Override
    @Unique
    public DragonRespawnStage getDragonRespawnStage() {
        return this.bei$dragonRespawnStage;
    }

    @Override
    @Unique
    public boolean isFirstExitPortalSpawn() {
        return this.bei$isFirstExitPortalSpawn;
    }

    @Override
    @Unique
    public boolean hasDragonEverSpawned() {
        return this.bei$hasDragonEverSpawned;
    }

    @Override
    @Unique
    public int getNumTimesDragonKilled() {
        return this.bei$numTimesDragonKilled;
    }

    @Override
    @Unique
    public void setDragonRespawnStage(DragonRespawnStage stage) {
        this.bei$dragonRespawnStage = stage;
    }

    @Override
    @Unique
    public void setIsFirstExitPortalSpawn(boolean bl) {
        this.bei$isFirstExitPortalSpawn = bl;
    }

    @Override
    @Unique
    public void setHasDragonEverSpawned(boolean bl) {
        this.bei$hasDragonEverSpawned = bl;
    }

    @Override
    @Unique
    public void setNumTimesDragonKilled(int i) {
        this.bei$numTimesDragonKilled = i;
    }
}

