/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.world.feature;

import com.mojang.serialization.Codec;
import com.soytutta.mynethersdelight.common.block.PowderyCaneBlock;
import com.soytutta.mynethersdelight.common.block.PowderyFlowerBlock;
import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class PowderyCaneFeature
extends class_3031<class_3111> {
    public PowderyCaneFeature(Codec<class_3111> config) {
        super(config);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 level = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 rand = level.method_8409();
        boolean hasPlacedAny = false;
        int areaSize = 4;
        int numFeatures = 8;
        int centerX = areaSize / 2;
        int centerZ = areaSize / 2;
        for (int i = 0; i < numFeatures; ++i) {
            double distanceToCenter;
            int maxHeight;
            int offsetZ;
            int offsetX = rand.method_43048(areaSize) - centerX;
            class_2338 newPos = origin.method_10069(offsetX, 0, offsetZ = rand.method_43048(areaSize) - centerZ);
            if (!this.placeSingleFeature(level, newPos, rand, maxHeight = (int)Math.max(1.0, 4.0 - (distanceToCenter = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ))), origin, areaSize)) continue;
            hasPlacedAny = true;
        }
        return hasPlacedAny;
    }

    private boolean placeSingleFeature(class_5281 level, class_2338 pos, class_5819 rand, int maxHeight, class_2338 origin, int areaSize) {
        class_2680 powderyCaneBase = (class_2680)MNDBlocks.POWDERY_CANE.get().method_9564().method_11657((class_2769)PowderyCaneBlock.BASE, (Comparable)Boolean.valueOf(true));
        class_2680 powderyCane = MNDBlocks.POWDERY_CANE.get().method_9564();
        class_2680 powderyCaneLeave = (class_2680)MNDBlocks.POWDERY_CANE.get().method_9564().method_11657((class_2769)PowderyCaneBlock.LEAVE, (Comparable)Boolean.valueOf(true));
        class_2680 powderyFlower = (class_2680)MNDBlocks.BULLET_PEPPER.get().method_9564().method_11657((class_2769)PowderyFlowerBlock.AGE, (Comparable)Integer.valueOf(rand.method_43048(1)));
        class_2680 powderyFlowerLIT = (class_2680)((class_2680)MNDBlocks.BULLET_PEPPER.get().method_9564().method_11657((class_2769)PowderyFlowerBlock.LIT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)PowderyFlowerBlock.AGE, (Comparable)Integer.valueOf(2));
        HashMap<class_2338, class_2680> blocks = new HashMap<class_2338, class_2680>();
        int i = 0;
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (Math.abs(x) >= 2 && Math.abs(z) >= 2) continue;
                for (int y = -1; y <= 1; ++y) {
                    class_2338 blockpos = pos.method_10069(x, y, z);
                    class_2338 below = blockpos.method_10074();
                    class_2680 belowState = level.method_8320(below);
                    if (PowderyCaneFeature.canGrowPowderyCane(belowState) && rand.method_43048(3) == 0) {
                        class_2338 above = blockpos.method_10084();
                        int emptyBlocksAbove = this.countEmptyBlocksAbove(level, blockpos);
                        if (level.method_22347(blockpos) && !level.method_31606(above)) {
                            int deltaX = origin.method_10263() - pos.method_10263();
                            int deltaZ = origin.method_10260() - pos.method_10260();
                            double distanceToCenter = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                            double proximityFactor = Math.max(0.1, 1.0 - distanceToCenter / ((double)areaSize * 0.5));
                            int heightToPlace = Math.min(maxHeight, (int)((double)(2 + rand.method_43048(5)) * proximityFactor));
                            if (rand.method_43048(3) == 0) {
                                blocks.put(blockpos, rand.method_43056() ? powderyFlower : powderyFlowerLIT);
                            } else if (rand.method_43056() && emptyBlocksAbove >= heightToPlace) {
                                for (int j = 0; j < heightToPlace; ++j) {
                                    class_2338 canePos = blockpos.method_10086(j);
                                    if (heightToPlace == 1) {
                                        blocks.put(canePos, powderyCaneBase);
                                        continue;
                                    }
                                    if (!level.method_22347(canePos)) continue;
                                    blocks.put(canePos, j == 0 ? powderyCaneBase : powderyCane);
                                    if (j != heightToPlace - 1) continue;
                                    blocks.put(canePos, powderyCaneLeave);
                                }
                                class_2338 topPos = blockpos.method_10086(heightToPlace);
                                if (level.method_22347(topPos)) {
                                    blocks.put(topPos, rand.method_43056() ? powderyFlower : powderyFlowerLIT);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        for (Map.Entry entry : blocks.entrySet()) {
            class_2338 entryPos = (class_2338)entry.getKey();
            class_2680 entryState = (class_2680)entry.getValue();
            level.method_8652(entryPos, entryState, 19);
        }
        return i > 0;
    }

    private int countEmptyBlocksAbove(class_5281 level, class_2338 pos) {
        int count = 0;
        class_2338 currentPos = pos.method_10084();
        while (level.method_22347(currentPos) && count < 7) {
            ++count;
            currentPos = currentPos.method_10084();
        }
        return count;
    }

    public static boolean canGrowPowderyCane(class_2680 state) {
        return state.method_26164(MNDTags.POWDERY_CANNON_PLANTABLE_ON);
    }
}

