/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntityBase;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.api.provider.BalmProviderHolder;
import net.minecraft.class_1263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BalmBlockEntity
extends BalmBlockEntityBase
implements BalmProviderHolder {
    private final Map<Class<?>, BalmProvider<?>> providers = new HashMap();
    private final Map<Pair<class_2350, Class<?>>, BalmProvider<?>> sidedProviders = new HashMap();
    private boolean providersInitialized;

    public BalmBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.createUpdateTag(this);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return this.createUpdatePacket();
    }

    @Deprecated
    public <T> T getProvider(Class<T> clazz) {
        BalmProvider<?> found;
        if (!this.providersInitialized) {
            ArrayList<Object> providers = new ArrayList<Object>();
            this.buildProviders(providers);
            for (Object e : providers) {
                BalmProviderHolder providerHolder = (BalmProviderHolder)e;
                for (BalmProvider<?> balmProvider : providerHolder.getProviders()) {
                    this.providers.put(balmProvider.getProviderClass(), balmProvider);
                }
                for (Pair pair : providerHolder.getSidedProviders()) {
                    class_2350 direction = (class_2350)pair.getFirst();
                    BalmProvider provider = (BalmProvider)pair.getSecond();
                    this.sidedProviders.put(Pair.of((Object)direction, provider.getProviderClass()), provider);
                }
            }
            this.providersInitialized = true;
        }
        return (found = this.providers.get(clazz)) != null ? (T)found.getInstance() : null;
    }

    @Override
    @Deprecated
    public void buildProviders(List<Object> providers) {
        providers.add(this);
        BalmBlockEntity balmBlockEntity = this;
        if (balmBlockEntity instanceof BalmContainerProvider) {
            final BalmContainerProvider containerProvider = (BalmContainerProvider)((Object)balmBlockEntity);
            providers.add(new BalmProviderHolder(){

                @Override
                public List<BalmProvider<?>> getProviders() {
                    class_1263 container = containerProvider.getContainer();
                    if (container != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider<class_1263>(class_1263.class, container)});
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Pair<class_2350, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (class_2350 direction : class_2350.values()) {
                        class_1263 container = containerProvider.getContainer(direction);
                        if (container == null) continue;
                        providers.add(Pair.of((Object)direction, new BalmProvider<class_1263>(class_1263.class, container)));
                    }
                    return providers;
                }
            });
        }
        if ((balmBlockEntity = this) instanceof BalmFluidTankProvider) {
            final BalmFluidTankProvider fluidTankProvider = (BalmFluidTankProvider)((Object)balmBlockEntity);
            providers.add(new BalmProviderHolder(){

                @Override
                public List<BalmProvider<?>> getProviders() {
                    FluidTank fluidTank = fluidTankProvider.getFluidTank();
                    if (fluidTank != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider<FluidTank>(FluidTank.class, fluidTank)});
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Pair<class_2350, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (class_2350 direction : class_2350.values()) {
                        FluidTank fluidTank = fluidTankProvider.getFluidTank(direction);
                        if (fluidTank == null) continue;
                        providers.add(Pair.of((Object)direction, new BalmProvider<FluidTank>(FluidTank.class, fluidTank)));
                    }
                    return providers;
                }
            });
        }
        if ((balmBlockEntity = this) instanceof BalmEnergyStorageProvider) {
            final BalmEnergyStorageProvider energyStorageProvider = (BalmEnergyStorageProvider)((Object)balmBlockEntity);
            providers.add(new BalmProviderHolder(){

                @Override
                public List<BalmProvider<?>> getProviders() {
                    EnergyStorage energyStorage = energyStorageProvider.getEnergyStorage();
                    if (energyStorage != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider<EnergyStorage>(EnergyStorage.class, energyStorage)});
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Pair<class_2350, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (class_2350 direction : class_2350.values()) {
                        EnergyStorage energyStorage = energyStorageProvider.getEnergyStorage(direction);
                        if (energyStorage == null) continue;
                        providers.add(Pair.of((Object)direction, new BalmProvider<EnergyStorage>(EnergyStorage.class, energyStorage)));
                    }
                    return providers;
                }
            });
        }
    }

    public void sync() {
        if (this.method_10997() != null && !this.method_10997().field_9236) {
            ((class_3218)this.method_10997()).method_14178().method_14128(this.method_11016());
        }
    }

    public class_2596<class_2602> createUpdatePacket() {
        return class_2622.method_39026((class_2586)this, (blockEntity, registryAccess) -> this.createUpdateTag((class_2586)blockEntity));
    }

    public class_2487 createUpdateTag(class_2586 blockEntity) {
        class_2487 tag = new class_2487();
        if (blockEntity instanceof BalmBlockEntity) {
            BalmBlockEntity balmBlockEntity = (BalmBlockEntity)blockEntity;
            balmBlockEntity.writeUpdateTag(tag);
        }
        return tag;
    }

    protected void writeUpdateTag(class_2487 tag) {
    }
}

