/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.balm.api.BalmHooks;
import net.blay09.mods.balm.api.BalmProxy;
import net.blay09.mods.balm.api.BalmRegistries;
import net.blay09.mods.balm.api.BalmRuntimeLoadContext;
import net.blay09.mods.balm.api.block.BalmBlockEntities;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.balm.api.capability.BalmCapabilities;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.balm.api.compat.BalmModSupport;
import net.blay09.mods.balm.api.component.BalmComponents;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.balm.api.loot.BalmLootTables;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.balm.api.module.BalmModule;
import net.blay09.mods.balm.api.network.BalmNetworking;
import net.blay09.mods.balm.api.particle.BalmParticles;
import net.blay09.mods.balm.api.permission.BalmPermissions;
import net.blay09.mods.balm.api.provider.BalmProviders;
import net.blay09.mods.balm.api.proxy.ModProxy;
import net.blay09.mods.balm.api.proxy.PlatformProxy;
import net.blay09.mods.balm.api.proxy.SidedProxy;
import net.blay09.mods.balm.api.recipe.BalmRecipes;
import net.blay09.mods.balm.api.resources.BalmResources;
import net.blay09.mods.balm.api.sound.BalmSounds;
import net.blay09.mods.balm.api.stats.BalmStats;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.balm.core.component.BalmDataComponentTypeRegistrar;
import net.blay09.mods.balm.core.particles.BalmParticleTypeRegistrar;
import net.blay09.mods.balm.server.packs.resources.BalmResourceConditionRegistrar;
import net.blay09.mods.balm.server.packs.resources.BalmResourceReloadListenerRegistrar;
import net.blay09.mods.balm.stats.BalmCustomStatRegistrar;
import net.blay09.mods.balm.world.entity.BalmEntityTypeRegistrar;
import net.blay09.mods.balm.world.inventory.BalmMenuTypeRegistrar;
import net.blay09.mods.balm.world.item.BalmCreativeModeTabRegistrar;
import net.blay09.mods.balm.world.item.BalmItemRegistrar;
import net.blay09.mods.balm.world.item.crafting.BalmRecipeTypeRegistrar;
import net.blay09.mods.balm.world.level.block.BalmBlockRegistrar;
import net.blay09.mods.balm.world.level.block.entity.BalmBlockEntityTypeRegistrar;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public interface BalmRuntime<TLoadContext extends BalmRuntimeLoadContext> {
    public BalmConfig getConfig();

    public BalmEvents getEvents();

    public BalmWorldGen getWorldGen();

    @Deprecated
    public BalmBlocks getBlocks();

    @Deprecated
    public BalmBlockEntities getBlockEntities();

    @Deprecated
    public BalmItems getItems();

    @Deprecated
    public BalmMenus getMenus();

    public BalmNetworking getNetworking();

    public BalmHooks getHooks();

    public BalmRegistries getRegistries();

    @Deprecated
    public BalmSounds getSounds();

    @Deprecated
    public BalmEntities getEntities();

    public BalmCapabilities getCapabilities();

    @Deprecated
    public BalmProviders getProviders();

    public BalmCommands getCommands();

    public BalmLootTables getLootTables();

    @Deprecated
    public BalmStats getStats();

    @Deprecated
    public BalmRecipes getRecipes();

    public BalmModSupport getModSupport();

    @Deprecated
    public BalmParticles getParticles();

    public BalmPermissions getPermissions();

    public boolean isModLoaded(String var1);

    public String getModName(String var1);

    public <TProxy> SidedProxy<TProxy> sidedProxy(String var1, String var2);

    default public void initializeMod(String modId, TLoadContext context, Runnable initializer) {
        this.initializeMod(modId, context, (BalmRegistrars registrars) -> initializer.run());
    }

    public void initializeMod(String var1, TLoadContext var2, Consumer<BalmRegistrars> var3);

    public void initializeIfLoaded(String var1, String var2);

    public void addServerReloadListener(class_2960 var1, class_3302 var2);

    public void addServerReloadListener(class_2960 var1, Consumer<class_3300> var2);

    @Deprecated
    public BalmComponents getComponents();

    public <T> PlatformProxy<T> platformProxy();

    public <T> ModProxy<T> modProxy();

    public String getPlatform();

    default public void initializeModule(BalmModule module) {
        String modId = module.getId().method_12836();
        module.registerConfig(this.getConfig());
        module.registerResources(this.getResources());
        this.resourceConditions(modId, module::registerResourceConditions);
        module.registerAdditional(this.getRegistries());
        module.registerAdditional(this.registrar());
        module.registerComponents(this.getComponents());
        this.dataComponentTypes(modId, module::registerDataComponentTypes);
        module.registerBlocks(this.getBlocks().scoped(modId));
        this.blocks(modId, module::registerBlocks);
        module.registerBlockEntities(this.getBlockEntities());
        this.blockEntityTypes(modId, module::registerBlockEntityTypes);
        module.registerItems(this.getItems().scoped(modId));
        this.items(modId, module::registerItems);
        this.creativeModeTabs(modId, module::registerCreativeModeTabs);
        module.registerEntities(this.getEntities());
        this.entityTypes(modId, module::registerEntityTypes);
        module.registerWorldGen(this.getWorldGen());
        module.registerNetworking(this.getNetworking());
        module.registerMenus(this.getMenus());
        this.menuTypes(modId, module::registerMenuTypes);
        module.registerCapabilities(this.getCapabilities());
        module.registerCommands(this.getCommands());
        module.registerRecipes(this.getRecipes());
        this.recipeTypes(modId, module::registerRecipeTypes);
        module.registerLootTables(this.getLootTables());
        module.registerStats(this.getStats());
        this.customStats(modId, module::registerCustomStats);
        module.registerSounds(this.getSounds());
        module.registerSoundEvents(this.registrar(class_7924.field_41225, modId));
        module.registerPermissions(this.getPermissions());
        module.registerParticles(this.getParticles());
        this.particleTypes(modId, module::registerParticleTypes);
        this.resourceReloadListeners(modId, module::registerReloadListeners);
        module.registerEvents(this.getEvents());
        module.initialize();
    }

    public BalmProxy getProxy();

    public boolean isReady();

    public void onRuntimeAvailable(Runnable var1);

    public void registerModule(BalmModule var1);

    public void registerModule(BalmRegistrars var1, BalmModule var2);

    @Deprecated
    public BalmResources getResources();

    public BalmEnvironment getEnvironment();

    public boolean isDevelopmentEnvironment();

    public Map<String, Path> lookupAllModPaths(String var1);

    public Optional<Path> lookupModPath(String var1, String var2);

    public void menuTypes(String var1, Consumer<BalmMenuTypeRegistrar> var2);

    public void entityTypes(String var1, Consumer<BalmEntityTypeRegistrar> var2);

    public void particleTypes(String var1, Consumer<BalmParticleTypeRegistrar> var2);

    public void customStats(String var1, Consumer<BalmCustomStatRegistrar> var2);

    public BalmRegistrar registrar();

    default public <T> BalmRegistrar.Scoped<T> registrar(class_5321<? extends class_2378<T>> registryKey, String namespace) {
        return this.registrar().scoped(registryKey, namespace);
    }

    public void blocks(String var1, Consumer<BalmBlockRegistrar> var2);

    public void items(String var1, Consumer<BalmItemRegistrar> var2);

    public void recipeTypes(String var1, Consumer<BalmRecipeTypeRegistrar> var2);

    public void dataComponentTypes(String var1, Consumer<BalmDataComponentTypeRegistrar> var2);

    public void creativeModeTabs(String var1, Consumer<BalmCreativeModeTabRegistrar> var2);

    public void blockEntityTypes(String var1, Consumer<BalmBlockEntityTypeRegistrar> var2);

    public void resourceReloadListeners(String var1, Consumer<BalmResourceReloadListenerRegistrar> var2);

    public void resourceConditions(String var1, Consumer<BalmResourceConditionRegistrar> var2);
}

