/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util.stack;

import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.TrimmedTitle;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_9326;

public abstract class EmiStackWithTitle
extends EmiStack {
    protected final class_2960 id;
    private final TrimmedTitle name;
    private final class_5250 rawName;

    public EmiStackWithTitle(class_2960 id, String unknownNamespace, String unknownPath, EMILoot.Type type, int width, class_124 ... formatting) {
        this.id = id;
        this.rawName = this.getRawTitle(id, unknownNamespace, unknownPath, type);
        this.name = TrimmedTitle.of((class_2561)this.rawName.method_27661().method_27695(formatting), width);
    }

    protected class_5250 getRawTitle(class_2960 id, String unknownNamespace, String unknownPath, EMILoot.Type type) {
        class_5250 rawTitle;
        String key = String.join((CharSequence)".", "emi_loot", unknownNamespace, id.toString());
        if (!class_1074.method_4663((String)key)) {
            String[] chestPathTokens;
            StringBuilder chestName = new StringBuilder();
            for (String str : chestPathTokens = id.method_12832().split("[/_]")) {
                if (LText.tablePrefixes.contains(str)) continue;
                if (!chestName.isEmpty()) {
                    chestName.append(" ");
                }
                if (str.length() <= 1) {
                    chestName.append(str);
                    continue;
                }
                chestName.append(str.substring(0, 1).toUpperCase()).append(str.substring(1));
            }
            if (EMILootAgnos.isModLoaded(id.method_12836())) {
                rawTitle = LText.translatable(this.getUnknownModdedKey(unknownNamespace, unknownPath), chestName.toString());
            } else {
                class_5250 unknown = LText.translatable(this.getUnknownKey(unknownNamespace));
                rawTitle = LText.translatable(this.getUnknownModdedKey(unknownNamespace, unknownPath), LText.literal(chestName.toString()).method_27693(" ").method_10852((class_2561)unknown));
            }
            if (EMILoot.config.isLogI18n(type)) {
                EMILoot.LOGGER.warn("Untranslated " + unknownNamespace + " loot table \"" + String.valueOf(id) + "\" (key: \"" + key + "\")");
            }
        } else {
            rawTitle = LText.translatable(key);
        }
        return rawTitle;
    }

    private String getUnknownModdedKey(String namespace, String path) {
        return String.join((CharSequence)".", "emi_loot", namespace, path);
    }

    private String getUnknownKey(String namespace) {
        return String.join((CharSequence)".", "emi_loot", namespace, "unknown");
    }

    public void render(class_332 draw, int x, int y, float delta, int flags) {
    }

    public boolean isEmpty() {
        return false;
    }

    public class_9326 getComponentChanges() {
        return class_9326.field_49588;
    }

    public Object getKey() {
        return this.getId().toString();
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<class_2561> getTooltipText() {
        return List.of();
    }

    public class_2561 getName() {
        return this.rawName.method_27661();
    }

    public class_5481 getTrimmedName() {
        return this.name.title();
    }

    public boolean isTrimmed() {
        return this.name.trimmed();
    }
}

