/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.StructureButtonControllerBuilder;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.events.common.LoadConfigEvent;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public final class StructuresConfigScreen {
    private static final List<Option<Boolean>> structureOptions = new ArrayList<Option<Boolean>>();

    public static YACLScreen createConfigGui(StructurifyConfig config, class_437 parent) {
        LoadConfigEvent.EVENT.invoke(new LoadConfigEvent());
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"gui.structurify.structures_category.title")).save(config::save);
        StructuresConfigScreen.createStructuresTab(yacl, config);
        return (YACLScreen)yacl.build().generateScreen(parent);
    }

    public static void createStructuresTab(YetAnotherConfigLib.Builder yacl, StructurifyConfig config) {
        ConfigCategory.Builder structureCategoryBuilder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structures_category.title")).tooltip(new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures_category.description")});
        StructuresConfigScreen.addGeneralSettings(structureCategoryBuilder, config);
        StructuresConfigScreen.addStructures(structureCategoryBuilder, config);
        yacl.category(structureCategoryBuilder.build());
    }

    private static void addGeneralSettings(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
        OptionGroup.Builder generalStructuresGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structures.global.title")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures.global.description")}));
        Option disableAllStructuresOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structures.disable_all_structures.title")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures.disable_all_structures.description")})).binding((Object)false, () -> config.disableAllStructures, disableAllStructures -> {
            config.disableAllStructures = disableAllStructures;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? class_2561.method_43471((String)"gui.structurify.label.yes").method_27694(style -> style.method_10977(class_124.field_1061)) : class_2561.method_43471((String)"gui.structurify.label.no").method_27694(style -> style.method_10977(class_124.field_1060)))).build();
        disableAllStructuresOption.addListener((opt, disableAllStructures) -> {
            for (Option<Boolean> structureOption : structureOptions) {
                structureOption.setAvailable(disableAllStructures == false);
            }
        });
        generalStructuresGroupBuilder.option(disableAllStructuresOption);
        Option.Builder minStructureDistanceFromWorldOptionBuilder = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"gui.structurify.structures.min_structure_distance_from_world_center.title")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures.min_structure_distance_from_world_center.description")})).binding((Object)0, () -> config.minStructureDistanceFromWorldCenter, minStructureDistanceFromWorldCenter -> {
            config.minStructureDistanceFromWorldCenter = minStructureDistanceFromWorldCenter;
        }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)1024)).step((Number)1));
        generalStructuresGroupBuilder.option(minStructureDistanceFromWorldOptionBuilder.build());
        structureCategoryBuilder.group(generalStructuresGroupBuilder.build());
    }

    private static void addStructures(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
        Map<String, StructureData> structures = WorldgenDataProvider.getStructures();
        ArrayList<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
        OptionGroup.Builder currentGroupBuilder = null;
        String currentNamespace = null;
        class_7225.class_7226<class_1959> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        for (Map.Entry<String, StructureData> entry : structures.entrySet()) {
            String structureStringId = entry.getKey();
            StructureData structureData = entry.getValue();
            class_2960 structureId = Structurify.makeNamespacedId(structureStringId);
            String namespace = structureId.method_12836();
            if (!namespace.equals(currentNamespace)) {
                if (currentGroupBuilder != null) {
                    optionGroups.add(currentGroupBuilder.build());
                }
                currentGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43469((String)"gui.structurify.structures.structures_group.title", (Object[])new Object[]{LanguageUtil.translateId(null, namespace).getString()})).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43469((String)"gui.structurify.structures.structures_group.description", (Object[])new Object[]{namespace})}));
                currentNamespace = namespace;
            }
            Option.Builder structureOptionBuilder = Option.createBuilder().name((class_2561)LanguageUtil.translateId("structure", structureStringId)).binding((Object)true, () -> !config.getStructureData().get(structureStringId).isDisabled(), isEnabled -> config.getStructureData().get(structureStringId).setDisabled(isEnabled == false)).available(!config.disableAllStructures).controller(opt -> ((BooleanControllerBuilder)StructureButtonControllerBuilder.create((Option<Boolean>)opt, structureStringId).valueFormatter(val -> val != false ? class_2561.method_43471((String)"gui.structurify.label.enabled") : class_2561.method_43471((String)"gui.structurify.label.disabled"))).coloured(true));
            OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder();
            descriptionBuilder.text(new class_2561[]{class_2561.method_43471((String)"gui.structurify.structures.biomes_description").method_10852((class_2561)class_2561.method_43470((String)"\n"))});
            for (String biome : structureData.getBiomes()) {
                if (biome.contains("#")) {
                    class_6862 biomeTagKey;
                    class_6885.class_6888 biomeTagHolder;
                    if (biomeRegistry == null || (biomeTagHolder = (class_6885.class_6888)biomeRegistry.method_46733(biomeTagKey = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)Structurify.makeNamespacedId(biome.replace("#", "")))).orElse(null)) == null) continue;
                    for (class_6880 biomeHolder : biomeTagHolder.method_40239().toList()) {
                        descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)" - ").method_10852((class_2561)LanguageUtil.translateId("biome", ((class_5321)biomeHolder.method_40229().left().get()).method_29177().method_42094()))});
                    }
                    continue;
                }
                descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)" - ").method_10852((class_2561)LanguageUtil.translateId("biome", biome))});
            }
            descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)"\n\n").method_10852((class_2561)class_2561.method_43471((String)"gui.structurify.structures.warning")).method_27694(style -> style.method_10977(class_124.field_1054))});
            structureOptionBuilder.description(descriptionBuilder.build());
            Option structureOption = structureOptionBuilder.build();
            structureOptions.add((Option<Boolean>)structureOption);
            currentGroupBuilder.option(structureOption);
        }
        if (currentGroupBuilder != null) {
            optionGroups.add(currentGroupBuilder.build());
        }
        for (OptionGroup structureOptionGroup : optionGroups) {
            structureCategoryBuilder.group(structureOptionGroup);
        }
    }

    private static void addSpecificStructure(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
    }
}

