/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_7138;

public final class JigsawStructureFlatnessCheck {
    public static boolean checkFlatness(StructureData structureData, class_6122 startHeight, class_3195.class_7149 generationContext) {
        int flatnessCheckDistance = structureData.getFlatnessCheckDistance();
        int flatnessCheckThreshold = structureData.getFlatnessCheckThreshold();
        boolean areAirBlocksAllowed = structureData.areAirBlocksAllowedInFlatnessCheck();
        boolean areLiquidBlocksAllowed = structureData.areLiquidBlocksAllowedInFlatnessCheck();
        if (flatnessCheckDistance == 0 || flatnessCheckThreshold == 0) {
            return true;
        }
        int offsetStep = (int)Math.ceil((float)flatnessCheckDistance / 2.0f);
        int stepsPerAxis = 2 * flatnessCheckDistance / offsetStep + 1;
        int stepAmount = stepsPerAxis * stepsPerAxis;
        int allowedAirBlockSteps = stepAmount / 2;
        int allowedLiquidBlockSteps = stepAmount / 2;
        class_2794 chunkGenerator = generationContext.comp_562();
        class_5539 heightAccessor = generationContext.comp_569();
        class_7138 randomState = generationContext.comp_564();
        class_1923 chunkPos = generationContext.comp_568();
        int y = startHeight.method_35391((class_5819)generationContext.comp_566(), new class_5868(chunkGenerator, heightAccessor));
        class_2338 basePos = new class_2338(chunkPos.method_8326(), y, chunkPos.method_8328());
        int baseX = basePos.method_10263();
        int baseZ = basePos.method_10260();
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        int airBlockSteps = 0;
        int fluidBlockSteps = 0;
        for (int xOffset = -flatnessCheckDistance; xOffset <= flatnessCheckDistance; xOffset += offsetStep) {
            for (int zOffset = -flatnessCheckDistance; zOffset <= flatnessCheckDistance; zOffset += offsetStep) {
                int x = baseX + xOffset;
                int z = baseZ + zOffset;
                int height = chunkGenerator.method_18028(x, z, class_2902.class_2903.field_13194, heightAccessor, randomState);
                if (height > maxHeight && (maxHeight = height) - minHeight > flatnessCheckThreshold) {
                    return false;
                }
                if (height < minHeight && maxHeight - (minHeight = height) > flatnessCheckThreshold) {
                    return false;
                }
                if (areAirBlocksAllowed && areLiquidBlocksAllowed) continue;
                class_2680 blockState = null;
                if (!areAirBlocksAllowed) {
                    if (blockState == null) {
                        blockState = chunkGenerator.method_26261(x, z, heightAccessor, randomState).method_32892(height);
                    }
                    if (blockState.method_26215() && ++airBlockSteps >= allowedAirBlockSteps) {
                        return false;
                    }
                }
                if (areLiquidBlocksAllowed) continue;
                if (blockState == null) {
                    blockState = chunkGenerator.method_26261(x, z, heightAccessor, randomState).method_32892(height);
                }
                if (blockState.method_26227().method_15769() || ++fluidBlockSteps < allowedLiquidBlockSteps) continue;
                return false;
            }
        }
        return true;
    }
}

