/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1973;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_5742;
import net.minecraft.class_6122;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7138;

public final class JigsawStructureBiomeCheck {
    public static boolean checkBiomes(StructureData structureData, class_6122 startHeight, class_3195.class_7149 generationContext, class_6885<class_1959> blacklistedBiomes) {
        int biomeCheckDistance = (int)Math.ceil((double)structureData.getBiomeCheckDistance() / 16.0);
        if (biomeCheckDistance == 0 || generationContext.comp_563() instanceof class_1973) {
            return true;
        }
        StructureData.BiomeCheckMode biomeCheckMode = structureData.getBiomeCheckMode();
        if (biomeCheckMode == StructureData.BiomeCheckMode.BLACKLIST && structureData.getBiomeCheckBlacklistedBiomes().isEmpty()) {
            return true;
        }
        class_1923 chunkPos = generationContext.comp_568();
        class_1966 biomeSource = generationContext.comp_563();
        class_7138 randomState = generationContext.comp_564();
        class_6544.class_6552 biomeSampler = randomState.method_42371();
        int blockX = chunkPos.field_9181 << 4;
        int blockZ = chunkPos.field_9180 << 4;
        int surfaceY = generationContext.comp_562().method_20402(blockX, blockZ, class_2902.class_2903.field_13194, generationContext.comp_569(), generationContext.comp_564());
        for (int curChunkX = chunkPos.field_9181 - biomeCheckDistance; curChunkX <= chunkPos.field_9181 + biomeCheckDistance; ++curChunkX) {
            block5: for (int curChunkZ = chunkPos.field_9180 - biomeCheckDistance; curChunkZ <= chunkPos.field_9180 + biomeCheckDistance; ++curChunkZ) {
                blockX = (curChunkX << 4) + 8;
                blockZ = (curChunkZ << 4) + 8;
                class_6880 biome = biomeSource.method_38109(class_5742.method_33100((int)blockX), class_5742.method_33100((int)256), class_5742.method_33100((int)blockZ), biomeSampler);
                switch (biomeCheckMode) {
                    case STRICT: {
                        if (generationContext.comp_570().test(biome)) continue block5;
                        return false;
                    }
                    case BLACKLIST: {
                        if (!blacklistedBiomes.method_40241(biome)) continue block5;
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

