/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.SyncMessageHistoryMessage;
import dev.ftb.mods.ftbteams.net.SyncTeamsMessage;
import dev.ftb.mods.ftbteams.net.ToggleChatResponseMessage;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TeamManagerImpl
implements TeamManager {
    public static final class_5218 FOLDER_NAME = new class_5218("ftbteams");
    public static TeamManagerImpl INSTANCE;
    private final MinecraftServer server;
    private UUID id;
    private boolean shouldSave;
    private final Map<UUID, PlayerTeam> knownPlayers;
    private final Map<UUID, AbstractTeam> teamMap;
    private final Set<UUID> chatRedirected;
    Map<String, Team> nameMap;
    private class_2487 extraData;

    public TeamManagerImpl(MinecraftServer s) {
        this.server = s;
        this.knownPlayers = new LinkedHashMap<UUID, PlayerTeam>();
        this.teamMap = new LinkedHashMap<UUID, AbstractTeam>();
        this.extraData = new class_2487();
        this.chatRedirected = new HashSet<UUID>();
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    @Override
    public Map<UUID, ? extends Team> getKnownPlayerTeams() {
        return Collections.unmodifiableMap(this.knownPlayers);
    }

    public Map<UUID, AbstractTeam> getTeamMap() {
        return this.teamMap;
    }

    @Override
    public Collection<Team> getTeams() {
        return Collections.unmodifiableCollection(this.teamMap.values());
    }

    public Map<String, Team> getTeamNameMap() {
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, Team>();
            for (AbstractTeam team : this.teamMap.values()) {
                this.nameMap.put(team.getShortName(), team);
            }
        }
        return this.nameMap;
    }

    @Override
    public Optional<Team> getTeamByID(UUID teamId) {
        return Optional.ofNullable((Team)this.teamMap.get(teamId));
    }

    @Override
    public Optional<Team> getTeamByName(String name) {
        return Optional.ofNullable(this.getTeamNameMap().get(name));
    }

    @Override
    public Optional<Team> getPlayerTeamForPlayerID(UUID uuid) {
        return Optional.ofNullable(this.getPersonalTeamForPlayerID(uuid));
    }

    public PlayerTeam getPersonalTeamForPlayerID(UUID uuid) {
        return this.knownPlayers.get(uuid);
    }

    @Override
    public Optional<Team> getTeamForPlayerID(UUID uuid) {
        PlayerTeam t = this.knownPlayers.get(uuid);
        return t == null ? Optional.empty() : Optional.ofNullable(t.getEffectiveTeam());
    }

    @Override
    public Optional<Team> getTeamForPlayer(class_3222 player) {
        return this.getTeamForPlayerID(player.method_5667());
    }

    @Override
    public boolean arePlayersInSameTeam(UUID id1, UUID id2) {
        return this.getTeamForPlayerID(id1).map(team1 -> this.getTeamForPlayerID(id2).map(team2 -> team1.getId().equals(team2.getId())).orElse(false)).orElse(false);
    }

    public void load() {
        this.id = null;
        Path directory = this.server.method_27050(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        SNBTCompoundTag dataFileTag = SNBT.read((Path)directory.resolve("ftbteams.snbt"));
        if (dataFileTag != null) {
            if (dataFileTag.method_10545("id")) {
                this.id = UUID.fromString(dataFileTag.method_10558("id"));
            }
            this.extraData = dataFileTag.method_10562("extra");
            ((Consumer)TeamManagerEvent.LOADED.invoker()).accept(new TeamManagerEvent(this));
            this.chatRedirected.clear();
            dataFileTag.method_10554("chat_redirected", 8).forEach(tag -> {
                try {
                    this.chatRedirected.add(UUID.fromString(tag.method_10714()));
                }
                catch (IllegalArgumentException e) {
                    FTBTeams.LOGGER.error("invalid uuid {} in 'chat_redirection', ignoring", (Object)tag.method_10714());
                }
            });
        }
        for (TeamType type : TeamType.values()) {
            Path dir = directory.resolve(type.method_15434());
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            try (Stream<Path> s = Files.list(dir);){
                s.filter(path -> path.getFileName().toString().endsWith(".snbt")).forEach(file -> {
                    SNBTCompoundTag nbt = SNBT.read((Path)file);
                    if (nbt != null) {
                        AbstractTeam team = type.createTeam(this, UUID.fromString(nbt.method_10558("id")));
                        this.teamMap.put(team.id, team);
                        team.deserializeNBT((class_2487)nbt, (class_7225.class_7874)this.server.method_30611());
                    }
                });
            }
            catch (Exception ex) {
                FTBTeams.LOGGER.error("can't list directory {}: {}", (Object)dir, (Object)ex.getMessage());
            }
        }
        for (AbstractTeam team : this.teamMap.values()) {
            if (!(team instanceof PlayerTeam)) continue;
            this.knownPlayers.put(team.id, (PlayerTeam)team);
        }
        for (AbstractTeam team : this.teamMap.values()) {
            if (!(team instanceof PartyTeam)) continue;
            for (UUID member : team.getMembers()) {
                PlayerTeam t = this.knownPlayers.get(member);
                if (t == null) continue;
                t.setEffectiveTeam(team);
            }
        }
        FTBTeams.LOGGER.info("loaded team data: {} known players, {} teams total", (Object)this.knownPlayers.size(), (Object)this.teamMap.size());
    }

    @Override
    public void markDirty() {
        this.shouldSave = true;
        this.nameMap = null;
    }

    public void saveNow() {
        Path directory = this.server.method_27050(FOLDER_NAME);
        if (!Files.exists(directory, new LinkOption[0])) {
            this.tryCreateDir(directory);
            for (TeamType type : TeamType.values()) {
                this.tryCreateDir(directory.resolve(type.method_15434()));
            }
        }
        if (this.shouldSave) {
            ((Consumer)TeamManagerEvent.SAVED.invoker()).accept(new TeamManagerEvent(this));
            SNBT.write((Path)directory.resolve("ftbteams.snbt"), (class_2487)this.serializeNBT());
            this.shouldSave = false;
        }
        for (AbstractTeam team : this.teamMap.values()) {
            team.saveIfNeeded(directory, (class_7225.class_7874)this.server.method_30611());
        }
    }

    private void tryCreateDir(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (Exception ex) {
            FTBTeams.LOGGER.error("can't create directory {}: {} {}", (Object)path, (Object)ex.getClass().getName(), (Object)ex.getMessage());
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.method_10582("id", this.getId().toString());
        nbt.method_10566("extra", (class_2520)this.extraData);
        nbt.method_10566("chat_redirected", (class_2520)class_156.method_654((Object)new class_2499(), l -> this.chatRedirected.forEach(id -> l.add((Object)class_2519.method_23256((String)id.toString())))));
        return nbt;
    }

    private PartyTeam createPartyTeamInternal(UUID playerId, @Nullable class_3222 player, String name) {
        PartyTeam team = new PartyTeam(this, UUID.randomUUID());
        team.owner = playerId;
        this.teamMap.put(team.id, team);
        team.setProperty(TeamProperties.DISPLAY_NAME, name.isEmpty() ? FTBTUtils.getDefaultPartyName(this.server, playerId, player) : name);
        team.setProperty(TeamProperties.COLOR, FTBTUtils.randomColor());
        team.onCreated(player, playerId);
        return team;
    }

    private PlayerTeam createPlayerTeam(UUID playerId, String playerName) {
        PlayerTeam team = new PlayerTeam(this, playerId);
        team.setPlayerName(playerName);
        team.setProperty(TeamProperties.DISPLAY_NAME, playerName);
        team.setProperty(TeamProperties.COLOR, FTBTUtils.randomColor());
        team.addMember(playerId, TeamRank.OWNER);
        return team;
    }

    public void playerLoggedIn(@Nullable class_3222 player, UUID id, String name) {
        PlayerTeam team = this.knownPlayers.get(id);
        boolean syncToAll = false;
        FTBTeams.LOGGER.debug("player {} logged in, player team = {}", (Object)id, (Object)team);
        if (team == null) {
            FTBTeams.LOGGER.debug("creating new player team for player {}", (Object)id);
            team = this.createPlayerTeam(id, name);
            this.teamMap.put(id, team);
            this.knownPlayers.put(id, team);
            team.onCreated(player, id);
            syncToAll = true;
            team.onPlayerChangeTeam(null, id, player, false);
            FTBTeams.LOGGER.debug("  - team created");
        } else if (!team.getPlayerName().equals(name)) {
            FTBTeams.LOGGER.debug("updating player name: {} -> {}", (Object)team.getPlayerName(), (Object)name);
            team.setPlayerName(name);
            team.markDirty();
            this.markDirty();
            syncToAll = true;
        }
        FTBTeams.LOGGER.debug("syncing player team data, all = {}", (Object)syncToAll);
        if (player != null) {
            this.syncAllToPlayer(player, team.getEffectiveTeam());
        }
        if (syncToAll) {
            this.syncToAll(team.getEffectiveTeam());
        }
        FTBTeams.LOGGER.debug("updating team presence");
        team.setOnline(true);
        team.updatePresence();
        if (player != null) {
            FTBTeams.LOGGER.debug("sending team login event for {}...", (Object)player.method_5667());
            ((Consumer)TeamEvent.PLAYER_LOGGED_IN.invoker()).accept(new PlayerLoggedInAfterTeamEvent(team.getEffectiveTeam(), player));
            FTBTeams.LOGGER.debug("team login event for {} sent", (Object)player.method_5667());
        }
    }

    public void playerLoggedOut(class_3222 player) {
        PlayerTeam team = this.knownPlayers.get(player.method_5667());
        if (team != null) {
            team.setOnline(false);
            team.updatePresence();
        }
    }

    public void syncAllToPlayer(class_3222 player, AbstractTeam selfTeam) {
        ClientTeamManagerImpl manager = ClientTeamManagerImpl.forSyncing(this, this.teamMap.values());
        NetworkHelper.sendTo((class_3222)player, (class_8710)new SyncTeamsMessage(manager.setSelfTeamId(selfTeam.id), selfTeam.getTeamId(), true));
        NetworkHelper.sendTo((class_3222)player, (class_8710)SyncMessageHistoryMessage.forTeam(selfTeam));
        NetworkHelper.sendTo((class_3222)player, (class_8710)new ToggleChatResponseMessage(this.isChatRedirected(player)));
        this.server.method_3760().method_14576(player);
    }

    public void syncToAll(Team ... teams) {
        if (teams.length == 0) {
            return;
        }
        ClientTeamManagerImpl manager = ClientTeamManagerImpl.forSyncing(this, Arrays.stream(teams).toList());
        for (class_3222 player : this.server.method_3760().method_14571()) {
            this.getTeamForPlayer(player).ifPresent(selfTeam -> {
                NetworkHelper.sendTo((class_3222)player, (class_8710)new SyncTeamsMessage(manager.setSelfTeamId(selfTeam.getTeamId()), selfTeam.getTeamId(), false));
                if (teams.length > 1) {
                    NetworkHelper.sendTo((class_3222)player, (class_8710)SyncMessageHistoryMessage.forTeam(selfTeam));
                }
            });
        }
    }

    @Override
    public Team createPartyTeam(class_3222 player, String name, @Nullable String description, @Nullable Color4I color) throws CommandSyntaxException {
        return this.createParty(player.method_5667(), player, name, description, color);
    }

    @Override
    public Team createServerTeam(class_2168 source, String name, @Nullable String description, @Nullable Color4I color, @Nullable UUID teamUUID) throws CommandSyntaxException {
        if (name.length() < 3) {
            throw TeamArgument.NAME_TOO_SHORT.create();
        }
        if (teamUUID != null && this.getTeamByID(teamUUID).isPresent()) {
            throw TeamArgument.TEAM_ALREADY_EXISTS.create((Object)teamUUID.toString());
        }
        class_3222 player = source.method_44023();
        UUID ownerId = player == null ? class_156.field_25140 : player.method_5667();
        ServerTeam team = new ServerTeam(this, Objects.requireNonNullElse(teamUUID, UUID.randomUUID()));
        this.teamMap.put(team.id, team);
        team.setProperty(TeamProperties.DISPLAY_NAME, name);
        if (description != null) {
            team.setProperty(TeamProperties.DESCRIPTION, description);
        }
        if (color != null) {
            team.setProperty(TeamProperties.COLOR, color);
        }
        team.onCreated(player, ownerId);
        source.method_9226(() -> class_2561.method_43469((String)"ftbteams.message.created_server_team", (Object[])new Object[]{team.getName()}), true);
        this.syncToAll(team);
        return team;
    }

    @Override
    public void setChatRedirected(class_3222 player, boolean redirect) {
        if (redirect && this.chatRedirected.add(player.method_5667()) || !redirect && this.chatRedirected.remove(player.method_5667())) {
            NetworkHelper.sendTo((class_3222)player, (class_8710)new ToggleChatResponseMessage(redirect));
            this.shouldSave = true;
        }
    }

    @Override
    public boolean isChatRedirected(class_3222 player) {
        return this.chatRedirected.contains(player.method_5667());
    }

    public PartyTeam createParty(class_3222 player, String name) throws CommandSyntaxException {
        return this.createParty(player.method_5667(), player, name, null, null);
    }

    public PartyTeam createParty(UUID playerId, @Nullable class_3222 player, String name, @Nullable String description, @Nullable Color4I color) throws CommandSyntaxException {
        if (player != null && !FTBTUtils.canPlayerUseCommand(player, "ftbteams.party.create")) {
            throw TeamArgument.NO_PERMISSION.create();
        }
        Team oldTeam = this.getTeamForPlayerID(playerId).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)playerId));
        if (!(oldTeam instanceof PlayerTeam)) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        PlayerTeam playerTeam = (PlayerTeam)oldTeam;
        PartyTeam team = this.createPartyTeamInternal(playerId, player, name);
        if (description != null) {
            team.setProperty(TeamProperties.DESCRIPTION, description);
        }
        if (color != null) {
            team.setProperty(TeamProperties.COLOR, color);
        }
        team.copyExtraData(playerTeam);
        playerTeam.setEffectiveTeam(team);
        class_2561 playerName = player != null ? player.method_5477() : class_2561.method_43470((String)playerId.toString());
        team.addMember(playerId, TeamRank.OWNER);
        team.sendMessage(class_156.field_25140, (class_2561)class_2561.method_43469((String)"ftbteams.message.joined", (Object[])new Object[]{playerName}).method_27692(class_124.field_1054));
        team.markDirty();
        playerTeam.removeMember(playerId);
        playerTeam.markDirty();
        playerTeam.updatePresence();
        this.syncToAll(team, playerTeam);
        team.onPlayerChangeTeam(playerTeam, playerId, player, false);
        return team;
    }

    public class_2561 getPlayerName(@Nullable UUID id) {
        if (id == null || id.equals(class_156.field_25140)) {
            return class_2561.method_43470((String)"System").method_27692(class_124.field_1076);
        }
        PlayerTeam team = this.knownPlayers.get(id);
        return class_2561.method_43470((String)(team == null ? "Unknown" : team.getPlayerName())).method_27692(class_124.field_1054);
    }

    @Override
    public class_2487 getExtraData() {
        return this.extraData;
    }

    void deleteTeam(AbstractTeam team) {
        this.teamMap.remove(team.getId());
        this.markDirty();
        this.saveNow();
        this.tryDeleteTeamFile(String.valueOf(team.getId()) + ".snbt", team.getType().method_15434());
    }

    private void tryDeleteTeamFile(String teamFileName, String subfolderName) {
        Path deletedPath = this.getServer().method_27050(FOLDER_NAME).resolve("deleted");
        Path teamFilePath = this.getServer().method_27050(FOLDER_NAME).resolve(subfolderName).resolve(teamFileName);
        try {
            Files.createDirectories(deletedPath, new FileAttribute[0]);
            Files.move(teamFilePath, deletedPath.resolve(teamFileName), new CopyOption[0]);
        }
        catch (IOException e) {
            FTBTeams.LOGGER.error("can't move {} to {}: {}", (Object)teamFileName, (Object)deletedPath, (Object)e.getMessage());
            try {
                Files.deleteIfExists(teamFilePath);
            }
            catch (IOException e1) {
                FTBTeams.LOGGER.error("can't delete directory {}: {}", (Object)teamFilePath, (Object)e1.getMessage());
            }
        }
    }
}

