/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public class TeamArgument
implements ArgumentType<TeamArgumentProvider> {
    public static final SimpleCommandExceptionType ALREADY_IN_PARTY = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.already_in_party"));
    public static final DynamicCommandExceptionType PLAYER_IN_PARTY = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbteams.player_already_in_party", (Object[])new Object[]{object}));
    public static final SimpleCommandExceptionType NOT_IN_PARTY = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.not_in_party"));
    public static final DynamicCommandExceptionType TEAM_NOT_FOUND = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbteams.team_not_found", (Object[])new Object[]{object}));
    public static final DynamicCommandExceptionType CANT_EDIT = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbteams.cant_edit", (Object[])new Object[]{object}));
    public static final Dynamic2CommandExceptionType NOT_MEMBER = new Dynamic2CommandExceptionType((a, b) -> class_2561.method_43469((String)"ftbteams.not_member", (Object[])new Object[]{a, b}));
    public static final Dynamic2CommandExceptionType NOT_OFFICER = new Dynamic2CommandExceptionType((a, b) -> class_2561.method_43469((String)"ftbteams.not_officer", (Object[])new Object[]{a, b}));
    public static final DynamicCommandExceptionType NOT_INVITED = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbteams.not_invited", (Object[])new Object[]{object}));
    public static final SimpleCommandExceptionType OWNER_CANT_LEAVE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.owner_cant_leave"));
    public static final SimpleCommandExceptionType CANT_KICK_OWNER = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.cant_kick_owner"));
    public static final SimpleCommandExceptionType API_OVERRIDE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.party_api_only"));
    public static final SimpleCommandExceptionType NAME_TOO_SHORT = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.name_too_short"));
    public static final SimpleCommandExceptionType NO_PERMISSION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.server_permissions_prevent"));
    public static final DynamicCommandExceptionType TEAM_ALREADY_EXISTS = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbteams.team_already_exists", (Object[])new Object[]{object}));
    private final TeamType type;

    public static TeamArgument create() {
        return new TeamArgument(null);
    }

    public static TeamArgument create(TeamType type) {
        return new TeamArgument(type);
    }

    public static Team get(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        return ((TeamArgumentProvider)context.getArgument(name, TeamArgumentProvider.class)).getTeam((class_2168)context.getSource());
    }

    private TeamArgument(@Nullable TeamType type) {
        this.type = type;
    }

    public TeamArgumentProvider parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '@') {
            class_2300 selector = new class_2303(reader, true).method_9882();
            if (selector.method_9819()) {
                throw class_2186.field_9861.create();
            }
            return new SelectorProvider(selector);
        }
        int i = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        return new IDProvider(reader.getString().substring(i, reader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
        if (commandContext.getSource() instanceof class_2172) {
            Stream<String> list = this.getTeams(commandContext).stream().filter(t -> this.type == null || this.type.matches((Team)t)).map(Team::getShortName).sorted();
            return class_2172.method_9264(list, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    private Collection<Team> getTeams(CommandContext<?> context) {
        FTBTeamsAPI.API api = FTBTeamsAPI.api();
        if (context.getSource() instanceof class_2168 && api.isManagerLoaded()) {
            return api.getManager().getTeams();
        }
        if (api.isClientManagerLoaded()) {
            return api.getClientManager().getTeams();
        }
        return List.of();
    }

    private static class SelectorProvider
    implements TeamArgumentProvider {
        private final class_2300 selector;

        private SelectorProvider(class_2300 s) {
            this.selector = s;
        }

        @Override
        public Team getTeam(class_2168 source) throws CommandSyntaxException {
            class_3222 player = this.selector.method_9811(source);
            return FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TEAM_NOT_FOUND.create((Object)player.method_5667()));
        }
    }

    private static class IDProvider
    implements TeamArgumentProvider {
        private final String id;

        private IDProvider(String s) {
            this.id = s;
        }

        private CommandSyntaxException error() {
            return TEAM_NOT_FOUND.create((Object)this.id);
        }

        @Override
        public Team getTeam(class_2168 source) throws CommandSyntaxException {
            Optional<Team> t = FTBTeamsAPI.api().getManager().getTeamByName(this.id);
            if (t.isPresent()) {
                return t.get();
            }
            return (Team)source.method_9211().method_3793().method_14515(this.id).map(GameProfile::getId).map(FTBTeamsAPI.api().getManager()::getTeamForPlayerID).orElseThrow().orElseThrow(this::error);
        }
    }

    public static class Info
    implements class_2314<TeamArgument, Template> {
        public void serializeToNetwork(Template template, class_2540 buf) {
            buf.method_43826((Object)template.teamType, class_2540::method_10817);
        }

        public Template deserializeFromNetwork(class_2540 buf) {
            return new Template((TeamType)((Object)buf.method_43827(b -> (TeamType)b.method_10818(TeamType.class))));
        }

        public void serializeToJson(Template template, JsonObject jsonObject) {
            if (template.teamType != null) {
                jsonObject.addProperty("type", template.teamType.name());
            }
        }

        public Template unpack(TeamArgument argumentType) {
            return new Template(argumentType.type);
        }

        public final class Template
        implements class_2314.class_7217<TeamArgument> {
            private final TeamType teamType;

            public Template(TeamType teamType) {
                this.teamType = teamType;
            }

            public TeamArgument instantiate(class_7157 commandBuildContext) {
                return TeamArgument.create(this.teamType);
            }

            public class_2314<TeamArgument, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

