/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.UpdatePresenceMessage;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PlayerTeam
extends AbstractTeam {
    private String playerName = "";
    private boolean online = false;
    private AbstractTeam effectiveTeam = this;

    public PlayerTeam(TeamManagerImpl manager, UUID id) {
        super(manager, id);
    }

    @Override
    public UUID getTeamId() {
        return this.effectiveTeam.getId();
    }

    @Override
    public TeamType getType() {
        return TeamType.PLAYER;
    }

    @Override
    public boolean isPlayerTeam() {
        return true;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public AbstractTeam getEffectiveTeam() {
        return this.effectiveTeam;
    }

    public void setEffectiveTeam(AbstractTeam effectiveTeam) {
        this.effectiveTeam = effectiveTeam;
    }

    @Override
    protected void serializeExtraNBT(class_2487 tag) {
        tag.method_10582("player_name", this.playerName);
    }

    @Override
    public void deserializeNBT(class_2487 tag, class_7225.class_7874 provider) {
        super.deserializeNBT(tag, provider);
        this.playerName = tag.method_10558("player_name");
    }

    @Nullable
    public class_3222 getPlayer() {
        return FTBTUtils.getPlayerByUUID(this.manager.getServer(), this.id);
    }

    @Override
    public TeamRank getRankForPlayer(UUID playerId) {
        return playerId.equals(this.id) ? TeamRank.OWNER : super.getRankForPlayer(playerId);
    }

    @Override
    public List<class_3222> getOnlineMembers() {
        class_3222 p = this.getPlayer();
        return p == null ? Collections.emptyList() : Collections.singletonList(p);
    }

    public void updatePresence() {
        NetworkHelper.sendToAll((MinecraftServer)this.manager.getServer(), (class_8710)new UpdatePresenceMessage(this.createClientPlayer()));
    }

    public Team createParty(UUID playerId, @Nullable class_3222 player, String name, String description, int color, Set<GameProfile> invited) {
        try {
            PartyTeam team = this.manager.createParty(playerId, player, name, description, Color4I.rgb((int)color));
            if (player != null) {
                team.invite(player, invited);
            }
            return team;
        }
        catch (CommandSyntaxException ex) {
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43470((String)ex.getMessage()).method_27692(class_124.field_1061), false);
            }
            return null;
        }
    }

    public boolean hasTeam() {
        return this.effectiveTeam != this;
    }

    public KnownClientPlayer createClientPlayer() {
        return new KnownClientPlayer(this.getId(), this.getPlayerName(), this.isOnline(), this.getTeamId(), new GameProfile(this.getId(), this.getPlayerName()), this.getExtraData());
    }
}

