/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.client.KnownClientPlayerNet;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ClientTeamManagerImpl
implements ClientTeamManager {
    private static ClientTeamManagerImpl INSTANCE;
    public static final class_9139<class_9129, ClientTeamManagerImpl> STREAM_CODEC;
    private final UUID managerId;
    private final Map<UUID, ClientTeam> teamMap;
    private final Map<UUID, KnownClientPlayer> knownPlayers;
    private UUID selfTeamId = class_156.field_25140;
    private boolean valid;
    private ClientTeam selfTeam;
    private KnownClientPlayer selfKnownPlayer;

    public static ClientTeamManagerImpl getInstance() {
        return INSTANCE;
    }

    public static void ifPresent(Consumer<ClientTeamManagerImpl> mgr) {
        if (INSTANCE != null) {
            mgr.accept(INSTANCE);
        }
    }

    private ClientTeamManagerImpl(UUID managerId) {
        this(managerId, new HashMap<UUID, ClientTeam>(), new HashMap<UUID, KnownClientPlayer>());
    }

    private ClientTeamManagerImpl(UUID managerId, Map<UUID, ClientTeam> teamMap, Map<UUID, KnownClientPlayer> knownPlayers) {
        this.managerId = managerId;
        this.teamMap = teamMap;
        this.knownPlayers = knownPlayers;
        this.valid = true;
    }

    public UUID getSelfTeamId() {
        return this.selfTeamId;
    }

    public ClientTeamManagerImpl setSelfTeamId(UUID selfTeamId) {
        this.selfTeamId = selfTeamId;
        return this;
    }

    public static ClientTeamManagerImpl forSyncing(TeamManagerImpl manager, Collection<? extends Team> teams) {
        ClientTeamManagerImpl clientManager = new ClientTeamManagerImpl(manager.getId());
        for (Team team : teams) {
            if (team instanceof AbstractTeam) {
                AbstractTeam abstractTeam = (AbstractTeam)team;
                ClientTeam clientTeam = manager.getTeamMap().containsKey(team.getId()) ? ClientTeam.copyOf(abstractTeam) : ClientTeam.invalidTeam(abstractTeam);
                clientTeam.setFullSyncRequired(() -> clientManager.getSelfTeamId().equals(clientTeam.getId()));
                clientManager.addTeam(clientTeam);
            }
            if (!(team instanceof PlayerTeam)) continue;
            PlayerTeam playerTeam = (PlayerTeam)team;
            clientManager.knownPlayers.put(team.getId(), playerTeam.createClientPlayer());
        }
        return clientManager;
    }

    @Override
    public UUID getManagerId() {
        return this.managerId;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Collection<KnownClientPlayer> knownClientPlayers() {
        return Collections.unmodifiableCollection(this.knownPlayers.values());
    }

    @Override
    public Collection<Team> getTeams() {
        return Collections.unmodifiableCollection(this.teamMap.values());
    }

    @Override
    public Optional<Team> getTeamByID(UUID teamId) {
        return Optional.ofNullable((Team)this.teamMap.get(teamId));
    }

    @Override
    public Optional<Team> getTeamForPlayer(class_1657 player) {
        return this.getKnownPlayer(player.method_5667()).flatMap(kcp -> this.getTeamByID(kcp.teamId()));
    }

    @Override
    public ClientTeam selfTeam() {
        return this.selfTeam;
    }

    @Override
    public KnownClientPlayer self() {
        return this.selfKnownPlayer;
    }

    public void initSelfDetails(UUID selfTeamID) {
        this.selfTeam = this.teamMap.get(selfTeamID);
        UUID userId = class_310.method_1551().method_1548().method_44717();
        this.selfKnownPlayer = this.knownPlayers.get(userId);
        if (this.selfKnownPlayer == null) {
            FTBTeams.LOGGER.error("Local player id {} was not found in the known players list [{}]! FTB Teams will not be able to function correctly!", (Object)userId, (Object)String.join((CharSequence)",", this.knownPlayers.keySet().stream().map(UUID::toString).toList()));
        }
    }

    @Override
    public Optional<KnownClientPlayer> getKnownPlayer(UUID id) {
        return Optional.ofNullable(this.knownPlayers.get(id));
    }

    public Optional<ClientTeam> getTeam(UUID id) {
        return Optional.ofNullable(this.teamMap.get(id));
    }

    @Override
    public class_2561 formatName(@Nullable UUID id) {
        if (id == null || id.equals(class_156.field_25140)) {
            return class_2561.method_43470((String)"System").method_27692(class_124.field_1076);
        }
        KnownClientPlayer p = this.knownPlayers.get(id);
        return class_2561.method_43470((String)(p == null ? "Unknown" : p.name())).method_27692(class_124.field_1054);
    }

    public void addTeam(ClientTeam team) {
        this.teamMap.put(team.getId(), team);
    }

    private void invalidate() {
        this.teamMap.clear();
        this.valid = false;
    }

    public static void syncFromServer(ClientTeamManagerImpl syncedData, UUID selfTeamID, boolean fullSync) {
        if (fullSync) {
            syncedData.initSelfDetails(selfTeamID);
            if (INSTANCE != null) {
                INSTANCE.invalidate();
            }
            INSTANCE = syncedData;
        } else if (INSTANCE != null) {
            syncedData.teamMap.forEach((teamID, clientTeam) -> {
                if (clientTeam.toBeRemoved()) {
                    FTBTeams.LOGGER.debug("remove {} from client team map", teamID);
                    ClientTeamManagerImpl.INSTANCE.teamMap.remove(teamID);
                } else {
                    ClientTeam existing = ClientTeamManagerImpl.INSTANCE.teamMap.get(teamID);
                    if (existing != null) {
                        FTBTeams.LOGGER.debug("update {} in client team map", teamID);
                    } else {
                        FTBTeams.LOGGER.debug("insert {} into client team map", teamID);
                    }
                    ClientTeamManagerImpl.INSTANCE.teamMap.put((UUID)teamID, (ClientTeam)clientTeam);
                }
            });
            ClientTeamManagerImpl.INSTANCE.knownPlayers.putAll(syncedData.knownPlayers);
            INSTANCE.initSelfDetails(selfTeamID);
        }
    }

    public void updatePresence(KnownClientPlayer newPlayer) {
        KnownClientPlayer existing = ClientTeamManagerImpl.INSTANCE.knownPlayers.get(newPlayer.id());
        KnownClientPlayer toUpdate = existing == null ? newPlayer : this.updateFrom(existing.id(), newPlayer);
        this.knownPlayers.put(toUpdate.id(), newPlayer);
        FTBTeams.LOGGER.debug("Updated presence of {}", (Object)newPlayer.name());
    }

    private KnownClientPlayer updateFrom(UUID id, KnownClientPlayer other) {
        return new KnownClientPlayer(id, other.name(), other.online(), other.teamId(), other.profile(), other.extraData());
    }

    public void updateDisplayName(UUID teamId, String newName) {
        Team team = this.teamMap.get(teamId);
        if (team != null) {
            team.setProperty(TeamProperties.DISPLAY_NAME, newName);
            FTBTeams.LOGGER.debug("Updated display name of {} to {}", (Object)teamId, (Object)newName);
        }
    }

    static {
        STREAM_CODEC = class_9139.method_56436((class_9139)class_4844.field_48453, m -> m.managerId, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_4844.field_48453, ClientTeam.STREAM_CODEC), m -> m.teamMap, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_4844.field_48453, KnownClientPlayerNet.STREAM_CODEC), m -> m.knownPlayers, ClientTeamManagerImpl::new);
    }
}

