/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.api.TeamMessage;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.AbstractTeamBase;
import dev.ftb.mods.ftbteams.data.TeamPropertyCollectionImpl;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ClientTeam
extends AbstractTeamBase {
    public static final class_9139<class_9129, ClientTeam> STREAM_CODEC = class_9139.method_56437(ClientTeam::toNet, ClientTeam::fromNet);
    private final TeamType type;
    private final UUID ownerID;
    private final boolean toBeRemoved;
    private BooleanSupplier fullSyncSupplier = () -> false;

    private ClientTeam(UUID id, UUID ownerId, TeamType type, boolean toBeRemoved, TeamPropertyCollection properties) {
        super(id, properties);
        this.ownerID = ownerId;
        this.type = type;
        this.toBeRemoved = toBeRemoved;
    }

    public static ClientTeam invalidTeam(AbstractTeam team) {
        return new ClientTeam(team.getId(), class_156.field_25140, team.getType(), true, new TeamPropertyCollectionImpl());
    }

    public static ClientTeam copyOf(AbstractTeam team) {
        ClientTeam clientTeam = new ClientTeam(team.id, team.getOwner(), team.getType(), false, team.properties.copy());
        clientTeam.ranks.putAll(team.ranks);
        clientTeam.extraData = team.extraData == null ? null : team.extraData.method_10553();
        return clientTeam;
    }

    @Override
    public <T> void syncOnePropertyToAll(MinecraftServer server, TeamProperty<T> property, T value) {
    }

    @Override
    public <T> void syncOnePropertyToTeam(TeamProperty<T> property, T value) {
    }

    @Override
    public TeamType getType() {
        return this.type;
    }

    @Override
    public UUID getOwner() {
        return this.ownerID;
    }

    @Override
    public void sendMessage(UUID senderId, String message) {
    }

    @Override
    public void sendMessage(UUID senderId, class_2561 message) {
    }

    @Override
    public List<class_2561> getTeamInfo() {
        return List.of();
    }

    @Override
    public boolean isClientTeam() {
        return true;
    }

    @Override
    public Collection<class_3222> getOnlineMembers() {
        return List.of();
    }

    @Override
    public boolean isValid() {
        return !this.toBeRemoved();
    }

    @Override
    public boolean isPlayerTeam() {
        return this.type == TeamType.PLAYER;
    }

    @Override
    public boolean isPartyTeam() {
        return this.type == TeamType.PARTY;
    }

    @Override
    public boolean isServerTeam() {
        return this.type == TeamType.SERVER;
    }

    public void setMessageHistory(List<TeamMessage> messages) {
        this.messageHistory.clear();
        this.messageHistory.addAll(messages);
    }

    public boolean toBeRemoved() {
        return this.toBeRemoved;
    }

    public void updateProperties(TeamPropertyCollection newProps) {
        TeamPropertyCollectionImpl old = this.properties.copy();
        this.properties.updateFrom(newProps);
        ((Consumer)TeamEvent.CLIENT_PROPERTIES_CHANGED.invoker()).accept(new ClientTeamPropertiesChangedEvent(this, old));
    }

    public void setFullSyncRequired(BooleanSupplier fullSyncSupplier) {
        this.fullSyncSupplier = fullSyncSupplier;
    }

    @NotNull
    private static ClientTeam fromNet(class_9129 buffer) {
        UUID id = buffer.method_10790();
        UUID ownerID = buffer.readBoolean() ? buffer.method_10790() : class_156.field_25140;
        TeamType type = (TeamType)buffer.method_10818(TeamType.class);
        boolean mustRemove = buffer.readBoolean();
        TeamPropertyCollection props = (TeamPropertyCollection)TeamPropertyCollectionImpl.STREAM_CODEC.decode((Object)buffer);
        ClientTeam clientTeam = new ClientTeam(id, ownerID, type, mustRemove, props);
        int nMembers = buffer.method_10816();
        for (int i = 0; i < nMembers; ++i) {
            clientTeam.addMember(buffer.method_10790(), (TeamRank)buffer.method_10818(TeamRank.class));
        }
        clientTeam.extraData = buffer.method_10798();
        return clientTeam;
    }

    private static void toNet(class_9129 buffer, ClientTeam team) {
        buffer.method_10797(team.id);
        boolean hasOwner = !team.ownerID.equals(class_156.field_25140);
        buffer.method_52964(hasOwner);
        if (hasOwner) {
            buffer.method_10797(team.ownerID);
        }
        buffer.method_10817((Enum)team.type);
        buffer.method_52964(team.toBeRemoved);
        if (team.fullSyncSupplier.getAsBoolean()) {
            team.properties.write(buffer);
        } else {
            team.properties.writeSyncableOnly(buffer);
        }
        buffer.method_10804(team.ranks.size());
        for (Map.Entry entry : team.ranks.entrySet()) {
            buffer.method_10797((UUID)entry.getKey());
            buffer.method_10817((Enum)entry.getValue());
        }
        buffer.method_10794((class_2520)team.extraData);
    }
}

