/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public abstract class TeamProperty<T> {
    protected final class_2960 id;
    private final Supplier<T> defaultValue;
    private boolean playerEditable;
    private boolean shouldSyncToAll;

    protected TeamProperty(class_2960 id, Supplier<T> defaultValue) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.playerEditable = true;
        this.shouldSyncToAll = false;
    }

    protected TeamProperty(class_2960 id, T defaultValue) {
        this(id, () -> defaultValue);
    }

    public abstract TeamPropertyType<T> getType();

    public class_2960 getId() {
        return this.id;
    }

    public T getDefaultValue() {
        return this.defaultValue.get();
    }

    public boolean isPlayerEditable() {
        return this.playerEditable;
    }

    public TeamProperty<T> notPlayerEditable() {
        this.playerEditable = false;
        return this;
    }

    public boolean shouldSyncToAll() {
        return this.shouldSyncToAll;
    }

    public TeamProperty<T> syncToAll() {
        this.shouldSyncToAll = true;
        return this;
    }

    public String getTranslationKey(String prefix) {
        return prefix + "." + this.id.method_12836() + "." + this.id.method_12832();
    }

    public abstract Optional<T> fromString(String var1);

    public abstract void write(class_9129 var1);

    public String toString(T value) {
        return value.toString();
    }

    public void writeValue(class_9129 buf, T value) {
        buf.method_10788(this.toString(value), Short.MAX_VALUE);
    }

    public T readValue(class_9129 buf) {
        return this.fromString(buf.method_10800(Short.MAX_VALUE)).orElse(this.getDefaultValue());
    }

    public class_2520 toNBT(T value) {
        return class_2519.method_23256((String)this.toString(value));
    }

    public Optional<T> fromNBT(class_2520 tag) {
        return this.fromString(tag.method_10714());
    }

    @Nullable
    public ConfigValue<?> config(ConfigGroup config, TeamPropertyValue<T> value) {
        return null;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TeamProperty) {
            return this.id.equals((Object)((TeamProperty)o).id);
        }
        return false;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final String toString() {
        return this.id.toString();
    }

    @Deprecated(forRemoval=true)
    public TeamPropertyValue<T> createDefaultValue() {
        return new TeamPropertyValue<T>(this, this.getDefaultValue());
    }

    @Deprecated(forRemoval=true)
    public TeamPropertyValue<T> createValueFromNetwork(class_9129 buf) {
        return new TeamPropertyValue<T>(this, this.readValue(buf));
    }

    @Deprecated(forRemoval=true)
    public TeamPropertyValue<T> createValueFromNBT(class_2520 tag) {
        return new TeamPropertyValue<T>(this, this.fromNBT(tag).orElse(this.getDefaultValue()));
    }
}

