/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class StringProperty
extends TeamProperty<String> {
    private final Pattern pattern;

    public StringProperty(class_2960 id, Supplier<String> def, @Nullable Pattern pattern) {
        super(id, def);
        this.pattern = pattern;
    }

    public StringProperty(class_2960 id, Supplier<String> def) {
        this(id, def, null);
    }

    public StringProperty(class_2960 id, String def, @Nullable Pattern pattern) {
        this(id, () -> def, pattern);
    }

    public StringProperty(class_2960 id, String def) {
        this(id, () -> def);
    }

    static StringProperty fromNetwork(class_2960 id, class_2540 buf) {
        String def = buf.method_10800(Short.MAX_VALUE);
        int flags = buf.method_10816();
        String patVal = buf.method_10800(Short.MAX_VALUE);
        return new StringProperty(id, def, patVal.isEmpty() ? null : Pattern.compile(patVal, flags));
    }

    @Override
    public TeamPropertyType<String> getType() {
        return TeamPropertyType.STRING;
    }

    @Override
    public Optional<String> fromString(String string) {
        if (this.pattern == null || this.pattern.matcher(string).matches()) {
            return Optional.of(string);
        }
        return Optional.empty();
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_10788((String)this.getDefaultValue(), Short.MAX_VALUE);
        buf.method_10804(this.pattern == null ? 0 : this.pattern.flags());
        buf.method_10788(this.pattern == null ? "" : this.pattern.pattern(), Short.MAX_VALUE);
    }

    @Override
    public ConfigValue<?> config(ConfigGroup config, TeamPropertyValue<String> value) {
        return config.addString(this.id.method_12832(), value.getValue(), value::setValue, (String)this.getDefaultValue(), this.pattern);
    }
}

