/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public class StringMapProperty<T>
extends TeamProperty<Map<String, T>> {
    private final TeamPropertyType<Map<String, T>> propType;
    private final Function<String, T> fromString;
    private final BiConsumer<class_2540, T> toNet;
    private final Function<class_2540, T> fromNet;

    protected StringMapProperty(class_2960 id, Supplier<Map<String, T>> defaultValue, TeamPropertyType<Map<String, T>> propType, Function<String, T> fromString, BiConsumer<class_2540, T> toNet, Function<class_2540, T> fromNet) {
        super(id, defaultValue);
        this.propType = propType;
        this.fromString = fromString;
        this.toNet = toNet;
        this.fromNet = fromNet;
    }

    @Override
    public TeamPropertyType<Map<String, T>> getType() {
        return this.propType;
    }

    @Override
    public Optional<Map<String, T>> fromString(String string) {
        try {
            HashMap res = new HashMap();
            Splitter.on((String)",").withKeyValueSeparator("=").split((CharSequence)string).forEach((k, v) -> res.put(k, this.fromString.apply((String)v)));
            return Optional.of(res);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    @Override
    public String toString(Map<String, T> value) {
        return Joiner.on((String)",").withKeyValueSeparator("=").join(value);
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_34063((Map)this.getDefaultValue(), class_2540::method_10814, this.toNet::accept);
    }

    @Override
    public class_2520 toNBT(Map<String, T> value) {
        class_2487 res = new class_2487();
        value.forEach((k, v) -> res.method_10582(k, v.toString()));
        return res;
    }

    @Override
    public Optional<Map<String, T>> fromNBT(class_2520 tag) {
        if (tag instanceof class_2487) {
            class_2487 c = (class_2487)tag;
            HashMap res = new HashMap();
            c.method_10541().forEach(k -> res.put(k, this.fromString.apply(c.method_10558(k))));
            return Optional.of(res);
        }
        return Optional.empty();
    }

    @Override
    public Map<String, T> readValue(class_9129 buf) {
        return buf.method_34067(class_2540::method_19772, this.fromNet::apply);
    }

    @Override
    public void writeValue(class_9129 buf, Map<String, T> value) {
        buf.method_34063(value, class_2540::method_10814, this.toNet::accept);
    }

    protected static <T> Map<String, T> mapFromNetwork(class_2540 buf, Function<class_2540, T> fromNet) {
        return buf.method_34067(class_2540::method_19772, fromNet::apply);
    }

    public static class ToString
    extends StringMapProperty<String> {
        public ToString(class_2960 id, Map<String, String> defaultValue) {
            super(id, () -> defaultValue, TeamPropertyType.STRING_MAP, Function.identity(), class_2540::method_10814, class_2540::method_19772);
        }

        static ToString fromNetwork(class_2960 id, class_2540 buf) {
            return new ToString(id, ToString.mapFromNetwork(buf, class_2540::method_19772));
        }
    }

    public static class ToBoolean
    extends StringMapProperty<Boolean> {
        public ToBoolean(class_2960 id, Map<String, Boolean> defaultValue) {
            super(id, () -> defaultValue, TeamPropertyType.BOOL_MAP, Boolean::parseBoolean, class_2540::method_52964, class_2540::readBoolean);
        }

        static ToBoolean fromNetwork(class_2960 id, class_2540 buf) {
            return new ToBoolean(id, ToBoolean.mapFromNetwork(buf, class_2540::readBoolean));
        }
    }

    public static class ToInteger
    extends StringMapProperty<Integer> {
        public ToInteger(class_2960 id, Map<String, Integer> defaultValue) {
            super(id, () -> defaultValue, TeamPropertyType.INT_MAP, Integer::parseInt, class_2540::method_10804, class_2540::method_10816);
        }

        static ToInteger fromNetwork(class_2960 id, class_2540 buf) {
            return new ToInteger(id, ToInteger.mapFromNetwork(buf, class_2540::method_10816));
        }
    }
}

