/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public class StringListProperty
extends TeamProperty<List<String>> {
    public StringListProperty(class_2960 id, Supplier<List<String>> def) {
        super(id, def);
    }

    public StringListProperty(class_2960 id, List<String> def) {
        this(id, () -> def);
    }

    static StringListProperty fromNetwork(class_2960 id, class_2540 buf) {
        return new StringListProperty(id, buf.method_34066(b -> b.method_10800(Short.MAX_VALUE)));
    }

    @Override
    public TeamPropertyType<List<String>> getType() {
        return TeamPropertyType.STRING_LIST;
    }

    @Override
    public Optional<List<String>> fromString(String string) {
        return string.length() > 2 && string.startsWith("[") && string.endsWith("]") ? Optional.of(new ArrayList<String>(Arrays.asList(string.substring(1, string.length() - 1).split("\t")))) : Optional.empty();
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_34062((Collection)this.getDefaultValue(), class_2540::method_10814);
    }

    @Override
    public String toString(List<String> value) {
        return "[" + String.join((CharSequence)"\t", value) + "]";
    }

    @Override
    public ConfigValue<?> config(ConfigGroup config, TeamPropertyValue<List<String>> value) {
        return config.addList(this.id.method_12832(), value.getValue(), (ConfigValue)new StringConfig(), (Object)"");
    }

    @Override
    public class_2520 toNBT(List<String> value) {
        class_2499 res = new class_2499();
        value.forEach(s -> res.add((Object)class_2519.method_23256((String)s)));
        return res;
    }

    @Override
    public Optional<List<String>> fromNBT(class_2520 tag) {
        Optional<List<String>> optional;
        if (tag instanceof class_2499) {
            class_2499 l = (class_2499)tag;
            optional = Optional.of(l.stream().map(class_2520::method_10714).toList());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public void writeValue(class_9129 buf, List<String> value) {
        buf.method_34062(value, class_2540::method_10814);
    }

    @Override
    public List<String> readValue(class_9129 buf) {
        return buf.method_34066(class_2540::method_19772);
    }
}

