/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2497;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_9129;

public class IntProperty
extends TeamProperty<Integer> {
    public final int minValue;
    public final int maxValue;

    public IntProperty(class_2960 id, Supplier<Integer> def, int min, int max) {
        super(id, def);
        this.minValue = min;
        this.maxValue = max;
    }

    public IntProperty(class_2960 id, Supplier<Integer> def) {
        this(id, def, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntProperty(class_2960 id, int def, int min, int max) {
        this(id, () -> def, min, max);
    }

    public IntProperty(class_2960 id, int def) {
        this(id, () -> def);
    }

    static IntProperty fromNetwork(class_2960 id, class_2540 buf) {
        return new IntProperty(id, buf.method_10816(), buf.method_10816(), buf.method_10816());
    }

    @Override
    public TeamPropertyType<Integer> getType() {
        return TeamPropertyType.INT;
    }

    @Override
    public Optional<Integer> fromString(String string) {
        try {
            int num = Integer.parseInt(string);
            return Optional.of(class_3532.method_15340((int)num, (int)this.minValue, (int)this.maxValue));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_10804(((Integer)this.getDefaultValue()).intValue());
        buf.method_10804(this.minValue);
        buf.method_10804(this.maxValue);
    }

    @Override
    public void writeValue(class_9129 buf, Integer value) {
        buf.method_53002(value.intValue());
    }

    @Override
    public Integer readValue(class_9129 buf) {
        return buf.readInt();
    }

    @Override
    public ConfigValue<?> config(ConfigGroup config, TeamPropertyValue<Integer> value) {
        return config.addInt(this.id.method_12832(), value.getValue().intValue(), value::setValue, ((Integer)this.getDefaultValue()).intValue(), this.minValue, this.maxValue);
    }

    @Override
    public class_2520 toNBT(Integer value) {
        return class_2497.method_23247((int)value);
    }

    @Override
    public Optional<Integer> fromNBT(class_2520 tag) {
        Optional<Integer> optional;
        if (tag instanceof class_2514) {
            class_2514 n = (class_2514)tag;
            optional = Optional.of(class_3532.method_15340((int)n.method_10701(), (int)this.minValue, (int)this.maxValue));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

