/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2489;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_9129;

public class DoubleProperty
extends TeamProperty<Double> {
    public final double minValue;
    public final double maxValue;

    public DoubleProperty(class_2960 id, Supplier<Double> def, double min, double max) {
        super(id, def);
        this.minValue = min;
        this.maxValue = max;
    }

    public DoubleProperty(class_2960 id, double def, double min, double max) {
        this(id, () -> def, min, max);
    }

    public DoubleProperty(class_2960 id, Supplier<Double> def) {
        this(id, def, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    static DoubleProperty fromNetwork(class_2960 id, class_2540 buf) {
        return new DoubleProperty(id, buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    @Override
    public TeamPropertyType<Double> getType() {
        return TeamPropertyType.DOUBLE;
    }

    @Override
    public Optional<Double> fromString(String string) {
        try {
            double num = Double.parseDouble(string);
            return Optional.of(class_3532.method_15350((double)num, (double)this.minValue, (double)this.maxValue));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_52940(((Double)this.getDefaultValue()).doubleValue());
        buf.method_52940(this.minValue);
        buf.method_52940(this.maxValue);
    }

    @Override
    public ConfigValue<?> config(ConfigGroup config, TeamPropertyValue<Double> value) {
        return config.addDouble(this.id.method_12832(), value.getValue().doubleValue(), value::setValue, ((Double)this.getDefaultValue()).doubleValue(), this.minValue, this.maxValue);
    }

    @Override
    public class_2520 toNBT(Double value) {
        return class_2489.method_23241((double)value);
    }

    @Override
    public Optional<Double> fromNBT(class_2520 tag) {
        Optional<Double> optional;
        if (tag instanceof class_2514) {
            class_2514 n = (class_2514)tag;
            optional = Optional.of(class_3532.method_15350((double)n.method_10697(), (double)this.minValue, (double)this.maxValue));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Double readValue(class_9129 buf) {
        return buf.readDouble();
    }

    @Override
    public void writeValue(class_9129 buf, Double value) {
        buf.method_52940(value.doubleValue());
    }
}

