/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class BigIntegerProperty
extends TeamProperty<BigInteger> {
    public BigIntegerProperty(class_2960 id, Supplier<BigInteger> def) {
        super(id, def);
    }

    public BigIntegerProperty(class_2960 id, BigInteger def) {
        this(id, () -> def);
    }

    @Override
    public TeamPropertyType<BigInteger> getType() {
        return TeamPropertyType.BIG_INTEGER;
    }

    @Override
    public Optional<BigInteger> fromString(String string) {
        try {
            return Optional.of(new BigInteger(string));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_10813(((BigInteger)this.getDefaultValue()).toByteArray());
    }

    public static TeamProperty<BigInteger> fromNetwork(class_2960 id, class_9129 buf) {
        return new BigIntegerProperty(id, new BigInteger(buf.method_10795()));
    }

    @Override
    public BigInteger readValue(class_9129 buf) {
        return new BigInteger(buf.method_10795());
    }

    @Override
    public void writeValue(class_9129 buf, BigInteger value) {
        buf.method_10813(value.toByteArray());
    }

    @Override
    public ConfigValue<?> config(ConfigGroup config, TeamPropertyValue<BigInteger> value) {
        return config.add(this.id.method_12832(), (ConfigValue)new BigIntegerConfig(), (Object)value.getValue(), value::setValue, (Object)((BigInteger)this.getDefaultValue()));
    }

    private static class BigIntegerConfig
    extends ConfigFromString<BigInteger> {
        private BigIntegerConfig() {
        }

        public boolean parse(@Nullable Consumer<BigInteger> consumer, String s) {
            try {
                BigInteger b = new BigInteger(s);
                return this.okValue(consumer, b);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }
}

