/**
 * 
 * How to classify spells:
 * 
 *      'acupuncture': {   // Spell name that you use in the code
            id: 'acupuncture',   // Spell ID that is used in commands in-game
            cast_time: 0.15, // Time in seconds to cast the spell. For instant spells, use 0.15
            tier: 1, // Tier of the spell (1-5). This is used to determine what power level the spell starts being cast at
            targeting: 'enemy', // Targeting type: 'self', 'enemy', 'ally', 'none'
            max_level: 10, // Maximum level the spell can reach.
            school: 'blood', // School of magic: 'blood', 'fire', 'ice', 'lightning', 'ender', 'evocation', 'holy', 'nature', 'eldritch', 'geo', 'special'
            distance: 'any',
            use: 'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
 * 
 * 
 * 
 * 
 * 
 */





global.spells = {
        'acupuncture': {
            id: 'acupuncture',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'blood',
            distance: 'any',
            use: 'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'ball_lightning': {
            id: 'ball_lightning',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'lightning',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'blood_needles': {
            id: 'blood_needles',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'blood',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'blood_slash': {
            id: 'blood_slash',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'blood',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'blood_step': {
            id: 'blood_step',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'blood',
            distance: 'close',
            use:'movement',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'wither_skull': {
            id: 'wither_skull',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'blood',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'burning_dash': {
            id: 'burning_dash',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'fire',
            distance: 'close',
            use:'movement',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'chain_lightning': {
            id: 'chain_lightning',
            cast_time: 0.15,
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'lightning',
            distance: 'close',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'charge': {
            id: 'charge',
            cast_time: 0.15,
            tier: 3,
            targeting: 'self',
            max_level: 3,
            school: 'lightning',
            distance: 'close',
            use:'empower',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'sunbeam': {
            id: 'sunbeam',
            cast_time: 2,
            tier: 1,
            targeting: 'enemy',
            max_level: 9,
            school: 'holy',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'devour': {
            id: 'devour',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'blood',
            distance: 'close',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'frost_step': {
            id: 'frost_step',
            cast_time: 0.15,
            tier: 3,
            targeting: 'enemy',
            max_level: 8,
            school: 'ice',
            distance: 'any',
            use:'movement',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'echoing_strikes': {
            id: 'echoing_strikes',
            cast_time: 0.15,
            tier: 3,
            targeting: 'enemy',
            max_level: 5,
            school: 'ender',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'eldritch_blast': {
            id: 'eldritch_blast',
            cast_time: 0.15,
            tier: 5,
            targeting: 'enemy',
            max_level: 5,
            school: 'eldritch',
            distance: 'any',
            use:'followup',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'evasion': {
            id: 'evasion',
            cast_time: 0.15,
            tier: 4,
            targeting: 'self',
            max_level: 5,
            school: 'ender',
            distance: 'any',
            use:'empower',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'firebolt': {
            id: 'firebolt',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'fire',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'firecracker': {
            id: 'firecracker',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'evocation',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'icicle': {
            id: 'icicle',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'ice',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'lightning_bolt': {
            id: 'lightning_bolt',
            cast_time: 0.15,
            tier: 3,
            targeting: 'enemy',
            max_level: 10,
            school: 'lightning',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'lob_creeper': {
            id: 'lob_creeper',
            cast_time: 0.15,
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'evocation',
            distance: 'close',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'magic_missile': {
            id: 'magic_missile',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'ender',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'ray_of_frost': {
            id: 'ray_of_frost',
            cast_time: 0.10,
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'ice',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'shield': {
            id: 'shield',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'evocation',
            distance: 'close',
            use:'reflect',
            type: 'instant',
            use_cases: ['defense']
        },
        'thunderstorm': {
            id: 'thunderstorm',
            cast_time: 3,
            tier: 3,
            targeting: 'enemy',
            max_level: 8,
            school: 'lightning',
            distance: 'close',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'guiding_bolt': {
            id: 'guiding_bolt',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'holy',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'heal': {
            id: 'heal',
            cast_time: 0.15,
            tier: 2,
            targeting: 'self',
            max_level: 8,
            school: 'holy',
            distance: 'close',
            use:'empower',
            type: 'instant',
            use_cases: ['defense']
        },
        'oakskin': {
            id: 'oakskin',
            cast_time: 1,
            tier: 1,
            targeting: 'self',
            max_level: 8,
            school: 'nature',
            distance: 'close',
            use:'empower',
            type: 'instant',
            use_cases: ['defense']
        },
        'blood_howl': {
            id: 'traveloptics:blood_howl',
            cast_time: 0.15,
            tier: 2,
            targeting: 'enemy',
            max_level: 5,
            school: 'blood',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'despair': {
            id: 'traveloptics:despair',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'ice',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'portal': {
            id: 'portal',
            cast_time: 0.50,
            tier: 2,
            targeting: 'self',
            max_level: 3,
            school: 'ender',
            distance: 'any',
            use:'movement',
            type: 'instant',
            use_cases: ['none']
        },
        // Add other instant spells here following the same structure
        //_______________________________________________________________________________________________________________________
        'acid_orb': {
            id: 'acid_orb',
            cast_time: 1.5, 
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'nature',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'arrow_volley': {
            id: 'arrow_volley',
            cast_time: 1.5,
            tier: 2,
            targeting: 'enemy',
            max_level: 6,
            school: 'nature',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'blight': {
            id: 'blight',
            cast_time: 2.5,
            tier: 3,
            targeting: 'enemy',
            max_level: 8,
            school: 'nature',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'chain_creeper': {
            id: 'chain_creeper',
            cast_time: 1.5,
            tier: 2,
            targeting: 'enemy',
            max_level: 6,
            school: 'evocation',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'cloud_of_regeneration': {
            id: 'cloud_of_regeneration',
            cast_time: 10,
            tier: 4,
            targeting: 'ally',
            max_level: 3,
            school: 'holy',
            distance: 'close',
            use:'empower',
            type: 'charge',
            use_cases: ['support']
        },
        'divine_smite': {
            id: 'divine_smite',
            cast_time: 1.5, 
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'holy',
            distance: 'very_close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'earthquake': {
            id: 'earthquake',
            cast_time: 2,
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'geo',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'blessing_of_life': {
            id: 'blessing_of_life',
            cast_time: 1.5,
            tier: 1,
            targeting: 'ally',
            max_level: 10,
            school: 'holy',
            distance: 'close',
            use:'empower',
            type: 'charge',
            use_cases: ['support']
        },
        'fang_strike': {
            id: 'fang_strike',
            cast_time: 1.5, 
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'nature',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'fang_ward': {
            id: 'fang_ward',
            cast_time: 1.5, 
            tier: 1,
            targeting: 'self',
            max_level: 8,
            school: 'evocation',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['defense']
        },
        'fireball': {
            id: 'fireball',
            cast_time: 2,
            tier: 3,
            targeting: 'enemy',
            max_level: 5,
            school: 'fire',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'firefly_swarm': {
            id: 'firefly_swarm',
            cast_time: 2,
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'nature',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'flaming_strike': {
            id: 'flaming_strike',
            cast_time: 0.5,
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'fire',
            distance: 'very_close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'fortify': {
            id: 'fortify',
            cast_time: 2,
            tier: 1,
            targeting: 'self',
            max_level: 10,
            school: 'holy',
            distance: 'close',
            use:'empower',
            type: 'charge',
            use_cases: ['support', 'defense']
        },
        'frostwave': {
            id: 'frostwave',
            cast_time: 1.2,
            tier: 1,
            targeting: 'enemy',
            max_level: 8,
            school: 'ice',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'greater_heal': {
            id: 'greater_heal',
            cast_time: 6,
            tier: 3,
            targeting: 'self',
            max_level: 1,
            school: 'holy',
            distance: 'any',
            use:'empower',
            type: 'charge',
            use_cases: ['defense']
        },
        'gust': {
            id: 'gust',
            cast_time: 0.7,
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'evocation',
            distance: 'close',
            use:'hinder',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'haste': {
            id: 'haste',
            cast_time: 2,
            tier: 4,
            targeting: 'self',
            max_level: 4,
            school: 'holy',
            distance: 'very_close',
            use:'empower',
            type: 'charge',
            use_cases: ['defense', 'support']
        },
        'healing_circle': {
            id: 'healing_circle',
            cast_time: 1.5, 
            tier: 1,
            targeting: 'ally',
            max_level: 10,
            school: 'holy',
            distance: 'close',
            use:'empower',
            type: 'charge',
            use_cases: ['support', 'defense']
        },
        'heat_surge': {
            id: 'heat_surge',
            cast_time: 1.5, 
            tier: 1,
            targeting: 'enemy',
            max_level: 8,
            school: 'fire',
            distance: 'very_close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'ice_block': {
            id: 'ice_block',
            cast_time: 2,
            tier: 3,
            targeting: 'enemy',
            max_level: 6,
            school: 'ice',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'lightning_lance': {
            id: 'lightning_lance',
            cast_time: 2.2,
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'lightning',
            distance: 'any',
            use:'followup',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'magic_arrow': {
            id: 'magic_arrow',
            cast_time: 1.5,
            tier: 3,
            targeting: 'enemy',
            max_level: 10,
            school: 'ender',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'magma_bomb': {
            id: 'magma_bomb',
            cast_time: 1.5, 
            tier: 2,
            targeting: 'enemy',
            max_level: 8,
            school: 'fire',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'poison_arrow': {
            id: 'poison_arrow',
            cast_time: 1.5, 
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'nature',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'poison_splash': {
            id: 'poison_splash',
            cast_time: 1.5, 
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'nature',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'raise_dead': {
            id: 'raise_dead',
            cast_time: 2,
            tier: 2,
            targeting: 'enemy',
            max_level: 6,
            school: 'blood',
            distance: 'any',
            use:'summon_multiple',
            type: 'charge',
            use_cases: ['offense', 'defense'],
            restricted: true
        },
        'root': {
            id: 'root',
            cast_time: 2.2,
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'nature',
            distance: 'any',
            use: 'control',
            type: 'charge',
            use_cases: ['support', 'defense']
        },
        'scorch': {
            id: 'scorch',
            cast_time: 1.5, 
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'fire',
            distance: 'any',
            use:'followup',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'sculk_tentacles': {
            id: 'sculk_tentacles',
            cast_time: 2,
            tier: 5,
            targeting: 'enemy',
            max_level: 4,
            school: 'eldritch',
            distance: 'any',
            use: 'followup',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'shockwave': {
            id: 'shockwave',
            cast_time: 0.7,
            tier: 1,
            targeting: 'enemy',
            max_level: 8,
            school: 'lightning',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'slow': {
            id: 'slow',
            cast_time: 1.5,
            tier: 3,
            targeting: 'enemy',
            max_level: 4,
            school: 'evocation',
            distance: 'close',
            use: 'hinder',
            type: 'charge',
            use_cases: ['support', 'defense']
        },
        'starfall': {
            id: 'starfall',
            cast_time: 8,
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'ender',
            distance: 'any',
            use:'followup',
            type: 'charge',
            use_cases: ['offense','support']
        },
        'stomp': {
            id: 'stomp',
            cast_time: 0.5,
            tier: 2,
            targeting: 'enemy',
            max_level: 5,
            school: 'geo',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'summon_vex': {
            id: 'summon_vex',
            cast_time: 1.5, 
            tier: 3,
            targeting: 'enemy',
            max_level: 5,
            school: 'evocation',
            distance: 'any',
            use:'summon_multiple',
            type: 'charge',
            use_cases: ['offense', 'defense'],
            restricted: true
        },
        'burning_judgement': {
            id: 'traveloptics:burning_judgment', // Incorrect spelling is intentional, its wrong in the mod
            cast_time: 2.7,
            tier: 1,
            targeting: 'enemy',
            max_level: 6,
            school: 'fire',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'stele_cascade': {
            id: 'traveloptics:stele_cascade',
            cast_time: 1.2,
            tier: 1,
            targeting: 'enemy',
            max_level: 6,
            school: 'nature',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'death_laser': {
            id: 'traveloptics:death_laser',
            cast_time: 6,
            tier: 2,
            targeting: 'enemy',
            max_level: 3,
            school: 'lightning',
            distance: 'any',
            use:'followup',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'meteor_storm': {
            id: 'traveloptics:meteor_storm',
            cast_time: 0.7,
            tier: 4,
            targeting: 'enemy',
            max_level: 6,
            school: 'fire',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'orbital_void': {
            id: 'traveloptics:orbital_void',
            cast_time: 2,
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'ender',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'abyssal_blast': {
            id: 'traveloptics:abyssal_blast',
            cast_time: 8,
            tier: 4,
            targeting: 'enemy',
            max_level: 3,
            school: 'eldritch',
            distance: 'any',
            use:'followup',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'aerial_collapse': {
            id: 'traveloptics:aerial_collapse',
            cast_time: 4,
            tier: 2,
            targeting: 'enemy',
            max_level: 5,
            school: 'nature',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],
            restricted: true
        },
        'annihilation': {
            id: 'traveloptics:annihilation',
            cast_time: 4.5,
            tier: 15,
            targeting: 'none',
            max_level: 3,
            school: 'special',
            distance: 'none',
            use:'none',
            type: 'none',
            use_cases: ['none', 'none'],
            restricted: true
        },
        'axe_of_the_doomed': {
            id: 'traveloptics:axe_of_the_doomed',
            cast_time: 4.5,
            tier: 5,
            targeting: 'enemy',
            max_level: 3,
            school: 'ice',
            distance: 'any',
            use:'summon_once',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        'cursed_minefield': {
            id: 'traveloptics:cursed_minefield',
            cast_time: 2.5,
            tier: 1,
            targeting: 'enemy',
            max_level: 8,
            school: 'ender',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'cursed_revenants': {
            id: 'traveloptics:cursed_revenants',
            cast_time: 2.5,
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'ice',
            distance: 'any',
            use:'summon_multiple',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        'eternal_sentinel': {
            id: 'traveloptics:eternal_sentinel',
            cast_time: 4.2,
            tier: 5,
            targeting: 'enemy',
            max_level: 3,
            school: 'ender',
            distance: 'any',
            use:'summon_once',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        'halberd_horizon': {
            id: 'traveloptics:halberd_horizon',
            cast_time: 2,
            tier: 3,
            targeting: 'enemy',
            max_level: 6,
            school: 'ice',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'ignited_onslaught': {
            id: 'traveloptics:ignited_onslaught',
            cast_time: 3.5,
            tier: 4,
            targeting: 'enemy',
            max_level: 5,
            school: 'fire',
            distance: 'any',
            use:'summon_once',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        'lava_bomb': {
            id: 'traveloptics:lava_bomb',
            cast_time: 2.5,
            tier: 3,
            targeting: 'enemy',
            max_level: 3,
            school: 'fire',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],
            restricted: true
        },
        /**
         * 
         *         'magnetron_deployment': {
            id: 'traveloptics:magnetron_deployment',
            cast_time: 3,
            tier: 5,
            targeting: 'enemy',
            max_level: 1,
            school: 'lightning',
            distance: 'any',
            use:'summon_once',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support']
        },
         * 
         */

        'mechanized_predator': {
            id: 'traveloptics:mechanized_predator',
            cast_time: 4.5,
            tier: 3,
            targeting: 'enemy',
            max_level: 5,
            school: 'lightning',
            distance: 'any',
            use:'summon_once',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        'nocturnal_swarm': {
            id: 'traveloptics:nocturnal_swarm',
            cast_time: 2,
            tier: 1,
            targeting: 'enemy',
            max_level: 8,
            school: 'blood',
            distance: 'any',
            use:'summon_multiple',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        /**
         *         'the_forgotten_beast': {
            id: 'traveloptics:the_forgotten_beast',
            cast_time: 5,
            tier: 5,
            targeting: 'enemy',
            max_level: 2,
            school: 'eldritch',
            distance: 'close',
            use:'summon_once',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support']
        },
         * 
         */

        'void_eruption': {
            id: 'traveloptics:void_eruption',
            cast_time: 2.2,
            tier: 3,
            targeting: 'enemy',
            max_level: 3,
            school: 'ender',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'nullflare': {
            id: 'traveloptics:nullflare',
            cast_time: 1.5, 
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'holy',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'sword_of_the_ancients': {
            id: 'traveloptics:sword_of_the_ancients',
            cast_time: 4.2,
            tier: 5,
            targeting: 'enemy',
            max_level: 3,
            school: 'holy',
            distance: 'any',
            use:'summon_once',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        'summon_desert_dwellers': {
            id: 'traveloptics:summon_desert_dwellers',
            cast_time: 3.5,
            tier: 4,
            targeting: 'enemy',
            max_level: 5,
            school: 'holy',
            distance: 'any',
            use:'summon_once',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        'em_pulse': {
            id: 'traveloptics:em_pulse',
            cast_time: 5,
            tier: 2,
            targeting: 'enemy',
            max_level: 5,
            school: 'lightning',
            distance: 'very_close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'primal_pack': {
            id: 'traveloptics:primal_pack',
            cast_time: 5,
            tier: 4,
            targeting: 'enemy',
            max_level: 5,
            school: 'nature',
            distance: 'any',
            use:'summon_once',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        /**
         *         'solar_flare': {
            id: 'traveloptics:solar_flare',
            cast_time: 1.5,
            tier: 2,
            targeting: 'self',
            max_level: 8,
            school: 'holy',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],

        },
         * 
         * 
         */

        'vortex_punch': {
            id: 'traveloptics:vortex_punch',
            cast_time: 1.5,
            tier: 5,
            targeting: 'enemy',
            max_level: 3,
            school: 'ender',
            distance: 'any',
            use: 'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'blackout': {
            id: 'traveloptics:blackout',
            cast_time: 2.1,
            tier: 3,
            targeting: 'enemy',
            max_level: 3,
            school: 'eldritch',
            distance: 'close',
            use: 'hinder',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'blaze_storm': {
            id: 'blaze_storm',
            cast_time: 3,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'fire',
            distance: 'any',
            use:'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'cone_of_cold': {
            id: 'cone_of_cold',
            cast_time: 5,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'ice',
            distance: 'close',
            use:'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'dragon_breath': {
            id: 'dragon_breath',
            cast_time: 5,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'ender',
            distance: 'close',
            use:'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'electrocute': {
            id: 'electrocute',
            cast_time: 5,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'lightning',
            distance: 'close',
            use:'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'fire_breath': {
            id: 'fire_breath',
            cast_time: 5,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'fire',
            distance: 'close',
            use:'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'poison_breath': {
            id: 'poison_breath',
            cast_time: 5,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'nature',
            distance: 'close',
            use: 'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'ashen_breath': {
            id: 'traveloptics:ashen_breath',
            cast_time: 5,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'evocation',
            distance: 'close',
            use: 'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'rapid_laser': {
            id: 'traveloptics:rapid_laser',
            cast_time: 6,
            tier: 2,
            targeting: 'enemy',
            max_level: 10,
            school: 'lightning',
            distance: 'any',
            use:'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'ashen_breath': {
            id: 'traveloptics:ashen_breath',
            cast_time: 1,
            tier: 5,
            targeting: 'enemy',
            max_level: 10,
            school: 'evocation',
            distance: 'close',
            use: 'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'vortex_of_the_deep': {
            id: 'traveloptics:vortex_of_the_deep',
            cast_time: 1,
            tier: 5,
            targeting: 'enemy',
            max_level: 6,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'bubble_spray': {
            id: 'traveloptics:bubble_spray',
            cast_time: 5.5,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'hydroshot': {
            id: 'traveloptics:hydroshot',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'aqua_missiles': {
            id: 'traveloptics:aqua_missiles',
            cast_time: 7,
            tier: 3,
            targeting: 'enemy',
            max_level: 5,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'persistent',
            use_cases: ['offense', 'defense']
        },
        'rainfall': {
            id: 'traveloptics:rainfall',
            cast_time: 2,
            tier: 4,
            targeting: 'enemy',
            max_level: 3,
            school: 'aqua',
            distance: 'any',
            use:'hinder',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'flood_slash': {
            id: 'traveloptics:flood_slash',
            cast_time: 0.15,
            tier: 3,
            targeting: 'enemy',
            max_level: 5,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'tidal_grasp': {
            id: 'traveloptics:tidal_grasp',
            cast_time: 2,
            tier: 2,
            targeting: 'enemy',
            max_level: 6,
            school: 'aqua',
            distance: 'any',
            use:'control',
            type: 'persistent',
            use_cases: ['defense']
        },
        'floodgate': {
            id: 'traveloptics:floodgate',
            cast_time: 0.15,
            tier: 4,
            targeting: 'enemy',
            max_level: 8,
            school: 'aqua',
            distance: 'any',
            use:'empower',
            type: 'instant',
            use_cases: ['offense', 'defense'],
        },
        'tsunami': {
            id: 'traveloptics:tsunami',
            cast_time: 1,
            tier: 3,
            targeting: 'enemy',
            max_level: 4,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'conjure_void_tomes': {
            id: 'traveloptics:conjure_void_tomes',
            cast_time: 3,
            tier: 3,
            targeting: 'self',
            max_level: 5,
            school: 'ender',
            distance: 'any',
            use:'summon_multiple',
            type: 'charge',
            use_cases: ['offense', 'defense', 'support'],
            restricted: true
        },
        //_______________________________________________________________________________________________________________________
        'fissure': {
            id: 'gtbcs_geomancy_plus:fissure',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 8,
            school: 'geo',
            distance: 'close',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'tremor_spike': {
            id: 'gtbcs_geomancy_plus:tremor_spike',
            cast_time: 1,
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'geo',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'tremor_step': {
            id: 'gtbcs_geomancy_plus:tremor_step',
            cast_time: 0.15,
            tier: 1,
            targeting: 'self',
            max_level: 3,
            school: 'geo',
            distance: 'close',
            use:'buff',
            type: 'instant',
            use_cases: ['support']
        },
        'eroding_boulder': {
            id: 'gtbcs_geomancy_plus:eroding_boulder',
            cast_time: 2.5,
            tier: 1,
            targeting: 'enemy',
            max_level: 5,
            school: 'geo',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'chunker': {
            id: 'gtbcs_geomancy_plus:chunker',
            cast_time: 2,
            tier: 2,
            targeting: 'enemy',
            max_level: 6,
            school: 'geo',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'seismic_surf': {
            id: 'gtbcs_geomancy_plus:seismic_surf',
            cast_time: 2,
            tier: 6,
            targeting: 'self',
            max_level: 3,
            school: 'geo',
            distance: 'close',
            use:'buff',
            type: 'charge',
            use_cases: ['support']
        },
        'dripstone_bolt': {
            id: 'gtbcs_geomancy_plus:dripstone_bolt',
            cast_time: 0.15,
            tier: 1,
            targeting: 'enemy',
            max_level: 10,
            school: 'geo',
            distance: 'any',
            use:'damage',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },
        'earth_pillar': {
            id: 'gtbcs_geomancy_plus:pillar_of_the_resounding_earth',
            cast_time: 1.5,
            tier: 3,
            targeting: 'enemy',
            max_level: 6,
            school: 'geo',
            distance: 'close',
            use: 'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'geo_conductor': {
            id: 'gtbcs_geomancy_plus:geo_conductor',
            cast_time: 1.0,
            tier: 2,
            targeting: 'self',
            max_level: 4,
            school: 'geo',
            distance: 'self',
            use: 'buff',
            type: 'instant',
            use_cases: ['support']
        },
        'petrivise': {
            id: 'gtbcs_geomancy_plus:petrivise',
            cast_time: 2.5,
            tier: 4,
            targeting: 'enemy',
            max_level: 4,
            school: 'geo',
            distance: 'close',
            use: 'debuff',
            type: 'instant',
            use_cases: ['offense', 'defense']
        },

        'solar_beam': {
            id: 'gtbcs_geomancy_plus:solar_beam',
            cast_time: 4.5,
            tier: 2,
            targeting: 'enemy',
            max_level: 5,
            school: 'holy',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },

        'the_howling_tempest': {
            id: 'traveloptics:the_howling_tempest',
            cast_time: 10.5,
            tier: 3,
            targeting: 'enemy',
            max_level: 3,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense']
        },
        'supernova': {
            id: 'traveloptics:supernova',
            cast_time: 5.5,
            tier: 4,
            targeting: 'enemy',
            max_level: 1,
            school: 'ender',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],
            restricted: true
        },
        'skypiercer': {
            id: 'traveloptics:skypiercer',
            cast_time: 1,
            tier: 4,
            targeting: 'enemy',
            max_level: 1,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],
            restricted: true
        },
        'shear_of_the_stars': {
            id: 'traveloptics:shear_of_the_stars',
            cast_time: 4,
            tier: 4,
            targeting: 'enemy',
            max_level: 1,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],
            restricted: true
        },
        'serpentide': {
            id: 'traveloptics:serpentide',
            cast_time: 2,
            tier: 2,
            targeting: 'enemy',
            max_level: 4,
            school: 'aqua',
            distance: 'close',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],
        },
        'psychic_bolt': {
            id: 'traveloptics:psychic_bolt',
            cast_time: 1,
            tier: 3,
            targeting: 'enemy',
            max_level: 4,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],
            restricted: true
        },
        'herald_of_acropolis': {
            id: 'traveloptics:herald_of_acropolis',
            cast_time: 6,
            tier: 4,
            targeting: 'enemy',
            max_level: 4,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],
            restricted: true
        },
        'coral_barrage': {
            id: 'traveloptics:coral_barrage',
            cast_time: 1,
            tier: 2,
            targeting: 'enemy',
            max_level: 5,
            school: 'aqua',
            distance: 'any',
            use:'damage',
            type: 'charge',
            use_cases: ['offense', 'defense'],
        },




};






// startup_scripts/effects.js
StartupEvents.registry('mob_effect', event => {
  let spells = global.spells
  Object.keys(spells).forEach(key => {
    let effectId = `${key}` // => kubejs:tsunami, kubejs:floodgate
    event.create(effectId)
      .color(0x00FFFF) // Aqua color
      .beneficial() // or .harmful() if it's meant to debuff enemies
  })
})