let metallurgy = {
    'ruby': 0xFF1100,
    'topaz': 0xFFA500,
    'peridot': 0xBAFF66,
    'jade': 0x00A86B,
    'necoium': 0xeb14a9,
    'ametrine': 0x941e70,
    'sapphire': 0x0816e8,
    'aquamarine': 0x0883e8
}
//__________________________
const removeDropsFromEntity = {
	'fathomless:crimson_ingot': ['fathomless:bishop', 'fathomless:herald', 'fathomless:cultist', 'fathomless:archbishop'],
	'soulsweapons:soul_ingot': ['soulsweapons:remnant'],
	'iceandfire:ghost_ingot': ['iceandfire:ghost'],
	'cataclysm:ancient_metal_ingot': ['cataclysm:koboleton', 'cataclysm:wadjet', 'cataclysm:kobolediator'],
	'cataclysm:black_steel_ingot': ['cataclysm:draugr', 'cataclysm:elite_draugr', 'cataclysm:royal_draugr', 'cataclysm:aptrgangr'],
	'endrem:wither_eye': ['minecraft:wither'],
    'cataclysm:burning_ashes': ['cataclysm:ignited_revenant'],
    'soulsweapons:essence_of_eventide': ['soulsweapons:night_shade'],
	'cataclysm:strange_key': ['cataclysm:aptrgangr'],
	'alexscaves:immortal_embryo': ['alexscaves:hullbreaker'],
	'quark:stoneling': ['quark:heart_of_diamond'],
}

LootJS.modifiers(event => {
	Object.entries(removeDropsFromEntity).forEach(([drop, entities]) => {
		entities.forEach(entity => {
			event.addEntityLootModifier(entity).removeLoot(drop)
		})
	})
})
//__________________________
const removeLootFromChest = {
	'cataclysm:black_steel_ingot': ['cataclysm:chests/frosted_prison_treasure'],
	'cataclysm:ancient_metal_ingot': ['cataclysm:chests/cursed_pyramid/cursed_pyramid_treasure', 'cataclysm:entities/kobolediator', 'cataclysm:entities/wadjet', 'cataclysm:entities/koboleton', 'traveloptics:entities/kobolediator_additions_new', 'traveloptics:entities/koboleton_additions'],
	'enigmaticlegacy:etherium_ore': ['bosses_of_mass_destruction:chests/obsidilith', 'minecraft:chests/end_city_treasure'],
	'cataclysm:necklace_of_the_desert': ['cataclysm:archaeology/cursed_pyramid_necklace', 'cataclysm:archaeology/cursed_pyramid'],
	'traveloptics:verdant_spellweave_ingot': ['traveloptics:entities/amethyst_crab_additions_new'],
	'iceandfire:sapphire_gem': ['idas:chests/dread_citadel/dread_citadel', 'idas:chests/labyrinth/if_labyrinth_tomb', 'iceandfire:blocks/sapphire_ore'],
	'call_of_yucutan:jade': ['call_of_yucutan:blocks/jade_ore', 'call_of_yucutan:blocks/deepslate_jade_ore', 'call_of_yucutan:chest/overgrown_chest_loot', 'call_of_yucutan:chest/crypt_chest_loot'],
	'hazennstuff:raw_zenalite': ['hazennstuff:blocks/deepslate_zenalite_ore', 'hazennstuff:blocks/zenalite_ore'],
	'soulsweapons:moonstone': ['soulsweapons:blocks/moonstone_ore', 'soulsweapons:blocks/moonstone_ore_deepslate'],
	'soulsweapons:verglas': ['soulsweapons:blocks/verglas_ore', 'soulsweapons:blocks/verglas_ore_deepslate'],
}

LootJS.modifiers((event) => {
	Object.entries(removeLootFromChest).forEach(([drop, tables]) => {
		tables.forEach(table => {
			event.addLootTableModifier(table).removeLoot(drop)
		})
	})
})

let removeRecipeByOutput = [
	'gobber2:gobber2_ingot_nether',
	'gobber2:gobber2_ingot_end',
	'fromtheshadows:diabolium_ingot',
	'create:rose_quartz',
	'create:polished_rose_quartz',
	'born_in_chaos_v1:dark_metal_ingot',
	'clanginghowl:extraterrestrial_steel_ingot',
	'soulsweapons:crimson_ingot',
	'fathomless:crimson_ingot',
	'clanginghowl:blaze_fuel',
	'iceandfire:sapphire_gem',
	'call_of_yucutan:jade',
	'rats:oratchalcum_ingot',
	'hazennstuff:zenalite_ingot',
	'soulsweapons:soul_ingot',
	'enigmaticlegacy:etherium_ingot',
	'alexscaves:tremorzilla_egg',
	'fdbosses:eye_of_chesed',
	'fdbosses:eye_of_malkuth',
	'call_of_yucutan:ancient_gold',
	'createaddition:electrum_ingot',
	'bonfires:estus_shard'
]

let removeByID = [
	'gobber2:gobber2_ingot_nether',
	'hazennstuff:starkissed_zenalite',
	'irons_spellbooks:arcane_ingot',
	'cataclysm:ancient_metal_ingot_from_nuggets',
	'cataclysm:black_steel_ingot_from_nuggets',
	'iceandfire:dragonforge/dragonsteel_ice_ingot',
	'iceandfire:dragonforge/dragonsteel_fire_ingot',
	'iceandfire:dragonforge/dragonsteel_lightning_ingot',
	'fromtheshadows:fromtheshadows.diabolium_ingot',
]

const non_silk_touch_blocks = [
	'iceandfire:sapphire_ore',
	'call_of_yucutan:jade_ore',
	'call_of_yucutan:deepslate_jade_ore',
]

non_silk_touch_blocks.forEach(block => {
	LootJS.modifiers(event => {
		event.addBlockLootModifier(block).addLoot(block)
	})
})

ServerEvents.recipes(event => {
	event.recipes.create.sandpaper_polishing('create:crushed_raw_iron', 'minecraft:iron_ingot')
	event.recipes.create.sandpaper_polishing('create:crushed_raw_gold', 'minecraft:gold_ingot')
	event.recipes.create.sandpaper_polishing('create:crushed_raw_copper', 'minecraft:copper_ingot')
	event.recipes.create.sandpaper_polishing('create:crushed_raw_zinc', 'create:zinc_ingot')
	event.recipes.create.sandpaper_polishing('create:crushed_raw_silver', 'iceandfire:silver_ingot')

	event.recipes.create.sandpaper_polishing('create:polished_rose_quartz', 'create:rose_quartz')
	removeRecipeByOutput.forEach(item => {
		event.remove({output: item})
	})

	removeByID.forEach(item => {
		event.remove({id: item})
	})

    event.recipes.create.sandpaper_polishing('kubejs:diamond_dust', 'minecraft:diamond')
    event.recipes.vintage.pressurizing('kubejs:diamond_cube', '4x kubejs:diamond_dust')
    event.shapeless('kubejs:diamond_cube', ['9x kubejs:diamond_dust'])
	event.recipes.create.mixing(Fluid.of('kubejs:liquid_diamond'), ['kubejs:diamond_cube', Fluid.of('minecraft:lava')])
	event.recipes.create.mixing(Fluid.of(`kubejs:acidic_gobber`), [`gobber2:gobber2_glob`, Fluid.of('alexscaves:acid')])


	event.shaped('eeeabsmobs:ghost_steel_ingot', [
		' I ',
		'IGI',
		' I '	
	], {
		I: 'eeeabsmobs:ancient_drive_crystal',
		G: 'iceandfire:ghost_ingot'
	})

// ####  Ore -> Dust -> Acidic Ore -> Ingot/Gem #### 

	// Ore -> Dust
	event.recipes.vintage.hammering('kubejs:sapphire_dust', 'iceandfire:sapphire_ore')
	event.recipes.create.mixing(Fluid.of('kubejs:acidic_sapphire'), ['kubejs:sapphire_dust', Fluid.of('alexscaves:acid')])
	event.recipes.vintage.hammering('kubejs:jade_dust', 'call_of_yucutan:jade_ore')
	event.recipes.vintage.hammering('kubejs:jade_dust', 'call_of_yucutan:deepslate_jade_ore')

	//Dust -> Acidic Ore
	event.recipes.create.mixing(Fluid.of(`kubejs:acidic_sapphire`), [`iceandfire:sapphire`, Fluid.of('alexscaves:acid')])
	event.recipes.create.mixing(Fluid.of(`kubejs:acidic_jade`), ['kubejs:jade_dust', Fluid.of('alexscaves:acid')])

	event.recipes.vintage.pressurizing('iceandfire:sapphire_gem', ['minecraft:netherite_ingot', Fluid.of(`kubejs:acidic_sapphire`)])
	event.recipes.vintage.pressurizing('call_of_yucutan:jade', ['iceandfire:sapphire_gem', Fluid.of(`kubejs:acidic_jade`)])


	event.recipes.vintage.centrifugation('traveloptics:verdant_spellweave_ingot', ['kubejs:wildweave_tonic', 'call_of_yucutan:jade', Fluid.of(`kubejs:ender_blood`)])
	event.recipes.vintage.vacuumizing(`gobber2:gobber2_ingot`, ['cataclysm:ancient_metal_ingot', 'traveloptics:verdant_spellweave_ingot',Fluid.of(`kubejs:acidic_gobber`)])
	event.recipes.create_optical.focusing(
		['2x iceandfire:ectoplasm'], // output
		['quark:soul_bead'] // input
	)
    event.recipes.create_optical.focusing(
		['2x iceandfire:ectoplasm'], // output
		['soulsweapons:lost_soul'] // input
	)

    event.recipes.vintage.centrifugation('iceandfire:ghost_ingot', ['4x iceandfire:ectoplasm', 'soulsweapons:soul_ingot'])

    //event.recipes.create.mixing('iceandfire:ghost_ingot', ['iceandfire:ghost_ingot', Fluid.of(`kubejs:acidic_gobber`), 'kubejs:diamond_dust', `gobber2:gobber2_ingot`])

	event.recipes.create.mixing('enigmaticlegacy:etherium_ore', ['iceandfire:ghost_ingot', Fluid.of(`kubejs:acidic_gobber`), 'alexscaves:pearl', `gobber2:gobber2_ingot`])
	event.recipes.vintage.laser_cutting('enigmaticlegacy:etherium_ingot', 'enigmaticlegacy:etherium_ore')
	event.recipes.vintage.pressurizing('gobber2:gobber2_ingot_nether', ['enigmaticlegacy:etherium_ingot', 'gobber2:gobber2_glob_nether']).superheated()
	event.recipes.vintage.vibrating('kubejs:gobber_dust','gobber2:gobber2_ingot_nether')
	event.recipes.vintage.pressurizing('gobber2:gobber2_ingot_end', ['#kubejs:cataclysm_boss_drops_for_ingots', 'kubejs:gobber_dust', Fluid.of(`kubejs:void`)])

	event.custom({
		type: "iceandfire:dragonforge",
		dragon_type: "fire",
		cook_time: 1000,
		input: {
			item: "gobber2:gobber2_ingot_end"
		},
		blood: {
			item: "iceandfire:summoning_crystal_fire"
		},
		result: {
			item: "iceandfire:dragonsteel_fire_ingot"
		}
	})

	event.custom({
		type: "iceandfire:dragonforge",
		dragon_type: "ice",
		cook_time: 1000,
		input: {
			item: "gobber2:gobber2_ingot_end"
		},
		blood: {
			item: "iceandfire:summoning_crystal_ice"
		},
		result: {
			item: "iceandfire:dragonsteel_ice_ingot"
		}
	})

	event.custom({
		type: "iceandfire:dragonforge",
		dragon_type: "lightning",
		cook_time: 1000,
		input: {
			item: "gobber2:gobber2_ingot_end"
		},
		blood: {
			item: "iceandfire:summoning_crystal_lightning"
		},
		result: {
			item: "iceandfire:dragonsteel_lightning_ingot"
		}
	})

    event.blasting('hazennstuff:zenalite_ingot', 'hazennstuff:starkissed_zenalite')
	event.recipes.vintage.pressurizing('soulsweapons:soul_ingot', ['4x iceandfire:dread_shard', 'quark:diamond_heart'])
	event.recipes.create.mixing('quark:diamond_heart', ['2x quark:soul_bead', 'kubejs:diamond_cube', '4x eeeabsmobs:immortal_debris'])

	event.replaceInput(
		{ output: 'iceandfire:summoning_crystal_fire' }, // Arg 1: the item recipe you are changing
		'minecraft:emerald',            // Arg 2: input to replace
		'fantasy_weapons:blazing_stone'            // Arg 3: item to replace with
	)

	event.replaceInput(
		{ output: 'iceandfire:summoning_crystal_lightning' }, // Arg 1: the item recipe you are changing
		'minecraft:amethyst_shard',            // Arg 2: input to replace
		'aquamirae:abyssal_amethyst'           // Arg 3: item to replace with
	)


	event.shaped('irons_spellbooks:arcane_anvil', [
		'mam',
		' d ',
		'pep'
	], {
			m: 'fantasy_armor:moon_crystal', // Moon Crystal
			a: 'aquamirae:abyssal_amethyst', // Abyssal amethyst
			d: 'kubejs:diamond_cube', // Diamond Cube
			p: 'minecraft:crying_obsidian', // Verglas
			e: 'minecraft:enchanting_table' // Enchanting table
		}
	)
    event.shaped('cataclysm:black_steel_ingot', [
		'nnn',
		'nsn',
		'nnn'
	], {
			n: 'cataclysm:black_steel_nugget', // Moon Crystal
			s: 'eeeabsmobs:immortal_ingot', // Abyssal amethyst
		}
	)

    event.replaceInput(
		{ output: 'eeeabsmobs:immortal_ingot' }, // Arg 1: the item recipe you are changing
		'minecraft:iron_ingot',       // Arg 2: input to replace
		'hazennstuff:steel_ingot'           // Arg 3: item to replace with
	)


    event.shaped('soulsweapons:moonstone', [
		'n n',
		' s ',
		'n n'
	], {
			n: 'irons_spellbooks:divine_pearl', // Moon Crystal
			s: 'iceandfire:silver_ingot', // Abyssal amethyst
		}
	)

    event.shaped('irons_spellbooks:arcane_ingot', [
		'nnn',
		'nsn',
		'nnn'
	], {
			n: 'irons_spellbooks:arcane_essence', // Moon Crystal
			s: 'soulsweapons:moonstone', // Abyssal amethyst
		}
	)


    event.recipes.create.compacting('soulsweapons:verglas', ['kubejs:diamond_cube', 'irons_spellbooks:arcane_ingot'])
    event.recipes.vintage.pressurizing('4x soulsweapons:verglas', [Fluid.of('kubejs:liquid_diamond'), 'irons_spellbooks:arcane_ingot'])
    event.recipes.create.mixing('3x soulsweapons:moonstone', ['iceandfire:silver_ingot', '6x irons_spellbooks:arcane_essence'])
    event.recipes.create.crushing('hazennstuff:raw_zenalite', 'soulsweapons:verglas')
    event.recipes.create.compacting('hazennstuff:starkissed_zenalite', ['hazennstuff:raw_zenalite', '3x irons_spellbooks:cinder_essence', 'irons_spellbooks:lightning_bottle'])
    event.recipes.vintage.pressurizing('4x hazennstuff:zenalite_ingot', [Fluid.of('kubejs:liquid_diamond'), '2x hazennstuff:starkissed_zenalite', '3x irons_spellbooks:cinder_essence', 'irons_spellbooks:lightning_bottle'])
	event.recipes.create.compacting('createaddition:electrum_ingot', ['iceandfire:silver_ingot', 'create:crushed_raw_gold'])


	// Copper
	event.shaped('vintage:vanadium_ingot', [
		'nnn',
		'nsn',
		'nnn'
	], {
			n: 'create:crushed_raw_iron', // Moon Crystal
			s: 'create:brass_ingot', // Abyssal amethyst
		}
	)
	event.recipes.create.compacting('fromtheshadows:diabolium_ingot', ['vintage:vanadium_ingot', 'fromtheshadows:crystallized_blood'])
	event.recipes.vintage.pressurizing('3x fromtheshadows:diabolium_ingot', ['vintage:vanadium_ingot', 'fromtheshadows:bottle_of_blood'])


	event.shaped('create:rose_quartz', [
		'rrc',
		'rqc',
		'rcc'
	], {
			q: 'minecraft:quartz', // Quartz
			r: 'minecraft:redstone', // Redstone
			c: 'create:crushed_raw_copper' // Crushed Copper
		}
	)


		event.shaped('call_of_yucutan:ancient_gold', [
		'ggg',
		'g g',
		'ggg'
	], {
			g: 'minecraft:gold_ingot', // Gold
		}
	)




	// Iron
	event.shaped('block_factorys_bosses:ancient_iron_ingot', [
		'nnn',
		'nsn',
		'nnn'
	], {
		n: 'block_factorys_bosses:ancient_iron_nugget', // Moon Crystal
		s: 'graveyard:dark_iron_ingot', // Abyssal amethyst
		}
	)

    event.recipes.create.compacting('born_in_chaos_v1:dark_metal_ingot', ['born_in_chaos_v1:pileof_dark_metal', 'block_factorys_bosses:ancient_iron_ingot'])


	// Silver
	event.recipes.create.compacting('clanginghowl:extraterrestrial_steel_ingot', ['createaddition:electrum_ingot', '2x clanginghowl:extraterrestrial_steel'])
    event.recipes.vintage.centrifugation('soulsweapons:crimson_ingot', ['soulsweapons:demon_chunk', 'clanginghowl:extraterrestrial_steel_ingot', '2x born_in_chaos_v1:fire_dust'])

	// Diamond
	event.recipes.create.mixing('fathomless:crimson_ingot', ['soulsweapons:crimson_ingot', 'bonfires:estus_shard', '3x fathomless:crimson_dust', 'fathomless:crimson_tendon'])
    event.recipes.vintage.centrifugation('clanginghowl:blaze_fuel', ['alexscaves:radon_bottle', 'fathomless:crimson_ingot', 'clanginghowl:extraterrestrial_energy_crystal'])
	event.recipes.vintage.pressurizing('alexscaves:gazing_pearl', ['clanginghowl:blaze_fuel', Fluid.of('alexscaves:purple_soda'), 'alexscaves:pewen_sap']).superheated()
	event.recipes.vintage.turning('alexscaves:pearl', 'alexscaves:gazing_pearl')

	event.recipes.create.compacting('bonfires:estus_shard', ['iceandfire:ectoplasm', 'minecraft:ghast_tear', 'minecraft:magma_cream', 'minecraft:fire_charge'])





	// Netherite
    event.recipes.vintage.centrifugation(Fluid.of('kubejs:liquified_ratlantean_spirit'), ['3x rats:ratlantean_flame', Fluid.of('minecraft:lava')])
	event.recipes.create.mixing('rats:oratchalcum_ingot', [Fluid.of('kubejs:liquified_ratlantean_spirit'), 'minecraft:netherite_ingot', 'rats:raw_oratchalcum'])
    event.recipes.vintage.pressurizing('cataclysm:ancient_metal_ingot', ['rats:oratchalcum_ingot', '8x cataclysm:ancient_metal_nugget', 'cataclysm:desert_eye'])
	event.recipes.vintage.vacuumizing('alexscaves:radon_bottle', 'alexscaves:uranium_rod')

})












