


/**
 * 
 * 
 * 
 */
let skill_data = global.skillData

ServerEvents.customCommand('power_level', event => {
    let server = event.server
    let player = event.player
    let power_level = server.persistentData.power_level
    player.tell(`Power Level: ${power_level}`)
})


ServerEvents.customCommand('increase_power_level', event => {
    let server = event.server
    let player = event.player
    server.persistentData.putInt('power_level', Number(server.persistentData.power_level) + 1)
    player.tell(`Power Level: ${server.persistentData.power_level}`)
})

ServerEvents.customCommand('decrease_power_level', event => {
    let server = event.server
    let player = event.player
    server.persistentData.putInt('power_level', Number(server.persistentData.power_level) - 1)
    player.tell(`Power Level: ${server.persistentData.power_level}`)
})



ServerEvents.customCommand('points', event => {
    let player = event.player
    let subclass = player.persistentData.subclass
    Utils.server.runCommandSilent(`/puffish_skills points add ${player.username} superior:skill_tree 100`)
})

ServerEvents.customCommand('combat_points', event => {
    let player = event.player
    let subclass = player.persistentData.subclass
    Utils.server.runCommandSilent(`/puffish_skills points add ${player.username} superior:combat_skills 100`)
})


function incrementPersistentInt(player, key) {
    let pd = player.persistentData;
    let current = pd.getInt(key); // 0 if missing
    pd.putInt(key, current + 1);
}



// Abilities
Object.entries(skill_data.abilities).forEach(([ability, max_level]) => {
    // loop from 1 to max_level
    ServerEvents.customCommand(`${ability}`, event => {
        let player = event.player;
        let pd = player.persistentData;

        // --- level handling ----------------------------------------------------
        let currentLevel = pd.getInt(ability);              // 0 if unset
        let newLevel = currentLevel > 0 ? currentLevel + 1  : 1;
        if (newLevel > max_level) newLevel = max_level;
        pd.putInt(ability, newLevel);

        // --- FX (sounds + particles) ------------------------------------------
        let username = player.username;
        let x = player.x;
        let y = player.y;
        let z = player.z;
        let dim = event.level.dimension;
        let pos = `${x} ${y} ${z}`;

        let baseSoundCmd = `execute as ${username} run playsound alexscaves:abyssmarine_glow_off ambient @s ${pos} 10`;
        Utils.server.runCommandSilent(`${baseSoundCmd} 1`);
        Utils.server.runCommandSilent(`${baseSoundCmd} 2`);
        Utils.server.runCommandSilent(`/execute in ${dim} run particle alexscaves:blue_hazmat_breathe ${pos} 0.3 2 0.3 1 1000`);

        // --- ability-specific side‑effects ------------------------------------
        if (ability === 'max_pets' && newLevel >= 1) {
            Utils.server.runCommandSilent(`/ftbquests change_progress ${username} complete 58574C87F68E4678`);
        }

        if (ability === 'scorch') {
            pd.flame_dashes = newLevel * 2;
        }

        if (ability === 'verminlord') {
            pd.putInt('blood_rat', 1);
        }

        // --- slot bookkeeping --------------------------------------------------
        if (skill_data.paint_key_abilities.includes(ability)) {
            // Increment first so keySlots sees the new count (same as before)
            incrementPersistentInt(player, 'key_slot_count');
            keySlots(player, ability);
        }

        if (skill_data.paint_nonkey_ability.includes(ability)) {
            nonKeySlots(player, ability);
            incrementPersistentInt(player, 'nonkey_ability_count');
        }

        // --- unlock + repaint --------------------------------------------------
        pd.putBoolean(`${ability}_unlocked`, true);
        repaintAbilities(player);
    });

    ServerEvents.customCommand(`${ability}_level`, event => {
        let level = event.player.persistentData.getInt(ability)
        event.player.tell(`${ability} is level ${level}`)
    })
    ServerEvents.customCommand(`${ability}_reset`, event => {
        event.player.persistentData.remove(ability)
    })

    ServerEvents.customCommand(`${ability}_remove_cooldown`, event => {
        let player = event.player
        removeSkillCooldown(player, ability, 'hide')
    })
})

function resetAbilityCounts(player) {
    player.persistentData.putInt('key_slot_count', 0)
    player.persistentData.putInt('nonkey_ability_count', 0)
}



ServerEvents.customCommand('reset_all_abilities', event => {
    let player = event.player
    Object.entries(skill_data.abilities).forEach(([ability, max_level]) => {
        player.persistentData.remove(ability)
        player.persistentData.remove(`${ability}_unlocked`)
        player.tags.remove(ability)
        removeSkillCooldown(player, ability)
    })

    removeAllSlots(player)
})




// Attributes
Object.entries(skill_data.attributes).forEach(([attribute, data]) => {


    // Set the base value of the attribute
    PlayerEvents.loggedIn(event => {
        Utils.server.scheduleInTicks(1, () => {
            let player = event.player
            let sanitized_attribute = attribute.replace(/\./g, ':');
            if (!player.persistentData.get(attribute)) {
                player.persistentData.putInt(attribute, parseInt(data.base))
                Utils.server.runCommandSilent(`/attribute ${player.username} ${sanitized_attribute} base set ${player.persistentData.getInt(attribute)}`)
            } else {
                Utils.server.runCommandSilent(`/attribute ${player.username} ${sanitized_attribute} base set ${player.persistentData.getInt(attribute)}`)

            }
        })

    })
                
    // Changes and saves the attribute value
    ServerEvents.customCommand(`${attribute}`, event => {
        let player = event.player;
        let sanitized_attribute = attribute.replace(/\./g, ':');
        let current_value = player.persistentData[attribute]
        player.persistentData.putInt(attribute, current_value + data.value)
        Utils.server.runCommandSilent(`/attribute ${player.username} ${sanitized_attribute} base set ${player.persistentData.getInt(attribute)}`)
    });

    ServerEvents.customCommand(`${attribute}_reset`, event => {
        let player = event.player
        player.persistentData.putInt(attribute, data.base)
        let sanitized_attribute = attribute.replace(/\./g, ':')
        Utils.server.runCommandSilent(`/attribute ${player.username} ${sanitized_attribute} base set ${data.base}`)
    })




})

// Command
Object.entries(skill_data.commands).forEach(([command, function_name]) => {
    ServerEvents.customCommand(`${command}`, event => {
        let player = event.player
        event.level.runCommandSilent(`${function_name} ${player.username}`)
    })
})





let to_remove = [
    'warlock',
    'vanguard',
    'ranger',
    'beastmaster',
]



function cleansingSerum (event) {
    let player = event.player
    let subclass = player.persistentData.subclass
    Utils.server.runCommandSilent(`/puffish_skills skills erase ${player.username} superior:${subclass}`)
    player.persistentData.remove('total_levels') // Remove total levels, this will reset the total levels for the player
    player.persistentData.remove('tree_level') // Remove the tree levels, this will reset the tree levels for the player
    Object.entries(class_object.subclasses).forEach(([subclass_name, subclass_data]) => {
        player.persistentData.remove(`kubejs_class:${subclass_name}`)
        player.persistentData.remove(`subclass`)
        //Utils.server.tell(`Removed: kubejs_class:${subclass_name}`)
        Object.entries(subclass_data.persistentData).forEach(([key, value]) => {
            player.persistentData.remove(key)
            //Utils.server.tell(`Removed: ${key}`)
        })
    })
    to_remove.forEach(class_name => {
        player.persistentData.remove(`kubejs_class:${class_name}`)
        player.persistentData.remove(`${class_name}_level`)
        player.persistentData.remove(`${class_name}_xp`)
    })

    // Remove all abilities
    Object.entries(skill_data.abilities).forEach(([ability, max_level]) => {
        player.persistentData.remove(ability)
        player.persistentData.remove(`${ability}_unlocked`)
    })
    removeAllSlots(player)
    player.paint({'*': {remove: true}})
    Utils.server.runCommandSilent(`/origin gui ${player.username}`)
}






ItemEvents.rightClicked('kubejs:reset_skills', event => {
    let player = event.server.getPlayer(event.player.uuid)
    let skill_data = global.skillData
    Utils.server.runCommandSilent(`/puffish_skills skills reset ${event.player.username} superior:skill_tree`)
    Utils.server.runCommandSilent(`/puffish_skills skills reset ${event.player.username} superior:beastmaster_skills`)
    Object.entries(skill_data.abilities).forEach(([ability, max_level]) => {
        removeSkillCooldown(player, ability)
        player.persistentData.remove('gKeyCurrent')
        player.persistentData.remove('hKeyCurrent')
        player.persistentData.remove('jKeyCurrent')
        player.persistentData.remove('kKeyCurrent')
        player.persistentData.remove('lKeyCurrent')

                //loop 20 timees
        for (let i = 1; i <= key_slot_cap; i++) {
            player.persistentData.putString(`key_slot_${i}`, 'null')
        }
        player.persistentData.putInt('key_slot_count', 0)

        for (let i = 0; i <= non_key_slot_cap; i++) {
            player.persistentData.putString(`non_key_slot_${i}`, 'null')
        }
        player.persistentData.remove(ability)
        player.persistentData.remove(`${ability}_unlocked`)
        player.persistentData.remove(`${ability}_cooldown`)
        player.persistentData.remove(`${ability}_key_slot`)
        player.persistentData.remove(`${ability}_level`)
        player.persistentData.remove(`skill_cooldown:${ability}`)
        player.tags.remove(ability)
        player.tags.remove(`${ability}_cooldown`)

    })

    //Utils.server.runCommandSilent(`/execute as ${event.player.username} run kjs custom_command reset_all_abilities`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle traveloptics:red_star_inward ${player.x} ${player.y + 1} ${player.z} 1 1 1 0.11 50`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.spawn ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 1.5`)
    Utils.server.runCommandSilent(`/execute as ${player.username} run aircombo set 0 ${player.username}`)
    Utils.server.runCommandSilent(`/puffish_skills points add ${player.username} superior:skill_tree -1`)
    killAllPets(event.player)
    player.paint({'*': {remove: true}})
    //player.persistentData.remove('subclass_chosen')
    player.persistentData.remove(`kubejs_class:${player.persistentData.subclass}`)
    player.persistentData.remove('subclass')
    event.item.count -= 1
    updateSubclassPainter(player)
})