let traits = ['vanguard', 'marksman', 'warlock', 'beastmaster'];

let trait_color_codes = {
    vanguard: '§c',
    warlock: '§5',
    marksman: '§b',
    beastmaster: '§a',
}




/*function wrapText(text, maxLineLength) {
    let words = text.split(" ");
    let wrappedText = "";
    let line = "";

    words.forEach(word => {
        if ((line + word).length > maxLineLength) {
            wrappedText += line + "\n";
            line = "";
        }
        line += word + " ";
    });

    wrappedText += line.trim();
    return wrappedText;
}*/

/**
 * Adds XP to the player based on the entity that died, the player's class, and other factors.
 * @param {Object} source - The source of damage (the player or tamed beast).
 * @param {Object} target - The entity that died.
 * @param {number} mult - The multiplier for XP based on specific conditions.
 * @param {string} order - The class or "order" of the player.
 */

/**
 * Combined:
 *  - Ranger:
 *     - 1.5x XP for killing mobs with arrows
 * - Shaman:
 *    - 1.5x XP for killing mobs with throwable items
 * - Vanguard:
 *   - 1.5x XP for killing mobs without using projectiles
 * - Warlock:
 *  - 1.5x XP for killing mobs with magic
 * - Beastmaster:
 *  - 1.1x XP for each pet nearby
 *  - Beastmaster pets give XP when they kill mobs
 * 
 * 




/**
 * Traits System:
 *  - Marksman:
 *     - 1.5x XP for killing mobs with arrows or throwable items
 *  - Vanguard:
 *    - 1.5x XP for killing mobs with melee weapons
 *  - Warlock:
 *    - 1.5x XP for killing mobs with spells
 *  - Beastmaster:
 *    - 1.1x XP for each pet nearby
 *    - Beastmaster pets give XP when they kill mobs
 */

/**
 * Traits System:
 *  - Marksman:
 *     - 1.5x XP for killing mobs with arrows or throwable items
 *  - Vanguard:
 *    - 1.5x XP for killing mobs with melee weapons
 *  - Warlock:
 *    - 1.5x XP for killing mobs with spells
 *  - Beastmaster:
 *    - 1.1x XP for each pet nearby
 *    - Beastmaster pets give XP when they kill mobs
 */

/**
 * Traits System:
 *  - Marksman:
 *     - 1.5x XP for killing mobs with arrows or throwable items
 *  - Vanguard:
 *    - 1.5x XP for killing mobs with melee weapons
 *  - Warlock:
 *    - 1.5x XP for killing mobs with spells
 *  - Beastmaster:
 *    - 1.1x XP for each pet nearby
 *    - Beastmaster pets give XP when they kill mobs
 * 
 * 
 * 
 * 
 * 
 * 

 */
let empty_bars = {
    vanguard: {
        x: 70,
        y: 120,
    },
    warlock: {
        x: 70,
        y: 100,
    },
    marksman: {
        x: 70,
        y: 80,
    },
    beastmaster: {
        x: 70,
        y: 60,
    },
}



let painter_x = {
            1: 119,
            2: 118,
            3: 117,
            4: 116,
            5: 115,
            6: 114,
            7: 113,
            8: 112,
            9: 111,
            // Skip 10, add 1
            11: 109,
            12: 108,
            13: 107,
            14: 106,
            15: 105,
            16: 104,
            17: 103,
            18: 102,
            19: 101,
            // Skip 20, add 1
            21: 99,
            22: 98,
            23: 97,
            24: 96,
            25: 95,
            26: 94,
            27: 93,
            28: 92,
            29: 91,
            // Skip 30, add 1
            31: 89,
            32: 88,
            33: 87,
            34: 86,
            35: 85,
            36: 84,
            37: 83,
            38: 82,
            39: 81,
            // Skip 40, add 1
            41: 79,
            42: 78,
            43: 77,
            44: 76,
            45: 75,
            46: 74,
            47: 73,
            48: 72,
            49: 71,
            // Skip 50, add 1
            51: 69,
            52: 68,
            53: 67,
            54: 66,
            55: 65,
            56: 64,
            57: 63,
            58: 62,
            59: 61,
            // Skip 60, add 1
            61: 59,
            62: 58,
            63: 57,
            64: 56,
            65: 55,
            66: 54,
            67: 53,
            68: 52,
            69: 51,
            // Skip 70, add 1
            71: 49,
            72: 48,
            73: 47,
            74: 46,
            75: 45,
            76: 44,
            77: 43,
            78: 42,
            79: 41,
            // Skip 80, add 1
            81: 39,
            82: 38,
            83: 37,
            84: 36,
            85: 35,
            86: 34,
            87: 33,
            88: 32,
            89: 31,
            // Skip 90, add 1
            91: 29,
            92: 28,
            93: 27,
            94: 26,
            95: 25,
            96: 24,
            97: 23,
            98: 22,
            99: 21,
    }


let class_symbols = {
    vanguard_symbol: {
        type: 'rectangle',
        x: -112,
        y: -3,
        w: 16,
        h: 16,
        draw: 'ingame',
        visible: true,
        alignX: 'right',
        alignY: 'bottom',
        texture: 'kubejs:textures/level_rework/vanguard.png'
    },
    warlock_symbol: {
        type: 'rectangle',
        x: -112,
        y: -23,
        w: 16,
        h: 16,
        draw: 'ingame',
        visible: true,
        alignX: 'right',
        alignY: 'bottom',
        texture: 'kubejs:textures/level_rework/warlock.png'
    },
    marksman_symbol: {
        type: 'rectangle',
        x: -112,
        y: -43,
        w: 16,
        h: 16,
        draw: 'ingame',
        visible: true,
        alignX: 'right',
        alignY: 'bottom',
        texture: 'kubejs:textures/level_rework/marksman.png'
    },
    beastmaster_symbol: {
        type: 'rectangle',
        x: -112,
        y: -63,
        w: 16,
        h: 16,
        draw: 'ingame',
        visible: true,
        alignX: 'right',
        alignY: 'bottom',
        texture: 'kubejs:textures/level_rework/beastmaster.png'
    }
};



let boss_reminder = new WeakMap()
let base_xp = 50
let total_level_cap = 100
let step = 15
/**
 * Adds XP to a specific trait of the player based on the target's attributes and trait-specific multiplier.
 * @param {Player} player - The player to receive XP.
 * @param {Entity} target - The entity that was killed.
 * @param {number} mult - The multiplier for XP based on specific conditions.
 * @param {string} trait - The trait to which XP should be added.
 */

function addXP(player, target, mult, trait, damage) {
    if (!player.persistentData.get('subclass_chosen')) return;

    //player.tell(`Target: ${target}, Mult: ${mult}, Trait: ${trait}, Damage: ${damage}`)

    let trait_level = player.persistentData[`${trait}_level`] || 0;
    let trait_xp = player.persistentData[`${trait}_xp`] || 0;
    let xp_cap = base_xp + (trait_level * step)
    //let xp_cap = XP_CAP_MULTIPLIER * trait_level;
    //level cap is number of bosses killed multiplied by 5 plus 5
    let bossKills = player.server.persistentData.bosses_killed || 0
    let level_cap = bossKills * 5 + 5
    if (trait_level > level_cap) {
        let plrKey = player.username+`_${trait}`
        
        if (boss_reminder[plrKey] % 150 == 0) {
            player.tell(`§fDefeat more §cBosses§f to level up your §d${capitalize(trait)}§f Trait`)
            boss_reminder[plrKey]++;
        } else if(boss_reminder[plrKey] == undefined) {
            boss_reminder[plrKey] = 0
        }
        return;
    }

    mult = 0.25
    if (target.isMonster()) {
        mult = 1;
    } else if (target.player) {
        mult = 0;
    }

    // Calculate XP based on target's max health and multiplier
    //let xp = target.maxHealth * mult
    //player.tell(`${target.health}/${target.maxHealth}`)
    let xp = Math.min(target.maxHealth, damage);
    xp *= mult;
    //player.tell(`Experience Gained: ${xp}`)

    // Add the calculated XP to the trait's XP
    player.persistentData[`${trait}_xp`] += xp;
    trait_xp = player.persistentData[`${trait}_xp`]

    let progress = Math.floor((trait_xp / xp_cap) * 100);
   // Utils.server.tell(`progress: ${progress}`);
    let paintData = {};
        paintData[`empty_bar_${trait}`] = {
            type: 'rectangle',
            x: empty_bars[trait].x,
            y: empty_bars[trait].y,
            w: 256,
            h: 256,
            draw: 'ingame',
            visible: true,
            alignX: 'right',
            alignY: 'bottom',
            texture: `kubejs:textures/level_rework/${trait}/empty_bar.png`
        };
        // paint the symbol
        paintData[`${trait}_symbol`] = class_symbols[`${trait}_symbol`];
        // loop down from progress to 0. Skip to the next value when theres any value with a 0 in the tens place.
        for (let i = progress; i > 0; i--) {
        
            let x = painter_x[i] || undefined;
            if(x === undefined) continue;
        
            // Construct the key for paintData
            let key = `${trait}_${x}`;
        
            // Assign paint data
            paintData[key] = {
                type: 'rectangle',
                x: x,
                y: empty_bars[trait].y,
                w: 256,
                h: 256,
                draw: 'ingame',
                visible: true,
                alignX: 'right',
                alignY: 'bottom',
                texture: `kubejs:textures/level_rework/${trait}/${i}.png`
            };
        }
        
        // Apply the paint data to the player
        player.paint(paintData);
    // Handle leveling up if XP exceeds the cap
    if (trait_xp >= xp_cap) {
        let remainder = trait_xp - xp_cap;
        player.persistentData[`${trait}_level`] += 1;
        player.persistentData[`${trait}_xp`] = remainder;

        //player.tell(`Xp left: ${player.persistentData[`${trait}_xp`]}`)

        if (player.persistentData.total_levels >= total_level_cap) return
        
        player.tell(`§d${capitalize(trait)}§f leveled up to level §A${player.persistentData[`${trait}_level`]}§f!`);
        Utils.server.runCommandSilent(`/execute at ${player.username} run particle irons_spellbooks:spark 0.3 1 0.5 ${player.x} ${player.y+1} ${player.z} 0.2 0.4 0.2 0.2 50 force`)
        Utils.server.runCommandSilent(`/execute at ${player.username} run playsound kubejs:trigger player ${player.username} ${player.x} ${player.y} ${player.z} 2 1.6`)
        let subclass_name = player.persistentData.subclass
        let trait_color = trait_color_codes[trait]
        let str = `§eLEVEL UP: §f${capitalize(trait)} §c${player.persistentData[`${trait}_level`]-1} §f-> §b${player.persistentData[`${trait}_level`]} `
        player.persistentData.getAllKeys().filter(key => key.includes(`${subclass_name}_attribute`)).forEach(key => {
            let attribute = key.split('_attribute:')[1]
            let value = player.persistentData.getFloat(key) * 1.01
            //increase the value of the attribute by 1%
            //let new_value = value * 1.01
            let attribute_name = attribute.replace('generic.', '').replace('player.', '').replace(/\./g, '').slice(attribute.indexOf(':')+1).replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase())
            //However, if the attribute is "combatroll:recharge" then display it as "Roll Recharge"
            if (attribute_name == "Recharge") {
                attribute_name = "Roll Recharge"
            } else if (attribute_name == "Generic") {
                attribute_name = "Projectile Damage"
            }

            player.persistentData[key] = value
        })
        Utils.server.runCommandSilent(`/immersivemessages sendcustom ${player.username} {anchor:'CENTER_CENTER', wrap:1, size: 0.80, background:1, slideup:1, slideoutdown:1, y:50} 8 ${str}`)
       // Utils.server.tell(trait)
        if (trait == 'beastmaster') {
            Utils.server.runCommandSilent(`/puffish_skills points add ${player.username} superior:beastmaster_skills 1`)
        } else {
            Utils.server.runCommandSilent(`/puffish_skills points add ${player.username} superior:skill_tree 1`)
        }
        //spawnItem(`kubejs:${trait}_gemstone`, 1, player)
        // Update variables after leveling up
        trait_level = player.persistentData[`${trait}_level`];
        trait_xp = player.persistentData[`${trait}_xp`];
        xp_cap = base_xp + (trait_level * 25)
        
        // start here. Loop down to 0 and make visible: false for all values.
        let paintData = {};
        for (let i = progress; i > 0; i--) {
            //let iStr = i.toString();
        
            // Skip numbers that contain '0' in any digit
            //if (iStr.includes('0')) continue;
        
            let x = painter_x[i] || undefined;
            if(x === undefined) continue;
        
            // Construct the key for paintData
            let key = `${trait}_${x}`;
        
            // Assign paint data
            paintData[key] = {
                type: 'rectangle',
                x: x,
                y: empty_bars[trait].y,
                w: 256,
                h: 256,
                draw: 'ingame',
                visible: false,
                alignX: 'right',
                alignY: 'bottom',
                texture: `kubejs:textures/level_rework/${trait}/${i}.png`
            };
            player.paint(paintData);
        }
    }




        
 //   }

}

/**
 * Determines the section of the progress bar based on the progress percentage.
 * @param {number} progress - The progress percentage.
 * @returns {number} - The section number for the UI.
 */
/*function getSection(progress) {
    // 10 sections for the progress bar
    return Math.floor(progress / 10)
}*/

/**
 * Capitalizes the first letter of a string.
 * @param {string} str - The string to capitalize.
 * @returns {string} - The capitalized string.
 */
function capitalize(str) {
    return str.charAt(0).toUpperCase() + str.slice(1);
}

/**
 * Retrieves the number of nearby pets for a player.
 * @param {Player} player - The player.
 * @returns {number} - The count of nearby pets.
 */
function getNearbyPets(player) {
    let box = AABB.of(player.x - 20, player.y - 20, player.z - 20, player.x + 20, player.y + 20, player.z + 20);
    let pets = player.level.getEntitiesWithin(box).filter(ent => ent.tags.contains('tamed_beast') && ent.persistentData.owner == player.username).length
    //player.tell(`Pet list Length: ${pets.length}`)
    return pets
}

let marksman_types = ['arrow', 'throw', 'shuriken', 'spear', 'trident', 'bolt'];

let spellTypes = ['nature_magic', 'blood_magic', 'ender_magic', 'evocation_magic', 
    'fire_magic', 'holy_magic', 'ice_magic', 'lightning_magic', 'eldritch_magic']; // Extend as needed

let scrollTypes = ['scroll' , 'iron_spell_book' , 'gold_spell_book' ,
    'diamond_spell_book' , 'copper_spell_book' , 'villager_spell_book' ,
    'dragonskin_spell_book' , 'blaze_spell_book' , 'rotten_spell_book' ,
    'evoker_spell_book' , 'netherite_spell_book' ,]
// Event Handlers

// Handle XP addition when an entity is killed by a player
EntityEvents.hurt(event => {
    if (!event.source.player) return;
    if (!event.entity.alive) return;
    if (event.entity.type == 'dummmmmmy:target_dummy') return;

    //event.source.player.tell(`EntityEvents Hurt Event`)

    //Utils.server.tell('Player killed entity')
    let player = event.source.player;
    let target = event.entity;
    let mult = 1;
    let trait = '';
    let isValid = false;

    // Determine trait based on the weapon or action used
    let scroll = event.source.weapon;
   // Utils.server.tell(scroll)
    let source_string = event.source.toString().replace('DamageSource ', '');

    if (!event.source.indirect) {
        mult = 2.5;
        trait = 'vanguard';
        isValid = true;
        //Utils.server.tell(trait)
    }
    if (isSpellDamageSource(event.source)) {
        mult = 2;
        trait = 'warlock';
        isValid = true;
       // Utils.server.tell(trait)
    } else if (physicalProjectileCheck(event.source)) {
        mult = 3.5;
        trait = 'marksman';
        isValid = true;
         // Utils.server.tell(trait)
    }

    // Handle Beastmaster trait based on nearby pets
    if (isValid) {
        //player.tell(`isValid`)
        let petsNearby = getNearbyPets(player);
        /*if (petsNearby > 0 && trait != 'beastmaster') { // Avoid overriding if trait is already set
            let new_mult = 0.03 * petsNearby;
            let beastmasterTrait = 'beastmaster';
            addXP(player, target, new_mult, beastmasterTrait, parseInt(event.damage/2));
            //Utils.server.tell(`Pets nearby: ${petsNearby}`);
        }*/
        if(petsNearby) {
            //player.tell(`Pets ARE nearby!`)
            let new_mult = 0.03 * petsNearby
            //player.tell(`Event Damage: ${event.damage}`)
            addXP(player, target, new_mult, 'beastmaster', parseInt(event.damage / 2))
        }
       
        addXP(player, target, mult, trait, event.damage);
    }
    updateSubclassPainter(player);
});

function updateSubclassPainter(player) {
    // Check if the player has a subclass; if not, exit early
    if (!player.persistentData.get('subclass_chosen')) return;

    traits.forEach(trait => {
      // Ensure XP and level data exist for the trait
      /*if (!player.persistentData[`${trait}_xp`]) {
        player.persistentData[`${trait}_xp`] = 0;
      }
      if (!player.persistentData[`${trait}_level`]) {
        player.persistentData[`${trait}_level`] = 1;
      }*/
  
      let trait_level = player.persistentData[`${trait}_level`] || 0;
      let trait_xp = player.persistentData[`${trait}_xp`] || 0;
      let xp_cap = base_xp + (trait_level * 15);
      let progress = Math.floor((trait_xp / xp_cap) * 100);
  
      // Prepare paint data for the empty bar and the trait symbol
      let paintData = {};
      paintData[`empty_bar_${trait}`] = {
        type: 'rectangle',
        x: empty_bars[trait].x,
        y: empty_bars[trait].y,
        w: 256,
        h: 256,
        draw: 'ingame',
        visible: true,
        alignX: 'right',
        alignY: 'bottom',
        texture: `kubejs:textures/level_rework/${trait}/empty_bar.png`
      };
      paintData[`${trait}_symbol`] = class_symbols[`${trait}_symbol`];
  
      // Paint the progress bar only if progress > 0
      for (let i = progress; i > 0; i--) {
        //let iStr = i.toString();
        // Skip numbers that contain '0'
        //if (iStr.includes('0')) continue;
  
        let x = painter_x[i] || undefined;
        if (x === undefined) continue; // Skip undefined values
  
        let key = `${trait}_${x}`;
        paintData[key] = {
          type: 'rectangle',
          x: x,
          y: empty_bars[trait].y,
          w: 256,
          h: 256,
          draw: 'ingame',
          visible: true,
          alignX: 'right',
          alignY: 'bottom',
          texture: `kubejs:textures/level_rework/${trait}/${i}.png`
        };
      }
  
      // Apply the paint data to the player
      player.paint(paintData);
    });
  }

// Handle XP addition when a tamed beast kills an entity
EntityEvents.hurt(event => {
    if (!event.source.actual || !event.source.actual.tags.contains('tamed_beast')) return;
    if (event.entity.type == 'dummmmmmy:target_dummy') return;

    let pet = event.source.actual;
    let owner_username = pet.persistentData.get('owner')
    let player = Utils.server.getPlayer(owner_username);
    if (!player) return;

    let target = event.entity;

    let mult = 1; // Base multiplier for Beastmaster
    let petsNearby = getNearbyPets(player);

    /*if (petsNearby > 0) {
        mult += 0.05 * petsNearby; // Increment XP multiplier based on pets
    }*/
    mult += 0.05 * petsNearby;

    // Add XP to Beastmaster trait
    addXP(player, target, mult, 'beastmaster', parseInt(event.damage/2));
    updateSubclassPainter(player);
});




// Show the player's XP progress when they join the server
PlayerEvents.loggedIn(event => {
    //event.player.tell(`LoggedIn Fired`)
    //Utils.server.tell(event.player.username, ': ', event.player.persistentData)
    traits.forEach(trait => {
        if(!event.player.persistentData[`${trait}_level`]) {
            event.player.persistentData[`${trait}_level`] = 1;
        }
        if(!event.player.persistentData[`${trait}_xp`]) {
            event.player.persistentData[`${trait}_xp`] = 0;
        }
    })
    //Utils.server.tell(event.player.username, ': ', event.player.persistentData)
    updateSubclassPainter(event.player);
});





