/**
 * Seraphim: 5 Levels
 * - §aLevel 1: KILLING an enemy while airborne will give you the Angelic Flight buff for 1.5 seconds
 * - §aLevel 2: increases the duration of the Angelic Flight buff by 1.5 seconds
 * - §aLevel 3: Killing an enemy while airborne will give you the impact buff for 2 seconds
 * - §aLevel 4: increases the strength of the impact buff
 * - §aLevel 5: SHOOTING an enemy while airborne will give you the Angelic Flight buff for 10 seconds (Code is above, not below)
 * 
 */


EntityEvents.death(event => {
    if (!event.source.player) return
    if (isAlly(event.source.player, event.entity)) return
    if (event.source.immediate == null) return
    if (!event.source.immediate.type.includes('arrow')) return
    let player = event.source.player
    if (!player.persistentData.get('seraphim')) return
    if (!player.blockStateOn.air) return
    if (player.persistentData.seraphim < 1) return
    if (!player.blockStateOn.air) return
    let level = player.persistentData.seraphim
    if (level > 5) level = 5
    player.potionEffects.add('irons_spellbooks:angel_wings', 30*level, 1)
    if (player.persistentData.seraphim < 2) return
    player.potionEffects.add('projectile_damage:impact', 40, level-2)
    //Utils.server.tell('2')
})



/**
 * Arrow Storm: 5 Levels
 *  - §aLevel 1: Shooting an enemy with an arrow will give you a levitation and slow falling effect.
 *  - §aLevel 2: 25% chance to reload your crossbow after shooting an enemy in the air
 *  - §aLevel 3: 50% chance to reload your crossbow after shooting an enemy in the air
 *  - §aLevel 4: 75% chance to reload your crossbow after shooting an enemy in the air
 *  - §aLevel 5: 100% chance to reload your crossbow after shooting an enemy in the air
 */
EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.source.immediate == null) return
    if (!event.source.immediate.type.includes('arrow')) return
    let player = event.source.player
    if (!player.blockStateOn.air) return
    if (player.persistentData.get('seraphim')) {
        if (player.persistentData.seraphim >= 5) {
            player.potionEffects.add('irons_spellbooks:angel_wings', 200, 1)
        }
    }
    if (!player.persistentData.get('arrow_storm')) return
    if (player.persistentData.arrow_storm < 1) return
    // §aLevel 1
    player.potionEffects.add('slow_falling', 60, 10)
    player.potionEffects.add('levitation', 8, 10)
    if (player.persistentData.arrow_storm < 2) return
    // chance is equal to the level - 1 times 25
    let chance = (player.persistentData.arrow_storm-1)*25
    if (Math.random() > chance/100) return
    let crossbow = null
    if (player.offHandItem.toString().includes('crossbow')) {
        crossbow = player.offHandItem
    } else if (player.mainHandItem.toString().includes('crossbow')) {
        crossbow = player.mainHandItem
    }
    let arrow_type = event.source.immediate.type
    //autoReload(player, crossbow, arrow_type)
})


/**
 * shattering Blow:
 * §aLevel 1: Hitting the enemy with the shield (no throw) will stun them for 0.5 seconds and knock them back
 * §aLevel 2: Increases Stun time by 0.5 seconds
 * §aLevel 3: Stunning an enemy will auto load an arrow into your crossbow. Increases Stun time by 0.5 seconds
 * §aLevel 4: Increases Stun time by 0.5 seconds
 * §aLevel 5: Thrown shields also stun enemies. Increases Stun time by 0.5 seconds
 * 
 * 
// §aLevel 1
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('shattering_blow')) return
    if (event.source.player.persistentData.shattering_blow < 1) return
    if (event.source.immediate.type.toString().includes('arrow')) return
    if (!event.source.player.mainHandItem.id.toString().includes('shield')) return
    let player = event.source.player
    // loop 20 times
    for (let i = 0; i < 40; i++) {
        player.push(event.entity)
    }
    if (event.source.indirect) return
    event.entity.potionEffects.add('levitation', 2, 20, true, true)
    let shield = player.mainHandItem
    let level = player.persistentData.shattering_blow
    if (level >= 3) {
        if (player.offHandItem.toString().includes('crossbow')) {
            //autoReload(player, player.offHandItem, 'minecraft:arrow')
        }
    }
    // Increase stun per level
    let ticks = 0
    if (event.entity.tags.contains('boss')) {
        ticks = 5*level
    } else if (event.entity.tags.contains('player')) {
        ticks = 5*level
    } else {
        ticks = 10*level
    }
    if (player.cooldowns.isOnCooldown(shield)) return
    player.cooldowns.addCooldown(shield, 200)
    event.entity.potionEffects.add('alexscaves:stunned', ticks, 1)
    event.entity.potionEffects.add('minecells:stunned', ticks, 1)

})


 */

// §aLevel 5
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (!event.source.indirect) return
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('shattering_blow')) return
    if (!event.source.immediate.nbt.toString().includes('aerodynamic_trim')) return
    if (event.source.player.mainHandItem.nbt == null) return
    if (!event.source.player.mainHandItem.nbt.toString().includes('aerodynamic_trim')) return
    if (event.source.player.persistentData.shattering_blow < 5) return
    let player = event.source.player
    let shield = player.mainHandItem
    if (player.cooldowns.isOnCooldown(shield)) return
    let ticks = 40
    if (event.entity.tags.contains('boss')) {
        ticks = 20
    }
    player.cooldowns.addCooldown(shield, 200)
    applyEffect(event.entity, 'alexscaves:stunned', ticks, 1)
    applyEffect(event.entity, 'minecells:stunned', ticks, 1)

})


/**
 * Fasthands: 
 * - §aLevel 1: Reload your crossbow after shooting an enemy that is stunned
 * - §aLevel 2: Killing an enemy has a 30% chance to reload your crossbow. +15% chance per level
 * - §aLevel 3: Killing an enemy with a crossbow will give you a the impact buff for 5 seconds (increases projectile damage)
 * - §aLevel 4: 20% chance to reload your crossbow after shooting an enemy
 * - §aLevel 5: 50% chance to reload your crossbow after shooting an enemy
 * -  
 *  */ 
/**
 * 
 * // §aLevel 1
EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    let player = event.source.player
    if (player.blockStateOn.air) return
    //if (!player.persistentData.get('kubejs_class:mercenary')) return
    if (player.persistentData.fasthands < 1) return
    let level = player.persistentData.fasthands
    let chance = 0.15 * level
    if (Math.random() > chance) return
    if (!player.persistentData.get('fasthands')) return
    if (!event.source.indirect) return
    if (!event.source.immediate.type.includes('arrow')) return
    if (!player.offHandItem.toString().includes('crossbow') && !player.mainHandItem.toString().includes('crossbow')) return
    let crossbow = null
    if (player.offHandItem.toString().includes('crossbow')) {
        crossbow = player.offHandItem
    } else if (player.mainHandItem.toString().includes('crossbow')) {
        crossbow = player.mainHandItem
    }
    if (!event.entity.potionEffects.isActive('alexscaves:stunned')) return
    if (!event.entity.potionEffects.isActive('minecells:stunned')) return
    let arrow_type = event.source.immediate.type
    autoReload(player, crossbow, arrow_type)
})

// §aLevel 2
EntityEvents.death(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    let player = event.source.player
    if (player.blockStateOn.air) return
    //if (!player.persistentData.get('kubejs_class:mercenary')) return
    if (!player.persistentData.get('fasthands')) return
    if (player.persistentData.fasthands < 2) return
    if (!event.source.indirect) return
    if (!event.source.immediate.type.includes('arrow')) return
    if (!player.offHandItem.toString().includes('crossbow') && !player.mainHandItem.toString().includes('crossbow')) return
    let crossbow = null
    if (player.offHandItem.toString().includes('crossbow')) {
        crossbow = player.offHandItem
    } else if (player.mainHandItem.toString().includes('crossbow')) {
        crossbow = player.mainHandItem
    }
    let arrow_type = event.source.immediate.type
    autoReload(player, crossbow, arrow_type)
    // §aLevel 3
    if (player.persistentData.fasthands < 3) return
    player.potionEffects.add(`projectile_damage:impact`, 100, 0)
})

// §aLevel 4 and 5
EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    let player = event.source.player
    if (!player.persistentData.get('fasthands')) return
    if (player.blockStateOn.air) return
    if (!event.source.indirect) return
    if (!event.source.immediate.type.includes('arrow')) return
    if (!player.offHandItem.toString().includes('crossbow') && !player.mainHandItem.toString().includes('crossbow')) return
    let crossbow = null
    if (player.offHandItem.toString().includes('crossbow')) {
        crossbow = player.offHandItem
    } else if (player.mainHandItem.toString().includes('crossbow')) {
        crossbow = player.mainHandItem
    }
    //if (!player.persistentData.get('kubejs_class:mercenary')) return
    if (player.persistentData.fasthands < 4) return
    let chance = 0
    if (player.persistentData.fasthands == 4) {
        chance = 20
    } else if (player.persistentData.fasthands == 5) {
        chance = 50
    }
    if (Math.random() > chance/100) return
    let arrow_type = event.source.immediate.type
    autoReload(player, crossbow, arrow_type)
})
 * 
 * 
 * 
 */


