
/**
 * 
 * EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    let entity = event.entity
    if (!player.persistentData.get('kubejs_class:shinobi')) return
    //Utils.server.tell(event.source.immediate.type)
    //Utils.server.tell(event.source.actual)
    let cooldown = player.persistentData.shinobi_cooldown
    //Utils.server.tell(cooldown)
    if (event.source.immediate.type != 'samurai_dynasty:shuriken') return
    //Utils.server.tell('hit')
    if (player.inventory.count('samurai_dynasty:shuriken') < 16*player.persistentData.order_level) {
        player.give(`${player.persistentData.order_level}x samurai_dynasty:shuriken`)
    }
    Utils.server.scheduleInTicks(cooldown, () => {
        player.cooldowns.removeCooldown('samurai_dynasty:shuriken')
        player.persistentData.shinobi_cooldown -= 1
        if (player.persistentData.shinobi_cooldown < 0) {
            player.persistentData.shinobi_cooldown = 0
        }

        
    })
})




EntityEvents.hurt(event => {
    if (!event.entity.player) return
    let player = event.entity.player
    if (!player.persistentData.get('kubejs_class:shinobi')) return
    if (player.persistentData.shinobi_counter < 3) {
        player.persistentData.shinobi_counter += 1
    } else {
        player.persistentData.shinobi_cooldown = 10
        player.persistentData.shinobi_counter = 0
    }

})


// Apply bleeding to entities within 10 blocks of the killed entity
EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!event.entity.isMonster() || event.entity.isPlayer()) return
    if (!player.persistentData.get('kubejs_class:shinobi')) return
    if (player.persistentData.order_level < 2) return
    if (!event.entity.isMonster() && !event.entity.player) return
    if (event.source.immediate.type != 'samurai_dynasty:shuriken') return
    let x = event.entity.x
    let y = event.entity.y
    let z = event.entity.z
    let box = AABB.of(x+10, y+10, z+10, x-10, y-10, z-10)
    let dim = event.level
    // filter to only find monsters and players
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.isMonster())
    entitiesWithin.forEach(ent => {
        if (ent != player) {
            ent.potionEffects.add('tetra:bleeding', 100*player.persistentData.order_level, 2)
        }
    })
})


// Kill entity if it has bleeding effect
ItemEvents.entityInteracted('kubejs:shinobi_dagger', event => {
    if (!event.entity.player) return
    let player = event.player
    if (event.target.tags.contains('boss')) return
    if (player.cooldowns.isOnCooldown('kubejs:shinobi_dagger')) return
    if (player.persistentData.order_level < 3) return
    if (!player.persistentData.get('kubejs_class:shinobi')) return
    let entity = event.target
    if (event.target.health < 1) return
    if (entity.potionEffects.isActive('tetra:bleeding')) {
        entity.kill()
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:blood ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 1 200 force @a`)
        entity.playSound('alexsmobs:fly_hurt')
        let cd = 1200
        let reduce = player.persistentData.order_level*200
        player.cooldowns.addCooldown('kubejs:shinobi_dagger', cd-reduce)
        if (player.persistentData.order_level < 4) return
            player.potionEffects.add('speed', 200, 0)
            player.potionEffects.add('haste', 200, 0)
    }
    
})





PlayerEvents.respawned(event => {
    if (!event.player.persistentData.get('kubejs_class:shinobi')) return
    event.player.giveInHand('samurai_dynasty:shuriken')
})

/// New Ability: Juggling


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.source.immediate.type != 'samurai_dynasty:shuriken') return
    let player = event.source.player
    if (!player.persistentData.get('kubejs_class:shinobi')) return
    if (player.persistentData.order_level < 5) return
    if (player.blockStateOn.block != 'Block{minecraft:air}') return
    let player_y = player.y
    let entity = event.entity
    let entity_y = entity.y
    //if (player_y < entity_y+2) return
    if (player_y > entity_y+8) return
    player.potionEffects.add('slow_falling', 10, 1)
    player.potionEffects.add('levitation', 5, 10)
})
 * 
 */





/**
 * 
 * let dart_counter =new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('kubejs_class:shinobi')) return
    if (dart_counter[event.player.username] == undefined) {
        dart_counter[event.player.username] = 30
    } else {
        dart_counter[event.player.username] -= 1
    }

    let player = event.player
    if (player.blockStateOn.block != 'Block{minecraft:air}') return



    if (dart_counter[event.player.username] > 0) return
    if (!event.player.shiftKeyDown) return;
    dart_counter[event.player.username] = 30
    // Create an arrow entity
    let arrow = event.level.createEntity('kubejs:arrow');
    arrow.tags.add(`Owner:${event.player.username}`);
    
    // Set the arrow's initial position to be at the player's location
    arrow.setPosition(event.player.x, event.player.y + 1, event.player.z);
    let x_rad = event.player.pitch * JavaMath.PI / 180;
    let y_rad = event.player.yaw * JavaMath.PI / 180;

    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    arrow.addMotion(dirV.x * 8, dirV.y * 8, dirV.z * 8)

    // Spawn the arrow in the world
    arrow.spawn();
    arrow.playSound('alexscaves:extinction_spear_throw', 1, 1)
});
 * EntityEvents.hurt(event => {
    //if (!event.source.player) return
    if (event.source.immediate == null) return
    if (event.source.immediate.type != 'kubejs:arrow') return
    if (!event.entity.isMonster()) return
    
    // get the owner of the arrow
    let username = event.source.immediate.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    let player = event.server.getPlayer(username)
    let entity = event.entity
    entity.potionEffects.add('alexscaves:stunned', 40, 0)
    event.source.immediate.remove()
    event.cancel()
})


 */




