

/**
 * 
 





// Right-click with Beastmaster Totem while holding shift
ItemEvents.rightClicked('kubejs:soulbinders_gate', event => {
    if (!event.player.persistentData.get('kubejs_class:soulbinder')) return
    if (!event.player.isShiftKeyDown()) return;
    event.player.persistentData.putInt('soulbinders_tarantula_hawk', 1)
    event.player.persistentData.putInt('soulbinders_bald_eagle', 1)
    event.player.persistentData.putInt('soulbinders_caiman', 1)
    // Retrieve defeated pets
    let defeated_pets = [];
    Object.entries(soulbinder_pets).forEach(([mod, pets]) => {
        Object.entries(pets).forEach(([petName, petData]) => {
            if (event.player.persistentData.getInt(`soulbinders_${petName}`) === 1) {
                defeated_pets.push(petName);
            }
        });
    });

    if (defeated_pets.length === 0) {
        event.player.tell("You haven't collected any Pet Souls yet!");
        return;
    }

    // Get current pet index, cycle through the pets
    let current = event.player.persistentData.current_pet ?? -1;
    current = (current + 1) % defeated_pets.length;

    let selectedPet = defeated_pets[current];
    let mod_key = Object.keys(soulbinder_pets).find(mod => soulbinder_pets[mod][selectedPet]);

    // Update player's persistent data with the selected pet (use pet name, not id)
    event.player.persistentData.current_pet = current;

    // Capitalize the first letter of each word after splitting the string by underscores
    let formattedPetName = selectedPet
        .split('_')
        .map(word => word.charAt(0).toUpperCase() + word.slice(1))
        .join(' ');

    // Store pet's key (e.g., "bald_eagle") instead of the entity ID
    event.player.persistentData.putString('chosen_pet', selectedPet);
    let paintData = {}
    paintData['painted_pet'] = {
        type: 'rectangle',
        x: -118,
        y: -54,
        w: 32,
        h: 32,
        draw: 'ingame',
        visible: true,
        alignX: 'right',
        alignY: 'bottom',
        texture: `kubejs:textures/beastmaster_icons/${selectedPet}.png`,
    }
    event.player.paint(paintData)

});

// Summon the selected pet
ItemEvents.rightClicked('kubejs:soulbinders_gate', event => {
    if (!event.player.persistentData.get('kubejs_class:soulbinder')) return
    if (event.player.persistentData.pet_counter >= event.player.persistentData.max_pets) return
    if (event.player.isShiftKeyDown()) return;
    if (event.player.cooldowns.isOnCooldown('kubejs:soulbinders_gate')) return;

    // Retrieve the selected pet (which now stores the key, not the ID)
    let selectedPet = event.player.persistentData.getString('chosen_pet');
    if (!selectedPet) {
        event.player.tell("You haven't selected a pet yet!");
        return;
    }

    // Find the mod containing the selected pet
    let petData = null;
    for (let mod in soulbinder_pets) {
        if (soulbinder_pets[mod][selectedPet]) {
            petData = soulbinder_pets[mod][selectedPet];
            break;
        }
    }

    if (!petData) {
        event.player.tell("Could not find pet data!");
        return;
    }

    // Create the pet entity
    let creature = event.level.createEntity(petData.id); // Use the correct entity ID from petData
    creature.setPos(event.player.x, event.player.y, event.player.z);
    let player = event.player;
    let username = player.username;
    let command = petData.command;
    creature.mergeNbt(command);
    // Set base NBT data for the creature
    creature.mergeNbt({
        Owner: username,
        Tags: [`Owner:${username}`, `tamed_beast`],
        Silverback: 1,
    });
    if (player.persistentData.get('bloodbound')) {
        creature.mergeNbt({
            Tags: [`bloodbound_beast`]
        })
    }
    // Check for pet-specific items in persistent data and add them to the creature
    for (let i = 1; i <= 3; i++) {
        let itemKey = `item${i}`;
        if (petData[itemKey] && player.persistentData.getBoolean(`${selectedPet}_item${i}`)) {
            // Apply item NBT to the pet
                creature.mergeNbt(
                    `${petData[itemKey].nbt}`
                );
               // console.log(creature.nbt)
                //console.log(player.persistentData.getBoolean(`${selectedPet}_item${i}`))
        }
    }

    // Spawn the creature
    player.persistentData.pet_counter += 1
    player.persistentData.putString(`pet_${player.persistentData.pet_counter}`, creature.uuid)
    creature.spawn();
    // pick integer between 1 and 10
    let color1 = Math.floor(Math.random() * 10) + 1
    let color2 = Math.floor(Math.random() * 4) + 1
    let color3 = Math.floor(Math.random() * 7) + 1
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:spark ${color1} ${color2} ${color3} ${creature.x} ${creature.y+1} ${creature.z} 0.2 0.2 0.2 0.3 120`)
    creature.playSound('irons_spellbooks:entity.chain_lightning.lightning_chain', 10, 1)
    event.level.spawnLightning(creature.x, creature.y, creature.z, true)
    creature.persistentData.putString('owner', username)
    event.player.cooldowns.addCooldown('kubejs:beastmaster_totem', 100); // Add a cooldown if needed
});
 * 

let soulbinder_pets = {
    alexsmobs: {
        crow: {//
            id: 'alexsmobs:crow',
            tier: 1,
            class_specialty: 'bloodripper',
            command: {
                Command: 1
            },
        },
        bald_eagle: {//

            id: 'alexsmobs:bald_eagle',
            tier: 1,
            class_specialty: 'none',
            item1: {
                id: 'alexsmobs:falconry_hood',
                nbt: '{HasCap:1b}'
            },
            command: {
                EagleCommand: 1
            }
        },
        capuchin_monkey: {//
            id: 'alexsmobs:capuchin_monkey',
            tier: 2,
            class_specialty: 'none',
            item1: {
                id: 'alexsmobs:ancient_dart',
                nbt: '{HasDart:1b}'
            },
            command:{
                Command: 1
            }
        },
        tarantula_hawk: {//
            id: 'alexsmobs:tarantula_hawk',
            tier: 3,
            class_specialty: 'none',
            command: {
                Command: 1
            }
        },
        elephant: {//
            id: 'alexsmobs:elephant',
            tier: 2,
            class_specialty: 'none',
            command: {
                Command: 1
            }
        },
        komodo_dragon: {//
            id: 'alexsmobs:komodo_dragon',
            tier: 3,
            class_specialty: 'none',
            item: {
                id: 'minecraft:saddle',
                nbt: '{Saddle:1b}'
            },
            command: {
                KomodoCommand: 1
            }
        },
        kangaroo: {//
            id: 'alexsmobs:kangaroo',
            tier: 3,
            class_specialty: 'mercenary',
            item1: {
                id: 'fantasy_weapons:weapon_sharp_curved_sword',
                nbt: '{Items: [{Count:1,id:"fantasy_weapons:weapon_sharp_curved_sword",Slot:0b}]}'
            },
            item2: {
                id: 'immersive_armors:steampunk_helmet',
                nbt: '{Items: [{Count:1,id:"immersive_armors:steampunk_helmet",Slot:1b}]}'
            },
            item3: {
                id: 'immersive_armors:wooden_chestplate',
                nbt: '{Items: [{Count:1,id:"immersive_armors:wooden_chestplate",Slot:2b}]}'
            },
            command: {
                Command: 1
            }
        },
        gorilla: {//
            id: 'alexsmobs:gorilla',
            tier: 3,
            class_specialty: 'none',
            command: {
                Command: 1
            }
        },
        crocodile: {//
            id: 'alexsmobs:crocodile',
            tier: 4,
            class_specialty: 'none',
            command: {
                Command: 1
            }
        },
        grizzly_bear: {//
            id: 'alexsmobs:grizzly_bear',
            tier: 4,
            class_specialty: 'none',
            command: {
                BearCommand: 1
            }
        },
        caiman: {//
            id: 'alexsmobs:caiman',
            tier: 4,
            class_specialty: 'none',
            command: {
                CaimanCommand: 1
            }

        },
    },
    iceandfire: {
        hippogryph: {//
            id: 'iceandfire:hippogryph',
            tier: 3,
            class_specialty: 'none',
            item1: {
                id: 'minecraft:chest',
                nbt: '{Chested:true,Items:[{Count:1b,Slot:1b,id:"minecraft:chest"}]}'
            },
            item2: {
                id: 'minecraft:saddle',
                nbt: '{Saddled:true, Items:[{Count:1b,Slot:0b,id:"minecraft:saddle"}]}'
            },
            item3: {
                id: 'iceandfire:iron_hippogryph_armor',
                nbt: '{Armor: true, Items:[{Count:1b,Slot:2b,id:"iceandfire:iron_hippogryph_armor"}]}'
            },
            command: {
                Command: 1
            }
        },
        cockatrice: {//
            id: 'iceandfire:cockatrice',
            tier: 4,
            class_specialty: 'none',
            command: {
                Command: 1
            }
        }
    },
    recrafted_creatures: {
        mammoth: {
            id: 'recrafted_creatures:mammoth',
            tier: 3,
            class_specialty: 'nomad'
        }
    },
    alexscaves: {
        subterranodon: {
            id: 'alexscaves:subterranodon',
            tier: 4,
            command: {
                Command: 1
            }
        },
        vallumraptor: {
            id: 'alexscaves:vallumraptor',
            tier: 4,
            command: {
                Command: 1
            }
        },
        tremorsaurus: {
            id: 'alexscaves:tremorsaurus',
            tier: 4,
            command: {
                Command: 1
            }
        },
    }
}






// Register death event listeners for all pets
Object.entries(soulbinder_pets).forEach(([mod, pets]) => {
    Object.entries(pets).forEach(([petName, petData]) => {
        EntityEvents.death(petData.id, event => {
            if (!event.source.player) return;
            let player = event.source.player;
            if (!player.persistentData.get('kubejs_class:soulbinder')) return;
            if (player.persistentData.get(`soulbinders_${petName}`)) return;
            player.persistentData.putInt(`soulbinders_${petName}`, 1);
            player.persistentData.pets_killed = (player.persistentData.pets_killed || 0) + 1;
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:soul ${event.entity.x} ${event.entity.y+1} ${event.entity.z} 0.1 0.1 0.1 0.11 200`)
            event.entity.playSound(`blocky_siege:soul_screams`, 10, 2)
            player.tell(`You have collected the soul of ${petName.split('_').map(word => word.charAt(0).toUpperCase() + word.slice(1)).join(' ')}!`);
        });
    });
});


 */






/**
 * Empower: Gives all tamed creatures an effect based on the level of empower
 * §aLevel 1: Speed I
 * §aLevel 2: Burning Thorns I
 * §aLevel 3: Devour I
 * §aLevel 4: Resilience I
 *  */ 
let empower = {
    1: {
        id: 'minecraft:speed',
        duration: 60,
        amplifier: 0
    },
    2: {
        id: 'runiclib:burning_thorns',
        duration: 60,
        amplifier: 0
    },
    3: {
        id: 'alexsmobs:soulsteal',
        duration: 60,
        amplifier: 0
    },
    4: {
        id: 'quark:resilience',
        duration: 60,
        amplifier: 0
    }

}


EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('empower')) return
    let box = AABB.of(event.entity.x+20, event.entity.y+20, event.entity.z+20, event.entity.x-20, event.entity.y-20, event.entity.z-20)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.tags.contains('tamed_beast'))
    entitiesWithin.forEach(ent => {
        ent.health += ent.maxHealth*0.05
        let level = event.source.player.persistentData.empower
        // loop down from empower level to 1
        for (let i = level; i > 0; i--) {
            let empower_effect = empower[i]
            ent.potionEffects.add(empower_effect.id, empower_effect.duration*level, level-i)
        }
    })
})



// Ability: Bloodbound: Tamed Creatures heal nearby soulbinders and tamed beasts when they kill a creature
// - Heals 1% * bloodbound level (10 levels) of max health to all nearby tamed creatures and soulbinders
EntityEvents.death(event => {
    if (event.source == null) return
    if (event.source == undefined) return
    if (event.source.actual == null) return
    if (!event.source.actual.tags.contains('tamed_beast')) return
    if (!event.source.actual.tags.contains('bloodbound_beast')) return
    let box = AABB.of(event.entity.x+20, event.entity.y+20, event.entity.z+20, event.entity.x-20, event.entity.y-20, event.entity.z-20)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    let level = event.source.actual.persistentData.bloodbound
    entitiesWithin.forEach(ent => {
        if (ent.tags.contains('tamed_beast')) {
            ent.health += ent.maxHealth*(0.01*level)
        }
        if (ent.player) {
            if (ent.persistentData.get('bloodbound')) {
                ent.health += ent.maxHealth*(0.01*level)
            }
        }
    })
})




/**
 * Ability: Winterfang 
 * // 1% chance per level to freeze an enemy for .5 seconds if they hit a pet. 10 levels. Each level increases the chance by 1% and the duration by .5 seconds.
  // Does not affect bosses.
*/

EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.entity.tags.contains('tamed_beast')) return
    let owner_username = event.entity.tags.find(tag => tag.includes('Owner:')).split(':')[1]
    let player = event.server.getPlayer(owner_username)
    if (!player) return
    if (!player.persistentData.get('winterfang')) return
    let level = player.persistentData.winterfang
    // 1% chance per level to freeze enemies if they are hit by an arrow
    if (Math.random() > level * 0.01) return
    event.source.actual.potionEffects.add('mowziesmobs:frozen', 10*level, 1)
})



/**
 * Ability: Wildfyre
 * // 1% chance per level to set an enemy on fire for 1.25 seconds if they hurt a pet. 10 levels. Each level increases the chance by 1% and the duration by 1.25 seconds.
 */

EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.entity.tags.contains('tamed_beast')) return
    let owner_username = event.entity.tags.find(tag => tag.includes('Owner:')).split(':')[1]
    let player = event.server.getPlayer(owner_username)
    if (!player) return
    if (!player.persistentData.get('wildfyre')) return
    let level = player.persistentData.wildfyre
    // 1% chance per level to burn
    if (Math.random() > level * 0.01) return
    let time = 25*level
    event.source.actual.remainingFireTicks = time
})

//_______________________________________________________________________________________________________________________
// Geomancy
/**
 * New Earth
 * - Right click to gain geomancy for 1 minute
 * - Shift right click to cast stomp
 * - Stomp will stun enemies
 * - hitting a stunned enemy with a boulder will kill them
 */



ItemEvents.rightClicked('kubejs:essence_of_earth', event => {
    let player = event.player
    player.tags.add('essence_of_earth')
    player.persistentData.putInt('essence_of_earth', 15)
    player.persistentData.putInt('essence_of_earth_cast', 0)
    player.potionEffects.add('mowziesmobs:geomancy', 1200, 0)
})


/**
 * PlayerEvents.tick(event => {
    if (!event.player.tags.contains('essence_of_earth')) return
    if (!event.player.potionEffects.isActive('mowziesmobs:geomancy')) return
    if (!event.player.shiftKeyDown) return
    if (event.player.persistentData.essence_of_earth_cast == 0) {
        let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.player.username} stomp`)
        event.player.persistentData.essence_of_earth_cast = 1
    } else if (event.player.persistentData.essence_of_earth_cast == 1) {
        event.player.persistentData.essence_of_earth--
        if (event.player.persistentData.essence_of_earth > 0) return
        let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.player.username} stomp`)
        event.player.persistentData.essence_of_earth = 15
    }
})
 * 
 * 
 */



EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.indirect) return
    let player = event.source.player
    if (!player.tags.contains('essence_of_earth')) return
    if (event.source.immediate.type == 'mowziesmobs:boulder_projectile') {
        if (!event.entity.potionEffects.isActive('alexscaves:stunned')) return
        event.entity.kill()
    } else if (event.source.immediate.type.includes('stomp')) {
        event.entity.potionEffects.add('alexscaves:stunned', 80, 0)
        //event.entity.addMotion(0, 1, 0)
        //event.entity.potionEffects.add('levitation', 10, 5) 
        Utils.server.scheduleInTicks(10, () => {
            //event.entity.potionEffects.add('irons_spellbooks:antigravity', 70, 5)
        })
        
    
    }
})


//_______________________________________________________________________________________________________________________

// Tempest

ItemEvents.rightClicked('kubejs:essence_of_storms', event => {
    let player = event.player
    let player_x = player.x
    let player_y = player.y
    let player_z = player.z
    let box = AABB.of(player_x+20, player_y+2, player_z+20, player_x-20, player_y-2, player_z-20)
    let dim = event.level
    let counter = 0
    let entitiesWithin = dim.getEntitiesWithin(box)
    let len = entitiesWithin.length
    //Utils.server.tell(len)
    entitiesWithin.forEach(near_player => {
        if (near_player != player) {
            if (near_player.isMonster()) {
                counter++
                if (counter > 10) return // Make this number equal to class level
                event.server.scheduleInTicks(10*counter, () => {
                    near_player.potionEffects.add('levitation', 15, 10)
                    near_player.potionEffects.add('slow_falling', 28, 10)
                    Utils.server.scheduleInTicks(25, () => {
                        player.magicData.addMana(10)
                        event.level.spawnLightning(near_player.x, near_player.y, near_player.z, false)
                        })
                })
            }
        }
    })
    event.player.cooldowns.addCooldown(event.item, 3600) //4100 ticks = 3 minutes 
})




/**
 * Essence of Eternity: Stop time for enemies around you for 12 seconds per level. 5 levels. Cooldown is 3 minutes and starts after the ability is over. Each level decreases the cooldown by 15 seconds for a minimum of 2 minutes.
 * - Level 1: 12 seconds. 3 minute cooldown
 * - Level 2: 24 seconds. 2 minute 45 second cooldown
 * - Level 3: 36 seconds. 2 minute 30 second cooldown
 * - Level 4: 48 seconds. 2 minute 15 second cooldown
 * - Level 5: 60 seconds. 2 minute cooldown

 */










// Apex Predator: Some certain creatures spawn as Special Variants and may have unique items.


EntityEvents.spawned('traveloptics:summoned_tremorsaurus', event => {
    let x = event.entity.x
    let y = event.entity.y
    let z = event.entity.z
    Utils.server.scheduleInTicks(1, () => {
        let summoner_nbt = event.entity.nbt.get('Summoner').toString()
        let player_username = event.server.persistentData[summoner_nbt]
        //Utils.server.tell(player_username)
        if (player_username == null) return
        let player = event.server.getPlayer(player_username)
        //Utils.server.tell(player)
        let raptor1 = event.level.createEntity('traveloptics:summoned_vallumraptor')
        raptor1.setPos(x, y, z)
        raptor1.mergeNbt({
            Summoner: player.username
        })
        raptor1.spawn()
        let raptor2 = event.level.createEntity('traveloptics:summoned_vallumraptor')
        raptor2.setPos(x, y, z)
        raptor2.mergeNbt({
            Summoner: player.username
        })
        raptor2.spawn()
        let raptor3 = event.level.createEntity('traveloptics:summoned_vallumraptor')
        raptor3.setPos(x, y, z)
        raptor3.mergeNbt({
            Summoner: player.username
        })
        raptor3.spawn()
    })
    event.entity.teleportRelative(0, 100, 0)
    Utils.server.scheduleInTicks(5, () => {
        event.entity.kill()
    })
})
// extra imports once at the top of your script
let cTag   = Java.loadClass('net.minecraft.nbt.CompoundTag')


/**
 * 
 * @param {*} player Player who owns the entity
 * @param {*} entity The pet entity
 * @param {*} petData Pet data
 * @returns 
 * 
 * Marsupial Warmachine: Kangaroos are equipped with items based on the level of Marsupial Warmachine. 5 Minute cooldown.
 * - Level 1: Wooden Saber, Golden Helmet, Leather Chestplate
 * - Level 2: Golden Saber, Steampunk Helmet, Wooden Chestplate
 * - Level 3: Iron Saber, Face Helmet, Chainmail Chestplate
 * - Level 4: Sharp Sword, Lady Maria Helmet, Iron Chestplate
 * - Level 5: Hero Claymore, Forgotten Trace Helmet, Heavy Iron Armor Chestplate
 */
function marsupialWarmachine(player, entity, petData) {
    // Check if the entity is a kangaroo
    if (entity.type !== 'alexsmobs:kangaroo') return;

    // Check if the player has the 'marsupial_warmachine' data
    if (!player.persistentData.get('marsupial_warmachine')) return;
    if (isSkillCoolingDown(player, 'marsupial_warmachine')) return;
    // Retrieve the level of 'marsupial_warmachine'
    let level = player.persistentData.marsupial_warmachine

    // Ensure the level is within the valid range

    let weapon = petData.NBTItems1[level]
    let helmet = petData.NBTItems2[level]
    let chest  = petData.NBTItems3[level]

    let items = []



    // ── weapon in slot 0 ────────────────────────────────────────────────
    if (weapon) {
        items.push({ Slot: 0, Count: 1, id: weapon })
    }
    // ── helmet in slot 1 ────────────────────────────────────────────────
    if (helmet) {
    items.push({ Slot: 1, Count: 1, id: helmet })
    }

    // ── chestplate in slot 2 ────────────────────────────────────────────
    if (chest) {
    items.push({ Slot: 2, Count: 1, id: chest })
    }

    if (items.length) entity.mergeNbt({ Items: items })

    addSkillCooldown(player, 'marsupial_warmachine', 6000)
}

/*
let marsupial_warmachine_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.tags.contains('marsupial_warmachine_cooldown')) return
    let ticks = 6000
    if (marsupial_warmachine_cooldown[event.player.username] == undefined) {
        marsupial_warmachine_cooldown[event.player.username] = ticks
    } else {
        marsupial_warmachine_cooldown[event.player.username] -= 1
    }


    if (marsupial_warmachine_cooldown[event.player.username] > 0) return
    event.player.tags.remove('marsupial_warmachine_cooldown')
    marsupial_warmachine_cooldown[event.player.username] = ticks
})
*/




/**
 * Primal Retribution: When your pet dies there is a 2.5% chance to spawn a 3 fireballs that seek out the enemy that killed it. 5 levels. Each level increases the chance by 2.5% and the number of fireballs by 3.
 * - Level 1: 2.5% chance to spawn 3 fireballs
 * - Level 2: 5% chance to spawn 6 fireballs
 * - Level 3: 7.5% chance to spawn 9 fireballs
 * - Level 4: 10% chance to spawn 12 fireballs
 * - Level 5: 12.5% chance to spawn 15 fireballs
 * 
 * 
 */

EntityEvents.death(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.entity.tags.contains('tamed_beast')) return
    let owner_username = event.entity.tags.find(tag => tag.includes('Owner:')).split(':')[1]
    let player = event.server.getPlayer(owner_username)
    if (!player.persistentData.get('primal_retribution')) return
    let level = player.persistentData.primal_retribution
    let randomNumber = Math.random()
    if (randomNumber > 0.025*level) return
    let item = 'irons_spellbooks:fireball'
    //Utils.server.tell(randomItem)   
    let nbt = {
        Damage: 2*level,
        ExplosionRadius:0.5*level,
        Owner: player.username,
        LeftOwner:true,
        Tags: ['primal_retribution', `Target:${event.source.actual.uuid}`],
        Glowing: 1
    }
    let count = 3*level
    let target = event.source.actual
    multiShotStaggered(target, item, nbt, player, count, event.entity)


})


EntityEvents.spawned(event => {
    if (!event.entity.tags.contains('primal_retribution')) return
    if (!event.entity.tags.toString().includes('Target:')) return
    let target = event.entity.tags.find(tag => tag.includes('Target:')).split(':')[1]
    let arrow = event.entity
    let entity = event.level.getEntity(target)
    let x = entity.x
    let y = entity.y
    let z = entity.z
    let dirV = {
        x: (x - arrow.x) / 10,
        y: (y+1 - arrow.y) / 10,
        z: (z - arrow.z) / 10
    }
    arrow.setMotion(dirV.x*3, dirV.y*3, dirV.z*3)
    Utils.server.scheduleInTicks(300, a => {
        arrow.kill()    
    })
    Utils.server.scheduleInTicks(1, e => {
        if (!entity.alive) {
            e.repeating = false
            arrow.kill()
        }
        if (!arrow.alive) {
            e.repeating = false
        } else {
            e.repeating = true
            let x = entity.x
            let y = entity.y
            let z = entity.z
            if (arrow.distanceToEntity(entity) <= 3) {
                let dirV = {
                    x: (x - arrow.x) / 2,
                    y: (y+1 - arrow.y) / 2,
                    z: (z - arrow.z) / 2
                }
                arrow.setMotion(dirV.x*2, dirV.y*2, dirV.z*2)
                e.repeating = false
            } else {
                let dirV = {
                    x: (x - arrow.x) / 2,
                    y: (y+1 - arrow.y) / 2,
                    z: (z - arrow.z) / 2
                }
                arrow.setMotion(dirV.x*1, dirV.y*1, dirV.z*1)
            }

        }
    })

})


/**
 * 
 */


