
ServerEvents.tags('item', event => {
    Object.keys(rats).forEach(level => {
        rats[level].forEach(upgrade => {
            event.add(`kubejs:rat_item`, upgrade)
        })
    })
})


let other_rat_clears = [
    'rats:rat_skull',
    'rats:chunky_cheese_token',
]

EntityEvents.death('rats:tamed_rat',event => {
    if (!event.entity.tags.contains('tamed_beast')) return
    Utils.server.scheduleInTicks(1, event => {
        rats[5].forEach(upgrade => {
            Utils.server.runCommandSilent(`/kill @e[type=item,nbt={Item:{id:"${upgrade}"}}]`)
        })
        other_rat_clears.forEach(clear => {
            Utils.server.runCommandSilent(`/kill @e[type=item,nbt={Item:{id:"${clear}"}}]`)
        })
    })
})





function summonRat(owner, spawnCoords, isDuplicate, hasPlagueCharge) {
    let rat = owner.level.createEntity('rats:tamed_rat');
    rat.setPosition(spawnCoords.x, spawnCoords.y, spawnCoords.z);
    // Set tags related to ownership
    rat.tags.add('tamed_beast');
    rat.tags.add(`Owner:${owner.username}`);
    rat.tags.add('tamed_rat');
    rat.persistentData.putString('owner', owner.username);
    let rat_health = 4
    let nbtData = {
        Owner: owner.username,
        Command: 2,
        Tags: ['tamed_beast', `Owner:${owner.username}`, 'tamed_rat']
    };
    let player = owner;

    if (owner.persistentData.get('symbiotic_rot') && hasPlagueCharge) {
        let symbioticRotLevel = player.persistentData.symbiotic_rot;
        nbtData.Items = [];
        // Slots start at 3 and increment based on symbioticRotLevel level
        for (let slot = 3; slot < 3 + Math.min(symbioticRotLevel, 3); slot++) {
            nbtData.Items.push({
                Slot: slot,
                id: randomUpgrade(player),
                Count: 1
            });
        }
    }

    // Merge NBT data
    rat.mergeNbt(nbtData);



    if (owner.persistentData.get('miasma')) {
        let miasmaLevel = owner.persistentData.miasma;
        rat_health = 4 + (miasmaLevel * 2);
    }

    if (owner.persistentData.get('verminlord') && !isDuplicate) {
        let verminlordLevel = owner.persistentData.verminlord;
        let additionalRats = verminlord_extra_rats[verminlordLevel]
        for (let i = 0; i < additionalRats; i++) {
        let odds = verminlordLevel * 0.05
            if (Math.random() < odds) {
                summonRat(owner, spawnCoords, true, hasPlagueCharge);
            }
        } 
    }

    if (hasPlagueCharge && !isDuplicate && owner.persistentData.get('symbiotic_rot')) {
        let chance = Math.random();
        let symbioticRotLevel = owner.persistentData.symbiotic_rot;
        let odds = symbioticRotLevel * 0.04; // 5% chance per level
        if (chance < odds) {
            let amp = player.potionEffects.getActive('kubejs:plague_charge').amplifier
            amp = amp - 1
            Utils.server.runCommandSilent(`/effect clear ${player.username} kubejs:plague_charge`)
            if (amp >= 0) {
                Utils.server.runCommandSilent(`/effect give ${player.username} kubejs:plague_charge infinite ${amp} true`)
            }
        }
    }
    
    rat.maxHealth = rat_health
    rat.health = rat.maxHealth;
    rat.spawn();
    Utils.server.scheduleInTicks(1, () => {
        rat.persistentData.putString('owner', owner.username)
        if (owner.persistentData.get('plaguebearer')) {
                let plaguebearerLevel = owner.persistentData.plaguebearer;
                let spellcasting_level = null
                // If plaguebearer level is less than 3, set spellcasting_level to 'base'
                // If plaguebearer level is less than 5 but greater than or equal to 3, set spellcasting_level to 'superior'
                // If plaguebearer level is greater than or equal to 5, set spellcasting_level to 'exalted'
                if (plaguebearerLevel < 3) {
                    spellcasting_level = 'base'
                } else if (plaguebearerLevel < 5) {
                    spellcasting_level = 'superior'
                } else {
                    spellcasting_level = 'exalted'
                }

                //tell(spellcasting_level)
                if (spellcasting_level != null) {
                    applySpellcasting(rat, ['nature'], spellcasting_level);
                }
            }
            if (owner.persistentData.get('miasma')) {
                let miasmaLevel = owner.persistentData.miasma;
                let effects = Object.keys(miasma_effects).filter(key => parseInt(key) <= miasmaLevel)
                effects.forEach(effect => {
                    let unlock_level = parseInt(effect);
                    Utils.server.runCommandSilent(`/effect give ${rat.uuid} ${miasma_effects[effect]} infinite ${miasmaLevel - unlock_level} true`);
                });
            }
            rat.playSound('minecraft:entity.wither.ambient');
            Utils.server.runCommandSilent(`/execute in ${owner.level.dimension} run particle blue_skies:blue_flame ${rat.x} ${rat.y} ${rat.z} 0.2 0.8 0.2 0.08 100`)
            Utils.server.scheduleInTicks(2, () => {
                let affinity_gems = handleAffinityGems(owner)
                if (affinity_gems.length == 0) return
                affinity_gems.forEach(school => {
                    applySchool(rat, school, true)
                })
            })
    })
    

}









/**
 * __________________________________________________________________________________________
 * New Plague Doctor:
 * 
 * // Done - Desc written
 * Symbiotic Rot: 5 Levels
 *   If you have an active Plague Charge, Rats that you summon will be equipped special items. 
 *   -> Consumes 1 Plague Charge per summon event, NOT per that is summoned.
 *   -> 4% chance per level to not consume a Plague Charge
 * 
 * // Done - Desc written
 * Plaguebearer:  5 Levels
 *  - Level 1: Rats Spawn as Nature Mages
 *  - Level 2: Enemies hit with Nature Spells from a Rat have a chance to gain the Plague effect
 *  - Level 3: Rats Spawn as Superior Nature Mages
 *  - Level 4: Better abilities.
 *  - Level 5: Rats Spawn as Exalted Nature Mages
 * 
 * // Done - Desc written
 * Miasma: Increases Rat Health and spawns them with permanent effects. The effect is based on the player's Miasma level
 * §aLevel 1: Adrenaline. 6 Health
 * §aLevel 2: Adrenaline. 8 Health
 * §aLevel 3: Adrenaline, Steel Feet. 10 Health
 * §aLevel 4: Adrenaline, Steel Feet 12
 * §aLevel 5: Berserk. 14 Health
 * 
 * // Done - Desc written
 *   * Pestilence: 6 Levels
 *   -> Activate to kill all non-boss monsters that have the Plague effect and summon a rat in their place. 20 mana cost per enemy 
 *  - Level 1: 5 block radius, 20 mana cost per enemy, 30 second cooldown
 *  - Level 2: 10 block radius, 17 mana cost per enemy, 27 second cooldown
 *  - Level 3: 15 block radius, 14 mana cost per enemy, 24 second cooldown
 *  - Level 4: 20 block radius, 11 mana cost per enemy, 21 second cooldown
 *  - Level 5: 25 block radius, 8 mana cost per enemy, 18 second cooldown
 *  - §aLevel 6: 30 block radius, 5 mana cost per enemy, 15 second cooldown
 * 
 * 
 * // Done- Desc written
 * Contagion: 5 levels 
 * If your rat kills an enemy with a Nature spell, you regain 10 mana. Mana regain is doubled if the enemy has a plague effect
 *  - Level 1: 10 mana regenerated
 *  - Level 2: 15 mana regenerated
 *  - Level 3: 20 mana regenerated
 *  - Level 4: 25 mana regenerated
 *  - Level 5: 30 mana regenerated
 * 
 * // Done - Desc written
 * Corrupted Savior: 6 Levels
 *   Buffs and heals all friendly creatures when a player with an active plague effect kills a monster.
 *  - §aLevel 1: 
 *   -> 5 block radius, 3 second duration, amplification 1
 *   -> Heals tamed creatures for 5% of their max health
 *   -> Effects: Retaliation
 * 
 * - §aLevel 2:
 *  -> 10 block radius, 6 second duration, amplification 2
 *  -> Heals tamed creatures for 7% of their max health
 *  - Effects: Retaliation
 * 
 * - §aLevel 3:
 * -> 15 block radius, 9 second duration, amplification 3
 * -> Heals tamed creatures for 9% of their max health
 * * -> Effects: Retaliation, Lesser Strength
 * 
 * - §aLevel 4:
 * -> 20 block radius, 12 second duration, amplification 4
 * -> Heals tamed creatures for 11% of their max health
 * * -> Effects: Retaliation, Lesser Strength
 * 
 * - §aLevel 5:
 * -> 25 block radius, 15 second duration, amplification 5
 * -> Heals tamed creatures for 13% of their max health
 * * -> Effects: Retaliation, Lesser Strength, Diversion
 * 
 *  §aLevel 6:
 * -> 25 block radius, 15 second duration, amplification 5
 * -> Heals tamed creatures for 13% of their max health
 * * -> Effects: Retaliation, Lesser Strength, Diversion
 *   -> Has a small chance to turn nearby allies into Nature Mages. Chance is 5% and is rolled per ally
 * 
 * 
 * // Done - Desc written
 * Necrotic Bloom: 
 * When a player melee kills a monster, they have a 10% chance to gain a Plague Charge.
 *  - Right Clicking an enemy will consume a Plague Charge and give enemies within a 3 block radius a 5 second Plague effect
 *  Level 1: 10% chance to gain a Plague Charge, 4 block radius, 5 second duration
 *  Level 2: 20% chance to gain a Plague Charge, 5.5 block radius, 8.75 second duration
 *  Level 3: 30% chance to gain a Plague Charge, 7 block radius, 12.5 second duration
 *  Level 4: 40% chance to gain a Plague Charge, 8.5 block radius, 16.25 second duration
 *  Level 5: 50% chance to gain a Plague Charge, 10 block radius, 20 second duration
 * 
 * // Done - Desc written
 * Verminlord: Gain buffs based on the number of rats you have surrounding you.
 *  -> Also has a chance to summon extra rats. 1 at level 1, 2 at level 3, and 3 at level 6
 * *  - Level 1:  Rat point value: 1  Points needed to gain effects: 15  §e[Effects]§7   • Knockback Resistance   Summoning Rats has a 5% chance to summon another Rat
 * *  - Level 2: Rat point value: 1  Points needed to gain effects: 14  §e[Effects]§7   • Knockback Resistance   §4[Summoned Rats]§7   • Additional Rats: 1  • Chance to trigger: 10%
 *    - Level 3: Rat point value: 2  Points needed to gain effects: 13  §e[Effects]§7   • Knockback Resistance, Oakskin   §4[Summoned Rats]§7   • Additional Rats: 1  • Chance to trigger: 15%
      - Level 4: Rat point value: 2  Points needed to gain effects: 12  §e[Effects]§7   • Knockback Resistance, Oakskin  §4[Summoned Rats]§7   • Additional Rats: 2  • Chance to trigger: 20%
      - Level 5: Rat point value: 2  Points needed to gain effects: 11  §e[Effects]§7   • Knockback Resistance, Oakskin,  §4[Summoned Rats]§7   • Additional Rats: 2  • Chance to trigger: 25%
 *    - Level 6: Rat point value: 3  Points needed to gain effects: 10  §e[Effects]§7   • Knockback Resistance, Oakskin, Soul Steal   §4[Summoned Rats]§7   • Additional Rats: 3  • Chance to trigger: 30%
 
 * 
 * 
 * // Epidemic: 5 Levels - Desc written
 *  Chance to summon a rat when you kill a monster that has the plague effect
 *  Level 1: 8% chance to summon a rat when you kill a monster with the plague effect
 *  Level 2: 16% chance to summon a rat when you kill a monster with the plague effect
 *  Level 3: 24% chance to summon a rat when you kill a monster with the plague effect
 *  Level 4: 32% chance to summon a rat when you kill a monster with the plague effect
 *  Level 5: 40% chance to summon a rat when you kill a monster with the plague effect
 * 
 * 
 * // Done: - Desc written 
 * Black Death: When a rat dies, it explodes and enemies close to the corpse get the plague effect
 *  - §aLevel 1: 2 block radius, 5 second duration
 *  - §aLevel 2: 4 block radius, 6.25 second duration
 *  - §aLevel 3: 6 block radius, 7.5 second duration
 *  - §aLevel 4: 8 block radius, 8.75 second duration
 *  - §aLevel 5: 10 block radius, 10 second duration
 
 * 
 */

ItemEvents.firstLeftClicked('rats:rat_flute', event => {
    if (!event.player.shiftKeyDown) return
    event.level.entities.filter(ent => ent.type == 'rats:tamed_rat').forEach(rat => {
        if (rat.tags.contains('tamed_beast')) {
            if (rat.tags.contains(`Owner:${event.player.username}`)) {
                Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run tp ${rat.uuid} ${event.player.x} ${event.player.y} ${event.player.z}`)
            }
        }
    })
})


EntityEvents.hurt('rats:tamed_rat', event => {
    if (event.source.actual != null) return
    if (!event.source.toString().includes('magic')) return
    if (!event.entity.tags.contains('tamed_beast')) return
    if (!event.entity.potionEffects.isActive('runiclib:venom')) return
    event.cancel()
})








/**
 * Corrupted Savior: Buffs and heals all friendly creatures when a player with an active plague effect kills a monster.
 *  - §aLevel 1: 
 *   -> 5 block radius, 3 second duration, amplification 1
 *   -> Heals tamed creatures for 5% of their max health
 *   -> Effects: Retaliation
 * 
 * - §aLevel 2:
 *  -> 10 block radius, 6 second duration, amplification 2
 *  -> Heals tamed creatures for 7% of their max health
 *  - Effects: Retaliation
 * 
 * - §aLevel 3:
 * -> 15 block radius, 9 second duration, amplification 3
 * -> Heals tamed creatures for 9% of their max health
 * * -> Effects: Retaliation, Lesser Strength
 * 
 * - §aLevel 4:
 * -> 20 block radius, 12 second duration, amplification 4
 * -> Heals tamed creatures for 11% of their max health
 * * -> Effects: Retaliation, Lesser Strength
 * 
 * - §aLevel 5:
 * -> 25 block radius, 15 second duration, amplification 5
 * -> Heals tamed creatures for 13% of their max health
 * * -> Effects: Retaliation, Lesser Strength, Diversion
 * 
 *  §aLevel 6:
 * -> 25 block radius, 15 second duration, amplification 5
 * -> Heals tamed creatures for 13% of their max health
 * * -> Effects: Retaliation, Lesser Strength, Diversion
 *   -> Has a small chance to turn nearby allies into Nature Mages. Chance is 5% and is rolled per ally
 * 
 */ 


let savior_effects = {
    1: 'runiclib:retaliation',
    3: 'runiclib:lesser_strength',
    5: 'kubejs:diversion',
}


EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.entity.isMonster()) return
    if (isAlly(event.source.player, event.entity)) return
    if (!event.source.player.persistentData.get('corrupted_savior')) return
    if (isSkillCoolingDown(event.source.player, 'corrupted_savior')) return
    if (!event.source.player.potionEffects.isActive('runiclib:venom')) return
    let player = event.source.player
    let level = player.persistentData.corrupted_savior
    let radius = 5 * level; // 5 block radius per level
    let box = AABB.of(
        event.entity.x+radius, event.entity.y+radius, event.entity.z+radius,
        event.entity.x-radius, event.entity.y-radius, event.entity.z-radius
    );
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.tags.contains('tamed_beast'))
    
    if (entitiesWithin.length == 0) return // if there are no entities within the radius, return
    entitiesWithin.forEach(ent => {
        ent.health += ent.maxHealth * (0.05 * (0.02*(level-1)))
        // choose a random number between 1 and the corrupted_savior level
        let effect_level = Math.floor(Math.random() * level) + 1
        let effect = savior_effects[effect_level]
        applyEffect(ent, effect, 60*level, level, true, true)
        if (level >= 6) {
            let chance = Math.random();
            if (chance < 0.05) {
                applySpellcasting(ent, ['nature'], 'base')
            }
        }
    })
    let cd = 200 - ((level-1) * 20); // 200 ticks - 20 ticks per level
    addSkillCooldown(player, 'corrupted_savior', cd);
})

/*
let corrupted_savior_cooldown = new WeakMap();
PlayerEvents.tick(event => {
    if (!event.player.tags.contains('corrupted_savior_cooldown')) return;
    if (!event.player.persistentData.get('corrupted_savior')) return
    let player = event.player;
    let level = player.persistentData.corrupted_savior;
    let cd = 200 - ((level-1) * 20); // 200 ticks - 20 ticks per level
    if (corrupted_savior_cooldown[player.username] == null || corrupted_savior_cooldown[player.username] == undefined) {
        corrupted_savior_cooldown[player.username] = cd;
    } else {
        corrupted_savior_cooldown[player.username]--;
    }


    if (corrupted_savior_cooldown[player.username] > 0) return;
    player.tags.remove('corrupted_savior_cooldown');
    corrupted_savior_cooldown[player.username] = cd;

})
*/


/**
 * Necrotic Bloom: When a player melee kills a monster with the plague effect, they gain a Plague Charge.
 *  - Right Clicking an enemy will consume a Plague Charge and give enemies within a 3 block radius a 5 second Plague effect
 * 
 * 
 */

EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.entity.isMonster()) return
    let player = event.source.player
    if (!player.persistentData.get('necrotic_bloom')) return
    let method = determineMethod(event.source)
    if (method != 'melee') return // only melee kills count
    let level = player.persistentData.necrotic_bloom
    let odds = 0.20 + ((level-1)*0.075); // 20% + 7.5% per level
    if (wasCrit(player)) odds = Number(odds*2)
    if (Math.random() > odds) return // if the random number is greater than the odds, return
    if (!player.potionEffects.isActive('kubejs:plague_charge')) {
        Utils.server.runCommandSilent(`/effect give ${player.username} kubejs:plague_charge infinite 0 false`)
    } else {
        applyStackingEffect(player, 'kubejs:plague_charge', 'infinite', 1, 'necrotic_bloom', player, 10)
    }
})

ItemEvents.entityInteracted(event => {
    if (event.target.player) return
    if (isAlly(event.player, event.target)) return
    if (!event.player.potionEffects.isActive('kubejs:plague_charge')) return
    if (!event.player.persistentData.get('necrotic_bloom')) return
    let level = event.player.persistentData.necrotic_bloom
    let amp = event.player.potionEffects.getActive('kubejs:plague_charge').amplifier
    let player = event.player
    if (player.cooldowns.isOnCooldown('kubejs:necrotic_bloom_ability')) return
    let target = event.target
    amp = amp - 1 // reduce the amplifier by 1
    if (amp < 0) {
        Utils.server.runCommandSilent(`/effect clear ${event.player.username} kubejs:plague_charge`)
    } else {
        Utils.server.runCommandSilent(`/effect clear ${event.player.username} kubejs:plague_charge`)
        Utils.server.runCommandSilent(`/effect give ${event.player.username} kubejs:plague_charge infinite ${amp} false`)
    }
    player.swing()
    player.cooldowns.addCooldown('kubejs:necrotic_bloom_ability', 10)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.ambient ambient ${player.username} ${target.x} ${target.y} ${target.z} 1 1.5`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle blue_skies:poison true ${target.x} ${target.y+1} ${target.z} 0.5 0.5 0.5 0.2 250`)
    let radius = 4 + ((level-1) * 1.5) // 4 block radius + 1.5 block radius per level
    let box = AABB.of(
        event.target.x + radius, event.target.y + radius, event.target.z + radius,
        event.target.x - radius, event.target.y - radius, event.target.z - radius);
    let entitiesWithin = event.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying() && !ent.player)
    if (entitiesWithin.length == 0) return // if there are no entities within the
    let dur = 100 + ((level-1)*75)
    entitiesWithin.forEach(ent => {
        applyEffect(ent, 'runiclib:venom', dur, amp, true, true)
    })

})

EntityEvents.hurt(event => {
    if (!event.entity.player) return
    if (event.source.actual != null) return
    if (!event.source.toString().includes('magic')) return
    let player = event.entity
    if (!player.persistentData.get('necrotic_bloom')) return
    if (!player.potionEffects.isActive('runiclib:venom')) return
    event.cancel()
})

// Plague Bearer
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.source.toString().includes('nature_magic')) return
    if (event.source.actual.type != 'rats:tamed_rat') return
    if (!event.source.immediate.tags.contains('tamed_beast')) return
    let username = event.source.actual.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    let player = event.server.getPlayer(username)
    if (!player.persistentData.get('plaguebearer')) return
    let level = player.persistentData.plaguebearer
    if (level < 2) return // if the player does not have plaguebearer level 2, return
    let chance = 0.05 + ((level-2)*0.05) // 4% chance per level
    if (Math.random() > chance) return // if the random number is greater than the chance, return
    let dur = 100 + ((level-2)*100) // 100 ticks + 100 ticks per level
    applyEffect(event.entity, 'runiclib:venom', dur, level-2, true, true)
})



/**
 * Pestilence: Press a key to kill all monsters nearby that have the Plague effect and summon a rat. 
 *  - Level 1: 5 block radius, 20 mana cost, 30 second cooldown
 * *  - Level 2: 10 block radius, 17 mana cost, 26.25 second cooldown
 * *  - Level 3: 15 block radius, 14 mana cost, 22.5 second cooldown
 * *  - Level 4: 20 block radius, 11 mana cost, 18.75 second cooldown
 * *  - Level 5: 25 block radius, 8 mana cost, 15 second cooldown
 */



function pestilence_ability(player) {
    if (!player.persistentData.get('pestilence')) return
    if (isSkillCoolingDown(player, 'pestilence')) return
    let level = player.persistentData.pestilence;
    let radius = 5 * level;
    let box = AABB.of(player.x + radius, player.y + radius, player.z + radius, player.x - radius, player.y - radius, player.z - radius);
    let dim = player.level;
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying() && ent.potionEffects.isActive('runiclib:venom') && !ent.tags.contains('boss'))
    if (entitiesWithin.length == 0) return // if there are no entities within the radius, return
    if (getMana(player) < 20 - ((level-1)*3)) return // if the player does not have enough mana, return
    let mana_cost = 20 - ((level-1)*3)
    entitiesWithin.forEach(ent => {
        let mana = getMana(player)
        if (mana < mana_cost) return
        player.magicData.mana -= mana_cost;
        summonRat(player, {x: ent.x, y: ent.y, z: ent.z}, false, player.potionEffects.isActive('kubejs:plague_charge'));
        ent.kill();
    })
    let cd = 600 - ((level-1)*60);
    addSkillCooldown(player, 'pestilence', cd);
}


/*
let pestilence_cooldown = new WeakMap();
PlayerEvents.tick(event => {
    if (!event.player.tags.contains('pestilence_cooldown')) return;
    let player = event.player;
    let cd = 600 - ((player.persistentData.pestilence-1)*60);
    if (pestilence_cooldown[player.username] == undefined) {
        pestilence_cooldown[player.username] = cd;
    } else {
        pestilence_cooldown[player.username]--;
    }

    if (pestilence_cooldown[player.username] > 0) return;
    player.tags.remove('pestilence_cooldown');
    pestilence_cooldown[player.username] = cd
})
*/


//________________________________________________________________________________________
// Contagion 5 levels

EntityEvents.death(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (event.source.actual.type != 'rats:tamed_rat') return
    if (!event.source.immediate.tags.contains('tamed_beast')) return
    let username = event.source.actual.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    let player = event.server.getPlayer(username)
    if (!player.persistentData.get('contagion')) return
    let level = player.persistentData.contagion
    let mana_regen = 10 + ((level-1)*5);
    if (event.entity.potionEffects.isActive('runiclib:venom')) {
        mana_regen *= 2; // Double the mana regen if the entity has the plague effect
    }
    if (event.source.toString().includes('nature_magic')) {
        mana_regen *= 1.5
    }
    addMana(player, mana_regen);
})

// Verminlord: 6 levels Gain buffs based on the number of rats you have summoned

const verminlord_effects = {
    1: 'alexsmobs:knockback_resistance',
    3: 'irons_spellbooks:oakskin',
    5: 'alexsmobs:soulsteal',
}

const rat_multiplier = {
    1: 1,
    2: 2,
    3: 2,
    4: 3,
    5: 3,
    6: 4,
}

let verminlord_extra_rats = {
    1: 1,
    2: 1,
    3: 2,
    4: 2,
    5: 2,
    6: 3
}


PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 != 0) return
    if (!event.player.persistentData.get('verminlord')) return
    let player = event.player
    let level = player.persistentData.verminlord
    let entitiesWithin = event.level.entities.filter(ent => ent.tags.contains('tamed_beast') && ent.type == 'rats:tamed_rat' && ent.tags.contains(`Owner:${player.username}`) && ent.distanceToEntity(player) <= 20)
    if (entitiesWithin.length == 0) return
    let rat_mult = rat_multiplier[level]
    let points = entitiesWithin.length * rat_mult;
    if (points < 1) return
    let needed_points = 15 - ((level-1))
    if (points < needed_points) return
    let effects = Object.keys(verminlord_effects).filter(key => parseInt(key) <= level)
    effects.forEach(effect => {
        // amplifier is the verminlord level/2 rounded down
        let amplifier = Math.floor(level/2);
        player.potionEffects.add(verminlord_effects[effect], 45, amplifier, true, true)
    })
})


// Epidemic: Killing a Monster that has the plague effect has a chance to summon a rat
EntityEvents.death(event => {
    if (!event.source.player) return
    if (isAlly(event.source.player, event.entity)) return
    if (!event.source.player.persistentData.get('epidemic')) return
    if (!event.entity.potionEffects.isActive('runiclib:venom')) return
    let player = event.source.player
    let level = player.persistentData.epidemic;
    let odds = 0.20 * level; // 8% chance per level
    if (Math.random() > odds) return // if the random number is greater than the odds, return
    let spawnCoords = {
        x: event.entity.x,
        y: event.entity.y,
        z: event.entity.z
    };
    summonRat(player, spawnCoords, false, player.potionEffects.isActive('kubejs:plague_charge'));
    //Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.death ambient ${player.username} ${event.entity.x} ${event.entity.y} ${event.entity.z} 1 1.5`)

})

/**
 * Black Death: When a rat dies, it has a chance to explode and enemies close to the corpse get the plague effect
 *  - §aLevel 1: 2 block radius, 5 second duration
 *  - §aLevel 2: 4 block radius, 6.25 second duration
 *  - §aLevel 3: 6 block radius, 7.5 second duration
 *  - §aLevel 4: 8 block radius, 8.75 second duration
 *  - §aLevel 5: 10 block radius, 10 second duration
 * 
 *  */ 


EntityEvents.death('rats:tamed_rat', event => {
    if (!event.entity.tags.contains('tamed_beast')) return
    let player_username = event.entity.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    let player = event.server.getPlayer(player_username)
    if (!player.persistentData.get('black_death')) return
    let level = player.persistentData.black_death;
    let odds = 0.1 + ((level-1)*0.05); // 10% chance + 5% chance per level
    if (Math.random() > odds) return // if the random number is greater than the
    let radius = 2 * level
    let box = AABB.of(event.entity.x + radius, event.entity.y + radius, event.entity.z + radius, event.entity.x - radius, event.entity.y - radius, event.entity.z - radius);
    let dim = event.level;
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying() && !ent.tags.contains('boss') && !isAlly(player, ent))
    let dur = 100 + ((level-1)*25)
    let entity = event.entity
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle traveloptics:red_coral_bubble ${event.entity.x} ${event.entity.y} ${event.entity.z} 0.5 0.5 0.5 0.15 100`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexsmobs:fly_hurt ambient ${player.username} ${entity.x} ${entity.y+1} ${entity.z} 0.9 0.9`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.ambient ambient ${player.username} ${event.entity.x} ${event.entity.y} ${event.entity.z} 0.2 1.5`)
    
    entitiesWithin.forEach(ent => {
        applyEffect(ent, 'runiclib:venom', dur, level, true, true)
    })
})



/**
 * Miasma: Increases Rat Health and spawns them with permanent effects. The effect is based on the player's Miasma level
 * §aLevel 1: Adrenaline. 6 Health
 * §aLevel 2: Adrenaline. 8 Health
 * §aLevel 3: Adrenaline, Steel Feet. 10 Health
 * §aLevel 4: Adrenaline, Steel Feet, Berserk. 12
 * §aLevel 5: Berserk. 14 Health
 */

let miasma_effects = {
    1: 'runiclib:adrenaline',
    3: 'kubejs:steel_feet',
    5: 'runiclib:berserk',
}


// Symbiotic Rot: If you have an active Plague Charge, Rats that you summon will have special items.

let rats = {
    1: [
        'rats:rat_upgrade_speed', 
        'rats:rat_upgrade_bow', 
        'rats:rat_upgrade_crossbow', 
        'rats:rat_upgrade_aquatic', 
        'rats:rat_upgrade_flight', 
    ],
    2: [
        'rats:rat_upgrade_speed', 
        'rats:rat_upgrade_remedy', 
        'rats:rat_upgrade_bow', 
        'rats:rat_upgrade_crossbow', 
        'rats:rat_upgrade_aquatic', 
        'rats:rat_upgrade_flight', 
        'rats:rat_upgrade_bee', 
        'rats:rat_upgrade_support'
    ],
    3: [
        'rats:rat_upgrade_speed', 
        'rats:rat_upgrade_remedy', 
        'rats:rat_upgrade_bow', 
        'rats:rat_upgrade_crossbow', 
        'rats:rat_upgrade_aquatic', 
        'rats:rat_upgrade_flight', 
        'rats:rat_upgrade_bee', 
        'rats:rat_upgrade_support',
        'rats:rat_upgrade_ender', 
        'rats:rat_upgrade_armor', 
        'rats:rat_upgrade_strength', 
        'rats:rat_upgrade_poison', 
    ],
    4: [
        'rats:rat_upgrade_speed', 
        'rats:rat_upgrade_remedy', 
        'rats:rat_upgrade_bow', 
        'rats:rat_upgrade_crossbow', 
        'rats:rat_upgrade_aquatic', 
        'rats:rat_upgrade_flight', 
        'rats:rat_upgrade_bee', 
        'rats:rat_upgrade_support',
        'rats:rat_upgrade_ender', 
        'rats:rat_upgrade_armor', 
        'rats:rat_upgrade_strength', 
        'rats:rat_upgrade_poison', 
        'rats:rat_upgrade_asbestos', 
        'rats:rat_upgrade_ethereal', 
        'rats:rat_upgrade_feral_bite',
        'rats:rat_upgrade_undead',
    ],
    5: [
        'rats:rat_upgrade_speed', 
        'rats:rat_upgrade_remedy', 
        'rats:rat_upgrade_bow', 
        'rats:rat_upgrade_crossbow', 
        'rats:rat_upgrade_aquatic', 
        'rats:rat_upgrade_flight', 
        'rats:rat_upgrade_bee', 
        'rats:rat_upgrade_support',
        'rats:rat_upgrade_ender', 
        'rats:rat_upgrade_armor', 
        'rats:rat_upgrade_strength', 
        'rats:rat_upgrade_poison', 
        'rats:rat_upgrade_asbestos', 
        'rats:rat_upgrade_ethereal', 
        'rats:rat_upgrade_feral_bite',
        'rats:rat_upgrade_undead',
        'rats:rat_upgrade_health', 
        'rats:rat_upgrade_demon', 
        'rats:rat_upgrade_tnt_survivor', 
        'rats:rat_upgrade_buccaneer', 
        'rats:rat_upgrade_ratinator', 
        'rats:rat_upgrade_psychic'
    ]
}
function randomUpgrade(player) {
    // get random upgrade based on the players symbiotic_rot level
    let level = player.persistentData.symbiotic_rot
    let random_upgrade = rats[level][Math.floor(Math.random() * rats[level].length)]
    return random_upgrade
}



