/**
 * Rename to mystic
 * 

 **/







/**
 * - Ability 2: Air Combo
 *   Normal:
 *   - When you hit an enemy with an arrow while you are in the air it will give you levitation and haste
 *   - You will also get Planar Sight
 *  Insane:
 *   - Your attacks cause enemies to wither (maybe bleed?)
 *   - Killing one of these enemies will spread it to other enemies
 * 
 * - Ability 3: mystic Teleport
 *  Normal:
 *  - When you kill an enemy with an arrow while you are in the air you will teleport to them
 *  - You will get a haste buff
 *  - Enemies around you will get levitation and a stun effect
 *  - Enemies that you hit with arrows while they are floating will be struck with lightning
 * Insane:
 * - You will get a much larger haste buff
 * - Larger radius for the levitation and stun effect
 * - You will get a much larger haste buff
 * - Enemies you hit will be struck with lightning twice
 *
 * Ability 4: Stacking haste buff:
 * Normal:
 *  - Every time you hit an enemy with an arrow you will add 1 to a counter and will give you a haste boost
 *  - if you are hit then you will lose the counter
 * Insane: 
 * - You will get a speed buff as well
 * 
 * //// Dont use crouch for any ability so that it doesnt conflict with ranger
 * // Make a new bow for mystic that is very very accurate, somewhat slow to draw, and does okay damage
 *  // Look at to do list to look at getting around the insane enemies.
 * // Rewrite how Insanity Orb works
 * // Make an ability that makes it so when you kill a player that is insane OR while you are insane then other players within a 20
 * block radius will go insane as well.
 * 
 * 
 * 










// Fiery Flight: 4 Levels Killing an enemy with an arrow while you are in the air will give you a Burning Dash


let fiery_flight_buffer = new WeakMap()
let fiery_flight_count = new WeakMap()
let fiery_flight_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    let player = event.player
    if (!player.persistentData.get('fiery_flight')) return
    if (!player.tags.contains('fiery_flight_cooldown')) {
        let level = player.persistentData.fiery_flight
        if (player.blockStateOn.block != 'Block{minecraft:air}') return
        if (!player.shiftKeyDown) return
        let slot = getNonKeySlot(player, 'fiery_flight')

        if (fiery_flight_buffer[player.username] == undefined) {
            fiery_flight_buffer[player.username] = 8
        } else {
            fiery_flight_buffer[player.username]--
        }

        if (fiery_flight_buffer[player.username] != 0) return

        let spell = 'burning_dash'
        let spell_level = level
        playerCast(player, spell, spell_level)
        player.potionEffects.add('minecraft:slow_falling', 60, 5)

        fiery_flight_buffer.delete(player.username)

        if (fiery_flight_count[player.username] == undefined) {
            fiery_flight_count[player.username] = level
        } else {
            fiery_flight_count[player.username]--
        }
        

        if (fiery_flight_count[player.username] == 0) {
            player.tags.add('fiery_flight_cooldown')
            hide_non_key_ability(player, 'fiery_flight')
            fiery_flight_count.delete(player.username)
        } else {
            paint_non_key_ability(player, 'fiery_flight', slot, 'fiery_flight')
        }
    } else {
        if (fiery_flight_cooldown[player.username] == undefined) {
            fiery_flight_cooldown[player.username] = 300
        } else {
            fiery_flight_cooldown[player.username]--
        }
        if (fiery_flight_cooldown[player.username] == 0) {
            player.tags.remove('fiery_flight_cooldown')
            fiery_flight_cooldown.delete(player.username)
        }
            
    }

})





// Terror: §aLevel 5 While insane, hitting an enemy will do 2x damage
// §aLevel 1: +20% damage
// §aLevel 2: +40% damage
// §aLevel 3: +60% damage
// §aLevel 4: +80% damage
// §aLevel 5: +100% damage
EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.tags.contains('insane')) return
    if (!event.source.player.persistentData.get('terror')) return
    let level = event.source.player.persistentData.terror
    let damage = event.damage * (0.20*level)
    event.entity.attack(damage)
})





 */

// esoteric_echoes: Killing an enemy while insane you gain echoing strikes for 5 seconds * level
// §aLevel 1: 1 level of echoing strikes for 5 seconds
// §aLevel 2: 2 levels of echoing strikes for 10 seconds
// §aLevel 3: 3 levels of echoing strikes for 15 seconds


EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (isInsane(player)) return
    if (!player.persistentData.get('esoteric_echoes')) return
    let level = player.persistentData.esoteric_echoes
    player.potionEffects.add('irons_spellbooks:echoing_strikes', 100*level, level)
})


/**
 * Terror: Hurting an enemy with a Throwable Weapon will have a chance to give you abyssal strike. Enemies hurt Abyssal Strike have a chance to gain a Mark of the Void
 * §aLevel 1: 5% chance to gain abyssal strike for 3 seconds. Enemies hurt by Abyssal Strike have a 5% chance to gain a Mark of the Void for 2 seconds
 * §aLevel 2: 10% chance to gain abyssal strike for 6 seconds. Enemies hurt by Abyssal Strike have a 10% chance to gain a Mark of the Void for 4 seconds
 * §aLevel 3: 15% chance to gain abyssal strike for 9 seconds. Enemies hurt by Abyssal Strike have a 15% chance to gain a Mark of the Void for 6 seconds
 * §aLevel 4: 20% chance to gain abyssal strike for 12 seconds. Enemies hurt by Abyssal Strike have a 20% chance to gain a Mark of the Void for 8 seconds
 * §aLevel 5: 25% chance to gain abyssal strike for 15 seconds. Enemies hurt by Abyssal Strike have a 25% chance to gain a Mark of the Void for 10 seconds
 */
EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('terror')) return

    let check = levelBetterProjectileCheck(player.persistentData.terror, event, 'throwable', 3, 5)
    if (!check) return

    let level = player.persistentData.terror
    let chance = Math.random()
    if (chance > 0.03*level) return
    event.source.player.potionEffects.add('traveloptics:abyssal_strike', 60*level, level, true, true)
})

EntityEvents.hurt(event => {
    if (!event.source.toString().includes('abyssal_burn')) return
    let possible_players = event.server.players.filter(player => player.potionEffects.isActive('traveloptics:abyssal_strike'))
    if (possible_players.length == 0) return
    let player = possible_players[0]
    let level = player.persistentData.terror

    let chance = Math.random()
    if (chance > level*0.05) return
    applyEffect(event.entity, 'kubejs:mark_of_the_void', 40*level, level)
})



/**
 * gravitic_flux: 3 Levels: Invert gravity
 * §aLevel 1: Invert your Gravity, allowing you to walk on the ceiling. Cooldown: 30 seconds
 * §aLevel 2: Cooldown reduced to 20 seconds
 * §aLevel 3: Cooldown reduced to 10 seconds and you gain Invisibility for 5 seconds upon activation
 */
// --- activation -----------------------------------------------------------
function gravitic_flux_ability(player) {
  if (!player.persistentData.get('gravitic_flux')) return
  
  let check = isSkillCoolingDown(player, 'gravitic_flux')
  if (check) return
  let level = player.persistentData.gravitic_flux           // 1–3
                         // 30 s, 20 s, 10 s

  // ability effect ---------------------------------------------------------
  if (player.potionEffects.isActive('gravityapi:invert')) {
    Utils.server.runCommandSilent(`/effect clear ${player.username} gravityapi:invert`)
    let cd = 600 - (level - 1) * 200
    addSkillCooldown(player, 'gravitic_flux', cd)
    Utils.server.scheduleInTicks(10, () => {
        Utils.server.runCommandSilent(`/effect give ${player.username} kubejs:steel_feet infinite 0 false`)
        Utils.server.scheduleInTicks(1, e => {
            if (player.blockStateOn.block != 'Block{minecraft:air}') {
                e.repeating = false
                Utils.server.runCommandSilent(`/effect clear ${player.username} kubejs:steel_feet`)
            } else {
                e.repeating = true
            }
        })

    })
  } else {
    Utils.server.runCommandSilent(`/effect give ${player.username} gravityapi:invert infinite 0 true`)
    if (level >= 3) {
      player.potionEffects.add('cofh_core:true_invisibility',   100, 0)
      player.potionEffects.add('irons_spellbooks:true_invisibility', 100, 0)
    }
  }

  // visuals & SFX ----------------------------------------------------------
  Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound traveloptics:abyssal_strike_trigger ambient ${player.username} ${player.x} ${player.y} ${player.z} 0.5 2`)
  Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle call_of_yucutan:death_wisp ${player.x} ${player.y} ${player.z} 0.1 0.1 0.1 0.5 25`)


  

}

/**
 * let gravitic_fluxCooldown = new WeakMap();
// --- tick handler ---------------------------------------------------------
PlayerEvents.tick(event => {
  if (!event.player.persistentData.get('gravitic_flux')) return
    let p = event.player
    if (p.tags.contains('gravitic_flux_cooldown')) {
        let level = p.persistentData.gravitic_flux
    let cd = 600 - (level - 1) * 200
    // 1. handle the steel-feet auto-clear ------------------------------------
    let onGround = false
    if (p.blockStateOn.block != 'Block{minecraft:air}') {
        onGround = true
    }
    if (onGround && p.potionEffects.isActive('kubejs:steel_feet') && p.tags.contains('gravitic_flux_steel_feet')) {
        Utils.server.scheduleInTicks(2, () => {
        Utils.server.runCommandSilent(`/effect clear ${p.username} kubejs:steel_feet`)
        p.tags.remove('gravitic_flux_steel_feet')
        })
    }
    
    if (gravitic_fluxCooldown[p.username] == undefined) {
        gravitic_fluxCooldown[p.username] = cd
    } else {
        gravitic_fluxCooldown[p.username]--
    }

    if (gravitic_fluxCooldown[p.username] <= 0) {
        p.tags.remove('gravitic_flux_cooldown')
        gravitic_fluxCooldown[p.username] = undefined
    }
  }
})
 * 
 * 
 * 
 * 
 */













/**
 * Parallax: 5 Levels: 
 * §aLevel 1: Activate the ability to make your next projectile attack mark the enemy. You have 10 seconds to press the ability key again to swap places with the enemy.
 * §aLevel 2: You gain speed for 5 seconds after swapping places with the enemy.
 * §aLevel 3: You gain speed for 10 seconds after swapping places with the enemy. Parallax will now work with any non-magical projectile.
 * §aLevel 4: You gain invisibility for 5 seconds after swapping places with the enemy.
 * §aLevel 5: Parallax will now work with any projectile type. Enemies within 5 blocks of you after you swap places have a 10% chance to gain a Mark of the Void for 10 seconds. Chance is calculated per enemy and is doubled if you are insane.
 */



function parallax_ability(player) {
    if (!player.persistentData.get('parallax')) return
    if (isSkillCoolingDown(player, 'parallax')) return
    if (player.persistentData.getBoolean('parallax_active') != true) {
        player.persistentData.putBoolean('parallax_active', true)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound kubejs:clock_slow ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle fathomless:crimson_aura ${player.x} ${player.y+1} ${player.z} 0.3 0.5 0.3 1 100 force ${player.username}`)
        let level = player.persistentData.parallax
        let ticks = 100*Number(level)
        let seconds = ticks/20
        player.tell(`§dParallax Activated§7`)
        player.tell(`§7Mark a target within §5${seconds}s...§7`)
        Utils.server.scheduleInTicks(20, e => {
            if (player.persistentData.get('parallax_entity')) {
                e.repeating = false
                return
            }
            if (seconds < 2) {
                player.persistentData.remove('parallax_active')
                player.persistentData.remove('parallax_entity')
                player.tell(`§7You did not mark a target in time`)
                Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle traveloptics:red_star_inward ${player.x} ${player.y + 1} ${player.z} 1 1 1 0.11 50`)
                Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.spawn ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
                e.repeating = false
                return
            } else {
                e.repeating = true
                seconds--
                player.tell(`§5${seconds}s...`)
                Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound create:stock_ticker_trade ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 2`)
                return
            }

        })



    } else {
        let entity = player.level.getEntity(player.persistentData.getString('parallax_entity'))
        if (!entity) return
        parallax_teleportation(player, entity)
    }
}


function parallax_teleportation(player, entity) {
    let level = player.persistentData.parallax
    player.persistentData.putBoolean('parallax_active', false)
    let x = entity.x
    let y = entity.y
    let z = entity.z
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run tp ${entity.uuid} ${player.x} ${player.y+2.5} ${player.z}`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run tp ${player.username} ${x} ${y} ${z}`)
    player.persistentData.remove('parallax_entity')
    entity.persistentData.remove('parallax_mark')
    Utils.server.runCommandSilent(`/effect clear ${entity.uuid} minecraft:glowing`);
    Utils.server.runCommandSilent(`/cgl clear ${entity.uuid} true`);
    player.tell(`§aParallax successful§7`)
    addSkillCooldown(player, 'parallax', 1200-Number(level * 100))
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound irons_spellbooks:spell.black_hole.cast ambient ${player.username} ${player.x} ${player.y} ${player.z} 2 1.5`)
    Utils.server.scheduleInTicks(1, e => {
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound irons_spellbooks:spell.black_hole.charge ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 2`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle fathomless:crimson_aura ${player.x} ${player.y+1} ${player.z} 0.3 0.5 0.3 1 100 force ${player.username}`)
    })
    speedyCast(player, 'shockwave', level)
    if (level >= 2) {
        player.potionEffects.add('minecraft:speed', 40*(level-2), level-2)
    }
    if (level >= 4) {
        player.potionEffects.add('irons_spellbooks:true_invisibility', 100, 0)
        player.potionEffects.add('cofh_core:true_invisibility', 100, 0)
    }
    if (level >= 5) {
        let box = AABB.of(player.x+5, player.y+5, player.z+5, player.x-5, player.y-5, player.z-5)
        let dim = player.level
        let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent != player && ent.isMonster() && !ent.tags.contains('tamed_beast'))
        entitiesWithin.forEach(ent => {
            let odds = Math.random()
            let chance = 0.1
            if (player.getSanity() == 0) {
                chance = chance * 2
            }
            if (odds < chance) {
                applyEffect(ent, 'irons_spellbooks:mark_of_the_void', 200, 0)
            }
            
        })
    }
}




EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    let player = event.source.player
    if (!player.persistentData.get('parallax')) return
    if (player.persistentData.getBoolean('parallax_active') != true) return
    let level = player.persistentData.parallax
    let check = levelBetterProjectileCheck(level, event, 'throwable', 3, 5)
    if (!check) return
    if (player.persistentData.get('parallax_entity')) return
    event.entity.persistentData.putString('parallax_mark', player.username)
    player.persistentData.putString('parallax_entity', event.entity.uuid)
    let ticks = 100*Number(level)
    applyEffect(player, 'minecraft:speed', ticks, Math.ceil(level-1, 2), 'parallax', player)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound kubejs:dash_smash ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
    let seconds = ticks/20
    player.tell(`§aTarget marked§7`)
    global.applyGlow(event.entity, 'purple', ticks)
    player.tell(`§7Reactivate within: §5${seconds}s...`)
    Utils.server.scheduleInTicks(20, e => {
        if (player.persistentData.getBoolean('parallax_active') == false) {
            e.repeating = false
            return
        }
        if (seconds < 2) {
            player.persistentData.putBoolean('parallax_active', false)
            player.persistentData.remove('parallax_entity')
            event.entity.persistentData.remove('parallax_mark')
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle traveloptics:red_star_inward ${player.x} ${player.y + 1} ${player.z} 1 1 1 0.11 50`)
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.spawn ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
            player.tell(`§7You did not reactivate §dParallax§7 in time.`)
            e.repeating = false
            return
        } else {
            e.repeating = true
            seconds--
            player.tell(`§5${seconds}s...`)
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound create:stock_ticker_trade ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 2`)
            return
        }

    })

})


/*
let parallaxCooldown = new WeakMap();

PlayerEvents.tick(event => {
    let player = event.player;
    if (!player.persistentData.get('parallax')) return;
    if (!player.tags.contains('parallax_cooldown')) return;
    let level = player.persistentData.parallax;
    let cd = 2400 - ((level-1)*300)
    if (parallaxCooldown[player.username] == undefined) {
        parallaxCooldown[player.username] = cd;
    } else {
        parallaxCooldown[player.username]--;
    }

    if (parallaxCooldown[player.username] > 0) return
    player.tags.remove('parallax_cooldown');
    parallaxCooldown[player.username] = cd;
})
*/




/**
 * Nightwalker: While insane, you gain special effects
 * 4 levels
 * §aLevel 1: Fortify
 * §aLevel 2: Precision
 * §aLevel 3: Diversion
 * §aLevel 4: Planar Sight
 */

let nightwalker = {
    1: [
        'irons_spellbooks:fortify',
    ],
    2: [
        'projectile_damage:impact',
    ],
    3: [
        'kubejs:diversion',
    ],
    4: [
        'irons_spellbooks:planar_sight',
    ]
}

PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 != 0) return
    if (!event.player.persistentData.get('nightwalker')) return
    let player = event.player
    let level = player.persistentData.nightwalker
    if (player.getSanity() > 0) return
    //loop down from level to 1
    for (let i = level; i > 0; i--) {
        nightwalker[i].forEach(effect => {
            player.potionEffects.add(effect, 60, 1)
        })
    }
})


EntityEvents.spawned('irons_spellbooks:sunbeam', event => {
    Utils.server.scheduleInTicks(1, () => {
        Utils.server.runCommand(`/data get entity ${event.entity.uuid}`)
    })
})





/**
 * Mindshatter: 3 Levels
 * §aLevel 1: Using this will cause you to go Insane. Activate again to remove Insanity. Cooldown: 30 seconds
 * §aLevel 2: Cooldown reduced to 20 seconds
 * §aLevel 3: Cooldown reduced to 10 seconds
 */
function mindshatter_ability(player) {
    if (!player.persistentData.get('mindshatter')) return
    if (isSkillCoolingDown(player, 'mindshatter')) return
    if (player.getSanity() < 100) {
        removeInsanity(player)
        let level = player.persistentData.mindshatter
        let cd = 600 - ((level-1)*100)
        addSkillCooldown(player, 'mindshatter', cd)
    } else {
        goInsane(player)
    }
}
/*
let mindshatterCooldown = new WeakMap();
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('mindshatter')) return
    if (!event.player.tags.contains('mindshatter_cooldown')) return
    let level = event.player.persistentData.mindshatter
    let cd = 600 - ((level-1)*100)

    if (mindshatterCooldown[event.player.username] == undefined) {
        mindshatterCooldown[event.player.username] = cd
    } else {
        mindshatterCooldown[event.player.username]--
    }

    if (mindshatterCooldown[event.player.username] > 0) return
        event.player.tags.remove('mindshatter_cooldown')
        mindshatterCooldown[event.player.username] = cd
})
*/



/**
 * Cyclone: 3 Levels
 * §aLevel 1: Activate the ability to gain an aerial boost whenever you hit an enemy with a projectile while in the air.
 * §aLevel 2: You gain a stacking hastened effect for 1 second after hitting an enemy with a projectile while in the air. Now works with any non-magical projectile.
 * §aLevel 3: You gain a stacking hastened effect for 2 seconds after hitting an enemy with a projectile while in the air. Now works with any projectile.
 * 
 * Stacking buff duration is doubled if you are insane
 */

function cyclone_ability(player) {
    if (!player.persistentData.get('cyclone')) return
    if (player.tags.contains('cyclone_active')) {
        player.tags.remove('cyclone_active')
        player.tell(Text.red('Cyclone deactivated'))
    } else {
        player.tags.add('cyclone_active')
        player.tell(Text.green('Cyclone activated'))
    }
}

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('cyclone')) return
    let level = player.persistentData.cyclone
    if (!player.tags.contains('cyclone_active')) return
    let entity = event.entity
    let trigger = false
    if (level == 1) {
        let throwable = throwableCheck(event.source)
        if (!throwable) return
        trigger = true
    } else if (level == 2) {
        let physical = physicalProjectileCheck(event.source)
        if (!physical) return
        trigger = true
    } else if (level == 3) {
        let anyProj = anyProjectileCheck(event.source)
        if (!anyProj) return
        trigger = true
    }

    if (!trigger) return
            

    let y_diff = player.y - entity.y; // Calculate the Y difference

    // Base amplification value
    let base_amplification = 10;

    // Ensure y_diff is positive (absolute difference)
    y_diff = Math.abs(y_diff);

    // Decrease amplification based on y_diff
    let amplification = base_amplification - (y_diff * 0.5); // Linear decrease
    if (amplification < 0) {
        amplification = 0; // Prevent amplification from going negative
    }
    player.potionEffects.add('minecraft:levitation', amplification, amplification*1.1)
    player.potionEffects.add('minecraft:slow_falling', 60, 50)

    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run tp ${event.source.immediate.uuid} ${player.x} ${player.y} ${player.z}`)
    entity.tags.add('mystic_target')
    if (level >= 2) {
        let dur = 20*(level-1)
        if (isInsane(player)) {
            dur = dur * 2
        }
        applyEffect(player, 'irons_spellbooks:hastened', dur, 1, 'mystic_target', player)
    }
    
    event.server.scheduleInTicks(10, () => {
        entity.tags.remove('mystic_target')
    })
})



// Voidblast: 5 Levels:
// - Killing an enemy with a Projectile while they have the mark of the void will cause you to rapidly teleport to enemies within range and cast shockwave. If you are insane, the shockwave level is doubled
EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!event.entity.potionEffects.isActive('kubejs:mark_of_the_void')) return
    if (!player.persistentData.get('voidblast')) return
    let level = player.persistentData.voidblast
    let entity = event.entity
    let check = levelBetterProjectileCheck(level, event, 'throwable', 3, 5)
    if (!check) return
    if (isSkillCoolingDown(player, 'voidblast')) return
    

    let player_x = player.x
    let player_y = player.y
    let player_z = player.z
    Utils.server.runCommandSilent(`/clear ${player.username} minecraft:levitation`)
    let shocklevel = 0
    if (player.getSanity() < 100) {
        shocklevel = level*2
    } else {
        shocklevel = level
    }
    //Utils.server.runCommandSilent(`/execute in ${dimension} run cast ${player.username} voidblast ${shocklevel}`)
    let box = AABB.of(entity.x + 5 + (level*5), entity.y+5 + (level*5), entity.z+5 + (level*5), entity.x-5 - (level*5), entity.y-5 - (level*5), entity.z-5 - (level*5))
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent != player && ent.isMonster() && !ent.tags.contains('tamed_beast'))
    let count = 0
    entitiesWithin.forEach(ent => {
            player.potionEffects.add('irons_spellbooks:evasion', 30, 1)
            if (count >= level * 3) return
            count++
            Utils.server.scheduleInTicks(8*count, () => {
                Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run tp ${player.username} ${ent.x} ${ent.y} ${ent.z}`)
                Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.enderman.teleport player ${player.username} ${player_x} ${player_y} ${player_z} 100`)
                speedyCast(player, 'shockwave', shocklevel)
            })
        })
     Utils.server.scheduleInTicks(2+(level*3*8), () => {
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run tp ${player.username} ${player_x} ${player_y+5} ${player_z}`)
        //player.potionEffects.add('minecraft:slow_falling', 80, 5)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound irons_spellbooks:spell.gust.cast master ${player.username} ${player_x} ${player_y} ${player_z} 50`)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:electricity ${player_x} ${player_y} ${player_z} 1 1 1 1 100 force @a`)
        
    })
    let cd = 3600 - ((level-1)*300)
    addSkillCooldown(player, 'voidblast', cd)
})

/*
let voidblastCooldown = new WeakMap();
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('voidblast')) return
    if (!event.player.tags.contains('voidblast_cooldown')) return
    let level = event.player.persistentData.voidblast
    let cd = 3600 - ((level-1)*300)
    if (voidblastCooldown[event.player.username] == undefined) {
        voidblastCooldown[event.player.username] = cd
    } else {
        voidblastCooldown[event.player.username]--
    }

    if (voidblastCooldown[event.player.username] > 0) return
    event.player.tags.remove('voidblast_cooldown')
    voidblastCooldown[event.player.username] = cd
    
})
*/




/**
 * Gravity Well: 5 Levels
 *  - Killing an enemy with a Projectile has a 0.5% chance to spawn a Black Hole at their location. If you are insane, the chance is doubled
 */


EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('gravity_well')) return
    let level = player.persistentData.gravity_well
    let entity = event.entity
    let check = levelBetterProjectileCheck(level, event, 'throwable', 3, 5)
    if (!check) return

    let odds = Math.random()
    let chance = 0.005 * level
    if (player.getSanity() == 0) {
        chance = chance * 2
    }
    if (odds > chance) return
    let black_hole = event.level.createEntity('irons_spellbooks:black_hole')
    black_hole.setPos(entity.x, entity.y, entity.z)
    black_hole.spawn()
    Utils.server.scheduleInTicks(200*level, () => {
        black_hole.kill()
    })
})

/**
 * Severed Continuum: 5 Levels - 3 minute cooldown
 * - Activate to gain a 10s stack of Diversion for each enemy within a 5 block radius. Entities within the radius are slowed If you are insane, the duration is doubled
 * - Killing a Time Slowed enemy will add 1 Temporal Charge. Once Severed Continuum has ended, all Temporal Charges will be consumed and apply an Abyssal Strike effect to you based on how many Temporal Charges were consumed. If you are insane, the duration is doubled
 * 
 * - Each level will add +5 to the radius of the ability and reduce the cooldown by 15 seconds
 */


function severed_continuum_ability(player) {
    if (!player.persistentData.get('severed_continuum')) return
    if (isSkillCoolingDown(player, 'severed_continuum')) return
    let level = player.persistentData.severed_continuum
    let box = AABB.of(player.x + (5*level), player.y+5 + (5*level), player.z+ (5*level), player.x- (5*level), player.y-5 - (5*level), player.z- (5*level))
    let dim = player.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => !isAlly(player, ent, true) && ent.pickable)
    if (entitiesWithin.length == 0) return
    let stacks = entitiesWithin.length
    let dur = 200
    if (isInsane(player)) {
        dur = dur * 2
    }
    applyEffect(player, 'kubejs:diversion', dur, stacks-1, 'severed_continuum', player)
    let cd = 3600 - ((level-1)*300)
    addSkillCooldown(player, 'severed_continuum', cd)
    //hide_ability(player, 'severed_continuum')
    entitiesWithin.forEach(ent => {
        //Utils.server.runCommandSilent(`/setTickrate entity ${ent.uuid} 2`)
        applyEffect(ent, 'minecraft:slowness', dur, level-1, 'severed_continuum', player)
        Utils.server.runCommandSilent(`/effect give ${ent.uuid} kubejs:temporal_disruption infinite 0 false`)
        ent.tags.add(`severed_continuum:${player.username}`)
        Utils.server.scheduleInTicks(dur, () => {
            //Utils.server.runCommandSilent(`/setTickrate entity ${ent.uuid} 20`)
            Utils.server.runCommandSilent(`/effect clear ${ent.uuid} kubejs:temporal_disruption`)
            ent.tags.remove(`severed_continuum:${player.username}`)

            if (severed_continuumCounter[player.username] == undefined) return
            let charges = severed_continuumCounter[player.username]
            if (charges == undefined) return
            if (charges == 0) return
            let duration = 60*charges
            if (player.getSanity() == 0) {
                duration = duration * 2
            }
            applyStackingEffect(player, 'traveloptics:abyssal_strike', duration, charges)
            severed_continuumCounter[player.username] = undefined
        })
    })
}


let severed_continuumCounter = new WeakMap();

EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('severed_continuum')) return
    //let level = player.persistentData.severed_continuum
    if (!event.entity.tags.contains(`severed_continuum:${player.username}`)) return

    if (severed_continuumCounter[player.username] == undefined) {
        severed_continuumCounter[player.username] = 1
    } else {
        severed_continuumCounter[player.username]++
    }
})


/*
let severed_continuumCooldown = new WeakMap();
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('severed_continuum')) return
    if (!event.player.tags.contains('severed_continuum_cooldown')) return
    let level = event.player.persistentData.severed_continuum
    let cd = 3600 - ((level-1)*300)
    if (severed_continuumCooldown[event.player.username] == undefined) {
        severed_continuumCooldown[event.player.username] = cd
    } else {
        severed_continuumCooldown[event.player.username]--
    }

    if (severed_continuumCooldown[event.player.username] > 0) return
    event.player.tags.remove('severed_continuum_cooldown')
    severed_continuumCooldown[event.player.username] = cd
})
*/
