/**
 * 
 * 
let mercenary_levels = {
    1: {
        0: "magistuarmory:wood_stylet",
    },
    2: {
        0: "magistuarmory:stone_stylet",
        1: "minecraft:leather_helmet",
    },
    3: {
        0: "magistuarmory:iron_stylet",
        1: "minecraft:leather_helmet",
        2: "minecraft:leather_chestplate",
    },
    4: {
        0: "magistuarmory:iron_stylet",
        1: "minecraft:leather_helmet",
        2: "minecraft:chainmail_chestplate",
    },
    5: {
        0: "magistuarmory:iron_stylet",
        1: "minecraft:iron_helmet",
        2: "minecraft:chainmail_chestplate",
    },
    6: {
        0: "cataclysm:khopesh",
        1: "minecraft:iron_helmet",
        2: "minecraft:iron_chestplate",
    },
    7: {
        0: "cataclysm:khopesh",
        1: "samurai_dynasty:iron_ninja_helmet",
        2: "minecraft:iron_chestplate",
    },
    8: {
        0: "wrd:ancient_cutlass",
        1: "samurai_dynasty:iron_ninja_helmet",
        2: "immersive_armors:heavy_chestplate",
    },
    9: {
        0: "samurai_dynasty:katana",
        1: "immersive_armors:steampunk_helmet",
        2: "immersive_armors:heavy_chestplate",
    },
    10: {
        0: "magistuarmory:silver_lochaberaxe",
        1: "nethers_exorcism:hellish_crown_helmet",
        2: "magistuarmory:ceremonial_chestplate",
    }
}



EntityEvents.spawned('alexsmobs:kangaroo', event => {
    let entity = event.entity
    //check if the entity has the Owner tag
    if (!entity.tags.toString().includes('Owner')) return
    // Get the player username
    let username = entity.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    // Get the player
    let player = event.server.getPlayer(username)
    // Check if the player has the mercenary class
    if (!player.persistentData.get('kubejs_class:mercenary')) return
    // Get the players mercenary level
    let level = player.persistentData.mercenary_level
    if (level > 10) level = 10
    // Get the items for the level
    let items = mercenary_levels[level]
    // Merge the items with the entity
    entity.mergeNbt({
        Items: [{
            Slot: 0,
            id: items[0],
            Count: 1
        },
        {
            Slot: 1,
            id: items[1],
            Count: 1
        },
        {
            Slot: 2,
            id: items[2],
            Count: 1
        
        }]
    })
})

EntityEvents.death('alexsmobs:kangaroo', event => {
    if (!event.entity.tags.contains('tamed_beast')) return
    //Utils.server.tell('Kangaroo died')
    let username = event.entity.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    //Utils.server.tell(username)
    let player = event.server.getPlayer(username)
    //Utils.server.tell(player)
    if (!player.persistentData.get('kubejs_class:mercenary')) return
    //Utils.server.tell('mercenary')
    player.persistentData.kangaroo_counter -= 1
    //Utils.server.tell(player.persistentData.kangaroo_counter)
})


ItemEvents.rightClicked('kubejs:rune_of_the_mercenary', event => {
    let player = event.player
    let xp = player.persistentData.mercenary_xp
    player.paint({
        mercenary_xp: {
            type: 'rectangle',
            x: 90,
            y: 114, 
            w: 295, 
            h: 295, 
            draw: 'ingame',
            alignX: 'right', 
            alignY: 'bottom',
            texture: `kubejs:textures/leveling/subclass/mercenary/0.png`
        },
        mercenary_symbol: {
            type: 'rectangle',
            x: -50,
            y: -68, 
            w: 16, 
            h: 16, 
            draw: 'ingame',
            alignX: 'right', 
            alignY: 'bottom',
            texture: `kubejs:textures/leveling/subclass/mercenary/mercenary.png`
        },
        mercenary_xp_percent: {
            type: 'text',
            text: `0%`,
            scale: 0.60,
            shadow: true,
            color: '#00FF00',
            x: -62,
            y: -2,
            draw: 'ingame',
            alignX: 'right',
            alignY: 'bottom',
        }
    })

})
 * 
 * 
 */
/*
* Elemental Bolt:
* - §aLevel 1: When auto reload triggers, 10% next arrow will deal Elemental Damage. Elements: Fire
* - §aLevel 2: Elemental Bolt chance +5%. Elemental Bolt power increased.
* - §aLevel 3: Elemental Bolt chance +5%. Elements: Fire, venom
* - §aLevel 4: Elemental Bolt chance +5%. Elemental Bolt power increased .
* - §aLevel 5: Elemental Bolt chance +5%. Elements: Fire, venom, Frost
*/
function autoReload(player, crossbow, arrow_type) {
    if (crossbow.toString().includes('crossbow')) {
        crossbow.nbt.merge({
            Charged:1,
            ChargedProjectiles:[{
                Count: 1,
                id: arrow_type
            }]
        })
    }

}





/**
 * 
 * @param {*} player 
 * @param {*} source 
 * @returns Boolean
 * 
 * If the player is level 1 it only works with arrows. If the player is level 2 or higher it works with projectiles.
 * 
 * 
 */
function fasthandsCheck(player, source) {
    if (!player.persistentData.get('fasthands')) return
    let level = player.persistentData.fasthands
    let boolean = false
    if (level < 5) {
        boolean = arrowCheck(source)
    } else {
        boolean = physicalProjectileCheck(source)
    }
    return boolean
}

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('fasthands')) return
    if (!fasthandsCheck(event.source.player, event.source)) return
    let level = event.source.player.persistentData.fasthands
    if (Math.random() > 0.15*level) return
    if (event.source.player.mainHandItem.toString().includes('crossbow')) {
        event.source.player.cooldowns.removeCooldown(event.source.player.mainHandItem)
    } else if (event.source.player.offHandItem.toString().includes('crossbow')) {
        event.source.player.cooldowns.removeCooldown(event.source.player.offHandItem)
    }
})


function triggerElementalBolt(player, target, event) {
    let level = player.persistentData.elemental_bolt
    let check = levelBetterProjectileCheck(level, event, 'arrow', 3, 10)
    if (!check) return
    let elements = []
    let ticks = 20*level

    if (level >= 1) {
        elements.push('fire')
    }
    if (level >= 2) {
        elements.push('blood')
    }
    if (level >= 3) {
        elements.push('venom')
    }
    if (level >= 4) {
        elements.push('plague')
    }
    if (level >= 5) {
        elements.push('frost')
    }
    let element = elements[Math.floor(Math.random()*elements.length)]
    if (element == 'fire') {
        target.remainingFireTicks = ticks
        target.tags.add('elemental_damage')
        target.tags.add('elemental_fire')
    } else if (element == 'frost') {
        applyEffect(target, 'cofh_core:chilled', ticks, 1)
        target.tags.add('elemental_damage')
        target.tags.add('elemental_frost')
    } else if (element == 'venom') {
        applyEffect(target, 'runiclib:venom', ticks, 1)
        target.tags.add('elemental_damage')
        target.tags.add('elemental_venom') 
    } else if (element == 'plague') {
        applyEffect(target, 'fromtheshadows:plague', ticks, 1)
        target.tags.add('elemental_damage')
        target.tags.add('elemental_plague')
    } else if (element == 'blood') {
        applyEffect(target, 'minecells:bleeding', ticks, 1)
        target.tags.add('elemental_damage')
        target.tags.add('elemental_blood')
    }
    Utils.server.scheduleInTicks(ticks, () => {
        target.tags.remove('elemental_damage')
        target.tags.remove('elemental_fire')
        target.tags.remove('elemental_frost')
        target.tags.remove('elemental_venom')
        target.tags.remove('elemental_plague')
        target.tags.remove('elemental_blood')
    })
}

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let check = levelBetterProjectileCheck(event.source.player.persistentData.elemental_bolt, event, 'arrow', 3, 10)
    if (!check) return
    let player = event.source.player
    if (!player.persistentData.get('elemental_bolt')) return
    // 10% chance + 5% per level 
    let level = player.persistentData.elemental_bolt
    let chance = 0.10 + ((level-1)*0.05)
    if (Math.random() > chance) return
    triggerElementalBolt(event.source.player, event.entity, event)
})


/**
 * Shatterpoint:
 *  Level 1: Thrown daggers at enemies will stun them. 15 second cooldown
 *  Stun Duration: 2 seconds\nCooldown: 12.5 seconds 12.5 second cooldown
 *  Level 3: Daggers that are shot from a crossbow will also stun enemies. 10 second cooldown
 */


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('shatterpoint')) return
    let player = event.source.player
    if (isSkillCoolingDown(player, 'shatterpoint')) return
    let proj = physicalProjectileCheck(event.source)
    if (!proj) return
    let check = throwableCheck(event.source)
    let level = player.persistentData.shatterpoint
    if (level < 3) {
        if (event.source.weapon.toString().includes('crossbow')) return
        if (!check) return
        applyEffect(event.entity, 'minecells:stunned', 20*level, 1)
    } else {
        if (!event.source.weapon.toString().includes('crossbow') && !check) return
        applyEffect(event.entity, 'minecells:stunned', 20*level, 1)
    }
    let cooldown = 300 - ((level-1)*50)
    addSkillCooldown(player, 'shatterpoint', cooldown)
})

/*
//5 sec cooldown at level 3
let shatterpoint_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('shatterpoint')) return
    if (!event.player.tags.contains('shatterpoint_cooldown')) return
    let level = event.player.persistentData.shatterpoint
    let cd = 300 - ((level-1)*50)
    if (shatterpoint_cooldown[event.player.username] == undefined) {
        shatterpoint_cooldown[event.player.username] = cd
    } else {
        shatterpoint_cooldown[event.player.username] -= 1
    }
    if (shatterpoint_cooldown[event.player.username] > 0) return
    event.player.tags.remove('shatterpoint_cooldown')
    shatterpoint_cooldown[event.player.username] = cd
})
*/


/**
 * Contagious Lobotomy: Killing a stunned enemy has a chance to apply stunned to nearby enemies
 * - §aLevel 1: 15% chance to apply stunned to nearest enemy for 2 seconds
 * - §aLevel 2: 20% chance to apply stunned to 2 nearby enemies for 4 seconds 
 * - §aLevel 3: 25% chance to apply stunned to 3 nearby enemies for 6 seconds
 * - §aLevel 4: 25% chance to apply stunned to 4 nearby enemies for 8 seconds
 * - §aLevel 5: 25% chance to apply stunned to 5 nearby enemies for 10 seconds
 *  */ 


EntityEvents.death(event => {
    if (!event.source.player) return
    if (event.source.player.persistentData.get('contagious_lobotomy')) return
    if (event.entity.tags.contains('boss')) return
    let player = event.source.player
    let level = player.persistentData.contagious_lobotomy
    let check = levelBetterProjectileCheck(level, event, 'arrow', 3, 5)
    if (!check) return
    if (!event.entity.potionEffects.isActive('alexscaves:stunned')) return
    if (!event.entity.potionEffects.isActive('minecells:stunned')) return
    let chance = 15+(5*level)
    if (chance > 25) chance = 25
    if (Math.random() > chance/100) return
    let x = event.entity.x
    let y = event.entity.y
    let z = event.entity.z
    let box = AABB.of(x+10, y+10, z+10, x-10, y-10, z-10)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    let count = 0
    entitiesWithin.forEach(ent => {
        if (count == level) return
        if (ent.isMonster()) {
            applyEffect(ent, 'alexscaves:stunned', 40*level, 1)
            applyEffect(ent, 'minecells:stunned', 40*level, 1)
            count += 1
        }
    })
})





/**
 * Elemental Blight: Killing an enemy with an elemental effect will apply the effect to nearby enemies. These enemies cannot spread the effect to other enemies.
 * - §aLevel 1: 5% chance to apply the effect to all enemies within 5 blocks. 
 * - §aLevel 2: 10% chance to apply the effect to all enemies within 10 blocks. 
 * - §aLevel 3: 15% chance to apply the effect to all enemies within 15 blocks. 
 * - §aLevel 4: 20% chance to apply the effect to all enemies within 20 blocks. 
 * - §aLevel 5: 25% chance to apply the effect to all enemies within 25 blocks. 
 * - §aLevel 6: Killing enemies affected with Elemental Blight have a chance to spread it to others. 
 */


EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('elemental_blight')) return
    if (!event.entity.tags.contains('elemental_damage')) return
    let player = event.source.player
    let level = player.persistentData.elemental_blight
    let chance = 5*level
    if (Math.random() > chance/100) return
    let box = AABB.of(event.entity.x+(5*level), event.entity.y+(5*level), event.entity.z+(5*level), event.entity.x-(5*level), event.entity.y-(5*level), event.entity.z-(5*level))
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        let ally = isAlly(player, ent)
        if (!ally) {
            triggerElementalBlight(player, ent)
        }
    })
})


function triggerElementalBlight(player, entity) {
    // 10% chance + 5% per level 
    let level = player.persistentData.elemental_blight
    if (entity.tags.contains('elemental_fire')) {
        entity.remainingFireTicks = 40*level
        if (level > 5) {
            entity.tags.add('elemental_damage')
            entity.tags.add('elemental_fire')
        }
    } else if (entity.tags.contains('elemental_frost')) {
        applyEffect(entity, 'mowziesmobs:frozen', 40*level, 1)
        if (level > 5) {
            entity.tags.add('elemental_damage')
            entity.tags.add('elemental_frost')
        }
    } else if (entity.tags.contains('elemental_venom')) {
        applyEffect(entity, 'venom', 40*level, 1)
        if (level > 5) {
            entity.tags.add('elemental_damage')
            entity.tags.add('elemental_venom')
        }
    } else if (entity.tags.contains('elemental_lightning')) {
        event.level.spawnLightning(entity.x, entity.y, entity.z, false)
        if (level > 5) {
            entity.tags.add('elemental_damage')
            entity.tags.add('elemental_lightning')
        }
    }
    Utils.server.scheduleInTicks(40*level, () => {
        entity.tags.remove('elemental_damage')
        entity.tags.remove('elemental_fire')
        entity.tags.remove('elemental_frost')
        entity.tags.remove('elemental_venom')
        entity.tags.remove('elemental_lightning')
    })
}



// Sentinel: Strenth increases with level, cooldown decreases by half a second. 10 levels 

ItemEvents.firstLeftClicked(event => {
    if (isSkillCoolingDown(event.player, 'sentinel')) return
    let needed_str = 'crossbow'
    let totemNBT = skillTotemCheck(event.player, 'sentry')
    if (totemNBT) {
        needed_str = 'bow'
    }
    if (!event.player.mainHandItem.toString().includes(needed_str)) return
    if (!event.player.persistentData.get('sentinel')) return
    if (!event.player.shiftKeyDown) return
    let level = event.player.persistentData.sentinel
    let player = event.player
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run cast ${player.username} shield ${level*2}`)
    let cooldown = 300 - ((level-1)*20)
    addSkillCooldown(player, 'sentinel', cooldown)

})

/*
let sentinel_cooldown =new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('sentinel')) return
    if (!event.player.tags.contains('sentinel_cooldown')) return
    let level = event.player.persistentData.sentinel
    let cd = 300 - ((level-1)*20)

    if (sentinel_cooldown[event.player.username] == undefined) {
        sentinel_cooldown[event.player.username] = cd
    } else {
        sentinel_cooldown[event.player.username] -= 1
    }

    if (sentinel_cooldown[event.player.username] > 0) return
    event.player.tags.remove('sentinel_cooldown')
    sentinel_cooldown[event.player.username] = cd
})
*/







// Claustrophobic: §aLevel 2: Hitting enemies with a Crossbow knocks them back
// Deadshot: §aLevel 3: Melee hitting enemies with a Crossbow has a 15% chance to slow their time (+5% per level)
/**
 * EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    let player = event.source.player
    if (!player.persistentData.get('kubejs_class:mercenary')) return
    //if (player.persistentData.order_level < 2) return
    if (event.source.indirect) return
    if (!event.source.weapon.toString().includes('crossbow')) return
    let targetEntity = event.entity
    let chance = Math.random() * 100
    // Deadshot
    //if (chance < 5*player.persistentData.order_level) {
        //if (player.persistentData.order_level >= 3) {
            let uuid = targetEntity.uuid
            Utils.server.runCommandSilent(`/setTickrate ${uuid} 5`)
            event.entity.tags.add('mercenary_deadshot')
            Utils.server.scheduleInTicks(20*player.persistentData.ranger_level, () => {
                Utils.server.runCommandSilent(`/setTickrate ${uuid} 20`)
                event.entity.tags.remove('mercenary_deadshot')
            })
        //}
   // }
    // Claustrophobic
    event.entity.knockback(player.persistentData.mercenary_level+player.persistentData.order_level, (player.x - targetEntity.x), (player.z - targetEntity.z));
    event.entity.tags.add('mercenary_crossbow')
    Utils.server.scheduleInTicks(20, () => {
        event.entity.tags.remove('mercenary_crossbow')
    })
})
 * 
 */


/**
 * EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('mercenary')) return
    let chance = Math.random() * 100
    if (chance > 25) return
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run loot spawn ${event.entity.x} ${event.entity.y} ${event.entity.z} loot minecraft:loot_boxes/mercenary_arrows`)
    // 50% chance to run again
    let chance2 = Math.random() * 100
    if (chance2 > 50) return
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run loot spawn ${event.entity.x} ${event.entity.y} ${event.entity.z} loot minecraft:loot_boxes/mercenary_arrows`)
})
 * 
 */

function clearLethalShadows(player) {
    Utils.server.runCommandSilent(`/effect clear ${player.username} irons_spellbooks:true_invisibility`)
    Utils.server.runCommandSilent(`/effect clear ${player.username} cofh_core:true_invisibility`)
    player.tags.remove('lethal_shadows_active')
    lethal_shadows_mana[player.username] = 1
}



/**
 * Lethal shadows:
 * - §aLevel 1: Crouching with a loaded crossbow will make you almost completely invisible
 */
let crossbow_invis_counter = new WeakMap()
let lethal_shadows_mana = new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('lethal_shadows')) return
    if (isSkillCoolingDown(event.player, 'lethal_shadows')) return
    if (!event.player.crouching) {
        clearLethalShadows(event.player)
        return
    }
    let string = 'crossbow'
    let totemNBT = skillTotemCheck(event.player, 'ghost_draw')
    if (totemNBT) {
        string = 'bow'
    }
    if (!event.player.mainHandItem.id.includes(string) && !event.player.offHandItem.id.includes(string)) {
        clearLethalShadows(event.player)
        return
    }
    let weapon = null
    let needed_weapon = 'crossbow'
    if (totemNBT) {
        needed_weapon = 'bow'
    }
    let hand = null
    if (event.player.mainHandItem.id.includes(needed_weapon)) {
        weapon = event.player.mainHandItem
        hand = 'MAIN_HAND'
    } else {
        weapon = event.player.offHandItem
        hand = 'OFF_HAND'
    }
    let valid = false
    if (totemNBT) {
        if (weapon.id.includes('bow')) {
            if (event.player.usedItemHand == hand) {
                if (weapon.id.includes('crossbow')) {
                    if (weapon.nbt.get('Charged').toString() == '1b') {
                        valid = true
                    }
                } else if (weapon.id.includes('bow') && !weapon.id.includes('crossbow')) {
                    if (event.player.usingItem) {
                        valid = true
                    }
                }
            }
        }

    } else {
        if (weapon.id.includes('crossbow') && weapon.nbt.get('Charged').toString() == '1b') {
            valid = true
        }
    }
    if (!valid) {
        clearLethalShadows(event.player)
        return
    }

    if (lethal_shadows_mana[event.player.username] != 0) {
        let mana_cost = 50 - (event.player.persistentData.lethal_shadows-1)*10
        if (event.player.magicData.getMana() < mana_cost) return
        event.player.magicData.setMana(event.player.magicData.getMana() - mana_cost);
        lethal_shadows_mana[event.player.username] = 0
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:smoke ${event.player.x} ${event.player.y} ${event.player.z} 0.5 0.5 0.5 0.01 5000`)
        Utils.server.runCommandSilent(`execute in ${event.level.dimension} run playsound minecraft:entity.wither.shoot ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 0.2 0.25`)
        event.player.tags.add('lethal_shadows_active')
    }


    event.player.potionEffects.add('irons_spellbooks:true_invisibility', 10, 1, true, true)
    event.player.potionEffects.add('cofh_core:true_invisibility', 10, 1, true, true)
    if (crossbow_invis_counter[event.player.username] == undefined) {
        crossbow_invis_counter[event.player.username] = 30
    } else {
        crossbow_invis_counter[event.player.username]--
    }
    if (crossbow_invis_counter[event.player.username] > 0) return
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:smoke ${event.player.x} ${event.player.y+1} ${event.player.z} 0.5 0.5 0.5 0.01 10`)
    crossbow_invis_counter[event.player.username] = 30
})


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('lethal_shadows')) return
    if (!event.source.player.tags.contains('lethal_shadows_active')) return
    let level = event.source.player.persistentData.lethal_shadows
    let cooldown = 600 - ((level-1)*100)
    addSkillCooldown(event.source.player, 'lethal_shadows', cooldown)
    clearLethalShadows(event.source.player)

    
    
})



// 4 total levels. 30 second cooldown at level 1, 25 seconds at level 2, 20 seconds at level 3, and 15 seconds at level 4
/*
let lethal_shadows_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('lethal_shadows')) return
    if (!event.player.tags.contains('lethal_shadows_cooldown')) return
    let level = event.player.persistentData.lethal_shadows
    let cd = 600 - ((level-1)*100)

    if (lethal_shadows_cooldown[event.player.username] == undefined) {
        lethal_shadows_cooldown[event.player.username] = cd
    } else {
        lethal_shadows_cooldown[event.player.username] -= 1
    }

    if (lethal_shadows_cooldown[event.player.username] > 0) return
    event.player.tags.remove('lethal_shadows_cooldown')
    lethal_shadows_cooldown[event.player.username] = cd
})
*/





/**
 * ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
 */

/**
 * Flickering Blade:
 * - §aLevel 1: Crouching with a loaded crossbow will teleport you to the entity you hit with the crossbow. 10 second cooldown
 * - §aLevel 2: Crouching with a loaded crossbow will apply Rend to the entity you hit with the crossbow. 8 second cooldown
 * - §aLevel 3: Crouching with a loaded crossbow will apply Rend and Slowness to the entity you hit with the crossbow. 6 second cooldown
 * - §aLevel 4: Crouching with a loaded crossbow will apply Rend, Slowness and Elemental Bolt to the entity you hit with the crossbow. 4 second cooldown
 * - §aLevel 5: Crouching with a loaded crossbow will apply Rend, Slowness and Elemental Bolt to the entity you hit with the crossbow. 2 second cooldown
 * 
 */
EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.crouching) return
    let player = event.source.player
    if (isSkillCoolingDown(player, 'flickering_blade')) return
    if (!player.persistentData.get('flickering_blade')) return
    let level = player.persistentData.flickering_blade
    if (level < 5) {
        if (!event.source.weapon.toString().includes('crossbow')) return
    }
    let check = levelBetterProjectileCheck(event.source.player.persistentData.flickering_blade, event, 'arrow', 3, 5)
    if (!check) return

    Utils.server.runCommandSilent(`execute in ${event.level.dimension} run tp ${player.username} ${event.entity.x+0.5} ${event.entity.y} ${event.entity.z} facing ${event.entity.x} ${event.entity.y} ${event.entity.z}`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:smoke ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 0.01 5000`)
    Utils.server.runCommandSilent(`execute in ${event.level.dimension} run playsound minecraft:entity.wither.shoot ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 0.7`)

    if (player.persistentData.get('lethal_shadows')) {
        if (player.tags.contains('lethal_shadows_active')) {
            clearLethalShadows(player)
            let lethal_shadows_level = player.persistentData.lethal_shadows
            player.potionEffects.add('minecraft:speed', 20*lethal_shadows_level, lethal_shadows_level-1)
        }
    }
    applyEffect(event.entity, 'irons_spellbooks:rend', 40*level, level)
    let cooldown = 200 - ((level-1)*30)
    addSkillCooldown(player, 'flickering_blade', cooldown)
    if (level < 3) return
    applyEffect(event.entity, 'slowness', 20*level, level-3)
    if (level < 5) return
    triggerElementalBolt(player, event.entity, event)
v


})

/*
let flickering_blade_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('flickering_blade')) return
    if (!event.player.tags.contains('flickering_blade_cooldown')) return
    let level = event.player.persistentData.flickering_blade
    let cd = 200 - ((level-1)*30)

    if (flickering_blade_cooldown[event.player.username] == undefined) {
        flickering_blade_cooldown[event.player.username] = cd
    } else {
        flickering_blade_cooldown[event.player.username] -= 1
    }

    if (flickering_blade_cooldown[event.player.username] > 0) return
    event.player.tags.remove('flickering_blade_cooldown')
    flickering_blade_cooldown[event.player.username] = cd
})
*/



/**
 * EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('flickering_blade')) return
    if (event.source.player.persistentData.merc_ability != 'flickering_blade') return
    let proj = physicalProjectileCheck(event.source)
    if (!proj) return
    let player = event.source.player
    if (!event.source.indirect) return
    // Check if its an arrow
    let entity = event.entity
    let dir = {
        x: entity.getX() - player.getX(),
        z: entity.getZ() - player.getZ()
    };
    let dirLength = Math.sqrt(dir.x * dir.x + dir.z * dir.z);
    if (dirLength > 0) {
        entity.addMotion((dir.x / dirLength) * -3, 0.5, (dir.z / dirLength) * -3);
    }
})
 * 
 */





let kronos = {
    'irons_spellbooks:small_magic_arrow': {
        nbt: {
            Damage:5,
            ExplosionRadius:3,
            NoGravity:true,
        }
    }
}

function multiDropInstant (target, item, nbt, player, count) {
    if (!target.alive) return
    for (let i = 0; i < count; i++) {
        let entity = target.level.createEntity(item)
        // num between -1 and 1
        let randomX = Math.floor(Math.random() * 0.5*i) - i
        let randomZ = Math.floor(Math.random() * 0.5*i) - i
        entity.x = target.x+randomX
        entity.y = target.y+10
        entity.z = target.z+randomZ
        entity.mergeNbt(nbt)
        entity.mergeNbt({
            Owner: player.username,
            LeftOwner:true
        })
        
        entity.spawn()
        Utils.server.scheduleInTicks(25+3*i, () => {
            entity.addMotion(0, 1.5, 0)
        })
        Utils.server.scheduleInTicks(28+3*i, () => {
            entity.addMotion(entity.getX()-target.getX(), 0, entity.getZ()-target.getZ())
        })
    }
}

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let proj = physicalProjectileCheck(event.source)
    if (!proj) return
    let player = event.source.player
    if (!player.persistentData.get('fist_of_kronos')) return
    let level = player.persistentData.fist_of_kronos
    let target = event.entity
    let keys = Object.keys(kronos)
    let randomItem = keys[Math.floor(Math.random() * keys.length)]
    let nbt = kronos[randomItem].nbt
    let count = 10
    multiDropInstant(target, randomItem, nbt, player, count)
})




// Claustrophobic: Punching enemies with a crossbow will stun them 1 second. Cooldown: 5 seconds

EntityEvents.hurt(event => {
    if (event.entity.tags.contains('boss')) return
    if (!event.source.player) return
    if (!event.source.weapon.toString().includes('crossbow')) return
    if (event.source.indirect) return
    if (!event.source.player.persistentData.get('claustrophobic')) return
    let player = event.source.player
    if (isSkillCoolingDown(player, 'claustrophobic')) return
    let level = event.source.player.persistentData.claustrophobic
    applyEffect(event.entity, 'minecells:stunned', 20, 1)
    addSkillCooldown(player, 'claustrophobic', 100)

    if (level < 2) return
    applyEffect(event.entity, 'slowness', 60, 1)
    if (level < 3) return
    triggerElementalBolt(player, event.entity, event)
})


/*
let claustrophobic_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('claustrophobic')) return
    if (!event.player.tags.contains('claustrophobic_cooldown')) return
    let level = event.player.persistentData.claustrophobic
    let cd = 100

    if (claustrophobic_cooldown[event.player.username] == undefined) {
        claustrophobic_cooldown[event.player.username] = cd
    } else {
        claustrophobic_cooldown[event.player.username] -= 1
    }

    if (claustrophobic_cooldown[event.player.username] > 0) return
    event.player.tags.remove('claustrophobic_cooldown')
    claustrophobic_cooldown[event.player.username] = cd
})
*/

/**
 * Elemental Seekers: 10% chance to spawn ball lightning or comets when hitting an entity with an arrow. They will home in on the target that was hit.
 * - §aLevel 1: 2.5% chance to spawn and 3 comets/ball lightning
 * - §aLevel 2: 5% chance to spawn and 6 comets/ball lightning
 * - §aLevel 3: 7.5% chance to spawn and 9 comets/ball lightning
 * - §aLevel 4: 10% chance to spawn and 12 comets/ball lightning
 * - §aLevel 5: 12.5% chance to spawn and 15 comets/ball lightning
 * 
 * 
 */




function multiDropStaggered (target, item, nbt, player, count) {
    for (let i = 0; i < count; i++) {
        Utils.server.scheduleInTicks(8*i, () => {
            if (!target.alive) return
            let entity = target.level.createEntity(item)
            // random number between -30 and 30
            let randomX = Math.floor(Math.random() * 20) - 10
            let randomZ = Math.floor(Math.random() * 20) - 10
            entity.x = target.x+randomX
            entity.y = target.y+10
            entity.z = target.z+randomZ
            entity.mergeNbt(nbt)
            entity.mergeNbt({
                Owner: player.username,
                LeftOwner:true,
                Tags: ['elemental_seekers']
            })
            entity.tags.add(`Target:${target.uuid}`)
            entity.spawn()
            entity.glowing = true
        })
    }
}


EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('elemental_seekers')) return
    let level = player.persistentData.elemental_seekers
    let check = levelBetterProjectileCheck(level, event, 'arrow', 3, 5)
    if (!check) return
    let element = player.persistentData.current_seeker
    let target = event.entity
    let randomNumber = Math.random()
    let chance = 0.01*level
    if (event.entity.tags.contains('elemental_damage')) {
        chance += chance
    }
    if (randomNumber > chance) return
    let elemental_seekers = {
        'fire': { // High damage, high aoe, low count
            item: 'irons_spellbooks:fireball',
            nbt: {
                Damage: 4*level,
                ExplosionRadius:5*level,
                Owner: player.username,
            },
            count: 1*level,
            particle: `irons_spellbooks:embers ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 1 100`
        },
        'poison': { //Effect
            item: 'irons_spellbooks:acid_orb',
            nbt: {
                RendLevel:level,
                RendDuration:80*level,
                Owner: player.username,
            },
            count: 1,
            particle: `irons_spellbooks:acid_bubble ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 1 100`
        },
        'lightning': { //Persistent
            item: 'irons_spellbooks:ball_lightning',
            nbt: {
                Damage: level,
                ExplosionRadius:1,
                NoGravity:true,
                Owner: player.username,
            },
            count: 2*level,
            particle: `irons_spellbooks:electricity ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 1 100`
        },
        'ender': { // Medium aoe, Medium damage, medium count
            item: 'irons_spellbooks:comet',
            nbt: {
                Damage:3*level,
                ExplosionRadius:3,
                NoGravity:true,
                Owner: player.username,
            },
            count: 3*level,
            particle: `irons_spellbooks:unstable_ender ~ ~ ~ 0.5 0.5 0.5 1 100`
        },
        'ice': { // High damage, no aoe
            item: 'irons_spellbooks:icicle',
            nbt: {
                Damage:2*level,
                Owner: player.username,
            },
            count: 5*level,
            particle: `irons_spellbooks:snowflake ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 1 100`
        }
    }
    //choose a random item to drop from the frostpiercers wrath object
    let keys = Object.keys(elemental_seekers)
    // Get the item property based on the player's active element
    let randomItem = keys.find(key => key == element)
    randomItem = elemental_seekers[randomItem].item
    //Utils.server.tell(randomItem)   
    let nbt = elemental_seekers[element].nbt
    let count = elemental_seekers[element].count
    let particle = elemental_seekers[element].particle
    multiDropStaggered(target, randomItem, nbt, player, count)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle ${particle}`)

})


EntityEvents.spawned(event => {
    if (!event.entity.tags.contains('elemental_seekers')) return
    if (!event.entity.tags.toString().includes('Target:')) return
    let target = event.entity.tags.find(tag => tag.includes('Target:')).split(':')[1]
    let arrow = event.entity
    let entity = event.level.getEntity(target)
    if (!entity) return
    Utils.server.scheduleInTicks(80, () => {
        arrow.kill()    
    })
    Utils.server.scheduleInTicks(1, e => {
        if (!entity.alive) {
            e.repeating = false
            arrow.kill()
        }
        if (!arrow.alive) {
            e.repeating = false
        } else {
            e.repeating = true
            let x = entity.x
            let y = entity.y
            let z = entity.z
            let dirV = {
                x: (x - arrow.x) / 20,
                y: (y+1 - arrow.y) / 20,
                z: (z - arrow.z) / 20
            }
            if (arrow.distanceToEntity(entity) > 4) {
                arrow.setMotion(dirV.x*4, dirV.y*4, dirV.z*4)
            } else if (arrow.distanceToEntity(entity) > 8) {
                arrow.setMotion(dirV.x*5, dirV.y*5, dirV.z*5)
            } else {
                arrow.setMotion(dirV.x*8, dirV.y*8, dirV.z*8)
            }
            
            
        }
    })

})



let seekers = [
    'fire',
    'ice',
    'poison',
    'lightning',
    'ender',
]

let seeker_map = new WeakMap()



function elemental_seekers_ability(player) {
    // Ensure the player has the seekers persistent data
    if (!player.persistentData.get(`elemental_seekers`)) return;
    let elemental_seekers = {
        'fire': {
            particle: `irons_spellbooks:embers ${player.x} ${player.y} ${player.z} 0.2 0.2 0.2 0.4 100`,
            sound: `irons_spellbooks:cast.generic.fire`
        },
        'poison': {
            particle: `irons_spellbooks:acid_bubble ${player.x} ${player.y} ${player.z} 0.2 0.2 0.2 0.4 100`,
            sound: `irons_spellbooks:cast.generic.poison`
        },
        'lightning': {
            particle: `irons_spellbooks:electricity ${player.x} ${player.y} ${player.z} 0.2 0.2 0.2 0.4 100`,
            sound: `irons_spellbooks:cast.generic.lightning`
        },
        'ender': {
            particle: `irons_spellbooks:unstable_ender ${player.x} ${player.y+1} ${player.z} 0.2 0.2 0.2 0.4 200`,
            sound: `irons_spellbooks:cast.generic.ender`
        },
        'ice': {
            particle: `irons_spellbooks:snowflake ${player.x} ${player.y} ${player.z} 0.2 0.2 0.2 0.4 100`,
            sound: `irons_spellbooks:cast.generic.ice`
        }
    }
    // Initialize seeker_map entry if not set
    if (seeker_map[player.username] == undefined) {
        seeker_map[player.username] = 0;
    } else {
        seeker_map[player.username] += 1;
    }

    // Loop back to the first seeker if the index exceeds the number of seekers
    if (seeker_map[player.username] >= seekers.length) {
        seeker_map[player.username] = 0;
    }

    let currentIndex = seeker_map[player.username]

    // Assign the selected element to persistent data
    let current_seeker = seekers[currentIndex];
    player.persistentData.putString('current_seeker', current_seeker);
    // Display ability selection (assuming paint_ability is a UI update function)
    let particle = elemental_seekers[current_seeker].particle
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle ${particle}`)
    let sound = elemental_seekers[current_seeker].sound
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound ${sound} ambient ${player.username} ${player.x} ${player.y} ${player.z}`)
}



