
// Viper: Give enemies a stacking Venom effect if you hit them while in the air. You must be 2 blocks above the enemy to activate this effect. 5 levels, 2 seconds of venom per level. The duration is doubled if the enemy is slowed
// §aLevel 1: 2 seconds of venom
// §aLevel 2: 4 seconds of venom
// §aLevel 3: 6 seconds of venom
// §aLevel 4: 8 seconds of venom
// §aLevel 5: 10 seconds of venom


EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (player.blockStateOn.block != 'Block{minecraft:air}') return
    if (!player.persistentData.get('viper')) return
    let level = player.persistentData.viper
    if (parseInt(player.y) <= parseInt(event.entity.y)) return
    let duration = 40 * level
    if (event.entity.potionEffects.isActive('minecraft:slowness')) {
        duration = duration * 2
    }
    applyStackingEffect(event.entity, 'runiclib:venom', duration, 1)
})

// Python: Gain a strength effect after killing an enemy with an arrow. 5 levels, 1 level of strength per level, 2 seconds of strength per level
// §aLevel 1: 1 level of strength for 2 seconds
// §aLevel 2: 2 levels of strength for 4 seconds
// §aLevel 3: 3 levels of strength for 6 seconds
// §aLevel 4: 4 levels of strength for 8 seconds
// §aLevel 5: 5 levels of strength for 10 seconds


// Cobra: Gain a haste effect after killing an enemy with a melee attack. 5 levels, 1 level of haste per level, 2 seconds of haste per level
// §aLevel 1: 1 level of haste for 2 seconds
// §aLevel 2: 2 levels of haste for 4 seconds
// §aLevel 3: 3 levels of haste for 6 seconds
// §aLevel 4: 4 levels of haste for 8 seconds
// §aLevel 5: 5 levels of haste for 10 seconds

EntityEvents.death(event => {
    if (!event.entity.isMonster()) return
    if (!event.source.player) return
    let player = event.source.player
    //Utils.server.tell(player.mainHandItem)
    if (event.source.indirect) {
        let check = levelBetterProjectileCheck(player.persistentData.python, event, 'arrow', 3, 5)
        if (check) {
            if (player.persistentData.get('python')) {
                let level = player.persistentData.python
                let dur = 30 * level
                if (event.entity.potionEffects.isActive('minecraft:slowness')) {
                    dur = dur * 2
                }
                applyStackingEffect(player, 'minecraft:strength', dur, level-1, 'python', player, 4, 300)
            }
        }
    } else {
        if (player.persistentData.get('cobra')) {
            let level = player.persistentData.cobra
            let dur = 40 * level
            if (event.entity.potionEffects.isActive('minecraft:slowness')) {
                dur = dur * 2
            }
            applyStackingEffect(player, 'irons_spellbooks:hastened', dur, 1, 'cobra', player, 4, 300)
        }   
    }
})

// Mamba: Killing an enemy with venom has a 5% chance to cause enemies within 10 blocks to get venom. 5 levels, 5% per level, increases the range by 1 block per level. Chance is doubled if the enemy is slowed
// §aLevel 1: 5% chance to cause enemies within 10 blocks to get §aLevel 1 venom for 2 seconds
// §aLevel 2: 10% chance to cause enemies within 11 blocks to get §aLevel 2 venom for 4 seconds
// §aLevel 3: 15% chance to cause enemies within 12 blocks to get §aLevel 3 venom for 6 seconds
// §aLevel 4: 20% chance to cause enemies within 13 blocks to get §aLevel 4 venom for 8 seconds
// §aLevel 5: 25% chance to cause enemies within 14 blocks to get §aLevel 5 venom for 10 seconds
EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('mamba')) return
    let player = event.source.player
    let level = player.persistentData.mamba
    let chance = 0.05 * level
    if (event.entity.potionEffects.isActive('minecraft:slowness')) {
        chance = chance * 2
    }
    if (Math.random() > chance) return
    let range = 10 + ((level - 1) * 3)
    if (level >= 5) {range = 25}
    let box = AABB.of(player.x + range, player.y + 3, player.z + range, player.x - range, player.y - 3, player.z - range)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    let duration = 40 * level
    if (event.entity.potionEffects.isActive('minecraft:slowness')) {
        duration = duration * 2
    }
    entitiesWithin.forEach(ent => {
        if (ent.isMonster()) {
            applyEffect(ent, 'runiclib:venom', duration, level)
        }
    })
})

// Anaconda:  If you land a critical hit on an enemy, your next 3 attacks will apply a 10 second Venom effect to the target (hits and time scale with level). Hitting an enemy with active venom will stack it
// §aLevel 1: 1 hit that applies 10 seconds of venom
// §aLevel 2: 2 hits that apply 12 seconds of venom
// §aLevel 3: 3 hits that apply 14 seconds of venom
// §aLevel 4: 4 hits that apply 16 seconds of venom
// §aLevel 5: 5 hits that apply 20 seconds of venom


EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (isAlly(player, event.entity)) return
    // Capture whether the player had hits before this attack
    let hadHitsBefore = player.persistentData.get('anaconda_hits') && player.persistentData.anaconda_hits > 0

    // Gain charges on crit against a venomous target
    if (
        //event.entity.potionEffects.isActive('runiclib:venom') &&
        player.persistentData.get('anaconda') &&
        wasCrit(player)
    ) {
        let level = player.persistentData.anaconda
        let hitsToAdd = level
        if (player.persistentData.get('anaconda_hits')) {
            player.persistentData.anaconda_hits += hitsToAdd
        } else {
            player.persistentData.putInt('anaconda_hits', hitsToAdd)
        }
    }

    // Only apply venom if hits existed before this attack (Crit -> next hits apply venom)
    if (!hadHitsBefore) return
    if (!player.persistentData.get('anaconda')) return
    if (!player.persistentData.get('anaconda_hits')) return
    if (player.persistentData.anaconda_hits <= 0) return

    let level = player.persistentData.anaconda
    let duration = level >= 5 ? 400 : 200 + ((level - 1) * 40)

    applyStackingEffect(event.entity, 'runiclib:venom', duration, 1)

    player.persistentData.anaconda_hits = Math.max(0, player.persistentData.anaconda_hits - 1)
    //tell(`${player.persistentData.anaconda_hits} anaconda hits remaining`)
})


// Boa: Killing an enemy with Venom has a 5% chance to cause enemies within 10 blocks to get slowness. 5 levels, 5% chance per level. The effect can stack
// §aLevel 1: 5% chance to cause enemies within 10 blocks to get slowness for 2 seconds
// §aLevel 2: 10% chance to cause enemies within 15 blocks to get slowness for 4 seconds
// §aLevel 3: 15% chance to cause enemies within 20 blocks to get slowness for 6 seconds
// §aLevel 4: 20% chance to cause enemies within 25 blocks to get slowness for 8 seconds
// §aLevel 5: 25% chance to cause enemies within 30 blocks to get slowness for 10 seconds
EntityEvents.death(event => {
    let entity = event.entity
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('boa')) return
    if (!entity.potionEffects.isActive('runiclib:venom')) return
    let level = player.persistentData.boa
    let chance = 0.05 * level
    if (Math.random() > chance) return

    let radius = 5 + (5*level)
    let duration = 40 * level
    let box = AABB.of(
        entity.x + radius, entity.y + radius, entity.z + radius,
        entity.x - radius, entity.y - radius, entity.z - radius
    )
    let nearby = event.level.getEntitiesWithin(box)

    nearby.forEach(ent => {
        if (ent == entity || !ent.isMonster() || isAlly(player, ent)) return
        let chance = Math.random()
        if (chance > 0.05*level) return
        if (ent.potionEffects.isActive('minecraft:slowness')) {
            applyStackingEffect(ent, 'minecraft:slowness', duration, 1)
        } else {
            applyEffect(ent, 'minecraft:slowness', duration, 0)
        }
    })
})



// Hydra: Instantly cast fang ward after blocking an attack. Each enemy hit with fang ward will slow them and give you a venom charge. Cooldown is 30 seconds
// §aLevel 1: Venom Charge Duration: 2 seconds, Cooldown = 30 seconds. Slowness on enemy: 2 seconds
// §aLevel 2: Venom Charge Duration: 4 seconds, Cooldown = 25 seconds. Slowness on enemy: 4 seconds
// §aLevel 3: Venom Charge Duration: 6 seconds, Cooldown = 20 seconds. Slowness on enemy: 6 seconds
// §aLevel 4: Venom Charge Duration: 8 seconds, Cooldown = 15 seconds. Slowness on enemy: 8 seconds
// §aLevel 5: Venom Charge Duration: 10 seconds, Cooldown = 10 seconds. Slowness on enemy: 10 seconds

EntityEvents.hurt(event => {
    if (!event.entity.player) return
    let player = event.entity
    if (!player.persistentData.get('hydra')) return
    if (isSkillCoolingDown(player, 'hydra')) return
    if (player.persistentData.all_block != 1) return // only applies if damage was successfully blocked
    let level = player.persistentData.hydra
    player.tags.add('hydra_block')
    if (level <= 4) {
        Utils.server.scheduleInTicks(1, () => {
            speedyCast(player, 'fang_strike', level)
        })
    } else {
        if (player.distanceToEntity(event.source.actual) > 4) {
            Utils.server.scheduleInTicks(1, () => {
                speedyCast(player, 'fang_strike', 4)
            })
        } else {
            Utils.server.scheduleInTicks(1, () => {
                speedyCast(player, 'fang_ward', 4)
            })
        }


    }
    let cooldown = 600 - ((level - 1) * 100)
    addSkillCooldown(player, 'hydra', cooldown)
    Utils.server.scheduleInTicks(40, () => {
        player.tags.remove('hydra_block')
    })
    
})

/*
let hydraCooldown = new WeakMap()
PlayerEvents.tick(event => {
    let player = event.player;
    if (!player.persistentData.get('hydra')) return;
    // Check if the player is on cooldown for hydra
    if (!player.tags.contains('hydra_cooldown')) return;
    let level = player.persistentData.hydra;
    let cd = 600 - ((level - 1) * 100);
    if (hydraCooldown[player.username] == undefined) {
        hydraCooldown[player.username] = cd
    } else {
        hydraCooldown[player.username]--
    }

    if (hydraCooldown[player.username] > 0) return;
    player.tags.remove('hydra_cooldown')
    hydraCooldown[player.username] = cd
});
*/





EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.tags.contains('hydra_block')) return
    let check = isSpellDamageSource(event.source)
    if (!check) return
    if (!event.source.immediate.type.includes('evoker_fangs')) return
    if (!player.persistentData.get('hydra')) return
    let level = player.persistentData.hydra
    applyStackingEffect(player, 'kubejs:venom_charge', 40*level, 1)
    applyStackingEffect(event.entity, 'minecraft:slowness', 40*level, 1)
})




// Ouroboros: 'Upon killing a mob with Venom, apply 10s of Venom to a nearby enemy, gain +1 Venom Charge, and gain 10s of Haste. If no enemies are nearby, consume all active Venom Charges to gain 1s of Speed and 1% health per stack. Venom Charges last for 10 seconds and refresh on killing an enemy with Venom',
// §aLevel 1: 5% chance to gain a Venom Charge, Range: 10 Blocks. Speed upon consuming Venom Charges: 1 second per venom charge
// §aLevel 2: 10% chance to gain a Venom Charge, Range: 11 Blocks. Speed upon consuming Venom Charges: 2 seconds per venom charge
// §aLevel 3: 15% chance to gain a Venom Charge, Range: 12 Blocks. Speed upon consuming Venom Charges: 3 seconds per venom charge. You now gain a stacking haste effect
// §aLevel 4: 20% chance to gain a Venom Charge, Range: 13 Blocks. Speed upon consuming Venom Charges: 4 seconds per venom charge.
// §aLevel 5: 25% chance to gain a Venom Charge, Range: 14 Blocks. Speed upon consuming Venom Charges: 5 seconds per venom charge. Upon consuming Venom Charges, gain 1% of your max health per charge consumed. You now gain a stacking haste effect
EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('ouroboros')) return
    if (!event.entity.potionEffects.isActive('runiclib:venom')) return
    let chance = Math.random()
    let level = Number(player.persistentData.ouroboros)
    let odds = 0.05 * level
    if (player.potionEffects.isActive('kubejs:venom_charge')) {
        odds = 1
    }
    if (chance > odds) return
    ouroborosHandler(event.source.player, event.entity)
})


function ouroborosHandler(player, target) {
    // Try to find a nearby entity to pass the poison to
    let dim = player.level
    let level = Number(player.persistentData.ouroboros)
    let range = 5 + (5*level)
    let box = AABB.of(player.x+range, player.y+2, player.z+range, player.x-range, player.y-2, player.z-range)
    let oro_level = level
    let entities = dim.getEntitiesWithin(box).filter(entity =>
        entity.isMonster() &&
        entity != target &&
        entity.alive
    )

    if (entities.length > 0) {
        let newTarget = entities[Math.floor(Math.random() * entities.length)]
        applyStackingEffect(player, 'kubejs:venom_charge', 100, 1)

        // Transfer poison effect
        Utils.server.runCommandSilent(`/effect give ${newTarget.uuid} runiclib:venom 10 1 false`)
        global.applyGlow(newTarget, 'dark_green', 10)
        //Utils.server.runCommandSilent(`/effect give ${newTarget.uuid} minecraft:glowing 10 0 false`)
        
        if (level >= 3) {
            if (!player.potionEffects.isActive('minecraft:haste')) {
                Utils.server.runCommandSilent(`/effect give ${player.uuid} minecraft:haste 5 0 false`)
            } else {
                applyStackingEffect(player, 'minecraft:haste', 100, 1)
            }
        }


    } else {
        // No nearby targets: buff the player instead
        let charge_level = 1+player.potionEffects.getActive('kubejs:venom_charge').amplifier
        Utils.server.runCommandSilent(`/effect give ${player.uuid} minecraft:speed ${oro_level*charge_level} ${oro_level-1} true`)
        if (level >= 5) {
            let health_gain = 0.01 * charge_level // 1% of max health per charge level
            player.health += parseFloat(player.maxHealth * health_gain) 
        }

    }
}


// Basilisk: Enemies hit by your Combat Roll will be given venom for 2 seconds. 5 levels, 2 seconds of venom per level. The duration is doubled if the enemy is slowed
EntityEvents.hurt(event => {
    if (!event.source.player) return // Only apply for player sources
    if (!event.source.player.potionEffects.isActive('kubejs:dashing')) return // Ensure the player has the rolling effect active
    if (event.source.player.cooldowns.isOnCooldown('basilisk_ability')) return // Check if the player is on cooldown for the ability
    if (!event.source.player.persistentData.get('basilisk')) return // Check if the player has already applied the effect
    let dur = 2 * event.source.player.persistentData.basilisk
    if (event.entity.potionEffects.isActive('minecraft:slowness')) {
        dur = dur * 2
    }
    let cooldown = 200 - ((event.source.player.persistentData.basilisk - 1) * 20)
    event.source.player.cooldowns.addCooldown('basilisk_ability', cooldown)
    applyStackingEffect(event.entity, 'runiclib:venom', dur, 1)
})
