// Bannerlord (Rally)
// Rally and Slam mechanics that scale with level.
// Level 1: Small radius pull/levitate on banner tap; short slam prep and modest fall‑slam damage.
// Level 2: +3 radius to rally pulse; +2 ticks slam prep levitation; fall‑slam base damage +1.
// Level 3: Rally pulse gains Slowness on enemies; stronger levitation/push; fall‑slam KB and stun improved.
// Level 4: Rally pulse reaches further; slam prep gains longer Steel Feet; fall‑slam radius increases.
// Level 5: Maximum rally radius/force; highest slam prep duration/amplifiers; strongest base damage/KB/stun/radius on fall‑slam.
BlockEvents.rightClicked(event => {
    if (!event.player.persistentData.get('bannerlord')) return
    if (!event.block.id.toString().includes('banner')) return
    if (event.player.tags.contains('banner_cooldown')) return
    event.player.tags.add('banner_cooldown')
    event.player.swing()
    Utils.server.scheduleInTicks(40, () => {
        event.player.tags.remove('banner_cooldown')
    })
    //tell('x')
    let player = event.player
    let lvl = player.persistentData.bannerlord
    if (!player.shiftKeyDown) {
        if (lvl < 4) return
        // Level scaling: range and control strength scale with bannerlord level
        let radius = 5 + (3*(lvl-1))
        //Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound cataclysm:parry ambient ${event.player.username} ${event.block.x} ${event.block.y} ${event.block.z} 1 1.0`)
        //Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound irons_spellbooks:spell.eldritch_blast.cast ambient ${event.player.username} ${event.block.x} ${event.block.y} ${event.block.z} 1 0.2`)
        //Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run particle irons_spellbooks:dragon_fire ${event.block.x} ${event.block.y+1} ${event.block.z} 0.5 1.5 0.5 0.25 200`)
        let box = AABB.of(event.player.x+radius, event.player.y+1, event.player.z+radius, event.player.x-radius, event.player.y-1, event.player.z-radius)
        let entities = event.player.level.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && !ent.tags.contains('boss') && ent.isAlive && ent.pickable && ent.potionEffects.isActive('minecells:bleeding'))
        entities.forEach(ent => {
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run tp ${ent.uuid} ${event.block.x} ${event.block.y} ${event.block.z}`)
        })
    } else {
        if (!player.persistentData.get('warbringer')) return // requires ability flag
        // Slam prep benefits scale with level
        player.persistentData.putBoolean('slam_ready', true)
        player.potionEffects.add('minecraft:levitation', 5 + 2 * lvl, 45, true, true)
        player.potionEffects.add('kubejs:steel_feet', 60 + 20 * lvl, Math.min(1 + Math.floor(lvl / 2), 3), true, true)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound irons_spellbooks:spell.gust.cast ambient ${player.username} ${player.x} ${player.y+1} ${player.z} 0.5 1.5`)
        Utils.server.scheduleInTicks(10, () => {
            player.setAttributeBaseValue('forge:entity_gravity', 0.5)
            Utils.server.scheduleInTicks(40, () => {
                player.setAttributeBaseValue('forge:entity_gravity', 0.08)
            })
        })
    }

})






// Rend always present; Slowness unlocks early; Bleeding unlocks later
let bannerlord_effects = {
    1: ['irons_spellbooks:rend'],
    2: ['irons_spellbooks:rend', 'minecraft:slowness'],
    3: ['irons_spellbooks:rend', 'minecraft:slowness', 'minecells:bleeding'],
    4: ['irons_spellbooks:rend', 'minecraft:slowness', 'minecells:bleeding'],
    5: ['irons_spellbooks:rend', 'minecraft:slowness', 'minecells:bleeding', 'cofh_core:chilled']
}


// Bannerlord (Banner) – boons near banners you place (allies) and Warbringer effects (enemies)
// Level 1: Radius 6; allies Regeneration I; enemies: Rend.
// Level 2: Radius 8; allies Regeneration II; enemies: Rend, Slowness.
// Level 3: Radius 10; allies Regeneration III; enemies: Rend, Slowness.
// Level 4: Radius 12; allies Regeneration IV; enemies: Rend, Slowness, Bleeding.
// Level 5: Radius 14; allies Regeneration V; enemies: Rend, Slowness, Bleeding.

/**
 * 
 * BlockEvents.placed(event => {
    if (!event.block.id.toString().includes('banner')) return
    let player = event.player
    if (!player || !player.persistentData.get('bannerlord')) return
    bannerlord_ability(player)
})
 * 
 */



function banner_check(player) {
    let check = true
    if (isSkillCoolingDown(player, 'bannerlord')) {
        check = false; 
        player.tell('§8Bannerlord is on cooldown')
        return check
    }
    return check
}

function clamp(value, min, max) {
  return Math.max(min, Math.min(max, value));
}



/**
 * function bannerlord_ability (player) {
    let check = banner_check(player)
    if (!check) return
    //player.tags.add('bannerlord_cooldown')

    if (player.persistentData.banner_active) {
        let ban_x = player.persistentData.banner_x
        let ban_y = player.persistentData.banner_y
        let ban_z = player.persistentData.banner_z
        let ban_dim = player.persistentData.banner_dim
        let block_pos = [ban_x,ban_y,ban_z]
        let block = player.level.getBlock(block_pos)
        block.set('minecraft:air')
        //Utils.server.runCommandSilent(`/execute in ${ban_dim} run setblock ${ban_x} ${ban_y} ${ban_z} minecraft:air destroy`)
    } 
    // Track this banner’s position and pulse effects while it remains
    let block = player.level.getBlock(player.pos)
    let bx = block.x
    let by = block.y
    let bz = block.z
    let dim = player.level
    //let block_pos = {x: bx, y: by, z: bz}
    player.persistentData.putBoolean('banner_active', true)
    player.persistentData.put(`banner_x`, bx)
    player.persistentData.put(`banner_y`, by)
    player.persistentData.put(`banner_z`, bz)
    player.persistentData.putString('banner_dim', dim.dimension)
    // Scale banner aura radius with level (coerce to number with sane default)
    let level = Number(player.persistentData.bannerlord)
    if (!isFinite(level) || level <= 0) level = 1
    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run setblock ${bx} ${by} ${bz} minecraft:red_banner destroy`)
    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:shockwave 4.5 4.5 0.5 4.5 true 'a' ${bx} ${by+1} ${bz} 0.5 0.5 0.5 0.1 2`)
    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run playsound bettercombat:hammer_slam ambient ${player.username} ${bx} ${by} ${bz} 0.5 1.25`)
    let radius = 5 + (3*(level-1)) // 5, 8, 11, 14, 17, 20
    let cx = Number(bx) + 0.5
    let cy = Number(by) + 0.5
    //tell(cy)
    let cz = Number(bz) + 0.5
    let r = Number(radius)
    let points = 20 + (5*level)
    let angleStep = (3.14159265359 * 2) / points
    // Effects ____________________________________________________________________________________________________________________________________________________________________________________
    Utils.server.scheduleRepeatingInTicks(20, effect_task => {
        // stop if banner removed
        if (dim.getBlock(bx, by, bz).id != block.id) { effect_task.repeating = false; player.persistentData.putBoolean('banner_active', false); return }
        for (let i = 0; i < points; i++) {
            let angle = angleStep * i
            let px = Math.round((cx + Math.cos(angle) * r) * 100) / 100
            let pz = Math.round((cz + Math.sin(angle) * r) * 100) / 100
            Utils.server.scheduleInTicks(i, () => {
                Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:dragon_fire ${px} ${cy} ${pz} 0.${(level-1)*5} 0 0.${(level-1)*5} 0.0${level} ${1+((level) * 5)} force`)
            })
        }

        let box = AABB.of(bx + radius, by + radius, bz + radius, bx - radius, by - radius, bz - radius)
        let ents = dim.getEntitiesWithin(box)
        ents.forEach(ent => {
            if (ent.player) {
                if (isAlly(player, ent)) {
                    let regen_max = clamp(level-1, 0, 2)
                    applyEffect(ent, 'minecraft:regeneration', 60, regen_max, 'bannerlord', player)
                }
            } else if (ent.isMonster() && !ent.tags.contains('boss')) {
                // Apply negative Warbringer effects to enemies by level
                let neg = bannerlord_effects[level] || []
                // Amplifier scales per-effect based on its unlock level:
                // Rend@1, Slowness@2, Bleeding@3, Chilled@5 -> amp = max(0, level - unlock)
                let blUnlock = {
                    'irons_spellbooks:rend': 1,
                    'minecraft:slowness': 2,
                    'minecells:bleeding': 3,
                    'cofh_core:chilled': 5
                }
                neg.forEach(eff => {
                    let unlock = blUnlock[eff] ?? level
                    let amp = Math.max(0, level - unlock)
                    applyEffect(ent, eff, 60, amp, 'bannerlord', player)
                })
            }
        })
    })
    //____________________________________________________________________________________________________________________________________________________________________________________
    
    let pulse_ticks = 200 - ((level-1) * 20)
    let pos = {x:bx, z:bz}
    Utils.server.scheduleRepeatingInTicks(pulse_ticks, pulse_task => {
        if (dim.getBlock(bx, by, bz).id != block.id) { pulse_task.repeating = false; player.persistentData.putBoolean('banner_active', false); return }
        Utils.server.runCommandSilent(`/execute in ${dim.dimension} run playsound bosses_of_mass_destruction:gauntlet_laser_charge ambient ${player.username} ${bx} ${by} ${bz} 1 2`)
        Utils.server.scheduleInTicks(10, () => {
            Utils.server.runCommandSilent(`/execute in ${dim.dimension} run playsound cataclysm:parry ambient ${player.username} ${bx} ${by} ${bz} 1 0.75`)
            //Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound irons_spellbooks:spell.eldritch_blast.cast ambient ${event.player.username} ${event.block.x} ${event.block.y} ${event.block.z} 1 0.2`)
            Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:shockwave 1.0 0.25 0.25 ${radius/2} true 'a' ${bx} ${by+0.25} ${bz} 0 0 0 0.01 2`)
            Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle alexscaves:amber_monolith ${bx} ${by+1} ${bz} 0.5 0.5 0.5 1000000 250 force`)
            let box = AABB.of(bx+radius, by+1, bz+radius, bx-radius, by-1, bz-radius)
            let entities = player.level.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && !ent.tags.contains('boss') && ent.isAlive && ent.pickable)
            entities.forEach(ent => {
                    //tell(ent)
                    // loop pushes scale with level
                    applyEffect(ent, 'minecraft:levitation', 2 + level, 10, 'leg', player)
                    // Extra slow unlocks at Bannerlord 3+
                    if (level >= 3) {
                        applyEffect(ent, 'minecraft:slowness', 40, 0, 'bannerlord', player)
                    }
                    knockbackEntity(ent, pos, 'push', level)
            })
        
        })


    })
}
 * 
 */

let level_banners = {}

function bannerlord_ability (player) {
    let check = banner_check(player)
    if (!check) return

    if (level_banners[player.username]) {
        let current_banner = level_banners[player.username]
        let block = player.level.getBlock(current_banner.x, current_banner.y, current_banner.z)
        block.set('minecraft:air')
        delete level_banners[player.username]
        //Utils.server.tell(`/execute in ${player.level.dimension} run setblock ${block_pos} minecraft:red_banner destroy`)
    }
    level_banners[player.username] = { x: player.x.toFixed(0), y: player.y.toFixed(0), z: player.z.toFixed(0), id: generateUUID() }
    let new_banner = level_banners[player.username]
    let block = player.level.getBlock(new_banner.x, new_banner.y, new_banner.z)
    block.set('minecraft:red_banner')
    let bx = Number(level_banners[player.username].x)
    let by = Number(level_banners[player.username].y)
    let bz = Number(level_banners[player.username].z)
    let dim = player.level
    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:shockwave 4.5 4.5 0.5 4.5 true 'a' ${bx} ${by+1} ${bz} 0.5 0.5 0.5 0.1 2`)
    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run playsound bettercombat:hammer_slam ambient ${player.username} ${bx} ${by} ${bz} 0.5 1.25`)
    let level = player.persistentData.bannerlord
    let cooldown = 1200 - (250 * (level - 1))
    addSkillCooldown(player, 'bannerlord', cooldown)
    let radius = Number(5 + (3*(level-1))) // 5, 8, 11, 14, 17, 20
    let cx = Number(bx) + 0.5
    let cy = Number(by) + 0.5
    //tell(cy)
    let cz = Number(bz) + 0.5
    let r = Number(radius)
    let points = 15 + (3*level)
    let angleStep = (3.14159265359 * 2) / points
    let banner_id = level_banners[player.username].id
    player.persistentData.putString('banner_id', level_banners[player.username].id)
    Utils.server.scheduleInTicks(5, e => {
        let valid = true
        let bannerData = level_banners[player.username]
        if (!bannerData || bannerData.id != banner_id) {
            valid = false
            e.repeating = false
            return
        }
        let block = player.level.getBlock(bannerData.x, bannerData.y, bannerData.z)
        if (!block.id.includes('red_banner')) {
            valid = false
            e.repeating = false
            return
        }
        if (!valid) {
            e.repeating = false
            return
        } else {
            e.repeating = true
            for (let i = 0; i < points; i++) {
                let angle = angleStep * i
                let px = Math.round((cx + Math.cos(angle) * r) * 100) / 100
                let pz = Math.round((cz + Math.sin(angle) * r) * 100) / 100
                Utils.server.scheduleInTicks(i, () => {
                    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:dragon_fire ${px} ${cy} ${pz} 0.${(level-1)*5} 0 0.${(level-1)*5} 0.0${level} ${1+((level) * 2)} force`)
                })
            }
            
            let box = AABB.of(bx - radius, by - radius, bz - radius, bx + radius, by + radius, bz + radius)
            let ents = dim.getEntitiesWithin(box)
            ents.forEach(ent => {
                if (isAlly(player, ent, true)) {
                        let regen_max = clamp(level-1, 0, 2)
                        applyEffect(ent, 'minecraft:regeneration', 60, regen_max, 'bannerlord', player)
                } else if (ent.isMonster() && !ent.tags.contains('boss')) {
                    // Apply negative Warbringer effects to enemies by level
                    let neg = bannerlord_effects[level] || []
                    // Amplifier scales per-effect based on its unlock level:
                    // Rend@1, Slowness@2, Bleeding@3, Chilled@5 -> amp = max(0, level - unlock)
                    let blUnlock = {
                        'irons_spellbooks:rend': 1,
                        'minecraft:slowness': 2,
                        'minecells:bleeding': 3,
                        'cofh_core:chilled': 5
                    }
                    neg.forEach(eff => {
                        let unlock = blUnlock[eff] ?? level
                        let amp = Math.max(0, level - unlock)
                        applyEffect(ent, eff, 60, amp, 'bannerlord', player)
                    })
                }
            })
        }
    })
    //__________________________________________________________________________________
    banner_pulse(player, radius, {x: bx, y: by, z: bz})
    let pulse_ticks = 200 - ((level-1) * 20)
    let pos = {x:bx, z:bz}
    Utils.server.scheduleInTicks(pulse_ticks, pulse_task => {
        let valid = true
        let bannerData = level_banners[player.username]
        if (!bannerData || bannerData.id != banner_id) {
            valid = false
            pulse_task.repeating = false
            return
        }
        let block = player.level.getBlock(bannerData.x, bannerData.y, bannerData.z)
        if (!block.id.includes('red_banner')) {
            valid = false
            pulse_task.repeating = false
            return
        }
        if (!valid) {
            pulse_task.repeating = false
        } else {
            pulse_task.repeating = true
            banner_pulse(player, radius, {x: bx, y: by, z: bz})
        }
    })
}


function banner_pulse (player, radius, bannerPos) {
    let bx = bannerPos.x
    let by = bannerPos.y
    let bz = bannerPos.z
    let dim = player.level
    let pos = {x:bx, z:bz}
    let level = player.persistentData.bannerlord
    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run playsound bosses_of_mass_destruction:gauntlet_laser_charge ambient ${player.username} ${bx} ${by} ${bz} 1 2`)
    Utils.server.scheduleInTicks(10, () => {
        Utils.server.runCommandSilent(`/execute in ${dim.dimension} run playsound cataclysm:parry ambient ${player.username} ${bx} ${by} ${bz} 1 0.75`)
        //Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound irons_spellbooks:spell.eldritch_blast.cast ambient ${event.player.username} ${event.block.x} ${event.block.y} ${event.block.z} 1 0.2`)
        Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:shockwave 1.0 0.25 0.25 ${radius/2} true 'a' ${bx} ${by+0.25} ${bz} 0 0 0 0.01 2`)
        Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle alexscaves:amber_monolith ${bx} ${by+1} ${bz} 0.5 0.5 0.5 1000000 250 force`)
        let box = AABB.of(bx+radius, by+1, bz+radius, bx-radius, by-1, bz-radius)
        let entities = player.level.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && !ent.tags.contains('boss') && ent.isAlive && ent.pickable)
        entities.forEach(ent => {
            //tell(ent)
            // loop pushes scale with level
            applyEffect(ent, 'minecraft:levitation', 2 + level, 10, 'leg', player)
            // Extra slow unlocks at Bannerlord 3+
            if (level >= 3) {
                applyEffect(ent, 'minecraft:slowness', 40, 0, 'bannerlord', player)
            }
            knockbackEntity(ent, pos, 'push', level)
        })
    })
}


BlockEvents.broken('minecraft:red_banner', event => {
    let players = event.server.players
    players.forEach(player => {
        if (level_banners[player.username]) {
            if (event.block.x == level_banners[player.username].x && event.block.y == level_banners[player.username].y && event.block.z == level_banners[player.username].z) {
                //tell('true')
                delete level_banners[player.username]
                let item = event.block.id
                Utils.server.scheduleInTicks(1, () => {
                    Utils.server.runCommandSilent(`/kill @e[type=item,nbt={Item:{id:"${item}"}}]`)
                })
            }
        }
    })
    //tell(`Block.x: ${event.block.x}, Block.y: ${event.block.y}, Block.z: ${event.block.z}`)
})





/*
let bannerlord_cooldown = new WeakMap();
PlayerEvents.tick(event => {
    let player = event.player;
    if (!player.persistentData.get('bannerlord')) return;
    if (!player.tags.contains('bannerlord_cooldown')) return;
    let level = player.persistentData.bannerlord;
    let cd = 1200 - (250 * (level - 1)); // 1200 ticks - 250 ticks per level. At level 5 this will be 500 ticks
    if (bannerlord_cooldown[player.username] == undefined) {
        bannerlord_cooldown[player.username] = cd
    } else {
        bannerlord_cooldown[player.username]--;
    }

    if (bannerlord_cooldown[player.username] > 0) return;
    player.tags.remove('bannerlord_cooldown');
    bannerlord_cooldown[player.username] = cd
})
*/

// Removed commander effect
/**
 * EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.source.player.potionEffects.isActive('kubejs:commander_effect')) return
    if (!event.entity.isMonster()) return
    applyEffect(event.entity, 'cofh_core:true_invisibility', 20, 0, 'commander')
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} as ${event.source.player.username} run summon guardvillagers:guard ${event.entity.x} ${event.entity.y} ${event.entity.z}`)
    event.level.spawnLightning(event.entity.x, event.entity.y, event.entity.z, true)
})
 * 
 */
function knockbackEntity(targetEntity, sourcePos, direction, strength) {
    //tell(targetEntity, sourcePos)
    if (!targetEntity || !sourcePos) return
    if (!direction) direction = 'push'
    if (!strength) strength = 3


    let tx = targetEntity.getX ? targetEntity.getX() : targetEntity.x
    let tz = targetEntity.getZ ? targetEntity.getZ() : targetEntity.z
    let sx = Number(sourcePos.x)
    let sz = Number(sourcePos.z)

    if (!isFinite(sx) || !isFinite(sz)) return
    
    // Direction from source -> target (push away from source)
    let dx = tx - sx
    let dz = tz - sz
    let len = Math.sqrt(dx * dx + dz * dz)
    if (len < 0.0001) return
    dx /= len
    dz /= len
    
    // Zero/counter vertical motion similar to Titan handling
    if (typeof targetEntity.setMotion === 'function') {
        targetEntity.setMotion(targetEntity.getMotionX(), 0, targetEntity.getMotionZ())
    } else if (typeof targetEntity.addMotion === 'function') {
        targetEntity.addMotion(0, -(targetEntity.getMotionY ? targetEntity.getMotionY() : 0), 0)
    }

    // Resolve direction + power; backward compat: if direction is number, treat as strength
    let mode = 'push'
    let powerInput
    if (typeof direction === 'string') {
        let d = direction.toLowerCase()
        mode = (d === 'pull') ? 'pull' : 'push'
        powerInput = strength
    } else {
        // Back-compat: third arg was strength
        powerInput = direction
    }
    let power = Number(powerInput)
    if (!isFinite(power)) power = 1.15
    let sign = (mode === 'pull') ? -1 : 1
    if (power < 0) { sign *= -1; power = Math.abs(power) }

    let vx = dx * power * sign
    let vy = 0.02
    let vz = dz * power * sign

    if (typeof targetEntity.setMotion === 'function') {
        targetEntity.setMotion(vx, vy, vz)
    } else if (typeof targetEntity.addMotion === 'function') {
        targetEntity.addMotion(vx, vy, vz)
    }
    // Nudge one tick later to ensure persistence (mirrors Titan scheduling)
    //Utils.server.scheduleInTicks(1, () => {
        if (!targetEntity || (typeof targetEntity.isAlive === 'function' && !targetEntity.isAlive())) return
        if (typeof targetEntity.setMotion === 'function') {
            targetEntity.setMotion(vx, vy, vz)
        } else if (typeof targetEntity.addMotion === 'function') {
            targetEntity.addMotion(vx, vy, vz)
        }
    //})
}




//__________________________________________________________________________________



// Titan: Switch between pull and push when the player attacks an enemy based on whether the player crits
EntityEvents.hurt(event => {
    if (!event.source.player) return
    
    if (event.entity.tags.contains('boss')) return
    if (!event.source.player.persistentData.get('titan')) return
    let method = determineMethod(event.source)
    if (method != 'melee') return
    let player = event.source.player
    if (player.persistentData.titan_active != true) return
    let entity = event.entity
    let level = player.persistentData.titan
    // compute horizontal direction from entity -> player
    let dx = player.getX() - entity.getX()
    let dz = player.getZ() - entity.getZ()
    let dirLength = Math.sqrt(dx * dx + dz * dz)

    if (dirLength < 0.0001) return

    if (typeof entity.setMotion === 'function') {
        entity.setMotion(entity.getMotionX(), 0, entity.getMotionZ())
    } else {
        entity.addMotion(0, -entity.getMotionY(), 0)
    }

    // Set strengths here
    let pullStrength = 0.40    // Change this for pull
    let pushStrength = -2.25    // Change this for push

    let num = wasCrit(player) ? pushStrength : pullStrength
    if (wasCrit(player)) {
        handleBoundroidSlamSound(player, entity)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:shockwave 4.5 4.5 0.5 4.5 true 'a' ${entity.x} ${entity.y+1} ${entity.z} 0.5 0.5 0.5 0.2 1`)
        applyEffect(entity, 'minecells:bleeding', level * 40, level, 'Titan')
    } else {
        applyEffect(entity, 'minecraft:slow_falling', 3, 1, 'leg', player)
    }
    

    Utils.server.scheduleInTicks(1, () => {
        let vx = (dx / dirLength) * num
        let vy = 0.05
        let vz = (dz / dirLength) * num
        //tell(num)
        if (typeof entity.setMotion === 'function') {
            entity.setMotion(vx, vy, vz)
        } else {
            entity.addMotion(vx, vy, vz)
        }


        Utils.server.scheduleInTicks(1, () => {
            if (typeof entity.setMotion === 'function') {
                entity.setMotion(vx, vy, vz)
            } else {
                entity.addMotion(vx, vy, vz)
            }
        })
    })
})

function titan_ability(player) {
    if (!player.persistentData.titan_active) {
        player.persistentData.putBoolean('titan_active', true)
        player.tell(`Titan: §aActivated§r`)
    } else {
        player.persistentData.titan_active = false
        player.tell(`Titan: §cDectivated§r`)
    }
}



function handleBoundroidSlamSound(player, sourceEntity) {
    if (player.tags.contains('boundroid_slam_cooldown')) return
    player.tags.add('boundroid_slam_cooldown')
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexscaves:boundroid_slam ambient ${player.username} ${sourceEntity.x} ${sourceEntity.y} ${sourceEntity.z} 1 0.50`)
    Utils.server.scheduleInTicks(20, () => {
        player.tags.remove('boundroid_slam_cooldown')
    })
}



// Colossus: Gain resilience and Regeneration based on number of nearby enemies. (6 levels)

PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 != 0) return
    if (!event.player.persistentData.get('colossus')) return
    let player = event.player
    let level = player.persistentData.colossus
    // Scale range and cap amplifiers by level
    let range = 3 + 2 * level
    let box = AABB.of(player.x+range, player.y+2, player.z+range, player.x-range, player.y-2, player.z-range)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && !ent.tags.contains('boss') && ent.isAlive && ent.pickable && ent.isMonster())
    let resist_threshold = 10 - (level-1)
    if (entitiesWithin.length < resist_threshold) return
    let resist_amp = entitiesWithin.length / resist_threshold
    player.potionEffects.add('quark:resilience', 41, Math.floor(resist_amp), true, true)
    let regen_threshold = 15-(level-1)
    if (entitiesWithin.length < regen_threshold) return
    let regen_amp = entitiesWithin.length / regen_threshold
    player.potionEffects.add('minecraft:regeneration', 41, Math.floor(regen_amp), true, true)
})

// Colossus reactive bonuses on taking melee hits (L3+/L5+)
EntityEvents.hurt('player', event => {
  let p = event.entity
  if (!p || !p.isAlive()) return
  if (!p.persistentData.get('colossus')) return
  let level = p.persistentData.colossus
  if (level < 2) return
  // throttle
  if (p.tags.contains('colossus_react_cd')) return
  // Check melee hits only
  let method = determineMethod(event.source)
  if (method != 'melee') return

  // Apply small reactive buffs
  p.tags.add('colossus_react_cd')
  Utils.server.scheduleInTicks(20, () => { p && p.tags && p.tags.remove('colossus_react_cd') })

  // L2+: retaliation. Scales
  p.potionEffects.add('runiclib:retaliation', 40 + (20*(level-2)), level-2, true, true)
  // L4+: Adrenaline. Scales
  if (level >= 4) {
    p.potionEffects.add('runiclib:adrenaline', 40 + (20 * (level-4)), level-4, true, true)
  }
})



function martyr_ability(player) {
    if (!player.persistentData.martyr_active) {
        player.persistentData.putBoolean('martyr_active', true)
        player.tell(`Martyr: §aActivated§r`)
    } else {
        player.persistentData.martyr_active = false
        player.tell(`Martyr: §cDectivated§r`)
    }
}


// Martyr: Grabs and pulls an entity to the player's crosshair and makes it follow the crosshair and float. Nearby enemies will target the grabbed entity (L2+).
// Level 1: Pull lasts ~6s
// Level 2: Taunt radius 16; pull lasts ~8s, enemies in radius set their target to the grabbed entity.
// Level 3: Taunt radius 18; pull lasts ~10s; 
// Level 4: Taunt radius 20; pull lasts ~12s;
// Level 5: Taunt radius 22; pull lasts ~14s;

ItemEvents.entityInteracted(event => {
    if (event.target.tags.contains('boss')) return
    let player = event.player
    if (!player.persistentData.martyr_active) return
    let target = event.target
    if (isAlly(player, target)) return 
    if (target.type == 'minecraft:villager') return
    if (!player.persistentData.get('martyr')) return
    let martyrLevel = player.persistentData.martyr
    let uuid = target.uuid.toString()
    if (player.tags.contains(`martyr:${uuid}`)) return
    player.tags.add(`martyr:${uuid}`)
    Utils.server.scheduleInTicks(5, () => {
        player.tags.remove(`martyr:${uuid}`)
    })
    if (target.tags.contains('martyr_target')) {
        target.tags.remove('martyr_target')
        target.tags.remove(`martyr:${player.username}`)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:wisp ${target.x} ${target.y+1} ${target.z} 0.5 0.5 0.5 0.1 50`)
        return
    } else {
        player.swing()
        // Calculate direction vector from player's view
        let x_rad = player.pitch * JavaMath.PI / 180
        let y_rad = player.yaw * JavaMath.PI / 180
        let dirV = {
            x: -Math.sin(y_rad) * Math.cos(x_rad),
            y: -Math.sin(x_rad),
            z: Math.cos(y_rad) * Math.cos(x_rad)
        }
        let crosshair_location = {
            x: player.x + dirV.x * 2.2,
            y: player.y + 1.6 + dirV.y * 2.2,
            z: player.z + dirV.z * 2.2
        }

        target.teleportTo(crosshair_location.x, crosshair_location.y, crosshair_location.z)
        target.playSound('irons_spellbooks:cast.void_tentacles.start', 10, 2)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:wisp ${target.x} ${target.y+1} ${target.z} 0.5 0.5 0.5 0.1 50`)
        target.tags.add('martyr_target')
        target.tags.add(`martyr:${player.username}`)
        let tauntRadius = 5 * martyrLevel
        let box = AABB.of(player.x+tauntRadius, player.y+5, player.z+tauntRadius, player.x-tauntRadius, player.y-5, player.z-tauntRadius)
        let entities = player.level.getEntitiesWithin(box).filter(e => e.isMonster()) 
        if (martyrLevel >= 2) {
            entities.forEach(e => {
                e.setTarget(target)
            })
        }
        // Start repeating pull effect for a short duration (e.g., 10 ticks)
        let ticks = 0
        let maxTicks = 100 * martyrLevel
        Utils.server.scheduleRepeatingInTicks(1, e => {
            if (!target.tags.contains('martyr_target') || !target.isAlive()) {
                e.repeating = false
                target.tags.remove('martyr_target')
                return
            }
            // Recalculate crosshair location each tick
            let x_rad = player.pitch * JavaMath.PI / 180
            let y_rad = player.yaw * JavaMath.PI / 180
            let dirV = {
                x: -Math.sin(y_rad) * Math.cos(x_rad),
                y: -Math.sin(x_rad),
                z: Math.cos(y_rad) * Math.cos(x_rad)
            }
            let crosshair_location = {
                x: player.x + dirV.x * 3,
                y: player.y + 1 + dirV.y * 2.2,
                z: player.z + dirV.z * 3
            }
            // Pull speed no longer scales with level
            let mod = 1.4
            target.setMotion(
                (crosshair_location.x - target.x) * mod,
                (crosshair_location.y - target.y) * mod,
                (crosshair_location.z - target.z) * mod
            )
            //target.setYBodyRot(player.yaw)
            //target.lookAt("eyes",new Vec3d(crosshair_location.x, crosshair_location.y, crosshair_location.z))
            applyEffect(target, 'minecells:stunned', 41, 0)
            applyEffect(target, 'alexscaves:stunned', 41, 0)
            if (martyrLevel >= 5) {
                applyEffect(target, 'irons_spellbooks:rend', 41, 0)
            }
            //target.setYHeadRot(player.yaw)

            ticks++
            if (ticks >= maxTicks) {
                e.repeating = false
                target.tags.remove('martyr_target')
                target.tags.remove(`martyr:${player.username}`)
            }
        })
    }
})


EntityEvents.hurt(event => {
    if (!event.entity.tags.contains('martyr_target')) return
    let ownerName = event.entity.tags.find(tag => tag.startsWith('martyr:')).split(':')[1]
    let owner = event.server.getPlayer(ownerName)
    if (!owner) return
    let lvl = owner.persistentData.martyr
    // Level gating: L1 owner-only; L3 owner or allies; L5 any hit
    let allow = false
    let srcPlayer = event.source?.player
    if (lvl >= 5) {
        allow = true
    } else if (lvl >= 3) {
        allow = srcPlayer ? (srcPlayer.username == ownerName || isAlly(owner, srcPlayer)) : false
    } else {
        allow = srcPlayer ? (srcPlayer.username == ownerName) : false
    }
    if (!allow) return
    // Lesser Strength scales with level (amplifier and/or duration)
    let amp = Math.max(0, lvl - 1)
    let dur = 80 + 20 * lvl
    applyStackingEffect(owner, 'runiclib:lesser_strength', dur, amp, 'martyr', owner, 4, 200)
})



// Overlord (active) – custom command to toggle for a short duration
// Level 1: Duration 5s; cooldown 25s; range 7; pull 0.12; release pulse light.
// Level 2: Duration 7.5s; cooldown 22s; range 8; pull 0.14; release pulse slightly stronger.
// Level 3: Duration 10s; cooldown 19s; range 9; pull 0.16; release pulse also applies Weakness; stronger overall.
// Level 4: Duration 12.5s; cooldown 16s; range 10; pull 0.18; release pulse strong, mild slow amp.
// Level 5: Duration 15s; cooldown 13s; range 11; pull 0.20; release pulse strongest, higher push/slow amp.
// Usage: /overlord


function overlord_ability (player) {
    if (!player.persistentData.get('overlord')) return // requires the ability
    Utils.server.runCommandSilent(`/execute as ${player.username} run kubejs custom_command overlord_command`)
}

ServerEvents.customCommand('overlord_command', e => {
    let player = e.player
    if (!player) return
    // Gate behind Overlord unlock
    if (!player.persistentData.get('overlord')) return // requires the ability
    if (player.tags.contains('overlord_active')) return
    if (isSkillCoolingDown(player, 'overlord')) {
        player.tell(`Overlord: Cooling down...`)
        return
    }
    player.tell(`Overlord: §aActivated`)
    player.tags.add('overlord_active')
    let gpLevel = player.persistentData.overlord || 0
    // Duration scales up, cooldown scales down with level; range increases with level
    let duration = 100 + (50 * (gpLevel-1))
    let cooldown = Math.max((25 - 3 * gpLevel), 8) * 20
    addSkillCooldown(player, 'overlord', cooldown)
    let range = 5 + gpLevel
    let tick = 0

    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexscaves:limestone_spear_miss ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.2`)

    Utils.server.scheduleRepeatingInTicks(1, task => {
        if (!player || !player.isAlive()) { task.repeating = false; return }
        // end condition
        if (tick++ >= duration || !player.tags.contains('overlord_active')) {
            task.repeating = false
            player.tags.remove('overlord_active')
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexscaves:boundroid_slam ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 ${push ? 1.2 : 0.8}`)
            return
        }

        // Ongoing pull + slow while active
        let box = AABB.of(player.x + range, player.y + 2, player.z + range, player.x - range, player.y - 2, player.z - range)
        let mobs = player.level.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && ent.isMonster())
        mobs.forEach(ent => {
            let dx = player.x - ent.x
            let dz = player.z - ent.z
            let len = Math.sqrt(dx * dx + dz * dz) || 1
            let pull = 0.10 + 0.02 * gpLevel
            let vx = (dx / len) * pull
            let vz = (dz / len) * pull
            if (typeof ent.setMotion === 'function') {
                ent.setMotion(vx, ent.getMotionY() * 0.5, vz)
            } else {
                ent.addMotion(vx, 0, vz)
            }
            applyEffect(ent, 'minecells:bleeding', 20, 0, 'overlord', player)
        })
    })

    /*
    // Cooldown removal
    Utils.server.scheduleInTicks(cooldown, () => {
        player && player.tags.remove('overlord_cooldown')
    })
    */
})



EntityEvents.hurt(event => {
    if (event.entity.tags.contains('boss')) return
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('overlord')) return
    if (!event.source.player.tags.contains('overlord_active')) return
    if (isAlly(event.source.player, event.entity)) return
    let level = event.source.player.persistentData.overlord
    if (level < 2) return
    applyEffect(event.entity, 'minecraft:slowness', 40*(level-1), level-1, 'overlord', event.source.player) 
})


EntityEvents.hurt('player', event => {
    if (!event.source || !event.source.actual) return
    if (event.source.actual.tags.contains('boss')) return
    if (!event.entity.persistentData.get('overlord')) return
    if (!event.entity.tags.contains('overlord_active')) return
    let level = event.entity.persistentData.overlord
    if (level < 3) return
    applyEffect(event.source.actual, 'minecraft:weakness', 40*(level-2), level-3, 'overlord', event.entity)
})

EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('overlord')) return
    if (!event.source.player.tags.contains('overlord_active')) return
    if (!event.entity.potionEffects.isActive('minecraft:weakness')) return
    let level = event.source.player.persistentData.overlord
    if (level < 5) return
    applyStackingEffect(event.source.player, 'kubejs:lesser_haste', 60, 1, 'overlord level 5', event.source.player)

})








// Warlord – All enemies within a 25 block radius target you.
// Level 1: Resistance I effect
// Level 2: Larger radius. Gain the Burning Thorns effect.
// Level 3: Larger radius: Gain the Clarity effect
// Level 4: Larger Radius, applies weakness to the enemies in radius
// Level 5: Allies also gain the positive effects from Warlord
PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 != 0) return
    let p = event.player
    if (!p || !p.isAlive()) return
    if (!p.persistentData.get('warlord')) return
    if (p.persistentData.getInt('warlord_active') != 1) return
    let level = p.persistentData.warlord
    // Increase aura radius with level
    let radius = 20 + 5 * level
    let box = AABB.of(p.x + radius, p.y + 3, p.z + radius, p.x - radius, p.y - 3, p.z - radius)
    let mobs = p.level.getEntitiesWithin(box).filter(ent => !ent.tags.contains('boss') && !isAlly(p, ent) && ent.isMonster())
    let target = 'self'
    if (level >= 5) {
        target = 'allies'
    }

    if (target = 'allies') {
        let allies = p.level.getEntitiesWithin(box).filter(ent => isAlly(p, ent))
        allies.forEach(ally => {
            applyEffect(ally, 'minecraft:resistance', 40, 0)
            applyEffect(ally, 'runiclib:burning_thorns', 40, level-2)
            applyEffect(ally, 'cofh_core:clarity', 40, 0)
        })
    }
    // Always grant Resistance I
    p.potionEffects.add('minecraft:resistance', 40, 0, true, true)
    // Burning Thorns effect at level 2+
    if (level >= 2) {
        p.potionEffects.add('runiclib:burning_thorns', 40, level-3, true, true)
    }
    // Clarity at level 3+
    if (level >= 3) {
        p.potionEffects.add('cofh_core:clarity', 40, 0, true, true)
    }
    mobs.forEach(ent => {
        ent.setTarget(p)
        // Apply Weakness
        if (level >= 4) {
            applyEffect(ent, 'minecraft:weakness', 40, 0, 'warlord', p)
        }
    })
})


function warlord_ability (player) {
    let p = player
    if (!p.persistentData.get('warlord')) return
    let active = p.persistentData.getInt('warlord_active')
    p.persistentData.putInt('warlord_active', active == 1 ? 0 : 1)
    if (p.persistentData.getInt('warlord_active') == 1) {
        p.tell('Warlord: §aActivated§r')
    } else {
        p.tell('Warlord: §cDeactivated§r')
    }
}







// Warden – Enemies hit for the first time by your melee attacks are briefly stunned and weakened
// Level 1: Stun ~0.5–0.75s; no Weakness; per‑enemy ICD ~4s.
// Level 2: Stun ~1.0s; Weakness I for ~6s; per‑enemy ICD ~3s.
// Level 3: Stun ~1.25s; Weakness II for ~7s; per‑enemy ICD ~2s.
// Level 4: Stun ~1.5s; Weakness II for ~8s; per‑enemy ICD ~1.5s.
// Level 5: Stun ~1.75s; Weakness III for ~9s; per‑enemy ICD ~1s.
EntityEvents.hurt(event => {
    if (!event.source.player) return
    let p = event.source.player
    if (!p.persistentData.get('warden')) return
    let ccLevel = p.persistentData.warden
    let method = determineMethod(event.source)
    if (method != 'melee') return
    let ent = event.entity
    let key = `cc_icd:${p.username}`
    if (ent.tags.contains(key)) return
    // Apply brief stagger and weaken; add per-enemy ICD that decays with level
    let stunTicks = Number(10 + Number((5 * (ccLevel-1))))
    applyEffect(ent, 'alexscaves:stunned', stunTicks, 0, 'warden', p)
    if (ccLevel >= 2) {
        let weakAmp = Math.max(0, Math.floor((ccLevel - 1) / 2))
        let weakDur = 60 + (20 * ccLevel-1)
        applyEffect(ent, 'minecraft:weakness', weakDur, weakAmp, 'warden', p)
    }
    ent.tags.add(key)
    let cd = (100 - (10 * ccLevel))
    Utils.server.scheduleInTicks(Number(cd + stunTicks), () => { ent && ent.tags && ent.tags.remove(key) })
})

EntityEvents.death(event => {
    // Clean up ICD tags on death if they are a player
    if (!event.entity.player) return
    if (!event.entity.tags.filter(t => t.startsWith('cc_icd:'))) return
    let tagsToRemove = event.entity.tags.filter(t => t.startsWith('cc_icd:'))
    tagsToRemove.forEach(t => event.entity.tags.remove(t))
})

// Bulwark – DR + regen under threshold with a small movespeed penalty
// Level 1: Triggers at ≤35% HP; Resistance II for ~1.25s; 3s internal cooldown.
// Level 2: Triggers at ≤38% HP; Resistance II + Regeneration II for ~1.25s; 2.5s internal cooldown.
// Level 3: Triggers at ≤41% HP; Resistance III + Regeneration II for ~1.25s; 2s internal cooldown.
// Level 4: Triggers at ≤44% HP; Resistance III + Regeneration III for ~1.25s; 1.5s internal cooldown.
// Level 5: Triggers at ≤47% HP; Resistance III + Regeneration III for ~1.25s; 1s internal cooldown.
PlayerEvents.tick(event => {
    if (event.server.tickCount % 40 != 0) return
    let p = event.player
    if (!p || !p.isAlive()) return
    if (!p.persistentData.get('bulwark')) return
    let lvl = p.persistentData.bulwark
    let hpFrac = p.health / p.maxHealth
    // Threshold scales up slightly with level; effects get stronger with level
    let threshold = Math.max(0.15 + ((lvl-1) * 0.025), 0.25)
    if (hpFrac <= threshold) {
        // Duration starts at 3s and increases by 0.5s per level
        
        // Amplifiers scale with level-1
        let amp = lvl-1
        applyEffect(p, 'gtbcs_geomancy_plus:aegis', 80, amp, 'bulwark')
        //if (lvl >= 2) {
            //applyEffect(p, 'minecraft:regeneration', dur, amp, 'bulwark')
        //}
        //applyEffect(p, 'minecraft:slowness', dur, 0, 'bulwark')
    }
    // Cooldown is 10x longer, still shortens with level
    //p.tags.add('bulwark_cooldown')
    //let cdTicks = Math.max(600 - 100 * lvl, 200)
    //Utils.server.scheduleInTicks(cdTicks, () => { p && p.tags && p.tags.remove('bulwark_cooldown') })
})


/*
// Siegebreak (Jugger Momentum) – build stacks while moving; consume on melee to add knockback + tiny cleave
// (Commented out for now; replaced by Battering Ram)
PlayerEvents.tick(event => {
    if (event.server.tickCount % 5 != 0) return
    let p = event.player
    if (!p || !p.isAlive()) return
    if (!p.persistentData.get('siegebreak')) return
    let lvl = p.persistentData.siegebreak
    let pd = p.persistentData
    let px = p.x
    let pz = p.z
    if (!pd.contains('sb_prevX')) { pd.putDouble('sb_prevX', px) }
    if (!pd.contains('sb_prevZ')) { pd.putDouble('sb_prevZ', pz) }
    let dx = px - pd.sb_prevX
    let dz = pz - pd.sb_prevZ
    let dist = Math.sqrt(dx*dx + dz*dz)
    pd.putDouble('sb_prevX', px)
    pd.putDouble('sb_prevZ', pz)

    let stacks = pd.contains('siegebreak_stacks') ? pd.siegebreak_stacks : 0
    if (dist > 0.06) {
        let maxStacks = 10 + 2 * lvl
        stacks = Math.min(stacks + 1, maxStacks)
    } else {
        stacks = Math.max(stacks - 2, 0)
    }
    pd.putInt('siegebreak_stacks', stacks)
})
*/



/*
EntityEvents.hurt(event => {
    if (!event.source.player) return
    let p = event.source.player
    if (!p.persistentData.get('siegebreak')) return
    let level = p.persistentData.siegebreak
    let method = determineMethod(event.source)
    if (method != 'melee') return
    let stacks = p.persistentData.get('siegebreak_stacks') ? p.persistentData.siegebreak_stacks : 0
    if (stacks <= 0) return
    // Apply bonus knockback proportional to stacks and a tiny cleave tap
    let ent = event.entity
    let dx = ent.x - p.x
    let dz = ent.z - p.z
    let len = Math.sqrt(dx*dx + dz*dz) || 1
    let strength = 0.4 + stacks * 0.12 + 0.05 * level
    let vx = (dx/len) * strength
    let vz = (dz/len) * strength
    if (typeof ent.setMotion === 'function') {
        ent.setMotion(vx, 0.05, vz)
    } else {
        ent.addMotion(vx, 0.05, vz)
    }
})
*/


// Warbringer – after enough airtime, slam on landing with scaling damage/KB/radius
// Scales with Warbringer level. Stun unlocks at L3.
// Level 1: Modest base damage; small radius/KB; no stun.
// Level 2: +1 base damage; slightly larger radius and KB; no stun.
// Level 3: Higher base/scaling damage; bigger radius/KB; stun unlocks.
// Level 4: Strong slam—wide radius, big KB; longer stun.
// Level 5: Devastating slam—widest radius, strongest KB; longest stun.

PlayerEvents.tick(event => {
    let p = event.player
    if (!p || !p.isAlive()) return
    if (!p.persistentData.get('warbringer')) return // requires ability flag
    if (p.persistentData.warbringer_active != 1) return
    let pd = p.persistentData
    // track air time and last Y velocity
    let onGround = typeof p.onGround === 'function' ? p.onGround() : p.onGround
    if (p.blockStateOn.block.id.toString().includes('air')) {
        onGround = false
    }
    if (!pd.contains('air_ticks')) pd.putInt('air_ticks', 0)
    if (!pd.contains('last_y_vel')) pd.putDouble('last_y_vel', 0.0)
    if (!pd.contains('slam_ready')) pd.putBoolean('slam_ready', false)
    let level = pd.contains('warbringer') ? pd.warbringer : 0

    let vy = (typeof p.getMotionY === 'function') ? p.getMotionY() : 0.0
    pd.putDouble('last_y_vel', vy)

    if (!onGround) {
        pd.putInt('air_ticks', pd.air_ticks + 1)
        if (pd.air_ticks > 12) pd.putBoolean('slam_ready', true)
    } else {
        // landing
        if (pd.slam_ready) {
            pd.putBoolean('slam_ready', false)
            pd.putInt('air_ticks', 0)
            let fallSpeed = Math.abs(pd.last_y_vel)
            // Scale outputs by fall speed; tune soft caps
            // Scale with Warbringer level
            let baseDmg = 4 + level
            let dmg = baseDmg + fallSpeed * (5 + level * 0.5)
            let kb = 1.0 + 0.15 * level + fallSpeed * (1.0 + 0.1 * level)
            let stun = 20 + 4 * level + fallSpeed * (12 + 1 * level)
            let radius = Math.min(6 + level + Math.floor(fallSpeed * 2), 16)

            let box = AABB.of(p.x + radius, p.y + 1.5, p.z + radius, p.x - radius, p.y - 1.5, p.z - radius)
            let mobs = p.level.getEntitiesWithin(box).filter(ent => !isAlly(p, ent) && ent.pickable)
            mobs.forEach(ent => {
                // Damage
                Utils.server.runCommandSilent(`/damage ${ent.uuid} ${dmg} minecraft:player by ${p.username}`)
                // Knockback away from impact point
                let dx = ent.x - p.x
                let dz = ent.z - p.z
                let len = Math.sqrt(dx*dx + dz*dz) || 1
                let vx = (dx/len) * kb
                let vz = (dz/len) * kb
                if (typeof ent.setMotion === 'function') {
                    ent.setMotion(vx, 0.2, vz)
                } else {
                    ent.addMotion(vx, 0.2, vz)
                }
                // Stun unlocks at Warbringer 3+
                if (level >= 3) {
                    applyEffect(ent, 'minecells:stunned', stun, 0, 'warbringer', p)
                }
                if (level >= 5) {
                    applyEffect(p, 'gtbcs_geomancy_plus:tremor_step_effect', 80, 5)
                }
            })
            Utils.server.runCommandSilent(`/execute in ${p.level.dimension} run playsound cataclysm:parry ambient ${p.username} ${p.x} ${p.y+1} ${p.z} 0.5 1.5`)
            Utils.server.runCommandSilent(`/execute in ${p.level.dimension} run particle irons_spellbooks:shockwave 4.5 4.5 4.5 4.5 true 'a' ${p.x} ${p.y} ${p.z} 0.5 0.5 0.5 0.2 6`)
        } else {
            // reset air ticks when landing without slam
            pd.putInt('air_ticks', 0)
        }
    }
})



function warbringer_ability (player) {
    let p = player
    if (!p.persistentData.get('warbringer')) return
    let active = p.persistentData.getInt('warbringer_active')
    p.persistentData.putInt('warbringer_active', active == 1 ? 0 : 1)
    if (p.persistentData.getInt('warbringer_active') == 1) {
        p.tell('Warbringer: §aActivated§r')
    } else {
        p.tell('Warbringer: §cDeactivated§r')
    }
}



// Juggernaut – build sprint stacks that grant speed; collide to knock back and stun
// Summary: While sprinting you build stacks over time; each stack grants speed. 
// Colliding with an enemy while sprinting consumes 1 stack to knock them back and apply control effects.
// Core rules:
//  - Build 1 stack every 2 seconds while sprinting.
//  - Lose all stacks if you stop sprinting for 0.5s (10 ticks).
//  - Each stack adds ~10% movespeed (via kubejs:lesser_speed).
//  - On collision while sprinting and with stacks > 0: consume 1 stack, knock back, and stun.
// Levels:
//  - Level 1: Max stacks 1; stun 1.0s on hit; speed scales with stacks.
//  - Level 2: Max stacks 2; stun 2.0s on hit; higher top speed from more stacks.
//  - Level 3: Max stacks 3; stun 3.0s on hit; also applies Weakness (amp = level−3).
//  - Level 4: Max stacks 4; stun 4.0s on hit; stronger top speed and knockback from additional stacks.
//  - Level 5: Max stacks 5; stun 5.0s on hit; also applies Rend in addition to Weakness.
PlayerEvents.tick(event => {
  if (event.server.tickCount % 2 != 0) return
  let p = event.player
  if (!p || !p.isAlive()) return
  if (!p.persistentData.get('juggernaut')) return
  if (p.persistentData.juggernaut_active != 1) return
  let level = p.persistentData.juggernaut
  let pd = p.persistentData

  // Detect sprinting state
  let sprinting = (typeof p.isSprinting === 'function') ? p.isSprinting() : (p.sprinting ?? false)
  // If not toggled on, clear stacks/effect and return (persistent flag style)
  if (p.persistentData.getInt('juggernaut_active') != 1) {
    if (pd.contains('bram_stacks') && pd.bram_stacks > 0) pd.putInt('bram_stacks', 0)
    if (p.potionEffects.isActive('kubejs:lesser_speed')) p.potionEffects.remove('kubejs:lesser_speed')
    return
  }

  // Initialize counters
  if (!pd.contains('bram_stacks')) pd.putInt('bram_stacks', 0)
  if (!pd.contains('bram_since')) pd.putInt('bram_since', 0)
  if (!pd.contains('bram_stop_ticks')) pd.putInt('bram_stop_ticks', 0)

  if (sprinting) {
    // Build timer
    pd.putInt('bram_stop_ticks', 0)
    pd.putInt('bram_since', pd.bram_since + 1)
    if (pd.bram_since >= 40 - ((level-1)*5)) { // every 2 seconds
      let stacks = pd.bram_stacks + 1
      let maxStacks = level
      pd.putInt('bram_stacks', Math.min(stacks, maxStacks))
      pd.putInt('bram_since', 0)
      if (stacks <= maxStacks) {
        let pitch = 1 + (0.20 * stacks)
        Utils.server.runCommandSilent(`/execute in ${p.level.dimension} run playsound irons_spellbooks:spell.gust.charge ambient ${p.username} ${p.x.toFixed(2)} ${p.y.toFixed(2)} ${p.z.toFixed(2)} 0.25 ${pitch}`)
      }
      
    }
  } else {
    // Stopping sprint: count up and reset after 0.5s
    pd.putInt('bram_stop_ticks', pd.bram_stop_ticks + 1)
    if (pd.bram_stop_ticks >= 10) {
      pd.putInt('bram_stacks', 0)
      pd.putInt('bram_since', 0)
      pd.putInt('bram_stop_ticks', 0)
    }
  }

  // Apply movement buff based on stacks while sprinting
  let stacksNow = pd.bram_stacks
  if (sprinting && stacksNow > 0) {
    // 10% per stack using 5%/level effect => amplifier ~ 2*stacks - 1
    let amp = Math.max(0, 2 * stacksNow - 1)
    p.potionEffects.add('kubejs:lesser_speed', 25, amp, true, true)
  }

  // Touch detection while sprinting and has stacks
  if (sprinting && stacksNow > 0 && !p.tags.contains('bram_touch_cd')) {
    let radius = 1.15
    let box = AABB.of(p.x + radius, p.y + 1, p.z + radius, p.x - radius, p.y - 1, p.z - radius)
    let mobs = p.level.getEntitiesWithin(box).filter(e => !isAlly(p, e))
    if (mobs.length > 0) {
      let ent = mobs[0]
      if (ent.tags.contains('boss')) return
      
      // Compute lateral (side) direction relative to player facing
      let dx = ent.x - p.x
      let dz = ent.z - p.z
      let y_rad = p.yaw * JavaMath.PI / 180
      // Forward and Right vectors from player yaw
      let fx = -Math.sin(y_rad), fz = Math.cos(y_rad)
      let rx =  Math.cos(y_rad), rz = Math.sin(y_rad)
      // Determine which side the target is on using dot with Right
      let sideDot = dx * rx + dz * rz
      let sideSign = sideDot >= 0 ? 1 : -1
      // Knockback scales with TOTAL current stacks (before consuming 1)
      // Slightly milder lateral push with a lighter forward bias
      let strength = 0.75 + 0.50 * stacksNow
      let vx = (rx * sideSign * 0.40 + fx * 0.60) * strength
      let vz = (rz * sideSign * 0.40 + fz * 0.60) * strength
      if (typeof ent.setMotion === 'function') {
        ent.setMotion(vx, 0.25, vz)
      } else {
        ent.addMotion(vx, 0.25, vz)
      }
      // Apply short stun
      if (ent.player && ent.potionEffects.isActive('alexscaves:stunned')) return
      applyEffect(ent, 'alexscaves:stunned', 20*level, 0, 'juggernaut', p)
      applyEffect(ent, 'minecells:stunned', 20*level, 0, 'juggernaut', p)

      if (level >= 3) {
        applyEffect(ent, 'minecraft:weakness', 20*level, level-3, 'juggernaut', p)
      }

      if (level >= 5) {
        applyEffect(ent, 'irons_spellbooks:rend', 20*level, level-4, 'juggernaut', p)
      }
      


      Utils.server.runCommandSilent(`/execute in ${p.level.dimension} run playsound alexscaves:resistor_shield_slam ambient ${p.username} ${ent.x.toFixed(2)} ${ent.y.toFixed(2)} ${ent.z.toFixed(2)} 1 0.5`)
      // Bright yellow spark (R,G,B = 5,5,0)
      Utils.server.runCommandSilent(`/execute in ${p.level.dimension} run particle irons_spellbooks:spark 5 5 0 ${ent.x} ${ent.y+ent.eyeHeight} ${ent.z} 0.1 0.1 0.1 0.1 15`)
        p.tags.add('bram_touch_cd')
      Utils.server.scheduleInTicks(7, () => { p && p.tags && p.tags.remove('bram_touch_cd') })
      let chance = 1
      if (level >= 5) {
        chance = 0.25
      }
      let odds = Math.random()
      //tell(`Chance: ${chance} Odds: ${odds}`)
      if (odds > chance) return
      // Consume one stack and immediately refresh Lesser Speed based on remaining stacks
      pd.putInt('bram_stacks', Math.max(stacksNow - 1, 0))
      let newStacks = pd.bram_stacks
      if (newStacks > 0) {
        let newAmp = Math.max(0, 2 * newStacks - 2)
        Utils.server.runCommandSilent(`/effect clear ${p.username} kubejs:lesser_speed`)
        p.potionEffects.add('kubejs:lesser_speed', 25, newAmp, true, true)
      } else {
        if (p.potionEffects.isActive('kubejs:lesser_speed')) {
        Utils.server.runCommandSilent(`/effect clear ${p.username} kubejs:lesser_speed`)
        }
      }

    }
  }
})


function juggernaut_ability (player) {
    let p = player
    if (!p.persistentData.get('juggernaut')) return
    let active = p.persistentData.getInt('juggernaut_active')
    p.persistentData.putInt('juggernaut_active', active == 1 ? 0 : 1)
    if (p.persistentData.getInt('juggernaut_active') == 1) {
        p.tell('Juggernaut: §aActivated§r')
    } else {
        p.tell('Juggernaut: §cDeactivated§r')
    }
}

