



// Sanctified: Heal self and allies for 3% of max health when killing an enemy with a spell within 15 blocks. Scales with level
// §aLevel 1: 3% of max health, 15 block radius
// §aLevel 2: 6% of max health, 14 block radius
// §aLevel 3: 9% of max health, 13 block radius
// §aLevel 4: 12% of max health, 12 block radius
// §aLevel 5: 15% of max health, 11 block radius
EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.entity.isMonster()) return
    let player = event.source.player
    let method = determineMethod(event.source)
    if (method != 'magic') return
    if (isSkillCoolingDown(player, 'sanctified')) return
    if (!player.persistentData.get(`sanctified`)) return
    let level = player.persistentData.sanctified
    //Utils.server.tell('Casting Spell ID:'+player.magicData.castingSpellId)
    //Utils.server.tell('Immediate:'+event.source.immediate.type)
    //Utils.server.tell('success')
    let box = AABB.of(player.x+10+(5*level), player.y+10+(5*level), player.z+10+(5*level), player.x-10-(5*level), player.y-10-(5*level), player.z-10-(5*level))
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.alive && isAlly(player, ent))
    entitiesWithin.forEach(ent => {
        ent.health += ent.maxHealth * (0.03 * level)
    })
    player.health += player.maxHealth * (0.03 * level)
    let sanctifiedCooldown = 60 - ((level - 1) * 10)
    addSkillCooldown(player, 'sanctified', sanctifiedCooldown)
})

/*
let sanctified_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.tags.contains('sanctified_cooldown')) return
    let level = event.player.persistentData.sanctified
    let cd = 60 - ((level-1) * 10) // 60 seconds - 10 seconds per level = 1 second at level 1
    if (sanctified_cooldown[event.player.username] == undefined) {
        sanctified_cooldown[event.player.username] = cd
    } else {
        sanctified_cooldown[event.player.username] -= 1
    }
    if (sanctified_cooldown[event.player.username] > 0) return
    event.player.tags.remove('sanctified_cooldown')
    sanctified_cooldown[event.player.username] = cd
})
*/


/// Consecration: Give nearby allies +10 mana when you kill an enemy. Mana and range scale with level
// §aLevel 1: 10 mana, 15 block radius
// §aLevel 2: 20 mana, 20 block radius
// §aLevel 3: 30 mana, 25 block radius
// §aLevel 4: 40 mana, 30 block radius
// §aLevel 5: 50 mana, 35 block radius

EntityEvents.death(event => {
    if (!event.entity.isMonster()) return
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('consecration')) return
    if (isSkillCoolingDown(player, 'consecration')) return
    let level = player.persistentData.consecration
    let box = AABB.of(player.x+10+(5*level), player.y+10+(5*level), player.z+10+(5*level), player.x-10-(5*level), player.y-10-(5*level), player.z-10-(5*level))
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => isAlly(player, ent))
    entitiesWithin.forEach(ent => {
        let mana = Number(10*level)
        Utils.server.runCommandSilent(`/mana add ${ent.username} ${mana}`)
    })
    let consecrationCooldown = 60 - ((level - 1) * 10)
    addSkillCooldown(player, 'consecration', consecrationCooldown)
})

/*
let consecration_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.tags.contains('consecration_cooldown')) return
    let level = event.player.persistentData.consecration
    let cd = 60 - ((level-1) * 10) // 60 seconds - 10 seconds per level = 1 second at level 1
    if (consecration_cooldown[event.player.username] == undefined) {
        consecration_cooldown[event.player.username] = cd
    } else {
        consecration_cooldown[event.player.username] -= 1
    }
    if (consecration_cooldown[event.player.username] > 0) return
    event.player.tags.remove('consecration_cooldown')
    consecration_cooldown[event.player.username] = cd
})
*/


// Inspire: choose which ability you want to use. 5 levels, 1 level per ability
// §aLevel 1: Luck
// §aLevel 2: Water Walking
// §aLevel 3: Steel Feet
// §aLevel 4: Spelunker
// §aLevel 5: Lava Walking, Fire Resistance

let inspire = {
    1: [
        'minecraft:luck',
    ],
    2: [
        'runiclib:water_walking',
    ],
    3: [
        'kubejs:steel_feet'
    ],
    4: [
        'runiclib:caffeinated' // 2
    ],
    5: [
        'runiclib:lava_walking',
        'enigmaticlegacy:molten_heart',
    ]
}

let inspire_icons = {
    1: 'luck',
    2: 'water_walking',
    3: 'steel_feet',
    4: 'spelunker',
    5: 'lava_walking',
}


function inspire_ability(player) {
    if (!player.persistentData.get('inspire')) return
    Utils.server.runCommandSilent(`/execute at ${player.username} run playsound irons_spellbooks:cast.blood_step ambient ${player.username} ~ ~ ~ 1 2`)
    if (inspire_map[player.username] == undefined) {
        inspire_map[player.username] = 1
    } else {
        inspire_map[player.username] += 1
    }
    if (inspire_map[player.username] > Object.keys(inspire).length) {
        inspire_map[player.username] = 1
    }
    if (inspire_map[player.username] > player.persistentData.inspire) {
        inspire_map[player.username] = 1
    }

    // tell the player what ability they have selected
    let icon = inspire_icons[inspire_map[player.username]]
    paint_ability_cycle(player, icon, 'inspire')
    let current_inspire = Object.keys(inspire)[inspire_map[player.username]-1]
    player.persistentData.putInt('current_inspire', current_inspire)
    //player.tell(`You have selected ${Object.keys(inspire)[inspire_map[player.username]-1]}`)
}

let inspire_map = new WeakMap()

/**
 * 
 * 
NetworkEvents.dataReceived("global.hKeySpecial.consumeClick", (e) => {
    let player = e.player;
    if (!player.persistentData.get(`inspire`)) return;
    if (inspire_map[player.username] == undefined) {
        inspire_map[player.username] = 1
    } else {
        inspire_map[player.username] += 1
    }
    if (inspire_map[player.username] > Object.keys(inspire).length) {
        inspire_map[player.username] = 1
    }
    if (inspire_map[player.username] > player.persistentData.inspire) {
        inspire_map[player.username] = 1
    }

    // tell the player what ability they have selected
    let icon = inspire_icons[inspire_map[player.username]]
    paint_ability(player, icon, 2, 'inspire')

    //player.tell(`You have selected ${Object.keys(inspire)[inspire_map[player.username]-1]}`)

})
 * 
 * 
 * 
 */




let inspire_countdown = new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('inspire')) return
    let player = event.player
    if (inspire_countdown[player.username] == undefined) {
        inspire_countdown[player.username] = 40
    } else {
        inspire_countdown[player.username] -= 1
    }
    if (inspire_countdown[player.username] == 0) {
        if (player.persistentData.current_inspire == undefined) {
            player.persistentData.putInt('current_inspire', 1)
        }
        let box = AABB.of(player.x+15, player.y+15, player.z+15, player.x-15, player.y-15, player.z-15)
        let dim = player.level
        let entitiesWithin = dim.getEntitiesWithin(box)
        entitiesWithin.forEach(ent => {
            if (ent.teamId == player.teamId) {
                let current_inspire = player.persistentData.current_inspire
                //Utils.server.tell(`current inspire: ${current_inspire}`)
                inspire[current_inspire].forEach(effect => {
                    player.potionEffects.add(effect, 60, 1, true, true)
                    
                })
            }
        })
        inspire_countdown[player.username] = 60
        //inspire_countdown.delete(player.username)
    }

})





// Kinetic Rebuke: Throwing an item at an enemy causes them to be blasted back. Scales with level. At §aLevel 5, levitate the enemy for 2 ticks
EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    let entity = event.entity
    if (entity.tags.contains('boss')) return
    // Check player class
    if (!player.persistentData.get('kinetic_rebuke')) return
    let level = player.persistentData.kinetic_rebuke
    // Check for thrown item
    if (!throwableCheck(event.source)) return
    // Play the sound
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound irons_spellbooks:spell.telekinesis.cast ambient ${player.username} ${entity.x} ${entity.y} ${entity.z} 0.4 2`)
    //entity.playSound('irons_spellbooks:spell.telekinesis.cast', 1, 2)
    if (level >= 5) {
        applyEffect(entity, 'minecraft:levitation', 2, 140)
    }
    applyEffect(entity, 'kubejs:hexed', 40*level, level-1)
    // loop once per order level
    for (let i = 0; i < level; i++) {
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
        player.push(entity)
    }
})

// Final Judgement: Throwing a Trident at an enemy times causes them to be marked. This gives them the rend and glowing effect for 3 seconds. Stacks. Scales with level

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    let entity = event.entity
    if (!player.persistentData.get('final_judgement')) return
    let level = player.persistentData.final_judgement
    // Check for thrown item
    let check = levelBetterProjectileCheck(level, event, 'throwable', 3, 5)
    if (!check) return
    global.applyGlow(entity, 'yellow', Number(level*60))
    if (entity.potionEffects.isActive('irons_spellbooks:rend')) {
        applyStackingEffect(entity, 'irons_spellbooks:rend', level*60, 1)
    } else {
        Utils.server.runCommandSilent(`/effect give ${entity.uuid} irons_spellbooks:rend ${3*level} 0 false`)
    }


})

/**
 * Recursive Light: Thrown items have a 5% chance to spawn a §3Magic Arrow§7 that riccochets between enemies.
 *  - Each level increases:
 *   -> Chance by 5%
 *   -> Damage by 3
 *   -> Max ricochets by 3
 *   -> Range by 5
 *  */ 
EntityEvents.hurt(event => {
    if (!event.source || !event.source.player) return;
    if (!event.entity.isMonster()) return;
    throwableCheck(event.source)
    let player = event.source.player;
    if (!player.persistentData.get('recursive_light')) return;
    // Let the chance that it will apply be 5% times the player's order level
    let level = player.persistentData.recursive_light;
    handleProjectileRicochet(event, 'irons_spellbooks:guiding_bolt', 5, 3, 3, 5, level)
})


let lastLightCooldown = new WeakMap()
// Burden of Oaths, 6 levels: When you are surrounded, you gain resistance and thorns. Scales with level
// §aLevel 1: 7 Block Radius, Enemies Required: 10, Effect Levels: 1
// §aLevel 2: 9 Block Radius, Enemies Required: 9, Effect Levels: 2
// §aLevel 3: 11 Block Radius, Enemies Required: 8, Effect Levels: 3

PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 !== 0) return // once per second
    let player = event.player
    if (event.player.persistentData.get('burden_of_oaths')) {
        let level = player.persistentData.burden_of_oaths
        let radius = 5 + level * 2
        let nearbyEnemies = player.level.getEntitiesWithin(AABB.of(player.x + radius, player.y + 2, player.z + radius, player.x - radius, player.y - 2, player.z - radius)).filter(e => e.isMonster())
        let burdenPoints = 10 - (level - 1)
        if (nearbyEnemies.length >=  burdenPoints) {
            player.potionEffects.add('aquamirae:strong_armor', 60, level, true, true)
            player.potionEffects.add('runiclib:retaliation', 60, level, true, true)
        }
    }
    // Last Light, 3 Levels: When you are at 10% health, allies within 10 blocks gain 5 regeneration and strength. Scales with level
    // §aLevel 1: 10% Health, 10 Block Radius, Effect Levels: 1
    // §aLevel 2: 20% Health, 10 Block Radius, Effect Levels: 2
    // §aLevel 3: 30% Health, 10 Block Radius, Effect Levels: 3
    if (event.server.tickCount % 60 !== 0) return // once per second
    if (event.player.persistentData.get('last_light')) {
        let level = player.persistentData.last_light
        if (player.health <= player.maxHealth * (0.1*level)) {
            let radius = 5 + level * 5
            let box = AABB.of(player.x + radius, player.y + 2, player.z + radius, player.x - radius, player.y - 2, player.z - radius)
            let entitiesWithin = player.level.getEntitiesWithin(box)
            entitiesWithin.forEach(ent => {
                if (isAlly(player, ent)) {
                    applyEffect(ent, 'minecraft:regeneration', 100, level - 1)
                    applyEffect(ent, 'minecraft:strength', 100, level - 1)
                }
            })
        }
    }
})
