
// Frenzy: Stacking haste buff. 5 levels. 2 levels of haste per level. 2 seconds of haste per level. Getting hit equal times to your level will remove the haste effect and reset the counter
// §aLevel 1: 2 seconds of haste, 1 amplification, 1 hit to remove
// §aLevel 2: 4 seconds of haste, 3 amplification, 2 hits to remove
// §aLevel 3: 6 seconds of haste, 5 amplification, 3 hits to remove
// §aLevel 4: 8 seconds of haste, 7 amplification, 4 hits to remove
// §aLevel 5: 10 seconds of haste, 9 amplification, 5 hits to removes

let frenzy_hit_map =new WeakMap()
EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('frenzy')) return
    let level = player.persistentData.frenzy
    if (frenzy_hit_map[player.username] == undefined) {
        frenzy_hit_map[player.username] = 1
    } else {
        frenzy_hit_map[player.username] += 1
    }
    if (frenzy_hit_map[player.username] > 2*level) {
        frenzy_hit_map[player.username] = 2*level
    }
    player.potionEffects.add('minecraft:haste', 40*level, (2*level)-1, true, true)
}) 

let frenzy_hurt_map =new WeakMap()
EntityEvents.hurt(event => {
    if (!event.entity.player) return
    let player = event.entity.player
    if (!player.persistentData.get('frenzy')) return
    let level = player.persistentData.frenzy
    if (frenzy_hurt_map[player.username] == undefined) {
        frenzy_hurt_map[player.username] = 1
    } else {
        frenzy_hurt_map[player.username] += 1
    }
    if (frenzy_hurt_map[player.username] != level) return
    Utils.server.runCommandSilent(`/effect clear ${player.username} minecraft:haste`)
    frenzy_hurt_map[player.username] = 0
    frenzy_hit_map[player.username] = 0
})

// Frozen Shackles: 5 levels. Chills enemies if shooting them while airborne. 1.5 seconds of frozen per level
// §aLevel 1: 2 seconds of Chilled
// §aLevel 2: 4 seconds of Chilled
// §aLevel 3: 6 seconds of Chilled
// §aLevel 4: 8 seconds of Chilled
// §aLevel 5: 10 seconds of Chilled
EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    let player = event.source.player
    let entity = event.entity
    if (!player.persistentData.get('frozen_shackles')) return
    let level = player.persistentData.frozen_shackles
    if (player.blockStateOn.block != 'Block{minecraft:air}') return   
    let check = levelBetterProjectileCheck(level, event, 'arrow', 3, 5)
    if (!check) return
    let duration = 40*level
    if (entity.potionEffects.isActive('cofh_core:chilled')) {
        applyStackingEffect(entity, 'cofh_core:chilled', duration, 1)
        if (level >= 5) {
            let chance = 0.25
            if (Math.random() < chance) {
                applyEffect(entity, 'mowziesmobs:frozen', 60, level-1, true, true);
            }
        }
    } else {
        applyEffect(entity, 'cofh_core:chilled', duration, level, true, true);
    }
})


/**
 * 
 * EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('elementalist')) return
    let active_element = player.persistentData.active_element
    let level = player.persistentData.elementalist
    let valid = false
    if (active_element == 'ice' && event.entity.potionEffects.isActive('mowziesmobs:frozen')) {
        valid = true
    } else if (active_element == 'fire' && event.entity.onFire) {
        valid = true
    } else if (active_element == 'poison' && event.entity.potionEffects.isActive('minecraft:poison')) {
        valid = true
    }
    if (!valid) return
    Utils.server.runCommandSilent(`/mana add ${player.username} ${20*level}`)
})
 * 
 * 
 * 
 */

// Cryomancer: Gain 20 mana * level if you kill an enemny with the frozen effect
// §aLevel 1: 20 mana
// §aLevel 2: 40 mana
// §aLevel 3: 60 mana
// §aLevel 4: 80 mana
// §aLevel 5: 100 mana
EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('cryomancer')) return
    let level = player.persistentData.cryomancer
    if (!event.entity.potionEffects.isActive('mowziesmobs:frozen')) return
    Utils.server.runCommandSilent(`/mana add ${player.username} ${10*level}`)
})

// Glacial Wind: When you hit an enemy with an arrow, its possible that it will ricochet icicles to nearby enemies. Icicles freeze enemies
// 3% chance per level
// §aLevel 1: 3% chance to activate. Icicles deal 1 damage. 7 block radius. Freezes for 1.5 seconds. 4 enemies max
// §aLevel 2: 6% chance. Icicles deal 2 damage. 9 block radius. Freezes for 3 seconds. 8 enemies max
// §aLevel 3: 9% chance. Icicles deal 3 damage. 11 block radius. Freezes for 4.5 seconds. 12 enemies max
// §aLevel 4: 12% chance Icicles deal 4 damage. 13 block radius. Freezes for 6 seconds. 16 enemies max
// §aLevel 5: 15% chance Icicles deal 5 damage. 15 block radius. Freezes for 7.5 seconds. 20 enemies max


let glacial_wind = {
    'ice': 'irons_spellbooks:icicle',
    'fire': 'irons_spellbooks:firebolt',
    'poison': 'irons_spellbooks:poison_arrow'
}

EntityEvents.hurt(event => {
    if (!event.source || !event.source.player) return;
    if (!event.source.immediate || !event.source.immediate.type.includes('arrow')) return;
    if (!event.entity.isMonster()) return;
    let player = event.source.player;
    if (!player.persistentData.get('glacial_winds')) return;
   // if (player.blockStateOn.block != 'Block{minecraft:air}') return
    // Let the chance that it will apply be 5% times the player's order level
    let level = player.persistentData.glacial_winds;
    let chance = 3 * level;
    if (Math.random() * 100 > chance) return;
    let x = event.entity.getX();
    let y = event.entity.getY();
    let z = event.entity.getZ();
    let coords = 5+(2*level);
    let box = AABB.of(x + coords, y + 2, z + coords, x - coords, y - 2, z - coords);
    let dim = event.level;
    let entitiesWithin = dim.getEntitiesWithin(box).filter(e => e.isMonster());
    // let damage be equal to 5*player's order level
    let damage = level;

    // Add the initial enemy to the list and tag them
    let count = 0;
    let enemies = [];
    entitiesWithin.forEach(ent => {
        if (ent.isMonster()) {
            if (count > level*4) return;
            count++;
            enemies.push(ent)
        }
    });
    if (enemies.length == 0) return;
    enemies.forEach((enemy, index) => {
        let nextEnemy = enemies[index + 1];
        if (!nextEnemy) return;
        Utils.server.scheduleInTicks(3 * (index + 1), () => {
            let arrow = dim.createEntity('irons_spellbooks:icicle');
            arrow.setPos(enemy.getX(), enemy.getY(), enemy.getZ());
            arrow.tags.add('Ricochet');

            let dir = {
                x: nextEnemy.getX() - enemy.getX(),
                y: nextEnemy.getY()+1.5 - enemy.getY(),
                z: nextEnemy.getZ() - enemy.getZ()
            };
            let dirLength = Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);
            if (dirLength > 0) {
              arrow.setMotion((dir.x / dirLength) * 2.2, (dir.y / dirLength) * 2.2, (dir.z / dirLength) * 2.2);
            }
            arrow.mergeNbt(`{Owner:${player.username}, Damage:${damage}, Tags:["Owner:${player.username}", "glacial_icicle"]}`);
            arrow.spawn();
            arrow.playSound('bosses_of_mass_destruction:comet_shoot', 10, 2);
        })
    })
})



EntityEvents.hurt(event => {
    if (event.entity.tags.contains('boss')) return
    if (event.source.immediate == null) return
    if (!event.source.immediate.type.includes('icicle')) return
    if (!event.source.immediate.tags.toString().includes('glacial_icicle')) return
    let p = event.source.immediate.tags.find(tag => tag.startsWith('Owner:'))
    if (p == undefined) return
    let player = event.server.getPlayer(p.split(':')[1])
    if (!player.persistentData.get('glacial_winds')) return
    let level = player.persistentData.glacial_winds
    applyEffect(event.entity, 'mowziesmobs:frozen', 30*level, 0)
    Utils.server.runCommandSilent(`/kill ${event.source.immediate.uuid}`)
});




// Frostbite: Deal more damage to enemies that have the frozen effect. 5 levels, 5% more damage per level
// §aLevel 1: 5% more damage
// §aLevel 2: 10% more damage
// §aLevel 3: 15% more damage
// §aLevel 4: 20% more damage
// §aLevel 5: 25% more damage

EntityEvents.hurt(event => {
    if (!event.entity.potionEffects.isActive('mowziesmobs:frozen')) return
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('frostbite')) return
    let level = event.source.player.persistentData.frostbite
    let damage = event.damage * (0.05*level)
    Utils.server.runCommandSilent(`/damage ${event.entity.uuid} ${damage} minecraft:player_attack by ${event.source.player.username}`)

    let chance = 0
    if (level >= 3) {
        chance = 0.05
    }
    if (level >= 4) {
        chance = 0.125
    }
    if (level >= 5) {
        chance = 0.25
    }
    if (Math.random() < chance) {
        applyEffect(event.entity, 'mowziesmobs:frozen', 60, 1)
    }
    event.cancel()
})



// Hypothermia: Killing a frozen enemy has a chance to cause enemies within 7 blocks to cast Ice Breath at another nearby monster at the nearest enemy
// §aLevel 1: 3% chance to cast Ice Breath at another nearby monster. 1.5 seconds cast time, 4 enemies max, 7 block search radius
// §aLevel 2: 6% chance to cast Ice Breath at another nearby monster. 3 seconds cast time, 8 enemies max, 9 block search radius
// §aLevel 3: 9% chance to cast Ice Breath at another nearby monster. 4.5 seconds cast time, 12 enemies max, 11 block search radius
// §aLevel 4: 12% chance to cast Ice Breath at another nearby monster. 6 seconds cast time, 16 enemies max, 13 block search radius
// §aLevel 5: 15% chance to cast Ice Breath at another nearby monster. 7.5 seconds cast time, 20 enemies max, 15 block search radius
EntityEvents.death(event => {
    if (!event.source || !event.source.player) return;
    let proj = physicalProjectileCheck(event.source);
    if (!proj) return;
    if (!event.entity.isMonster()) return;
    let player = event.source.player;
    if (!player.persistentData.get('hypothermia')) return;
    if (event.entity.potionEffects.isActive('mowziesmobs:frozen')) return;
   // if (player.blockStateOn.block != 'Block{minecraft:air}') return
    // Let the chance that it will apply be 5% times the player's order level
    let level = player.persistentData.hypothermia;
    let chance = 3 * level;
    if (Math.random() * 100 > chance) return;
    let x = event.entity.getX();
    let y = event.entity.getY();
    let z = event.entity.getZ();
    let coords = 5+(2*level);
    let box = AABB.of(x + coords, y + 2, z + coords, x - coords, y - 2, z - coords);
    let dim = event.level;
    let entitiesWithin = dim.getEntitiesWithin(box).filter(e => e.isMonster());
    // let damage be equal to 5*player's order level
    let damage = 1 * level;

    // Add the initial enemy to the list and tag them
    let count = 0;
    let enemies = [];
    entitiesWithin.forEach(ent => {
        if (ent.isMonster()) {
            if (count > level*4) return;
            count++;
            enemies.push(ent)
        }
    });
    if (enemies.length == 0) return;
    enemies.forEach((enemy, index) => {
        let nextEnemy = enemies[index + 1];
        if (!nextEnemy) return;
            let spells = ['cone_of_cold']
            newCast(enemy, spells, nextEnemy, level, `hypothermia_${spells[0]}`)
    })
})


/**
 * REWORK SO THE SPELL THAT IS USED IS BASED ON YOUR ACTIVE ELEMENT
 * 
 * 
 * 
 * 
 */




/**
 * 
 * 
 * 
 */


function avalanche_ability(player) {
    // don't run if already on cooldown
    if (isSkillCoolingDown(player, 'avalanche')) return
    // must have the data
    if (!player.persistentData.get('avalanche')) return
    let level = player.persistentData.getInt('avalanche');
    let radius = 10 + (5 * level);
    let box = AABB.of(
        player.x + radius, player.y + 3, player.z + radius,
        player.x - radius, player.y - 1, player.z - radius
    );
    let dim = player.level;

    let count = 0;
    
    dim.getEntitiesWithin(box).forEach(ent => {
        let ally = isAlly(player, ent);
        if (ent && ent.alive && ent != player && !ally) {
            if (ent.pickable) {
                if (ent.potionEffects.isActive('cofh_core:chilled')) {
                    applyEffect(ent, 'mowziesmobs:frozen', 60 * level, 0, true, false);
                }
                count++;
                if (count < 3 * level) {
                    // stagger each bomb spawn by 6 ticks
                    Utils.server.scheduleInTicks(count * 6, () => {
                        let proj = dim.createEntity('irons_spellbooks:ice_block_projectile');
                        proj.setPosition(ent.x, ent.y + 4, ent.z);
                        proj.mergeNbt({
                            airTime: 15,
                            Damage: 4 * level,
                            Glowing: true,
                            Owner: player.username,
                        });
                        proj.spawn();
                    });
                } else {

                }
            }
        }
    });
    // nothing to target
    if (count == 0) return
    // hide the key-slot icon and apply tag/effects
    //hide_ability(player, 'avalanche');
    let cd = 2400 - ((level-1)*300)
    addSkillCooldown(player, 'avalanche', cd);
    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:snowflake ${player.x} ${player.y+1} ${player.z} 0.5 0.5 0.5 0.1 400`)
    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run playsound minecells:weapon.frost_blast.release ambient ${player.username} ${player.x} ${player.y+1} ${player.z} 1 1.75`)
}


/*
let avalancheCooldown = new WeakMap();
PlayerEvents.tick(event => {
    let player = event.player;
    if (!player.persistentData.get('avalanche')) return;
    if (!player.tags.contains('avalanche_cooldown')) return
    let level = player.persistentData.avalanche;
    let cd = 2400 - ((level-1)*300)
    if (avalancheCooldown[player.username] == undefined) {
        avalancheCooldown[player.username] = cd; 
    } else {
        avalancheCooldown[player.username] -= 1;
    }

    if (avalancheCooldown[player.username] > 0) return;
    avalancheCooldown[player.username] = cd;
    player.tags.remove('avalanche_cooldown');
})
*/


function subzero_pulse(player) {
    // don't run if already on cooldown
    // must have the data
    if (!player.persistentData.get('subzero')) return
    if (player.persistentData.getBoolean('subzero_active') != true) return;
    let level = player.persistentData.getInt('subzero');
    let radius = 5 * level
    let box = AABB.of(
        player.x + radius, player.y + radius, player.z + radius,
        player.x - radius, player.y - radius, player.z - radius
    );
    let dim = player.level;

    //
    //Utils.server.runCommandSilent(`/execute in ${dim.dimension} run playsound minecells:weapon.frost_blast.release ambient ${player.username} ${player.x} ${player.y+1} ${player.z} 1 0.75`)
    dim.getEntitiesWithin(box).forEach(ent => {
        let ally = isAlly(player, ent);
        if (ent && ent.alive && ent != player && !ally) {
            if (ent.pickable) {
                if (!ent.potionEffects.isActive('mowziesmobs:frozen')) {
                    Utils.server.runCommandSilent(`/effect give ${ent.uuid} mowziesmobs:frozen ${level*2} 0`);
                    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:snowflake ${ent.x} ${ent.y+1} ${ent.z} 0.5 0.5 0.5 0.1 400`)
                } else {
                    let amp = ent.potionEffects.getActive('mowziesmobs:frozen').amplifier
                    let odds = 0.50
                    if (odds < Math.random()) {
                        Utils.server.runCommandSilent(`/effect give ${ent.uuid} mowziesmobs:frozen ${level*2} ${amp+1}`);
                        Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:snowflake ${ent.x} ${ent.y+1} ${ent.z} 0.5 0.5 0.5 0.1 400`)
                    } else {
                        Utils.server.runCommandSilent(`/effect give ${ent.uuid} mowziesmobs:frozen ${level*2} ${amp}`);
                        Utils.server.runCommandSilent(`/execute in ${dim.dimension} run particle irons_spellbooks:snowflake ${ent.x} ${ent.y+1} ${ent.z} 0.5 0.5 0.5 0.1 400`)
                    }


                }
            }

        }
    });
    player.magicData.setMana(player.magicData.getMana() - (50 - (5*(level-1))));
}

PlayerEvents.tick(event => {
    if (event.server.tickCount % 10 != 0) return;
    if (!event.player.persistentData.get('subzero')) return;
    let level = event.player.persistentData.subzero;
    if (event.player.magicData.mana < (50 - (5*(level-1)))) {
        event.player.persistentData.putBoolean('subzero_active', false);
        hide_ability(event.player, 'subzero');
        return
    } else {
        paint_ability(event.player, 'subzero', 'subzero');
        if (event.player.persistentData['subzero_active'] != true) return;
        subzero_pulse(event.player);
    }

})




function subzero_ability(player) {
    // must have the subzero tag
    if (!player.persistentData.get('subzero')) return;
    let active = player.persistentData.getBoolean('subzero_active');
    if (!active) {
        player.magicData.setMana(player.magicData.getMana() - 25);
        player.persistentData.putBoolean('subzero_active', true);
    } 
    // already active: deactivate
    else {
        player.persistentData.putBoolean('subzero_active', false);
    }
}




let permafrost_charge = new WeakMap();
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('permafrost')) return
    if (event.player.potionEffects.isActive('kubejs:permafrost_charge')) return
    let level = event.player.persistentData.permafrost
    // Requires a bow
    if (!event.player.usingItem) return
    let item = event.player.mainHandItem
    if (!item.id.includes('bow')) return
    if (event.player.magicData.getMana() < 15) return
    // If the player is not crouching, or the level is less than 5, clear the effect and reset the charge
    if (!event.player.crouching && level < 5) {
        Utils.server.runCommandSilent(`/effect clear ${event.player.username} kubejs:permafrost_charge`)
        if (permafrost_charge[event.player.username] != undefined) {
            permafrost_charge[event.player.username] = 0;
        }
    } else {
        if (permafrost_charge[event.player.username] == undefined) {
            permafrost_charge[event.player.username] = 1
        } else {
            permafrost_charge[event.player.username] += 1
        }
        
        if (permafrost_charge[event.player.username] % 20 == 0) {
            event.player.magicData.setMana(event.player.magicData.getMana() - 15);
        }



        if (permafrost_charge[event.player.username] > 100 - (15*(level-1))) {
            Utils.server.runCommandSilent(`effect give ${event.player.username} kubejs:permafrost_charge infinite 0 false`)
            Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound minecells:weapon.frost_blast.release ambient ${event.player.username} ${event.player.x} ${event.player.y+1} ${event.player.z} 1 0.75`)
            Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run particle irons_spellbooks:snowflake ${event.player.x} ${event.player.y+1} ${event.player.z} 0.5 0.5 0.5 0.1 400`)
            permafrost_charge[event.player.username] = 0;
        }
    }
})

EntityEvents.hurt('player', event => {
    if (!event.entity.isPlayer()) return
    //if (!event.source.player.persistentData.get('permafrost')) return
    if (!event.entity.potionEffects.isActive('kubejs:permafrost_charge')) return
    Utils.server.runCommandSilent(`/effect clear ${event.entity.uuid} kubejs:permafrost_charge`)
    permafrost_charge[event.source.player.username] = 0;
})




/**
 * Arctic Wind: 10 levels
 * 1% chance per level to freeze an enemy for .25 seconds if they are hit by an arrow. 10 levels. Each level increases the chance by 1% and the duration by .25 seconds.
 */

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    if (!event.source.player.persistentData.get('deep_freeze')) return
    let level = event.source.player.persistentData.deep_freeze
    let check = levelBetterProjectileCheck(level, event, 'arrow', 5, 10)
    if (!check) return
    let odds = 0.01 * level
    if (Math.random() > odds) return
    applyEffect(event.entity, 'mowziesmobs:frozen', 10*level, 0, true, false);
})



EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.potionEffects.isActive('kubejs:permafrost_charge')) return
    let curios = skillTotemCheck(event.source.player, 'dreadmark')
    let dur = 0
    let amp = 0
    if (!curios) {
        //tell(`No curios found for ${event.source.player.username}`)
        let arrow = arrowCheck(event.source)
        if (!arrow) return
        //tell(`Arrow found for ${event.source.player.username}`)
        if (event.source.player.persistentData.get('permafrost')) {
            dur = 60 * event.source.player.persistentData.permafrost;
            amp = event.source.player.persistentData.permafrost - 1;
        } else {
            dur = 60;
        }
    } else {
        let proj = physicalProjectileCheck(event.source);
        if (!proj) return
        dur = 60;
    }

    applyEffect(event.entity, 'mowziesmobs:frozen', dur, amp, true, false);
    applyEffect(event.entity, 'irons_spellbooks:rend', dur, amp, true, false);
    let odds = 0
    if (event.source.player.persistentData.get('permafrost') && event.source.player.persistentData.permafrost >= 3) {
        odds = 0.15 * (1+(event.source.player.persistentData.permafrost-3))
        if (event.source.player.persistentData.permafrost >= 5) {odds = 0.50}
    }
    if (Math.random() < odds) return 
    Utils.server.runCommandSilent(`/effect clear ${event.source.player.username} kubejs:permafrost_charge`)
})
