/// Disciple




let scorchCooldown = new WeakMap();


function scorch_ability(player) {
    if (!player.persistentData.get('scorch')) return
    if (player.tags.contains('scorch_active')) {
        player.tags.remove('scorch_active')
        player.tell(Text.red('§4Scorch §cdeactivated'))
    } else {
        player.tags.add('scorch_active')
        player.tell(Text.green('§4Scorch §aactivated'))
    }
}



PlayerEvents.tick(event => {
    let player = event.player;
    if (!player.tags.contains('scorch_active')) return
    if (!player.persistentData.get('scorch')) return;
    let check = isSkillCoolingDown(player, 'scorch')
    if (check) return
    // Check if the player is in the air and has the 'scorch' ability
    if (!player.blockStateOn.block.toString().includes('air')) return;
    

    // Check if the player is on cooldown for Scorch
    let dashes = player.persistentData.flame_dashes;
    if (dashes > 0) {
        if (!player.shiftKeyDown) return;
        // Initialize cooldown and flame dashes if undefined
        if (scorchCooldown[player.username] == undefined) {
            scorchCooldown[player.username] = 4; // 4 ticks cooldown for dashes
        } else {
            scorchCooldown[player.username] -= 1;
        }
        
        
        if (scorchCooldown[player.username] <= 0) {
            scorchCooldown[player.username] = 4; // Reset cooldown
            
            // Cast burning dash
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run cast ${player.username} burning_dash`);
            // Subtract a dash
            dashes -= 1;
            // Update the player's flame dashes
            player.persistentData.flame_dashes = dashes;
        }
    } else {
        addSkillCooldown(player, 'scorch', 1200)
    // Reset dashes based on level
        let level = player.persistentData.scorch;
        let maxDashes = 2 * level;
        player.persistentData.flame_dashes = maxDashes;
        player.potionEffects.add('kubejs:steel_feet', 200, 1, true, true);
        //removeSkillCooldown(player, 'scorch')
    }
});


EntityEvents.death(event => {
    if (!event.source.player) return;
    if (!event.entity.onFire) return
    if (!event.source.player.persistentData.get('scorch')) return
    if (!isSkillCoolingDown(event.source.player, 'scorch')) return
    let level = event.source.player.persistentData.scorch
    let cd_reduction = Number(level * 20)
    reduceSkillCooldown(event.source.player, 'scorch', cd_reduction)
    tell(event.source.player.persistentData[`skill_cooldown:scorch`])
})






// Rite of Cinders: drops blocky_siege:projectile_fire_bomb on each enemy around you. 5 levels, 2 damage per level. Gives you the rite_of_cinders potion effect for 5 seconds
// §aLevel 1: 2 damage and 5 seconds of rite_of_cinders
// §aLevel 2: 4 damage and 10 seconds of rite_of_cinders
// §aLevel 3: 6 damage and 15 seconds of rite_of_cinders
// §aLevel 4: 8 damage and 20 seconds of rite_of_cinders
// §aLevel 5: 10 damage and 25 seconds of rite_of_cinders

/**
 * Launches a volley of fire bombs around the player if they have the rite_of_cinders tag/data
 * @param {ServerPlayerEntity} player
 * @returns {boolean} true if the ability ran, false otherwise
 */
function rite_of_cinders_ability(player) {
    // don't run if already on cooldown
    if (isSkillCoolingDown(player, 'rite_of_cinders')) return
    // must have the data
    if (!player.persistentData.get('rite_of_cinders')) return
    let level = player.persistentData.getInt('rite_of_cinders');
    let radius = 10 + (5 * level);
    let box = AABB.of(
        player.x + radius, player.y + radius, player.z + radius,
        player.x - radius, player.y - radius, player.z - radius
    );
    let dim = player.level;

    let count = 0;
    
    dim.getEntitiesWithin(box).forEach(ent => {
        let ally = isAlly(player, ent);
        if (ent && ent.alive && ent != player && !ally) {
            if (count > 5*level) return
            count++;
            // stagger each bomb spawn by 6 ticks
            Utils.server.scheduleInTicks(count * 6, () => {
                let proj = dim.createEntity('irons_spellbooks:fireball');
                proj.setPosition(ent.x, ent.y + 6, ent.z);
                proj.mergeNbt({
                    Damage: 2 * level,
                    Glowing: true,
                    Owner: player.username,
                    NoGravity: false,
                    ExplosionRadius: 3,
                    Motion: [0, -1, 0],
                });
                proj.spawn();
            });
        }

    });

    // nothing to target
    if (count == 0) return
    // hide the key-slot icon and apply tag/effects
    let cd = 3600 - ((level-1)*480)
    if (level >= 5) {
        cd = 1800
    }
    addSkillCooldown(player, 'rite_of_cinders', cd);
    player.potionEffects.add('runiclib:pyromaniac', 100 * level, level, true, true);
}

/*
let rite_of_cindersCooldown = new WeakMap();
PlayerEvents.tick(event => {
    let player = event.player;
    if (!player.persistentData.get('rite_of_cinders')) return;
    if (!player.tags.contains('rite_of_cinders_cooldown')) return
    let level = player.persistentData.rite_of_cinders;
    let cd = 3600 - ((level-1)*480)
    if (level >= 5) {
        cd = 1800
    }

    if (rite_of_cindersCooldown[player.username] == undefined) {
        rite_of_cindersCooldown[player.username] = cd; 
    } else {
        rite_of_cindersCooldown[player.username] -= 1;
    }
    if (rite_of_cindersCooldown[player.username] > 0) return
    player.tags.remove('rite_of_cinders_cooldown');
    rite_of_cindersCooldown[player.username] = cd;
    
})
*/




/**
 * 
 * 
 * NetworkEvents.dataReceived("global.hKeySpecial.consumeClick", (e) => {
    let player = e.player;
    if (player.tags.contains('rite_of_cinders')) return;
    if (!player.persistentData.get(`rite_of_cinders`)) return;
    let level = player.persistentData.rite_of_cinders
    let box = AABB.of(player.x+10+(5*level), player.y+10+(5*level), player.z+10+(5*level), player.x-10-(5*level), player.y-10-(5*level), player.z-10-(5*level))
    let dim = player.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    let count = 0
    entitiesWithin.forEach(ent => {
        if (ent == undefined) return
        if (ent == null) return
        if (ent.alive) {
            if (ent == player) return
            count += 1
            Utils.server.scheduleInTicks(count*6, () => {
                let proj = dim.createEntity('blocky_siege:projectile_fire_bomb')
                proj.setPosition(ent.x, ent.y+6, ent.z)
                proj.mergeNbt({
                    damage: 2*level,
                    Glowing: true,
                })
                proj.spawn()
            })
        }
    })
    if (count == 0) return
    hide_ability(player, 2, 'rite_of_cinders')
    player.tags.add('rite_of_cinders')
    player.potionEffects.add('runiclib:rite_of_cinders', 100*level, level, true, true)
    let cd = 3600 - ((level-1)*480)
    Utils.server.scheduleInTicks(cd, () => {
        paint_ability(player, 'rite_of_cinders', 2, 'rite_of_cinders')
        player.tags.remove('rite_of_cinders')
    })

})
 * 
 * 
 */

// Unholy Oath: if you land a critical hit then your next attack will find all enemies within a 5 block range and set them on fire
// Scaling: +2 range per level above 1, +20 ticks per level above 1
EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('unholy_oath')) return

    // Track whether we had a charge before this attack (so crits this hit won't immediately consume the brand-new charge)
    let hadChargeBefore =
        player.persistentData.get('unholy_oath_charges') &&
        player.persistentData.unholy_oath_charges > 0

    // Crit primes a charge
    if (wasCrit(player)) {
        if (player.persistentData.get('unholy_oath_charges')) {
            player.persistentData.unholy_oath_charges += 1
        } else {
            player.persistentData.putInt('unholy_oath_charges', 1)
        }
    }

    // Only apply if we had a charge before this attack (crit -> next attack applies)
    if (!hadChargeBefore) return

    let level = player.persistentData.unholy_oath
    let extra = Math.max(0, level - 1)
    let range = 5 + (2 * extra)
    let durationTicks = 60 + (20 * extra) // 3s base +20 ticks per level above 1

    let center = event.entity
    if (!center) return

    let box = AABB.of(
        center.x + range, center.y + range, center.z + range,
        center.x - range, center.y - range, center.z - range
    )

    event.level.getEntitiesWithin(box).forEach(target => {
        if (!target || !target.alive) return
        if (isAlly(player, target)) return
        if (!target.isMonster()) return
        target.remainingFireTicks = durationTicks
        Utils.server.scheduleInTicks(1, () => {
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle blue_skies:blue_flame ${target.x} ${target.y+1.5} ${target.z} 0.2 0.2 0.2 0.1 45`)
        })
        target.playSound('irons_spellbooks:cast.generic.fire', 1, 0.75)
    })

    // Consume one charge (critting on this same hit will have already re-added one above)
    player.persistentData.unholy_oath_charges = Math.max(0, player.persistentData.unholy_oath_charges - 1)
})



// Hellfire: Killing an enemy with a fire spell has a chance to burn all enemies within 10 blocks for 3 seconds per level

EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!event.source.toString().includes('fire_magic')) return
    if (!player.persistentData.get('hellfire')) return
    let level = player.persistentData.hellfire
    let chance = 0.1 * level
    if (Math.random() > chance) return
    applyAoeEffect(player, 5*level, 'kubejs:smouldering', 3*level*20, 0, 5*level, true, 'dark_orange')
})


/**
 * Flaming Shadows: Killing an enemy while they are on fire has a chance to:
 * - Level 1: Killing an enemy has a 5% chance to give you 3 seconds of invisibility, speed 1, and trail blazing
 * - Level 2: Chance to activate: +5%, Effects: +3 seconds
 * - Level 3: Flaming Shadows now blinds enemies within 10 blocks for 3 seconds. +5% chance to activate, +3 seconds of effects
 * - Level 4: +5% chance to activate, +3 seconds of effects, Blinding range is increased to 15 blocks
 * - Level 5: Enemies that are blinded now burn. +5% chance to activate, +3 seconds of effects
 */


EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!event.entity.onFire) return
    if (!player.persistentData.get('flaming_shadows')) return
    let level = player.persistentData.flaming_shadows
    let chance = 0.05*level
    if (Math.random() > chance) return
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle minecraft:smoke ${player.x} ${player.y+1} ${player.z} 0.5 0.5 0.5 0.01 1000`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound soulsweapons:night_shade_idle master ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
    player.potionEffects.add('irons_spellbooks:true_invisibility', 60*level, 0, true, true)
    player.potionEffects.add('cofh_core:true_invisibility', 60*level, 0, true, true)
    player.potionEffects.add('irons_spellbooks:true_invisibility', 60*level, 0, true, true)
    player.potionEffects.add('speed', 60*level, 1, true, true)
    player.tags.add('flaming_shadows_hit_mod')
    Utils.server.scheduleInTicks(60*level, () => {
        player.tags.remove('flaming_shadows_hit_mod')
    })
    if (level < 3) return
    let box = AABB.of(player.x+10+(5*level), player.y+10+(5*level), player.z+10+(5*level), player.x-10-(5*level), player.y-10-(5*level), player.z-10-(5*level))
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        let ally = isAlly(player, ent)
        if (!ally) {
            applyEffect(ent, 'minecraft:blindness', 60*level, 0)
            if (level < 5) return
            applyEffect(ent, 'kubejs:smouldering', 60*level, 1)
        }
    })
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.tags.contains('flaming_shadows_hit_mod')) return
    let player = event.source.player
    let level = player.persistentData.flaming_shadows
    event.entity.remainingFireTicks = 60*level
})


PlayerEvents.respawned(event => {
    event.player.tags.remove('flaming_shadows_hit_mod')
})





/**
 * Legion of the Damned: Gain a damage bonus for each Dark Servant within 5 blocks. 5 levels, +1 damage per level.
 * 
 */

let legionOfTheDamned = {
    1: {
        effect: 'enigmaticlegacy:molten_heart',
    },
    3: {
        effect: 'cataclysm:monstrous'
    },
    6: {
        effect: 'runiclib:burning_thorns'
    },

}



PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 != 0) return
    if (!event.player.persistentData.get('legion_of_the_damned')) return
    let player = event.player
    let level = player.persistentData.legion_of_the_damned
    let range = 4 * level
    let box = AABB.of(player.x+range, player.y+2, player.z+range, player.x-range, player.y-2, player.z-range)
    let dim = event.level
    let player_username = player.username
    // Make sure legion:username is the same as the player's username
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.alive)
    let count = 0
    entitiesWithin.forEach(ent => {
        if (ent.tags.contains(`dark_servant`)) {
            if (ent.potionEffects != null && ent.potionEffects.isActive('kubejs:mark_of_the_beast')) {
                count++;
            }
        }
    })

    if (count == 0) return
    let points = entitiesWithin.length
    let requiredPoints = 10 - (level-1)

    let effects = []
    if (level >= 1) {
        effects.push(legionOfTheDamned[1].effect);
    }
    if (level >= 3) {
        effects.push(legionOfTheDamned[3].effect);
    }
    if (level >= 6) {
        effects.push(legionOfTheDamned[6].effect);
    }
    if (points < requiredPoints) return
    effects.forEach(effect => {
        player.potionEffects.add(effect, 100, 0, true, true)
    })
})



let dark_servants = {
    1: [
        'irons_spellbooks:summoned_skeleton',
        'irons_spellbooks:summoned_zombie',
    ],
    2: [
        'irons_spellbooks:summoned_skeleton',
        'irons_spellbooks:summoned_zombie',
        'traveloptics:summoned_draugr',
    ],
    3: [
        'irons_spellbooks:summoned_skeleton',
        'irons_spellbooks:summoned_zombie',
        'traveloptics:summoned_draugr',
        'traveloptics:summoned_elite_draugr',
    ],
    4: [
        'irons_spellbooks:summoned_skeleton',
        'irons_spellbooks:summoned_zombie',
        'traveloptics:summoned_draugr',
        'traveloptics:summoned_elite_draugr',
        'traveloptics:summoned_royal_draugr'
    ],
    5: [
        'irons_spellbooks:summoned_skeleton',
        'irons_spellbooks:summoned_zombie',
        'traveloptics:summoned_draugr',
        'traveloptics:summoned_elite_draugr',
        'traveloptics:summoned_royal_draugr',
        'traveloptics:summoned_ignited_berserker'
    ],
}

// -----------------------------------------------------------
//  Imports – Mojang helpers for writing UUID as an IntArrayTag
// -----------------------------------------------------------
const NbtUtils     = Java.loadClass('net.minecraft.nbt.NbtUtils')        // createUUID(UUID) → IntArrayTag
const CompoundTag  = Java.loadClass('net.minecraft.nbt.CompoundTag')     // empty compound for mergeNbt
// -----------------------------------------------------------
//  Helper – attach Summoner tag ([I;…]) to an entity BEFORE spawn()
// -----------------------------------------------------------
function attachSummonerNBT(entity, player) {
  const tag = new CompoundTag()                                     // {}
  tag.put('Summoner', NbtUtils.createUUID(player.uuid))             // IntArrayTag
  entity.mergeNbt(tag)                                             // write into entity NBT
  entity.setCustomName(`${player.username}'s ${entity.displayName.getString()}`) // set custom name
}

function getAltUUID (entity) {
    let uuid = NbtUtils.createUUID(entity.uuid)
    return uuid
}

// -----------------------------------------------------------
//  Main death handler – spawns the demon
// -----------------------------------------------------------


/**
 * Dark Servant - Killing an enemy that has the Mark of the Beast effect has a 10% chance per level to summon a Dark Servant
 */
EntityEvents.death(event => {
  if (!event.source.player) return
  const player = event.source.player

  // ▸ Optional gating (uncomment to use your own logic)
  if (!player.persistentData.get('dark_servant')) return
  if (!event.entity.potionEffects.isActive('kubejs:mark_of_the_beast')) return
  let level = player.persistentData.dark_servant
  let chance = 0.1 * level
  if (Math.random() > chance) return
  summonDemonAtEntity(player, level, event.entity)
})



function summonDemonAtEntity(owner, level, entity) {
  const pool = dark_servants[level]
  if (!pool || pool.length === 0) return null
  let player = owner
  const mobId = pool[Math.floor(Math.random() * pool.length)]
  const demon = player.level.createEntity(mobId)
    let x = entity.x
    let y = entity.y
    let z = entity.z
  demon.setPosition(x, y, z)

  // Tagging for other scripts
  demon.tags.add(`legion:${player.username}`)
  demon.tags.add(`Dark Servant`)
  demon.tags.add(`Owner:${player.username}`)
  demon.tags.add(`specter`)
  demon.tags.add(`conjured:${player.username}`) // for other scripts to identify this as a conjured entity
  demon.tags.add(`tamed_beast`) // for other scripts to identify this as a tamed beast
  demon.persistentData.putString('owner', owner.username)
  // Add the Summoner NBT
  attachSummonerNBT(demon, player)

  demon.spawn()

  return
}


/**
 * ___________________________________________________________________________________
    * Mark of the Beast
    * - Killing an enemy has a chance to give a nearby enemy the Mark of the Beast effect
    * -> Hitting an enemy that has the Mark of the Beast will burn all other nearby enemies with Mark of the Beast and reset the duration to 10 seconds
*/


EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('mark_of_the_beast')) return
    let level = player.persistentData.mark_of_the_beast
    let chance = 0.1 * level
    if (Math.random() > chance) return
    applyAoeEffect(player, 3*level, 'kubejs:mark_of_the_beast', 100, 0, level, true, 'dark_red')
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('mark_of_the_beast')) return
    let level = player.persistentData.mark_of_the_beast
    let markedEnemies = event.level.entities.filter(ent => ent.isMonster() && ent.potionEffects.isActive('kubejs:mark_of_the_beast'))
    if (markedEnemies.length == 0) return
    let fireTicks = 40 * level
    markedEnemies.forEach(ent => {
        ent.remainingFireTicks = fireTicks;
        let durRem = ent.potionEffects.getActive('kubejs:mark_of_the_beast').duration/20
        // cap at 2*level seconds
        applyStackingEffect(ent, 'kubejs:mark_of_the_beast', 200, 1)
    })
        
})


/**
 * unyielding_sin
 * - Enemies hurt by Dark Servants have a 15% chance per level to get Mark of the Beast
 */

EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('unyielding_sin')) return
    if (!event.source.immediate.tags.contains('Dark Servant')) return
    let level = player.persistentData.unyielding_sin
    let chance = 0.075 * level
    if (Math.random() > chance) return
    if (!event.source.immediate.tags.contains('Dark Servant')) return
    let p_username = event.source.immediate.tags.find(tag => tag.startsWith('legion')).split(':')[1]
    if (p_username != player.username) return
    let durRem = 0
    if (event.entity.potionEffects.isActive('kubejs:mark_of_the_beast')) {
        durRem = event.entity.potionEffects.getActive('kubejs:mark_of_the_beast').duration/20
    }
    applyEffect(event.entity, 'kubejs:mark_of_the_beast', 200-durRem, 1, `${curio}_player_effect`, player)
})

/**
 * Unwilling Host
 *  - When an Dark Servant dies, it has a 20% chance per level to give Mark of the Beast to its killer
 */

EntityEvents.death(event => {
    if (!event.entity.tags.contains('Dark Servant')) return
    let player_username = event.entity.tags.find(tag => tag.startsWith('Owner:')).split(':')[1]
    let source = event.source.causingEntity
    if (!source) return
    let player = event.server.getPlayer(player_username)
    if (!player) return
    if (!player.persistentData.get('unwilling_host')) return
    let level = player.persistentData.unwilling_host
    let chance = 0.15 * level
    if (Math.random() > chance) return
    let durRem = 0
    if (source.potionEffects.isActive('kubejs:mark_of_the_beast')) {
        durRem = source.potionEffects.getActive('kubejs:mark_of_the_beast').duration/20
    }
    Utils.server.runCommandSilent(`/effect give ${source.uuid} kubejs:mark_of_the_beast ${5*level} ${0} false`)
})







