
let necromancer_spells = [
    'raise_dead',
    'traveloptics:cursed_revenants',
]


// Necromancer: 5 levels: 2% chance to summon 2 creatures upon killing an enemy
// §aLevel 1: 3% chance, §aLevel 1
// §aLevel 2: 6% chance, §aLevel 2
// §aLevel 3: 9% chance, §aLevel 3
// §aLevel 4: 12% chance, §aLevel 4
// §aLevel 5: 15% chance, §aLevel 5

EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.entity.isMonster()) return
    if (event.entity.maxHealth < 15) return
    let player = event.source.player
    if (event.source.actual.tags.contains('tamed_beast')) return
    if (!player.persistentData.get('necromancer')) return
    if (isSkillCoolingDown(player, 'necromancer')) return
    let level = player.persistentData.necromancer
    let chance = Math.random()
    if (chance > 0.015*level) return
    let dim = event.level.dimension
    let base_cast_attr = player.getAttribute('irons_spellbooks:cast_time_reduction').baseValue
    player.getAttribute('irons_spellbooks:cast_time_reduction').setBaseValue(100)
    let spell = necromancer_spells[Math.floor(Math.random() * necromancer_spells.length)]
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${player.username} ${spell} ${level}`)
    event.entity.playSound('minecraft:entity.wither.ambient', 1, 0.5);
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle minecraft:soul ${player.x} ${player.y} ${player.z} 2 2 2 0.5 600 force @a`);
    Utils.server.scheduleInTicks(20, () => {
        player.getAttribute('irons_spellbooks:cast_time_reduction').setBaseValue(base_cast_attr)
        Utils.server.runCommandSilent(`/effect clear ${player.username} traveloptics:cursed_revenants_timer`)
        Utils.server.runCommandSilent(`/effect clear ${player.username} irons_spellbooks:raise_dead_timer`)

    })
    addSkillCooldown(player, 'necromancer', 1200)
})


/*
let necromancer_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    let player = event.player
    if (!player.persistentData.get('necromancer')) return
    if (!player.tags.contains('necromancer_cooldown')) return
    if (necromancer_cooldown[player.username] == undefined) {
        necromancer_cooldown[player.username] = 1200
    } else {
        necromancer_cooldown[player.username]--
    }
    if (necromancer_cooldown[player.username] > 0) return
    player.tags.remove('necromancer_cooldown')
    necromancer_cooldown[player.username] = 1200
})
*/





// Revenants Gift: When a summon kills an enemy, nearby allies are given a strength buff. Scales with level
// §aLevel 1: 5 block radius, 1 level of strength, 60 ticks
// §aLevel 2: 10 block radius, 2 levels of strength, 120 ticks
// §aLevel 3: 15 block radius, 3 levels of strength, 180 ticks
// §aLevel 4: 20 block radius, 4 levels of strength, 240 ticks
// §aLevel 5: 25 block radius, 5 levels of strength, 300 ticks

//conjurer_pets.forEach(pet => {
EntityEvents.death(event => {
    if (!event.source.indirect) return
    if (!event.source.player) return
    if (event.source.immediate == null) return
    if (event.source.immediate.type == null) return
    if (event.source.immediate.type != 'irons_spellbooks:summoned_polar_bear' && event.source.immediate.type != 'irons_spellbooks:summoned_skeleton' && event.source.immediate.type != 'irons_spellbooks:summoned_vex' && event.source.immediate.type != 'irons_spellbooks:summoned_zombie') return
    if (!event.source.toString().includes('blood_magic') && !event.source.toString().includes('evocation_magic') && !event.source.toString().includes('ice_magic')) return
    let player = event.source.player
    if (!player.persistentData.get('revenants_gift')) return
    let level = player.persistentData.revenants_gift
    let box = AABB.of(player.x+(5*level), player.y+(5*level), player.z+(5*level), player.x-(5*level), player.y-(5*level), player.z-(5*level))
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent.tags.contains('tamed_beast')) {
            if (ent.tags.contains(`Owner:${player.username}`)) return
            applyEffect(ent, 'strength', 30*level, level-1, true, true)
        }
    })
})

// Ravenous Undead: When a summon kills an enemy, nearby allies are given a Speed buff. Scales with level. Cooldown of 30 seconds.
// §aLevel 1: 5 block radius, 1 level of speed, 60 ticks
// §aLevel 2: 10 block radius, 2 levels of strength, 120 ticks
// §aLevel 3: 15 block radius, 3 levels of strength, 180 ticks
// §aLevel 4: 20 block radius, 4 levels of strength, 240 ticks
// §aLevel 5: 25 block radius, 5 levels of strength, 300 ticks

//conjurer_pets.forEach(pet => {
    EntityEvents.death(event => {
        if (!event.source.indirect) return
        if (!event.source.player) return
        if (event.source.immediate == null) return
        if (event.source.immediate.type == null) return
        if (isSkillCoolingDown(event.source.player, 'ravenous_undead')) return
        if (event.source.immediate.type != 'irons_spellbooks:summoned_polar_bear' && event.source.immediate.type != 'irons_spellbooks:summoned_skeleton' && event.source.immediate.type != 'irons_spellbooks:summoned_vex' && event.source.immediate.type != 'irons_spellbooks:summoned_zombie') return
        if (!event.source.toString().includes('blood_magic') && !event.source.toString().includes('evocation_magic') && !event.source.toString().includes('ice_magic')) return
        let player = event.source.player
        if (!player.persistentData.get('ravenous_undead')) return
        let level = player.persistentData.ravenous_undead
        let box = AABB.of(player.x+(5*level), player.y+(5*level), player.z+(5*level), player.x-(5*level), player.y-(5*level), player.z-(5*level))
        let dim = event.level
        let entitiesWithin = dim.getEntitiesWithin(box)
        entitiesWithin.forEach(ent => {
            if (ent.tags.contains('tamed_beast')) {
                if (ent.tags.contains(`Owner:${player.username}`)) return
                applyEffect(ent, 'speed', 60*level, level-1, true, true)
            }
        })
        let ravenousCooldown = 1200 - ((level - 1) * 250)
        addSkillCooldown(player, 'ravenous_undead', ravenousCooldown)
})

/*
let ravenous_undead_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    let player = event.player
    if (!player.persistentData.get('ravenous_undead')) return
    if (player.tags.contains('ravenous_undead_cooldown')) {
        let level = player.persistentData.ravenous_undead
        let cd = 1200 - ((level - 1) * 250)
        if (ravenous_undead_cooldown[player.username] == undefined) {
            ravenous_undead_cooldown[player.username] = cd
        } else {
            ravenous_undead_cooldown[player.username]--
        }
        if (ravenous_undead_cooldown[player.username] > 0) return
        player.tags.remove('ravenous_undead_cooldown')
        ravenous_undead_cooldown[player.username] = cd
    }
})
*/




// Conjurer Login stuff
PlayerEvents.loggedIn(event => {
    if (event.player.persistentData.loggedIn == 1) return
    event.player.persistentData.putInt('loggedIn', 1)
    let player_username = event.player.username
    let uuid = event.player.nbt.get('UUID').toString()
    event.server.persistentData.putString(uuid, player_username)
})
let conjurer_pets = [
    'irons_spellbooks:summoned_polar_bear',
    'irons_spellbooks:summoned_skeleton',
    'irons_spellbooks:summoned_vex',
    'irons_spellbooks:summoned_zombie',
    'traveloptics:summoned_aptrgangr',
    'traveloptics:summoned_atlatitan',
    'traveloptics:summoned_deepling',
    'traveloptics:summoned_draugr',
    'traveloptics:summoned_elite_draugr',
    'traveloptics:summoned_ender_golem',
    'traveloptics:summoned_forsaken',
    'traveloptics:summoned_gum_worm',
    'traveloptics:summoned_ignited_berserker',
    'traveloptics:summoned_ignited_revenant',
    'traveloptics:summoned_kobolediator',
    'traveloptics:summoned_koboleton',
    'traveloptics:summoned_magnetron',
    'traveloptics:summoned_royal_draugr',
    'traveloptics:summoned_the_prowler',
    'traveloptics:summoned_the_watcher',
    'traveloptics:summoned_tremorsaurus',
    'traveloptics:summoned_vallumraptor',
    'traveloptics:summoned_vesper',
    'traveloptics:summoned_wadjet',

]


/**
 * Soul Steal: Conjurer pets gain a level of soul steal when spawned. 5 levels, 1 level per level
 * §aLevel 1: 1 level of soul steal
 * §aLevel 2: 2 levels of soul steal
 * §aLevel 3: 3 levels of soul steal
 * §aLevel 4: 4 levels of soul steal
 * §aLevel 5: 5 levels of soul steal
 */




function determineSummonerUsername(event) {
    //tell(event.entity.nbt.toString().includes('Summoner'))
    let summoner_nbt = event.entity.nbt['Summoner'].toString()
    let player_username = event.server.persistentData[summoner_nbt]
    if (player_username == null) return null
    return player_username
}




conjurer_pets.forEach(pet => {
    EntityEvents.spawned(pet, event => {
        Utils.server.scheduleInTicks(2, () => {
            let entity = event.entity
            let player_username = determineSummonerUsername(event)
            if (player_username == null) return
            let player = event.server.getPlayer(player_username)
            if (player == null) return
            entity.tags.add('tamed_beast')
            entity.tags.add(`specter`)
            entity.tags.add(`Owner:${player_username}`)
            event.entity.tags.add(`conjured:${player.username}`)
            applyEffect(event.entity, 'kubejs:specter', 'infinite', 0, 'conjurer_summon', player)
            event.entity.persistentData.putString('owner', player_username)
            if (!player.persistentData.get('soul_steal')) return
            let level = player.persistentData.soul_steal
            applyEffect(entity, 'alexsmobs:soulsteal', 'infinite', level, true, true)
        })

    })

/// Soul Siphon: give the player 5 mana when a Specter kills an enemy. 5 levels, 5 mana per level
// §aLevel 1: 5 mana
// §aLevel 2: 10 mana
// §aLevel 3: 15 mana
// §aLevel 4: 20 mana
// §aLevel 5: 25 mana
    EntityEvents.death(event => {
        if (!event.source.indirect) return
        if (!event.source.player) return
        if (event.source.immediate == null) return
        if (event.source.immediate.type != pet) return
        if (!event.source.toString().includes('blood_magic') && !event.source.toString().includes('evocation_magic') && !event.source.toString().includes('ice_magic')) return
        let player = event.source.player
        if (!player.persistentData.get('soul_siphon')) return
        let mana = 5*Number(player.persistentData.soul_siphon)
        Utils.server.runCommandSilent(`/mana add ${player.username} ${mana}`)
    })
})




// Consume ability: Press a key to kill all of your specters and have a chance to gain their buffs
function consumeSpecters(player) {
    if (!player.persistentData.get('consume')) return
    let level = player.persistentData.consume
    let specters = player.level.getEntities().filter(e => e.tags.contains(`conjured:${player.username}`) && e.tags.contains('tamed_beast') && e.potionEffects.isActive('kubejs:specter'));
    if (specters.length == 0) return;
    let chance = Math.random() * 100;
    if (chance > 20 * level) return; // 20% chance per level
    specters.forEach(specter => {
        specter.remove();
        player.potionEffects.add('irons_spellbooks:consumed_specter_buff', 600, level - 1, true, true);
    });
}



EntityEvents.hurt(event => {
    if (event.source == null) return;
    if (event.source.actual == null) return;
    if (!event.source.player) return;
    let player = event.source.player;
    if (!player.persistentData['scent_of_blood_active']) return;
    if (isSkillCoolingDown(player, 'scent_of_blood')) return;
    if (event.source.directEntity.tags.contains('tamed_beast')) return;
    if (!player.persistentData.get('scent_of_blood')) return;
    let method = determineMethod(event.source)
    if (method == 'melee') return;
    let level = player.persistentData.scent_of_blood;
    scent_of_blood(player, event.entity);
    
    
})



function scent_of_blood(player, target) {
    let level = player.persistentData.scent_of_blood;
    let allPets = player.level.entities.filter(entity => entity.tags.contains('tamed_beast') && entity.tags.contains(`Owner:${player.username}`))
    allPets.forEach(pet => {
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run tp ${pet.uuid} ${target.x} ${target.y} ${target.z}`)
        pet.setTarget(target)
        if (level >= 3) {
            Utils.server.runCommandSilent(`/effect give ${pet.uuid} minecraft:speed ${5*(level-2)} ${level-3} true`)
        }
        if (level >= 5) {
            Utils.server.runCommandSilent(`/effect give ${pet.uuid} kubejs:diversion ${5*(level-2)} ${level-3} true`)
        }
    })
    let cooldown = 1200 - (250 * (level - 1));
    addSkillCooldown(player, 'scent_of_blood', cooldown)
}

/**
 * Scent of Blood: Activate to teleport all of your beasts to the next enemy you hit. At level 3, they gain 4 seconds of speed.
 */
function scent_of_blood_ability(player) {
    if (!player.persistentData.get('scent_of_blood')) return;
    if (isSkillCoolingDown(player, 'scent_of_blood')) return;
    if (!player.persistentData['scent_of_blood_active']) {
        player.persistentData.putBoolean('scent_of_blood_active', true);
        player.tell(`§aScent of Blood activated`);
    } else {
        player.persistentData.putBoolean('scent_of_blood_active', false);
        player.tell(`§cScent of Blood deactivated`);
    }
}



/*
let scent_of_blood_cooldown = new WeakMap();
PlayerEvents.tick(event => {
    let player = event.player;
    if (!player.persistentData.get('scent_of_blood')) return;
    if (!player.tags.contains('scent_of_blood_cooldown')) return;
    let level = player.persistentData.scent_of_blood;
    let cd = 1200 - (250 * (level - 1)); // 1200 ticks - 250 ticks per level. At level 5 this will be 500 ticks
    if (scent_of_blood_cooldown[player.username] == undefined) {
        scent_of_blood_cooldown[player.username] = cd
    } else {
        scent_of_blood_cooldown[player.username]--;
    }

    if (scent_of_blood_cooldown[player.username] > 0) return;
    player.tags.remove('scent_of_blood_cooldown');
    scent_of_blood_cooldown[player.username] = cd
})
*/
