/**
 * Final Bloodripper:
 *  - The Bloodripper is a subclass that focuses on the player's ability to mark enemies for death and Using Blood Harvest enemies.
 * 
 * 
 * Abilities:
 *  - Rip and Tear: Right clicking on an enemy will Blood Harvest them under certain conditions
 *  1.) The enemy is less than 50% health
 *  2.) The enemy is marked for death (Marked for death is a debuff that the crow applies to enemies)
    3.) The Blood Harvest can chain to other enemies
 * 
 * 
 * 
 *  Symbiotic Ripper: Summons a Crow that follows the player around and marks enemies for death
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 *  1.) §4Blood Slash§7: Crow can cast §4Blood Slash§7 on enemies.
 *  -> 1: 1 §4Blood Slash§7. Low Chance
 *  -> 2: 2 §4Blood Slashes§7. Medium Chance
 *  -> 3: 3 §4Blood Slashes§7. High Chance
 * 
 *  2.) Marked for Death: Enemies hit by the crow are marked for death. 5 Levels:
 *  -> 1: Marked for death for 2 seconds
 *  -> 2: Marked for death for 3 seconds
 *  -> 3: Marked for death for 4 seconds
 *  -> 4: Marked for death for 5 seconds
 *  -> 5: Marked for death permanently
 * 
 *  3.) Cripple: Enemies hit by the crow are slowed. 5 Levels:
 *  -> 1: Slow with 0 amplifier for 2 seconds
 *  -> 2: Slow with 1 amplifier for 2 seconds
 *  -> 3: Slow with 1 amplifier for 3 seconds
 *  -> 4: Slow with 2 amplifier for 3 seconds
 *  -> 5: Slow with 2 amplifier for 4 seconds
 *  
 *  4.) Harvest: Using Blood Harvest an enemy heals you [REMOVED: Bloodripper already gets the lifesteal attribute causing this to double lifesteal]
 *  -> 1: 2% of max health
 *  -> 2: 4% of max health
 *  -> 3: 6% of max health
 *  -> 4: 8% of max health
 *  -> 5: 10% of max health
 * 
 * 
 * 5.) Rage: Activate to enter an insane rage state. 5 Levels: 
 *  -> Each level:
 *  -> Increases the duration of the rage state
 *  -> Increases the amplifier of the speed and haste potion effects
 *  -> Increases range of the Blood Harvest. 
 *  -> Decreases the cooldown of the rage state by 30 seconds. This number was picked so that at §aLevel 5 the cooldown is 3 minutes.
 * 
 * 
 * 
 * 
 */


// Random names for the crows. 
let crow_names = [
    'Bart',
    'Robert',
    'Tony',
    'Ralph',
    'Greg',
    'Manny',
    'Lenny',
    'Clint',
    'Don',
    'Walter',
    'Bruce',
    'Otis',
    'Randy',
    'Ricky',
    'Earl',
    'Herb',
    'Clyde',
    'Lyle',
    'Mort',
    'Moe',
    'Lloyd',
]






// Initialize subclass paint for player. Will be used for any other subclass that is added.

function initSubclassPaintBar(player,subclass) {
    let paint_data = {}
    paint_data[`${subclass}_bar`] = {
            type: 'rectangle',
            x: 110,
            y: 65, 
            w: 300, 
            h: 300, 
            draw: 'ingame',
            alignX: 'right', 
            alignY: 'bottom',
            texture: `kubejs:textures/level_rework/subclass/0.png`
    }
    player.paint(paint_data)
}
function initSubclassPaintSymbol(player, subclass, x, y) {
    let paint_data = {}
    paint_data[`${subclass}_symbol`] = {
        type: 'rectangle',
        x: x,
        y: y,
        w: 15,
        h: 15,
        draw: 'ingame',
        alignX: 'right',
        alignY: 'bottom',
        texture: `kubejs:textures/level_rework/subclass/${subclass}.png`
    }
    player.paint(paint_data)
}



function symbioticRipperEffects(player, crow) {
    // Symbiotic Ripper effects
    let symbiotic_ripper_effects = {
        1: 'minecraft:speed',
        2: 'runiclib:adrenaline',
        3: 'minecraft:strength',
        4: 'runiclib:berserk',
        5: 'minecraft:regeneration'
    }
    let level = player.persistentData.symbiotic_ripper
    for (let i = level; i > 0; i--) {
        applyEffect(crow, `${symbiotic_ripper_effects[i]}`, 'infinite', level - i)
    }
}


function bloodripperCrowInit(player, crow) {
    if (!player.persistentData.get('symbiotic_ripper')) return
    if (!crow) return
    let crow_names = [
    'Bart',
    'Robert',
    'Tony',
    'Ralph',
    'Greg',
    'Manny',
    'Lenny',
    'Clint',
    'Don',
    'Walter',
    'Bruce',
    'Otis',
    'Randy',
    'Ricky',
    'Earl',
    'Herb',
    'Clyde',
    'Lyle',
    'Mort',
    'Moe',
    'Lloyd',
    ]
    crow.setCustomName(`${crow_names[Math.floor(Math.random()*crow_names.length)]} The Bloodripper Crow`)
    player.persistentData.putString(`bloodripper_crow`, crow.uuid)
    crow.persistentData.putBoolean('isBloodripperCrow', true)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle alexscaves:black_vent_smoke ${crow.x} ${crow.y+1} ${crow.z} 0.05 0.05 0.05 0.01 5`)
    crow.playSound('minecraft:entity.wither.ambient', 0.2, 1.8)
    symbioticRipperEffects(player, crow)
    let level = player.persistentData.symbiotic_ripper
    if (level >= 3 && level < 5) {
        applySpellcasting(crow, ['blood'], 'superior')
    } else if (level >= 5) {
        applySpellcasting(crow, ['blood'], 'exalted')
    }
    return crow
}




function summonPetSpecial(player, mobid, effects, scales, level) {
    if (!player.persistentData.get('symbiotic_ripper')) return
    if (!player.persistentData.get('bloodripper_crow_count')) {player.persistentData.putInt('bloodripper_crow_count', 0)}
    if (player.persistentData.bloodripper_crow_count != 0) return
    // Create the pet entity
    let mod_id = mobid.split(':')[0]
    let mob_name = mobid.split(':')[1]
    let petData = all_pet_data[mob_name]
   // Utils.server.tell(petData)
    let creature = player.level.createEntity(petData.id); // Use the correct entity ID from petData
    let subclass = player.persistentData.subclass
    //Utils.server.tell(subclass)
    //Utils.server.tell(creature)
    creature.setPos(player.x, player.y, player.z);
    let creatureName = petData.id.split(':')[1];
    let username = player.username;
    let tier = petData.tier;
    
    let cleaned_name = mobid.split(':').pop().replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase())
    creature.mergeNbt({
        Owner: player.username,
        Tags: ['Owner:' + player.username, 'tamed_beast', subclass + `_${cleaned_name.toLowerCase()}`, 'bloodripper_crow'],
        Command: 1,
        PersistenceRequired: true
    })
    petsCheckAndSet(player, creature)
    creature.tags.add('bloodripper_crow')
    let capitalized_subclass = 'Bloodripper'
    // Pick a random name. Do 'Name' The Bloodripper Crow
    creature.setCustomName(`${crow_names[Math.floor(Math.random()*crow_names.length)]} The ${capitalized_subclass} ${cleaned_name}`)
    if (scales) {
        // get what entry the effect is in the array
        effects.forEach(effect => {
            let index = effects.indexOf(effect)
            Utils.server.runCommandSilent(`/effect give ${creature.uuid} ${effect} infinite ${level-index} false`)
            //creature.potionEffects.add(effect, 999999, level-index, true, true)
        })
    } else {
        effects.forEach(effect => {
            Utils.server.runCommandSilent(`/effect give ${creature.uuid} ${effect} infinite ${level-index} false`)
        })
    }
    player.persistentData.putString(`bloodripper_crow`, creature.uuid)

    creature.spawn();
    // detect if the creature has the tameCommand tag
    Utils.server.scheduleInTicks(5, () => {
        slotCheckAndSet(player, creature)
    })
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle alexscaves:black_vent_smoke ${creature.x} ${creature.y+1} ${creature.z} 0.05 0.05 0.05 0.01 5`)
    creature.playSound('minecraft:entity.wither.ambient', 0.2, 1.8)
    player.persistentData.putString(`bloodripper_crow`, creature.uuid)
    player.persistentData.putInt('bloodripper_crow_count', 1)
    
    




    Utils.server.scheduleInTicks(5, () => {
        creature.persistentData.putString('owner', username)
        applySchool(creature, 'blood')
        if (player.persistentData.symbiotic_ripper >= 3) {
            superiorMage(creature)
        }
        if (player.persistentData.symbiotic_ripper >= 5) {
            exaltedMage(creature)
        }

    })
    if (level == 0) {
        creature.maxHealth = tier * 5
        creature.health = tier * 5
    } else {
        creature.maxHealth = tier * 5 * level
        creature.health = tier * 5 * level
    }
}
//___________________________________________________________________________________________________________________________
//Blood Harvest Function
function blood_harvest(player, entity) {
    if (entity.player) return
    if (entity.tags.contains('boss')) return
    if (entity.tags.contains('tamed_beast')) return
    if (entity.tags.contains('blood_kill_4')) return

    let mult = 0

    if (!entity.tags.contains('blood_kill_1') && !entity.tags.contains('blood_kill_2') && !entity.tags.contains('blood_kill_3')) {
        tunnelVisionHandler(player, entity)
        let damage = entity.health
        addXP(player, entity, 3.5, 'vanguard', damage)
        // particle and sound effects
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:blood ${entity.x} ${entity.y+1} ${entity.z} 0.2 0.2 0.2 0.2 25 force @a`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexsmobs:fly_hurt ambient ${player.username} ${entity.x} ${entity.y+1} ${entity.z} 0.7 0.9`)
        
        moneyOnKill(player, entity)
        entity.kill()
        entity.tags.add('blood_kill_1')

        if (entity.potionEffects.isActive('minecraft:slowness') && player.persistentData.get('cripple')) {
            mult += 0.01
        }

    // Requires Blood Siphon to consume multple times
    } else if (entity.tags.contains('blood_kill_1') && !entity.tags.contains('blood_kill_2') && !entity.tags.contains('blood_kill_3') && player.persistentData.get('blood_siphon') && player.persistentData.blood_siphon >= 1) {
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:blood ${entity.x} ${entity.y} ${entity.z} 0.4 0.4 0.4 0.2 100 force @a`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexsmobs:fly_hurt ambient ${player.username} ${entity.x} ${entity.y+1} ${entity.z} 1 1.1`)
        entity.tags.add('blood_kill_2')

        if (entity.potionEffects.isActive('minecraft:slowness') && player.persistentData.get('cripple')) {
            mult += 0.01
        }


    } else if (entity.tags.contains('blood_kill_2') && !entity.tags.contains('blood_kill_3') && player.persistentData.get('blood_siphon') && player.persistentData.blood_siphon >= 2) {
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:blood ${entity.x} ${entity.y} ${entity.z} 0.7 0.7 0.7 1 250 force @a`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexsmobs:fly_hurt ambient ${player.username} ${entity.x} ${entity.y+1} ${entity.z} 1 1.5`)
        entity.tags.add('blood_kill_3')

        if (entity.potionEffects.isActive('minecraft:slowness') && player.persistentData.get('cripple')) {
            mult += 0.01
        }

    } else if (entity.tags.contains('blood_kill_3') && player.persistentData.get('blood_siphon') && player.persistentData.blood_siphon >= 3) {
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:blood ${entity.x} ${entity.y} ${entity.z} 1 1 1 2 500 force @a`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexsmobs:fly_hurt ambient ${player.username} ${entity.x} ${entity.y+1} ${entity.z} 1.5 2`)
        entity.tags.add('blood_kill_4')

        if (entity.potionEffects.isActive('minecraft:slowness') && player.persistentData.get('cripple')) {
            mult += 0.01
        }
    }

    if (player.persistentData.get('blood_siphon')) {
        let level = player.persistentData.blood_siphon
        if (entity.potionEffects.isActive('minecells:bleeding')) {
            mult += Number(0.01*level) * 1.25
        } else {
            mult += Number(0.01*level)
        }
        player.health += parseFloat(player.maxHealth) * mult
    }

        

    if (player.persistentData.get('rip_and_tear')) {
        let rip_and_tear_level = player.persistentData.rip_and_tear
        let radius = 3*rip_and_tear_level
        let duration = 5*rip_and_tear_level
        let amp = rip_and_tear_level-1
        let effect = 'minecells:bleeding'
        let count = 1
        if (rip_and_tear_level == 1) {
            count = 1
        } else if (rip_and_tear_level == 3) {
            count = 2
        } else if (rip_and_tear_level == 5) {
            count = 3
        }
        applyAoeEffect(player, radius, effect, duration*20, amp, count, true, 'red')
    }

    let curio = skillTotemCheck(player, 'blood_splatter')
    if (curio) {
        let level = curio
        let box = AABB.of(player.x+15, player.y+5, player.z+15, player.x-15, player.y-5, player.z-15)
        let dim = player.level
        let entitiesWithin = dim.getEntitiesWithin(box).filter(entity => entity.isMonster())
        entitiesWithin.forEach(ent => {
            let chance = 0.10 * level
            if (Math.random() < chance) {
                applyEffect(ent, 'minecells:bleeding', 200, 0, 'blood_splatter:bleed_effect', player)
            }
        })
    }

}

function instakillChain (player, entity, event) {
        if (!player.persistentData.get('rip_and_tear')) return
        // Does not work on players
        if (entity.player) return
        if (entity.tags.contains('blood_kill')) return
        if (entity.tags.contains('tamed_beast')) return
        // Does not work on entities with the boss tag
        if (entity.tags.contains('boss')) return
        // Only works on mobs under 50 health. Each level increases the max health of mobs
        if (entity.maxHealth > 50*player.persistentData.rip_and_tear) return
        // Only kill mobs at less than 50% health
        if (entity.health > entity.maxHealth*0.50) return
        
        // If the player's crow is dead, summon a new one
        let damage = entity.maxHealth*0.50
        addXP(player, entity, 0.1, 'vanguard', damage)
    
        // particle and sound effects
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:blood ${entity.x} ${entity.y} ${entity.z} 0.5 0.5 0.5 1 200 force @a`)
        entity.playSound('alexsmobs:fly_hurt')
    
        // Add the blood kill tag to prevent double harvesting
        entity.tags.add('blood_kill')
        entity.kill()
    // life steal relative to bloodripper level
    ///if (player.persistentData.get('harvest')) {
      //  player.health += player.maxHealth *(player.persistentData.harvest*0.02)
    //}
}

function instakillRage(player, entity, event) {
    if (!player.tags.contains('rage')) return
    // Does not work on players
    if (entity.player) return
    if (entity.tags.contains('blood_kill')) return
    // Does not work on entities with the boss tag
    if (entity.tags.contains('boss')) return
    entity.kill()
    let damage = entity.maxHealth*0.50
    addXP(player, entity, 0.1, 'vanguard', damage)
    // particle and sound effects
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:blood ${entity.x} ${entity.y} ${entity.z} 0.5 0.5 0.5 1 200 force @a`)
    entity.playSound('alexsmobs:fly_hurt')
    // Add the blood kill tag to prevent double harvesting
    entity.tags.add('blood_kill')
    let level = player.persistentData.rage
    let mult = 5
    let total = level*mult
    let box = AABB.of(player.x+total, player.y+total, player.z+total, player.x-total, player.y-total, player.z-total)
    let dim = player.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(entity => entity.isMonster())
    let counter = 0
    entitiesWithin.forEach(ent => {
        counter += 1
        Utils.server.scheduleInTicks(5*counter, event => {
            instakillChain(player, ent, event)
        })
    })
    // life steal relative to bloodripper level
    //if (player.persistentData.get('harvest')) {
     //   player.health += player.maxHealth *(player.persistentData.harvest*0.02)
    //}
}

function determineCrowEffects (player, level) {
    let crow_effects = []
    for (let i = level; i > 0; i--) {
        //crow_effects.push(symbiotic_ripper_effects[i])
    }
    return crow_effects
}



// Crow marks the target for death

/**
 * Cripple Ability
 * - Slows the enemy when hit by the crow
 * - Leveling it up increases the amplifier and duration of the slow
 *  */ 
EntityEvents.hurt(event => {
    if (event.source.actual == null) return
    if (event.entity.tags.contains('boss')) return
    if (event.source.actual.persistentData.get('isBloodripperCrow') != true) return
    //Utils.server.tell(event.source.actual))

    let player_username = event.source.actual.persistentData.get('owner')
    if (!player_username) return
    let player = event.server.getPlayer(player_username)
    if (!player) return
    // Marked for Death
    if (player.persistentData.get('marked_for_death')) {
        let level = player.persistentData.marked_for_death
        let chance = 0.15 * level
        let odds = Math.random()
        if (odds > chance) return
        let time = 40*level
        if (level == 5) {
            time = 'infinite'
        } else {
            time = time/20
        }
        Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} kubejs:marked_for_death ${time} 0 false`)
    }

    // Cripple
    if (!player.persistentData.get('cripple')) return
    let level = player.persistentData.cripple
    applyEffect(event.entity, 'minecraft:slowness', 40*level, level-1)
})

//___________________________________________________________________________________________________________________________
/**
 * Symbiotic Ripper:
 *  - §aLevel 1: Summons a crow that follows the player around. Applies speed to the crow
 *  - §aLevel 2: Crow gets diversion effect. This gives the crow a chance to dodge attacks
 *  - §aLevel 3: Crow can mark enemies for death. Gives the crow a strength effect
 *  - §aLevel 4: Crow gets berserk effect. This increases the crows attack damage the lower its health is
 *  - §aLevel 5: Your Bloodripper Crow spawns with a permanent Regeneration effect
 */


//___________________________________________________________________________________________________________________________

/**
 * Rip and Tear: Right clicking on an enemy will Blood Harvest them under certain conditions
 * - Each level increases the max health of mobs that can be Blood Harvested. At §aLevel 4+ each level increases the range of the Blood Harvest chain
 *  1: Right click enemies with less than 50% health and less than 50 max health
 *  2: Summons a new crow when you Blood Harvest an enemy. Also increases the max health of enemies that can be Blood Harvested
 *  3: Blood Harvest can chain to other enemies
 *  4: Increases the range of the Blood Harvest and max number of enemies that can be Blood Harvested
 *  5: Increases the range of the Blood Harvest and max number of enemies that can be Blood Harvested
 * 
 */


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.player) return
    if (!event.source.player.persistentData.get('rip_and_tear')) return
    let level = event.source.player.persistentData.rip_and_tear
    let mult = Number(0.25 + (0.05*(level-1)))
    //tell(`${event.entity.health} ${event.entity.maxHealth * mult} `)
    if (Number(event.entity.health) > parseFloat(event.entity.maxHealth) * parseFloat(mult)) return
    let chance = Math.random()
    let odds = 0.20 + (0.10*(level-1))
    //tell(`Chance: ${chance.toFixed(2)} Odds: ${odds.toFixed(2)}`)
    if (chance > odds) return
    Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} kubejs:marked_for_death 10 0 false`)
})

EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.entity.potionEffects.isActive('kubejs:marked_for_death')) return
    if (!event.source.player.persistentData.get('rip_and_tear')) return
    let player = event.source.player
    let level = player.persistentData.rip_and_tear
    let count = 1
    // Count is 1 at level 1, 2 at level 3, 3 at level 5
    if (level == 1) {
        count = 1
    } else if (level == 3) {
        count = 2
    } else if (level == 5) {
        count = 3
    }
    let radius = 3*level
    let duration = 5*level
    let amp = level-1
    let effect = 'minecells:bleeding'
    applyAoeEffect(player, radius, effect, duration*20, amp, count, true, 'red')
})







ItemEvents.entityInteracted(event => {
    let player = event.player
    let entity = event.target
    if (event.target.type == 'dummmmmmy:target_dummy') return
    if (!player.persistentData.get('blood_harvest')) return
    if (!entity.potionEffects.isActive('kubejs:marked_for_death')) return

    // Check if rage is active
    if (!player.tags.contains('rage')) {

        player.swing()
        blood_harvest(player, entity)
        let level = player.persistentData.blood_harvest
        let range = 5 * level
        let box = AABB.of(player.x+range, player.y+range, player.z+range, player.x-range, player.y-range, player.z-range)
        let dim = event.level
        // Only get entities that are monsters and have the minecells:bleeding potion effect
        let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.isMonster() && ent.potionEffects.isActive('minecells:bleeding') && ent != event.target && !isAlly(player, ent))
        let counter = 0
        let cap = level * 2
        entitiesWithin.forEach(ent => {
            if (counter <= cap) {
                counter += 1
                Utils.server.scheduleInTicks(6*counter, e => {
                    blood_harvest(player, ent)
                })
            }
        })
    } else {
        instakillRage(player, entity, event)

    }
})


//___________________________________________________________________________________________________________________________
// Rage




/*
let rage_cooldown = new WeakMap()
PlayerEvents.tick(event => {
    let player = event.player
    if (!player.persistentData.get('rage')) return
    let level = player.persistentData.rage
    let cd = 6000-(600*(level-1))
    if (player.tags.contains('rage_cooldown')) {
        if (rage_cooldown[player.username] == undefined) {
            rage_cooldown[player.username] = cd
        } else {
            rage_cooldown[player.username]--
        }
        if (rage_cooldown[player.username] <= 0) {
            player.tags.remove('rage_cooldown')
            rage_cooldown[player.username] = cd
            //paint_ability(player, 'rage', 'rage')
        }
    } else {
        return
    }
    
})
*/


function rage_ability(player) {
    if (player.tags.contains('rage')) return
    if (!player.persistentData.rage) return
    if (isSkillCoolingDown(player, 'rage')) return
    //Utils.server.tell(player.persistentData.rage)
    Utils.server.runCommandSilent(`execute as ${player.username} run playsound alexsmobs:dropbear_hurt ambient @s ${player.x} ${player.y} ${player.z} 10 1`)
    player.tags.add('rage')
    let cd = 200*player.persistentData.rage
    player.potionEffects.add('irons_spellbooks:planar_sight', cd, 0)
    player.potionEffects.add('irons_spellbooks:hastened', cd, 1+player.persistentData.rage)
    player.potionEffects.add('minecraft:darkness', cd, 0)
    let level = player.persistentData.rage
    // Cooldown for the rage state. Decreases by 30 seconds per level
    Utils.server.scheduleInTicks(200*level, e => {
        player.tags.remove('rage')
        Utils.server.runCommandSilent(`/sanity set ${player.username} 100`)
        let cooldown = 6000-(600*(level-1))
        addSkillCooldown(player, 'rage', cooldown)
        //hide_ability(player, 'rage')
    })
}

PlayerEvents.respawned(event => {
    event.player.tags.remove('rage')
 })








EntityEvents.death('alexsmobs:crow', event => {
    if (!event.entity.tags.contains('tamed_beast')) return
    if (event.entity.persistentData.get('isBloodripperCrow') != true) return
    let owner_username = event.entity.persistentData.get('owner')
    let player = event.server.getPlayer(owner_username)
    if (!player) return
    if (!player.persistentData.get('blood_pact')) return
    let level = player.persistentData.blood_pact;
    let odds = 0.1 + ((level-1)*0.05); // 10% chance + 5% chance per level
    if (Math.random() > odds) return // if the random number is greater than the
    let radius = 2 * level
    let box = AABB.of(event.entity.x + radius, event.entity.y + radius, event.entity.z + radius, event.entity.x - radius, event.entity.y - radius, event.entity.z - radius);
    let dim = event.level;
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.tags.contains('boss') && !isAlly(player, ent))
    let dur = 100 + ((level-1)*25)
    let entity = event.entity
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:blood ${entity.x} ${entity.y+1} ${entity.z} 0.2 0.2 0.2 0.05 50 force @a`)    
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexsmobs:fly_hurt ambient ${player.username} ${entity.x} ${entity.y+1} ${entity.z} 0.9 0.9`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.ambient ambient ${player.username} ${event.entity.x} ${event.entity.y} ${event.entity.z} 0.2 1.5`)
    
    entitiesWithin.forEach(ent => {
        applyEffect(ent, 'minecells:bleeding', dur, level, true, true)
    })
})



// Blood Frenzy
// Killing a monster with a critical hit has a 15% chance to  give you a blood charge.
// Enemies that are bleeding are instantly killed when you have a Blood Charge and they are hit with a thrown weapon. Max Blood charges is equal to your level
// Cooldown. Killing bleeding enemies reduces the cooldown


EntityEvents.death(event => {
    if (!event.source.player) return
    if (!wasCrit(event.source.player)) return
    if (!event.entity.isMonster()) return
    if (!event.source.player.persistentData.get('blood_fever')) return
    if(isSkillCoolingDown(event.source.player, 'blood_fever')) return
    let level = event.source.player.persistentData.blood_fever
    let chance = 0.15 + ((level-1)*0.10)
    let odds = Math.random()
    if (odds > chance) return
    let cap = event.source.player.persistentData.blood_fever
    let player = event.source.player
    if (event.source.player.potionEffects.isActive('kubejs:blood_charge')) {
        applyStackingEffect(player, 'kubejs:blood_charge', 'infinite', 1, 'Blood Frenzy charge', player, cap)
    } else {
        applyEffect(player, 'kubejs:blood_charge', 'infinite', 0)
    }
})



EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    if (!event.entity.isMonster()) return
    if (!event.source.player.persistentData.get('blood_fever')) return
    if(isSkillCoolingDown(event.source.player, 'blood_fever')) return
    if (!event.source.player.potionEffects.isActive('kubejs:blood_charge')) return
    //if (!event.entity.potionEffects.isActive('minecells:bleeding')) return
    let level = event.source.player.persistentData.blood_fever
    if (!levelBetterProjectileCheck(level, event, 'throwable', 3, 5)) return
    blood_harvest(event.source.player, event.entity)
    let amp = event.source.player.potionEffects.getActive('kubejs:blood_charge').amplifier
    Utils.server.runCommandSilent(`/effect clear ${event.source.player.username} kubejs:blood_charge`)
    addSkillCooldown(event.source.player, 'blood_fever', 400)
    if (Number(amp) === 0) return
    applyEffect(event.source.player, 'kubejs:blood_charge', 'infinite', amp-1)
})



EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.entity.isMonster()) return
    if (!event.entity.potionEffects.isActive('minecells:bleeding')) return
    if (!event.source.player.persistentData.get('blood_fever')) return
    if(!isSkillCoolingDown(event.source.player, 'blood_fever')) return
    let level = event.source.player.persistentData.blood_fever
    let player = event.source.player
    let cd = 20
    if (level > 2) {
        cd = 40
    }
    if (level >= 5) {
        cd = 60
    }
    reduceSkillCooldown(player, 'blood_fever', cd)
})


