


//___________________________________________________________________________________________________________________________


/**
 * 
 * /**
 * Fimbulwinter: Hitting an entity with a thrown item has a chance to freeze the enemy for a short duration. Killing a frozen enemy gives the player bonus effects
 *  - Leveling up: increases the chance of freezing the enemy, increases the duration of the freeze, and increases the bonus effects
 * 
 * §aLevel 1: 10% chance, speed boost
 * §aLevel 2: 15% chance, speed boost, jump boost
 * §aLevel 3: 20% chance, speed boost, jump boost, slow falling
 * §aLevel 4: 25% chance, speed boost, jump boost, slow falling, haste
 * §aLevel 5: 30% chance, speed boost, jump boost, slow falling, haste, and a chance to freeze nearby enemies
 * 



let fimbulwinter = {
    1: ['minecraft:speed'],
    2: ['minecraft:speed', 'minecraft:jump_boost'],
    3: ['minecraft:speed', 'minecraft:jump_boost', 'minecraft:slow_falling'],
    4: ['minecraft:speed', 'minecraft:jump_boost', 'minecraft:slow_falling', 'minecraft:haste'],
    5: ['minecraft:speed', 'minecraft:jump_boost', 'minecraft:slow_falling', 'minecraft:haste']
}

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    let player = event.source.player
    if (!player.persistentData.get('fimbulwinter')) return
    let level = player.persistentData.fimbulwinter
    let entity = event.entity
    if (player.blockStateOn.block != 'Block{minecraft:air}') return   
    if (!event.source.immediate.type.includes('throw')) return

    // 10% base chance + 5% per level
    let chance = 10 + 5*level
    if (Math.random() * 100 > chance) return
    let duration = 40*level
    entity.potionEffects.add('mowziesmobs:frozen', duration)
    entity.tags.add('fimbulwinter_enemy')
    Utils.server.scheduleInTicks(duration, () => {
        entity.tags.remove('fimbulwinter_enemy')
    })
})


EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('fimbulwinter')) return
    if (!event.entity.tags.contains('fimbulwinter_enemy')) return
    let level = player.persistentData.fimbulwinter
    let effects = fimbulwinter[level]
    let amplifier = level - 2
    if (amplifier < 0) amplifier = 0
    effects.forEach(effect => {
        player.potionEffects.add(effect, 40*level, amplifier)
    })
    if (level != 5) return
    let range = 3*level
    let box = AABB.of(player.x+range, player.y+range, player.z+range, player.x-range, player.y-range, player.z-range)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent.isMonster()) {
            // 20% chance to freeze nearby enemies
            if (Math.random() * 100 > 20) return
            let duration = 40*level
            ent.potionEffects.add('mowziesmobs:frozen', duration)
            ent.tags.add('fimbulwinter_enemy')
            Utils.server.scheduleInTicks(duration, () => {
                ent.tags.remove('fimbulwinter_enemy')
            })
        }
    })
        
})





EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    let player = event.source.player
    if (!player.persistentData.get('yggdrasil')) return
    let entity = event.entity
    if (entity.tags.contains('primed')) return
    if (!entity.tags.contains('prime_hit_1')) {
        entity.tags.add('prime_hit_1')
        Utils.server.scheduleInTicks(20, () => {
            entity.tags.remove('prime_hit_1')
        })
        return
    } else {
        entity.tags.remove('prime_hit_1')
        entity.tags.add('primed')
        player.persistentData.putInt('primed_damage', event.damage)
        Utils.server.scheduleInTicks(40, () => {
            entity.tags.remove('primed')
            player.persistentData.remove('primed_damage')
        })
    }
})

ItemEvents.entityInteracted(event => {
    if (!event.player.persistentData.get('yggdrasil')) return
    if (!event.target.tags.contains('primed')) return
    let player = event.player
    let entity = event.target
    if (entity.tags.contains('primed2')) return
    if (player.shiftKeyDown) {
        if (!player.persistentData.get('skofnung')) return
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle aether:passive_whirlwind ${entity.x} ${entity.y} ${entity.z} 0.5 0.5 0.5 1 100`)
        entity.playSound(`alexsmobs:guster_hurt`, 1, 2)
        entity.teleportRelative(0, 2, 0)
        entity.potionEffects.add('irons_spellbooks:antigravity', 30, 0, true, true)
        entity.tags.remove('primed')
        entity.tags.add('primed2')
        Utils.server.scheduleInTicks(35, () => {
            entity.tags.remove('primed2')
        })
    } else {
        if (!player.persistentData.get('tyrfing')) return
        entity.attack(player.persistentData.primed_damage*2)
        event.target.playSound('alexsmobs:fly_hurt', 1, 1)
        //Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle biomesoplenty:falling_blood ${event.target.x} ${event.target.y} ${event.target.z} 0.2 0.2 0.2 4 100 force`)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:blood ${event.target.x} ${event.target.y+1} ${event.target.z} 0.5 0.5 0.5 0.5 100 force @a`)
        entity.tags.remove('primed')
        if (player.persistentData.tyrfing < 2) return
        entity.potionEffects.add('minecraft:slowness', 20*player.persistentData.tyrfing, 1)
        if (player.persistentData.tyrfing < 3) return
        entity.potionEffects.add('alexscaves:stunned', 40, 1)
        entity.potionEffects.add('minecells:stunned', 40, 1)
    }
})

EntityEvents.hurt(event => {
    if (!event.entity.tags.contains('primed2')) return
    if (event.entity.tags.contains('primed')) return
    if (!event.source.player) return
    let entity = event.entity
    let player = event.source.player
    if (event.source.indirect) {
        if (!event.source.immediate.type.includes('throw')) return
        //if (!player.persistentData.get('yggdrasil')) return
        if (!player.persistentData.get('mjolnir')) return
        let level = player.persistentData.mjolnir 
        // loop equal to the level
        for (let i = 0; i < level; i++) {
            event.level.spawnLightning(entity.x, entity.y, entity.z, false)
        }
        entity.tags.remove('primed2')
    } else {
        if (!player.persistentData.get('gungnir')) return
        //loop 30 times
        for (let i = 0; i < 40; i++) {
            event.source.player.push(event.entity)
        }
        entity.playSound('minecells:weapon.frost_blast.release', 1, 1)
        Utils.server.runCommandSilent(`execute in ${event.level.dimension} run particle bosses_of_mass_destruction:soul_flame ${entity.x} ${entity.y+1} ${entity.z} 0.1 0.1 0.1 0.5 100 force`)
        entity.tags.remove('primed2')
        entity.tags.add('primed3')
        //Utils.server.tell(`Primed3`)
        Utils.server.scheduleInTicks(70, () => {
            entity.tags.remove('primed3')
            //Utils.server.tell(`Primed3 removed`)
        })
        if (player.persistentData.gungnir < 2) return
        entity.potionEffects.add('alexscaves:stunned', 60, 1)
        entity.potionEffects.add('minecells:stunned', 60, 1)
        if (player.persistentData.gungnir < 3) return
        entity.potionEffects.add('irons_spellbooks:rend', 70, player.persistentData.gungnir-3)
    }
})

EntityEvents.hurt(event => {
    if (!event.entity.tags.contains('primed3')) return
    if (event.entity.tags.contains('primed2')) return
    if (event.entity.tags.contains('primed')) return
    if (!event.source.player) return
    if (event.source.indirect) {
        if (!event.source.immediate.type.includes('throw')) return
        let player = event.source.player
        let entity = event.entity
        if (player.persistentData.get('gleipnir')) {
            let level = player.persistentData.gleipnir
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run cast ${player.username} flaming_strike ${level}`)
        }
        if (!player.persistentData.get('nidhogg')) return
        Utils.server.scheduleInTicks(8, () => {
            Utils.server.runCommandSilent(`/execute as ${player.username} run tp ${player.username} ${entity.x-1} ${entity.y} ${entity.z} facing ${entity.x} ${entity.y} ${entity.z}`)
        })
        event.entity.tags.remove('primed3')
        if (player.persistentData.nidhogg != 2) return
        player.potionEffects.add('minecraft:strength', 60, player.persistentData.nidhogg-2)
        if (player.persistentData.nidhogg != 3) return
        event.entity.tags.add('primed')
    }
})


 * 
 * 
 * 
 */
//____________________________________________________________________________________________________________________________



/**
 * Berserker Rework
 * 
 * All about being empowered while being surrounded
 * 
 * Ability: Skofnung
 * - Hitting a monster with a projectile while you are low on health will blast all nearby enemies backwards // 
 * - Each level increases the amount of health the player must be below to trigger the effect // 
 * - If the hit enemy has a §b[Runic Charge]§7, it has a chance to give §b[Runic Charges]§7 to all other enemies that get blasted back. Chance is 8% per level and is run per enemy
 * - Range increases with level. 3 blocks per level
 * 
 * 
 * Ability:
 * - Gain a strength effect based on how many enemies you are surrounded by //
 * - every 3 enemies you get 1 level of strength // 
 * 
 * 
 * 
 * Ability: //
 * - Activate this ability and crouch throw your projectile to teleport the enemies to you
 * 
 * Ability: // 
 * - Landing an attack on an enemy has a chance to add a 5 second §b[Runic Charge]§7
 * - 5% chance per level
 * - Gain abilities based on the number of enemies that have §b[Runic Charges]§7
 * 
 * 
 * Ability:
 * - Press a key to kill all enemies with rune charges and consume the charges to gain a haste effect based on the number of charges consumed //
 * 
 * 
 * 
 *  * Tyrfing:
 * - Dealing damage to an entity has a chance to give it a §b[Runic Charge]§7
 * - Each level increases the chance of giving a §b[Runic Charge]§7
 * * Level 1: 10% chance
 * * Level 2: 15% chance
 * * Level 3: 20% chance
 * * * Level 4: 25% chance
 * * * Level 5: 30% chance
 * 
 * 
 * 
 *  * Skofnung:
 * - Hitting an entity with a thrown item while you are below a certain health threshold will blast nearby enemies backwards
 * - Each level increases the health threshold, how close enemies need to be for them to be blasted back, and the strength of the blast
 * - If the enemy hit by the projectile has a §b[Runic Charge]§7, it has a chance to give §b[Runic Charges]§7 to all other enemies that get blasted back
 * 
 * 
 * Level 1: Below 15% health, 3 block radius, 8% chance to give §b[Runic Charge]§7
 * Level 2: Below 20% health, 6 block radius, 16% chance to give §b[Runic Charge]§7
 * Level 3: Below 25% health, 9 block radius, 24% chance to give §b[Runic Charge]§7
 * Level 4: Below 30% health, 12 block radius, 32% chance to give §b[Runic Charge]§7
 * Level 5: Below 35% health, 15 block radius, 40% chance to give §b[Runic Charge]§7
 * 
 * 
 * 
 *  * Gungnir:
 * - Gain effects based on how many enemies you are surrounded by
 * - Each enemy near you gives you a point, enemies with a §b[Runic Charges]§7 give you 2 points
 * 
 * Level 1: Gain 1 level of Lesser Strength for every 3 Points
 * Level 3: Gain 1 level of Hastened for every 4 Points
 * Level 5: Gain 1 level of soul steal for every 5 enemies and 1 level
 * 
 * 
 * 
 * 
 *  * Mjolnir:
 *  - Does not work on bosses
 *  - Press a key to teleport all enemies to you. 
 *  - Enemies with §b[Runic Charges]§7 are struck by lightning and killed which consumes the §b[Runic Charges]§7
 *  - Gain shock charges equal to §b[Runic Charges]§7 consumed.
 *  - Shock Charges make it so Projectiles strike enemies with lightning.
 *  - At Level 3, gain the thunderstorm ability if you consume 5 §b[Runic Charges]§7. Each level reduces the amount of §b[Runic Charges]§7 needed by 1 and increases the power of the thunderstorm ability
 *  - At level 5, thunderstorm hits have a chance to give §b[Runic Charges]§7 to enemies they hit.
 *  - 2 minute cooldown. Each level reduces the cooldown by 15 seconds
 * 
 * 
 * 
 * 
 * 
 */



/**
 * Tyrfing:
 * - Dealing damage to an entity has a chance to give it a §b[Runic Charge]§7
 * - Each level increases the chance of giving a §b[Runic Charge]§7
 * * Level 1: 10% chance
 * * Level 2: 15% chance
 * * Level 3: 20% chance
 * * * Level 4: 25% chance
 * * * Level 5: 30% chance
 */
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('tyrfing')) return
    let level = player.persistentData.tyrfing
    if (event.entity.potionEffects.isActive('kubejs:runic_charge')) {
        let proj = levelBetterProjectileCheck(level, event, 'throwable', 3, 5)
        if (!proj) return
        let sunbeam = event.level.createEntity('irons_spellbooks:sunbeam')
        let uuid = getAltUUID(player)
        sunbeam.setPos(event.entity.x, event.entity.y, event.entity.z)
        sunbeam.mergeNbt({
            Owner: uuid,
            Damage: 5*level,
            Radius: 5*level,
        })
        sunbeam.spawn()
        Utils.server.scheduleInTicks(5, () => {
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run teleport ${sunbeam.uuid} ${event.entity.x} ${event.entity.y} ${event.entity.z}`)
        })
    } else {
        let method = determineMethod(event.source)
        if (method != 'melee') return
        let chance = 5 + (5*level)
        if (event.entity.onFire) {
            chance *= 2 // If the entity is on fire, double the chance
        }
        //if (Math.random() * 100 > chance) return
        applyEffect(event.entity, 'kubejs:runic_charge', 3*level*20, 0, 'tyrfing', player)
    }

})



/**
 * Skofnung:
 * - Hitting an entity with a thrown item while you are below a certain health threshold will blast nearby enemies backwards
 * - Each level increases the health threshold, how close enemies need to be for them to be blasted back, and the strength of the blast
 * - If the enemy hit by the projectile has a §b[Runic Charge]§7, it has a chance to give §b[Runic Charges]§7 to all other enemies that get blasted back
 * 
 * 
 * Level 1: Below 15% health, 3 block radius, 8% chance to give §b[Runic Charge]§7
 * Level 2: Below 20% health, 6 block radius, 16% chance to give §b[Runic Charge]§7
 * Level 3: Below 25% health, 9 block radius, 24% chance to give §b[Runic Charge]§7
 * Level 4: Below 30% health, 12 block radius, 32% chance to give §b[Runic Charge]§7
 * Level 5: Below 35% health, 15 block radius, 40% chance to give §b[Runic Charge]§7
 * 
 * 
 * 
 */
EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('skofnung')) return
    let proj = physicalProjectileCheck(event.source)
    if (!proj) return
    let player = event.source.player
    let level = player.persistentData.skofnung
    if (!event.entity.potionEffects.isActive('kubejs:runic_charge')) return

    let range = 5 * level
    let box = AABB.of(player.x+range, player.y+range, player.z+range, player.x-range, player.y-range, player.z-range)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && !ent.tags.contains('boss') && ent.isAlive && ent.pickable)
    if (entitiesWithin.length == 0) return
    Utils.server.runCommandSilent(`/execute in ${dim.dimension} run playsound traveloptics:blast_stage_two ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1`)
    Utils.server.runCommandSilent(`/effect clear ${event.entity.uuid} kubejs:runic_charge`)

    entitiesWithin.forEach(ent => {
        // Loop
        ent.potionEffects.add('minecraft:levitation', 2, 30, true, true)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:ring_smoke ${ent.x.toFixed(2)} ${ent.y.toFixed(2)+1} ${ent.z.toFixed(2)} 0 0 0 0.1 3`)
        Utils.server.scheduleInTicks(1, () => {
            for (let i = 0; i < 30*level; i++) {
                player.push(ent)
            }
        })
        if (Math.random() * 100 < 10*level) {
            ent.potionEffects.add('kubejs:runic_charge', 100, 0, true, true)
            global.applyGlow(ent, 'light_blue', 100)
        }
    })
})



/**
 * Gungnir:
 * - Gain effects based on how many enemies you are surrounded by
 * - Each enemy near you gives you a point, enemies with a §b[Runic Charge]§7 give you 2 points
 * 
 * Level 1: Gain 1 level of Lesser Strength for every 3 Points
 * Level 3: Gain 1 level of Hastened for every 4 Points
 * Level 5: Gain 1 level of soul steal for every 5 enemies
 * 
 */
PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 != 0) return
    if (!event.player.persistentData.get('gungnir')) return
    let player = event.player
    let level = player.persistentData.gungnir
    let range = 5 * level
    let box = AABB.of(player.x+range, player.y+2, player.z+range, player.x-range, player.y-2, player.z-range)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && !ent.tags.contains('boss') && ent.isAlive && ent.pickable && ent.isMonster())
    if (entitiesWithin.length == 0) return
    let points = 0
    entitiesWithin.forEach(ent => {
        if (ent.potionEffects.isActive('kubejs:runic_charge')) {
            points += 2
        } else {
            points += 1
        }
        // +1 Strength per 3 enemies
        let str_amp = 1 - (Math.floor(points / 3))
        let hastened_amp = 1 - (Math.floor(points / 4))
        let soul_amp = 1 - (Math.floor(entitiesWithin.length / 5))
        player.potionEffects.add('runiclib:lesser_strength', 80+(20*level), str_amp, true, true)
        if (level >= 3) {
            player.potionEffects.add('irons_spellbooks:hastened', 80+(20*(level-3)), hastened_amp, true, true)
        }
        if (level >= 5) {
            player.potionEffects.add('alexsmobs:soulsteal', 80, soul_amp, true, true)
        }
    })

})



/**
 * Mjolnir:
 *  - Does not work on bosses
 *  - Press a key to teleport all enemies to you. 
 *  - Enemies with §b[Runic Charges]§7 are struck by lightning and killed which consumes the §b[Runic Charges]§7
 *  - Gain shock charges equal to §b[Runic Charges]§7 consumed.
 *  - Shock Charges make it so Projectiles strike enemies with lightning.
 *  - At Level 3, gain the thunderstorm ability if you consume 5 §b[Runic Charges]§7. Each level reduces the amount of §b[Runic Charges]§7 needed by 1 and increases the power of the thunderstorm ability
 *  - At level 5, thunderstorm hits have a chance to give §b[Runic Charges]§7 to enemies they hit.
 *  - 2 minute cooldown
 * 
 * 
 * 
 */


function mjolnir_ability(player) {
    if (!player.persistentData.get('mjolnir')) return
    if (isSkillCoolingDown(player, 'mjolnir')) return
    let level = player.persistentData.mjolnir
    let radius = 5 * level
    let box = AABB.of(player.x+radius, player.y+radius, player.z+radius, player.x-radius, player.y-radius, player.z-radius)
    let dim = player.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && ent.isAlive && ent.pickable && !ent.tags.contains('boss') && ent.isMonster())
    if (entitiesWithin.length == 0) return
    let mjolnirCooldown = 2400 - (300 * (level - 1))
    addSkillCooldown(player, 'mjolnir', mjolnirCooldown)
    let charges = 0
    entitiesWithin.forEach(ent => {
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run tp ${ent.uuid} ${player.x} ${player.y} ${player.z}`)
        Utils.server.scheduleInTicks(10, () => {
            if (ent.potionEffects.isActive('kubejs:runic_charge')) {
                player.level.spawnLightning(ent.x, ent.y, ent.z, true)
                charges += 1
                ent.kill()
            }
            
        })
    })
    Utils.server.scheduleInTicks(15, () => {
        if (charges == 0) return
        Utils.server.runCommandSilent(`/effect give ${player.username} kubejs:shock_charge infinite ${charges-1} false`)

        if (level >= 3 && charges >= 5 - (level - 3)) {
            player.potionEffects.add('irons_spellbooks:thunderstorm', 100 * (level - 3), level-3, true, true)
        }
    })

}


/*
let mjolnir_cooldown = new WeakMap();
PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('mjolnir')) return;
    if (!event.player.tags.contains('mjolnir_cooldown')) return;
    let player = event.player;
    let level = player.persistentData.mjolnir;
    let cd = 2400 - (300 * (level - 1)); //2400
    if (mjolnir_cooldown[player.username] == undefined) {
        mjolnir_cooldown[player.username] = cd
    } else {
        mjolnir_cooldown[player.username]--
    }

    if (mjolnir_cooldown[player.username] > 0) return
    player.tags.remove('mjolnir_cooldown');
    mjolnir_cooldown[player.username] = cd;
})
*/



EntityEvents.hurt(event => {
    if (!event.entity.isMonster()) return
    if (!event.source.player) return
    if (!event.source.player.potionEffects.isActive('irons_spellbooks:thunderstorm')) return
    let player = event.source.player
    if (!player.persistentData.get('mjolnir')) return
    if (event.source.immediate.type != 'irons_spellbooks:lightning_strike') return
    let level = player.persistentData.mjolnir
    if (level < 5) return
    // 25% chance to give §b[Runic Charge]§7 to the entity
    let chance = 0.25
    if (Math.random() > chance) return
    event.entity.potionEffects.add('kubejs:runic_charge', 100, 0, false, false)
    global.applyGlow(event.entity, 'light_blue', 100)
})



/**
 * Fimbulwinter:
 * 
 * - Enemies hit by ranged attacks have a 15% chance to cast Icicles at other nearby enemies. 
 * - Enemies hit by a ray of frost are chilled and have a chance to be frozen. 
 * - Level 5 Killing a frozen enemy gives nearby chilled enemies a §b[Runic Charge]§7 and consumes the chill effect.
 */

/**
 * EntityEvents.hurt(event => {
    if (!event.source.player) return
    let method = determineMethod(event.source) 
    if (method != 'ranged') return
    if (!event.source.player.persistentData.get('fimbulwinter')) return
    let player = event.source.player
    let level = player.persistentData.fimbulwinter
    let chance = 10 + (5 * level) // 10% base chance + 5% per level
    if (Math.random() * 100 > chance) return
    // loop equal to the level
    for (let i = 0; i < level; i++) {
        Utils.server.scheduleInTicks(i*10, () => {
            castAtOtherMobs(event, 'icicle', 1, 5*level, 3*level)
        })
    }
    if (level < 2) return
    let radius = 5 * level
    let box = AABB.of(player.x+radius, player.y+radius, player.z+radius, player.x-radius, player.y-radius, player.z-radius)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && ent.isAlive && ent.pickable && !ent.tags.contains('boss') && ent.isMonster())
    if (entitiesWithin.length == 0) return
    entitiesWithin.forEach(ent => {
        ent.potionEffects.add('cofh_core:chilled', 100*(level-1), level-1, true, true)
        ent.tags.add(`fimbulwinter_enemy:${player.username}`)
    })
})


EntityEvents.hurt(event => {
    if (!event.entity.isMonster()) return
    if (!event.source.toString().includes('ice_magic')) return
    if (!event.entity.tags.toString().includes('fimbulwinter_enemy')) return
    let player_username = event.entity.tags.toString().match(/fimbulwinter_enemy:(\w+)/)[1]
    let player = Utils.server.getPlayer(player_username)
    if (!player.persistentData.get('fimbulwinter')) return
    let level = player.persistentData.fimbulwinter
    if (level < 3) return
    event.entity.tags.remove(`fimbulwinter_enemy:${player_username}`)
    let chance = 0.10 + (0.05 * (level-2))
    if (Math.random() > chance) return
    event.entity.potionEffects.add('mowziesmobs:frozen', 80*level, level-1, true, true)
    event.entity.tags.add(`fimbulwinter_frozen`)
    Utils.server.scheduleInTicks(80*level, () => {
        event.entity.tags.remove(`fimbulwinter_frozen`) 
    })
})

EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('fimbulwinter')) return
    if (!event.entity.tags.toString().includes('fimbulwinter_frozen')) return
    let level = event.source.player.persistentData.fimbulwinter
    if (level < 5) return
    let radius = 5 * level
    let box = AABB.of(event.entity.x+radius, event.entity.y+radius, event.entity.z+radius, event.entity.x-radius, event.entity.y-radius, event.entity.z-radius)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => !ent.tags.contains('boss') && ent.isMonster())
    if (entitiesWithin.length == 0) return
    entitiesWithin.forEach(ent => {
        if (ent.potionEffects.isActive('cofh_core:chilled')) {
            Utils.server.runCommandSilent(`/effect clear ${ent.uuid} cofh_core:chilled`)
            Utils.server.runCommandSilent(`/effect give ${ent.uuid} kubejs:runic_charge 10 0 false`)
        }
    })
})
 * 
 * 
 * 
 * 
 */


// New fimbulwinter: 
// Projectiles have a 15% chance to apply chilled. If they have a Mark of Yggdrasil, the chill effect lasts 2x longer

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('fimbulwinter')) return
    let player = event.source.player
    let method = determineMethod(event.source)
    if (method != 'ranged') return
    let level = player.persistentData.fimbulwinter
    let chance = 0.10 + (0.05 * level) // 10% base chance + 5% per level
    if (Math.random() > chance) return
    let dur = 60 * level
    if (event.entity.potionEffects.isActive('kubejs:mark_of_yggdrasil')) {
        dur = dur * 2
    }
    applyEffect(event.entity, 'cofh_core:chilled', dur, level, 'fimbulwinter', player)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecells:weapon.frost_blast.release ambient ${event.entity.uuid} ${event.entity.x} ${event.entity.y} ${event.entity.z} 1 1`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:snowflake ${event.entity.x} ${event.entity.y+1} ${event.entity.z} 0.5 0.5 0.5 0.2 50`)

})









/**
 * Gleipnir:
 * - Killing a burning enemy has a chance to give you a dread charge.
 *  -> [Dread Charges] are a buff that lets you see enemies through walls.
 *  -> Hitting an enemy while you have [Dread Charges] will consume the charge and stack 2 levels of Wither and Weakness on the enemy.
 * - Each level increases the chance of giving a dread charge
 * - Level 1: 15% chance
 * 
 * 
 * 
 */


EntityEvents.death(event => {
    if (!event.source.player) return
    if (event.entity.remainingFireTicks > 0) return
    if (!event.source.player.persistentData.get('gleipnir')) return
    let level = event.source.player.persistentData.gleipnir
    let player = event.source.player
    let chance = 10 + (5 * level) // 10% base chance + 5% per level
    if (Math.random() * 100 > chance) return
    let quantity = level
    applyEffect(player, 'kubejs:shock_charge', 'infinite', quantity-1, 'gleipnir', player)
})




/**
 * Yggdrasil:
 *  - Level 1: Melee attacks have a chance to apply Mark of Yggdrasil to your target for 20 seconds, +5 seconds per level. 
 *  - Non-melee attacks have a chance to cause all enemies with the Mark of Yggdrasil to cast a firebolt at the target
 *  - Level 3: Blaze Storm is cast instead of Firebolt
 * 
 */

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('yggdrasil')) return
    let method = determineMethod(event.source)
    if (method != 'melee') return
    let player = event.source.player
    let level = player.persistentData.yggdrasil
    let chance = 10 + (5 * level) // 10% base chance + 5% per level
    if (event.entity.isOnFire) {
        chance *= 2 // If the entity is on fire, double the chance
    }
    if (Math.random() * 100 > chance) return
    event.entity.potionEffects.add('kubejs:mark_of_yggdrasil', 400+((level-1)*100), 0, true, true)
    event.entity.tags.add(`yggdrasil_target:${player.username}`)
})


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('yggdrasil')) return
    if (!classifyDamageSource(event.source, 'melee', false)) return
    let level = event.source.player.persistentData.yggdrasil
    let chance = 15 + (5 * level) // 15% base chance + 5% per level
    if (Math.random() * 100 > chance) return
    let entities = event.level.entities.filter(ent => ent.isMonster() && ent.potionEffects.isActive('kubejs:mark_of_yggdrasil') && ent != event.entity)
    if (entities.length == 0) return
    entities.forEach(ent => {
        let spells = []
        if (level >= 3) {
            spells.push('blaze_storm')
        } else {
            spells.push('firebolt')
        }
        castSpell(ent, spells, event.entity, level, 1, 'Yggdrasil cast')
        //randomCast(ent, spells, event.entity, level)
    })
})
        







/**
 * Nidhogg:
 *  - Level 1: Nearby enemies are set on fire when enemies with Wither that are killed with Fire Magic from an enemy with the Mark of Yggdrasil
 *  - Level 3: Enemies that are hit by a firebolt from an enemy with the Mark of Yggdrasil have a chance to get a §b[Runic Charge]§7
 * -  Level 5 (Max Level): Killing an enemy with the Mark of Yggdrasil has a chance to give you a Rage Charge
 */


EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('nidhogg')) return
    if (!event.entity.potionEffects.isActive('kubejs:mark_of_yggdrasil')) return
    let player = event.source.player
    let level = player.persistentData.nidhogg
    let chance = 0.10 * level // 10% chance per level
    if (Math.random() > chance) return
    let ticks = 100 * level
    applyEffect(player, 'gtbcs_geomancy_plus:solar_storm', ticks, 0, 'nidhogg', player)
})


// Rewritten bloodlust: fenrir
// 1.) Hitting an entity will give you a stacking haste effect
// 2.) If you are hit equal times as 1 + your fenrir level you will lose your haste effect


let fenrir_hit_counter = new WeakMap()
let fenrir_hurt_counter = new WeakMap()
let fenrir_countdown = new WeakMap()


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (isAlly(event.source.player, event.entity)) return
    let player = event.source.player
    if (!player.persistentData.get('fenrir')) return
    let level = player.persistentData.fenrir
    let hit = 1
    if (event.entity.potionEffects.isActive('kubejs:runic_charge')) {
        hit = 2 // if the entity has a runic charge, it counts as 2 hits
    }
    if (fenrir_hit_counter[player.username] == undefined) {
        fenrir_hit_counter[player.username] = hit
    } else {
        fenrir_hit_counter[player.username] += hit
    }
    fenrir_countdown[player.username] = 5
    if (fenrir_hit_counter[player.username] > 3 * level) fenrir_hit_counter[player.username] = 3 * level
    player.potionEffects.add('minecraft:haste', 100, fenrir_hit_counter[player.username]-1, true, true)    
})

EntityEvents.hurt(event => {
    if (!event.entity.player) return
    if (event.source == null) return
    if (event.source.actual == null) return
    let player = event.entity.player
    if (!player.persistentData.get('fenrir')) return
    let level = player.persistentData.fenrir
    if (fenrir_hurt_counter[player.username] == undefined) {
        fenrir_hurt_counter[player.username] = 1
    } else {
        fenrir_hurt_counter[player.username] += 1
    }
    if (fenrir_hurt_counter[player.username] < level) return
    fenrir_hurt_counter[player.username] = 0
    if (fenrir_hit_counter[player.username] == undefined) {
        fenrir_hit_counter[player.username] = 0
    } else {
        fenrir_hit_counter[player.username] = 0
    }
    Utils.server.runCommandSilent(`/effect clear ${player.username} minecraft:haste`) 
})


EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('fenrir')) return
    let player = event.source.player
    if (fenrir_hit_counter[player.username] == undefined || fenrir_hit_counter[player.username] == 0) return
    // stacks equal fenrir/3 
    let stacks = Math.floor(fenrir_hit_counter[player.username] / 3)
    if (stacks == 0) return
    applyEffect(player, 'kubejs:shock_charge', 'infinite', stacks-1, 'fenrir', player)
})





PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 != 0) return
    if (!event.player.persistentData.get('fenrir')) return
    if (fenrir_hit_counter[event.player.username] == undefined || fenrir_hit_counter[event.player.username] == 0) return
    let player = event.player
    if (fenrir_countdown[player.username] == undefined) {
        fenrir_countdown[player.username] = 5
    } else {
        fenrir_countdown[player.username] -= 1
    }
    if (fenrir_countdown[player.username] > 0) return
    fenrir_countdown[player.username] = 5
    fenrir_hit_counter[player.username] = 0
    Utils.server.runCommandSilent(`/effect clear ${player.username} minecraft:haste`)
})






/***
 * Gjallarhorn: Gives aoe effects to nearby allies. You can swap them by shift + H
 *  - §aLevel 1: Jump Boost, 5 block radius
 *  - §aLevel 2: Berserk, 10 block radius
 * - §aLevel 3: Adrenaline, 15 block radius
 */

let gjallarhorn = {
    1: [
        'minecraft:jump_boost',
    ],
    2: [
        'runiclib:berserk',
    ],
    3: [
        'runiclib:adrenaline'
    ],
}

let gjallarhorn_icons = {
    1: 'jump_boost',
    2: 'berserk',
    3: 'adrenaline',
}


let gjallarhorn_map = new WeakMap()

function gjallarhorn_ability (player) {
    if (gjallarhorn_map[player.username] == undefined) {
        gjallarhorn_map[player.username] = 1
    } else {
        gjallarhorn_map[player.username] += 1
    }
    if (gjallarhorn_map[player.username] > Object.keys(gjallarhorn).length) {
        gjallarhorn_map[player.username] = 1
    }
    if (gjallarhorn_map[player.username] > player.persistentData.gjallarhorn) {
        gjallarhorn_map[player.username] = 1
    }

    // tell the player what ability they have selected
    let icon = gjallarhorn_icons[gjallarhorn_map[player.username]]
    paint_ability_cycle(player, icon, 'gjallarhorn')


    Utils.server.runCommandSilent(`/execute at ${player.username} run playsound irons_spellbooks:spell.scorch.prepare ambient ${player.username} ~ ~ ~ 1 2`)
    let current_gjallarhorn = Object.keys(gjallarhorn)[gjallarhorn_map[player.username]-1]
    player.persistentData.putInt('current_gjallarhorn', current_gjallarhorn)

}





// Use a plain object, not a WeakMap
let gjallarhorn_countdown = {};    // { playerName: ticksRemaining }

// Every tick, apply effects when countdown hits zero
PlayerEvents.tick(event => {
    let player = event.player;
    if (!player.persistentData.get('gjallarhorn')) return;

    // Use player name (or UUID) as key
    let pname = player.name ? player.name.string : player.toString();
    
    // Initialize or decrement
    if (gjallarhorn_countdown[pname] === undefined) {
        gjallarhorn_countdown[pname] = 25;
    } else {
        gjallarhorn_countdown[pname]--;
    }
    // When it hits zero, reapply and reset
    if (gjallarhorn_countdown[pname] <= 0) {
        // Get the string you stored earlier
        let currentKey = player.persistentData.getInt('current_gjallarhorn');
        // Look up your effects array
        let effects = gjallarhorn[currentKey];
        if (Array.isArray(effects)) {
            let level = player.persistentData.getInt('gjallarhorn');
            let range = 5 * level;
            let box = AABB.of(
                player.x + range, player.y + range, player.z + range,
                player.x - range, player.y - range, player.z - range
            );
            
            let entitiesWithin = player.level.getEntitiesWithin(box);
            entitiesWithin.forEach(ent => {
                if (isAlly(player, ent) || ent == player) {
                    effects.forEach(effect => {
                        ent.potionEffects.add(effect, 40, 0, true, true);
                    });
                }
            });
        }
        // Reset countdown
        gjallarhorn_countdown[pname] = 25;
    }
});
