

// Warpath: 4% chance to cast a spell for free. Scales up with each level
// §aLevel 1: 4% chance
// §aLevel 2: 8% chance
// §aLevel 3: 12% chance
// §aLevel 4: 16% chance
// §aLevel 5: 20% chance
PlayerEvents.spellOnCast(event => {
    if (!event.player.persistentData.get('war_path')) return
    let level = event.player.persistentData.war_path
    let chance = Math.random() * 100
    if (chance > 4 *level) return
    event.setManaCost(0)
})


// Battle Fever: Kill 10 entities to gain a Hastened effect. Amount of enemies killed scales with level, charged effect scales with level
// §aLevel 1: 10 kills for 5 seconds of Hastened 1
// §aLevel 2: 9 kills for 10 seconds of Hastened 2
// §aLevel 3: 8 kills for 15 seconds of Hastened 3
// §aLevel 4: 7 kills for 20 seconds of Hastened 4
// §aLevel 5: 6 kills for 25 seconds of Hastened 5
let battle_fever_map =new WeakMap()
EntityEvents.death(event => {
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('battle_fever')) return
    if (!event.entity.isMonster()) return
    if (event.source.player.tags.contains('battle_fever_active')) return
    let level = event.source.player.persistentData.battle_fever
    let player = event.source.player
    if (battle_fever_map[player.username] == undefined) {
        battle_fever_map[player.username] = 1
    } else {
        battle_fever_map[player.username] += 1
    }
    if (battle_fever_map[player.username] < 10-(level-1)) return
    event.source.player.potionEffects.add('irons_spellbooks:hastened', 100*level, 1+level)
    player.tags.add('battle_fever_active')
    battle_fever_map[player.username] = 0
    Utils.server.scheduleInTicks(100*level, () => {
        player.tags.remove('battle_fever_active')
    })
})



/**
 * jupiters gift: 
 *  When you are below 25% health: 
 *  1.) gain a resistance effect for 10 seconds*level. When you are hit, add to a counter equal to the level. 
 *  2.) After the resistance effect ends, give thunderstorm effect for 1 seconds times the counter. Scales with level
 *  3. 3 minute cooldown. Each level reduces the cooldown by 12 seconds
 *  
 *  - §aLevel 1: 1 second of thunderstorm per hit, 3 minute cooldown
 *  - §aLevel 2: 2 seconds of thunderstorm per hit, 2 minute 48 second cooldown
 *  - §aLevel 3: 3 seconds of thunderstorm per hit, 2 minute 36 second cooldown
 *  - §aLevel 4: 4 seconds of thunderstorm per hit, 2 minute 24 second cooldown
 *  - §aLevel 5: 5 seconds of thunderstorm per hit, 2 minute 12 second cooldown
 * */ 
    
EntityEvents.hurt('player', event => {
    let player = event.entity
    if (!player.persistentData.get('jupiters_gift')) return
    let level = player.persistentData.jupiters_gift
    if (isSkillCoolingDown(player, 'jupiters_gift')) return
    let health = player.health
    let maxHealth = player.maxHealth
    let percent = health / maxHealth
    if (percent > 0.25) return
    player.potionEffects.add('minecraft:resistance', 200*level, level)
    player.tags.add('jupiters_gift_active')
    Utils.server.scheduleInTicks(200*level, () => {
        player.tags.remove('jupiters_gift_active')
        let counter = jupiter_map[player.username]
        player.potionEffects.add('irons_spellbooks:thunderstorm', (20 + ((level-1)*10))*counter, level)
        jupiter_map[player.username] = 0
        let cooldown = level == 5 ? 1800 : 3600 - ((level-1)*480)
        addSkillCooldown(player, 'jupiters_gift', cooldown)
    })
})

/*
let jupiterCooldown = new WeakMap();
PlayerEvents.tick(event => {
    let player = event.player;
    if (!player.persistentData.get('jupiters_gift')) return;
    if (!player.tags.contains('jupiter_cooldown')) return;
    let level = player.persistentData.jupiters_gift;
    let cd = 3600 - ((level-1)*480)
    if (player.persistentData.jupiters_gift == 5) {
        cd = 1800
    }

    if (jupiterCooldown[player.username] == undefined) {
        jupiterCooldown[player.username] = cd; 
    } else {
        jupiterCooldown[player.username] -= 1;
    }
    if (jupiterCooldown[player.username] <= 0) {
        jupiterCooldown[player.username] = cd;
        player.tags.remove('jupiter_cooldown');
    }
})
*/



let jupiter_map =new WeakMap()
EntityEvents.hurt('player', event => {
    if (!event.entity.tags.contains('jupiters_gift_active')) return
    let player = event.entity
    if (jupiter_map[player.username] == undefined) {
        jupiter_map[player.username] = 1
    } else {
        jupiter_map[player.username] += 1
    }
})

// Carnage: Kill 10 entities to gain a Charged effect. Amount of enemies killed scales with level, charged effect scales with level
// §aLevel 1: 10 kills for 5 seconds of Charged 1
// §aLevel 2: 9 kills for 10 seconds of Charged 2
// §aLevel 3: 8 kills for 15 seconds of Charged 3
// §aLevel 4: 7 kills for 20 seconds of Charged 4
// §aLevel 5: 6 kills for 25 seconds of Charged 5
let carnage_map =new WeakMap()
EntityEvents.death(event => {
    if (!event.entity.isMonster()) return
    if (!event.source.player) return
    if (event.source.player.tags.contains('carnage_active')) return
    if (!event.source.player.persistentData.get('carnage')) return
    let level = event.source.player.persistentData.carnage
    let player = event.source.player
    if (carnage_map[player.username] == undefined) {
        carnage_map[player.username] = 1
    } else {
        carnage_map[player.username] += 1
    }
    if (carnage_map[player.username] < 10-(level-1)) return
    event.source.player.potionEffects.add('irons_spellbooks:charged', 100*level, 1+level)
    player.tags.add('carnage_active')
    carnage_map[player.username] = 0
    Utils.server.scheduleInTicks(100*level, () => {
        player.tags.remove('carnage_active')
    })
})




/**
 * Arcane Synergy: If both Battle Fever and Carnage are active, gain a 5% chance per level that monsters will cast the spell around them at other monsters
 * - Level 1: 5% chance. 3 enemies affected in a 5 block radius
 * - Level 2: 10% chance. 6 enemies affected in a 10 block radius
 * - Level 3: 15% chance. 9 enemies affected in a 15 block radius
 * - Level 4: 20% chance. 12 enemies affected in a 20 block radius
 * - Level 5: 25% chance. 15 enemies affected in a 25 block radius
 */
EntityEvents.hurt(event => {
    if (!event.source || !event.source.player) return;
    if (!event.entity.isMonster()) return;
    if (event.source.immediate == null) return;
    if (event.source.immediate.nbt.contains('Summoner')) return;
    let player = event.source.player;
    let isSpell = isSpellDamageSource(event.source);
    if (!isSpell) return;
    if (!player.persistentData.get('arcane_synergy')) return;
    if (!player.tags.contains('battle_fever_active') || !player.tags.contains('carnage_active')) return;
    // Let the chance that it will apply be 5% times the player's order level
    let level = player.persistentData.arcane_synergy;
    let chance = 5 * Number(level);
    if (Math.random() * 100 > chance) return;
    let x = event.entity.getX();
    let y = event.entity.getY();
    let z = event.entity.getZ();
    let coords = 5+(5*level);
    let box = AABB.of(x + coords, y + 2, z + coords, x - coords, y - 2, z - coords);
    let dim = event.level;
    let entitiesWithin = dim.getEntitiesWithin(box).filter(e => !isAlly(player, e));
    // Add the initial enemy to the list and tag them
    let count = 0;
    let enemies = [];
    entitiesWithin.forEach(ent => {
        if (ent.isMonster()) {
            if (count > level*3) return;
            count++;
            enemies.push(ent)
        }
    });
    if (enemies.length == 0) return;
    enemies.forEach((enemy, index) => {
        let nextEnemy = enemies[index + 1];
        if (!nextEnemy) return;
            let spell = player.persistentData.getString('last_spell').split(':')[1]
            let spells = [spell]
            Utils.server.scheduleInTicks(3*index, () => {
                castSpell(enemy, spells, nextEnemy, level, 1, `arcane_synergy_${spell}`)
                //newCast(enemy, spells, nextEnemy, level, `arcane_synergy_${spell}`)
            })
    })
})


PlayerEvents.spellOnCast(event => {
    let spellID = event.spellId
    event.player.persistentData.putString('last_spell', spellID)
})






// Battle Echoes: Infinite Echoing Strikes. Enemies hit by Echoing Strikes will regenerate 1 mana per level for the player
// Level 1: Regenerate 1 mana per enemy hit
// Level 2: Regenerate 2 mana per enemy hit
// Level 3: Regenerate 3 mana per enemy hit
// Level 4: Regenerate 4 mana per enemy hit
// Level 5: Regenerate 5 mana per enemy hit




function battle_echoes_ability (player) {
    let p = player
    if (!p.persistentData.get('battle_echoes')) return
    let active = p.persistentData.getInt('battle_echoes_active')
    p.persistentData.putInt('battle_echoes_active', active == 1 ? 0 : 1)
    if (p.persistentData.getInt('battle_echoes_active') == 1) {
        p.tell('Battle Echoes: §aActivated§r')
    } else {
        p.tell('Battle Echoes: §cDeactivated§r')
    }
}


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    if (event.source.immediate == null) return
    if (event.source.immediate.type != 'irons_spellbooks:echoing_strike') return
    if (!event.source.player.persistentData.get('battle_echoes')) return
    let level = event.source.player.persistentData.battle_echoes
    let mana = level
    Utils.server.runCommandSilent(`/mana add ${event.source.player.username} ${mana}`)
    Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} kubejs:hexed ${level*2} ${level-1} true`)
})


PlayerEvents.tick(event => {
    if (event.server.tickCount % 100 != 0) return
    if (!event.player.persistentData.get('battle_echoes')) return
    if (event.player.persistentData.getInt('battle_echoes_active') != 1) return
    let level = event.player.persistentData.battle_echoes
    let box = AABB.of(event.player.x - 15, event.player.y - 3, event.player.z - 15, event.player.x + 15, event.player.y + 3, event.player.z + 15)
    let entitiesWithin = event.level.getEntitiesWithin(box).filter(e => e.pickable && isAlly(event.player, e, true))
    entitiesWithin.forEach(entity => {
        applyEffect(entity, 'irons_spellbooks:echoing_strikes', 120, level-1, 'battle_echoes')
    })
})


/**
 * Spellbreaker Slam: Hitting an enemy with a shield will knock them back and stun them for a short duration. Crouch while bashing to consume 50 mana, apply the Hexed effect, and increase the power of the stun
 * * §aLevel 1: 0.5 seconds of stun, Charged Bash Cost: 50 mana
 * * §aLevel 2: 1 second of stun, Charged Bash Cost: 45 mana
 * * * §aLevel 3: 1.5 seconds of stun, Charged Bash Cost: 40 mana
 * * * §aLevel 4: 2 seconds of stun, Charged Bash Cost: 35 mana
 * * * §aLevel 5: 2.5 seconds of stun, Charged Bash Cost: 30 mana
 */

// §aLevel 1
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('spellbreaker_slam')) return
    let player = event.source.player
    let level = player.persistentData.spellbreaker_slam
    if (!event.source.player.mainHandItem.id.includes('shield')) return
    let shield = player.mainHandItem
    if (player.cooldowns.isOnCooldown(shield)) {
        event.cancel()
        return
    }
    player.cooldowns.addCooldown(shield, 100)


    let loops = 20
    // Increase stun per level
    let ticks = 0
    if (event.entity.tags.contains('boss')) {
        ticks = 5*level
    } else if (event.entity.tags.contains('player')) {
        ticks = 5*level
    } else {
        ticks = 10*level
    }
    
    let mana = player.magicData.getMana()
    let cost = 50 - ((level - 1) * 5)
    //tell(mana)
    if (player.crouching && mana >= cost) {
        applyStackingEffect(event.entity, 'kubejs:hexed', 40*level, 1)
        ticks = ticks*2
        loops = loops*2
        event.source.player.magicData.setMana(event.source.player.magicData.getMana() - cost)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound irons_spellbooks:cast.generic.blood ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
    }
    applyEffect(event.entity, 'levitation', 2, 20, true, true)
    for (let i = 0; i < loops; i++) {
        player.push(event.entity)
    }
    
    applyEffect(event.entity, 'alexscaves:stunned', ticks, 1)
    applyEffect(event.entity, 'minecells:stunned', ticks, 1)

})



// Arcane Might: Gain a stacking lesser strength effect after hitting an enemy with a spell
// §aLevel 1: 1 extra damage for 40 ticks
// §aLevel 2: 2 extra damage for 80 ticks
// §aLevel 3: 3 extra damage for 120 ticks
// §aLevel 4: 4 extra damage for 160 ticks
// §aLevel 5: 5 extra damage for 200 ticks
EntityEvents.death(event => {
    if (!event.entity.isMonster()) return
    if (!event.source.player) return
    if (!event.source.player.persistentData.get('arcane_might')) return
    let level = event.source.player.persistentData.arcane_might
    let player = event.source.player
    if (player.cooldowns.isOnCooldown('kubejs:arcane_might_ability')) return
    let check = isSpellDamageSource(event.source)
    if (!check) return
    let str = level
    let dur = 40*level
    applyStackingEffect(player, 'runiclib:lesser_strength', dur, str)
    player.cooldowns.addCooldown('kubejs:arcane_might_ability', 5)
})
