
/**
 * 
 * ItemEvents.rightClicked('kubejs:beastmaster', event => {
    event.player.paint({
        beastmaster_xp: {
            type: 'rectangle',
            x: 130,
            y: 110, 
            w: 290, 
            h: 290, 
            draw: 'ingame',
            alignX: 'right', 
            alignY: 'bottom',
            texture: `kubejs:textures/summoner_leveling/beastmaster0.png`
        },
        beastmaster_symbol: {
            type: 'rectangle',
            x: -8,
            y: -70, 
            w: 15, 
            h: 15, 
            draw: 'ingame',
            alignX: 'right', 
            alignY: 'bottom',
            visible: 'true',
            texture: `kubejs:textures/item/order/beastmaster.png`
        },
    })
    if (event.player.persistentData.get('activated_beastmaster_classes')) return
    event.player.persistentData.putInt('activated_beastmaster_classes', 0)
})
 */



let class_object = {
    main_classes : {
        // Add from the main_class_peristent_data
        warlock: {
            commands: [
                
            ],
            persistentData: {
                warlock_boss_damage_counter: 0,
                warlock_xp: 0,
                warlock_level: 1
            },
            pet: 'alexsmobs:tarantula_hawk'
        },
        vanguard: {
            commands: [
                
            ],
            persistentData: {
                vanguard_boss_damage_counter: 0,
                vanguard_xp: 0,
                vanguard_level: 1
            },
            pet: 'alexsmobs:grizzly_bear'
        },
        shaman: {
            commands: [
                
            ],
            persistentData: {
                shaman_kill_counter: 0,
                shaman_hurt_counter: 0,
                shaman_boss_damage_counter: 0,
                shaman_xp: 0,
                shaman_level: 1
            },
            pet: 'alexsmobs:capuchin_monkey'
        },
        ranger: {
            commands: [
                
            ],
            persistentData: {
                ranger_projectile_counter: 0,
                valkyrie_combo: 0,
                ranger_xp: 0,
                ranger_level: 1
            },
            pet: 'alexsmobs:bald_eagle'
        },
        beastmaster: {
            commands: [
                
            ],
            persistentData: {
                beastmaster_xp: 1000,
                beastmaster_level: 1
            },
            pet: 'alexsmobs:komodo_dragon'
        }
    },
    subclasses : {
        // Add from the subclass_object
        guardian: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'irons_spellbooks:holy_spell_power' : 1.05,
                'irons_spellbooks:cooldown_reduction' : 1.05,
                'irons_spellbooks:max_mana' : 150,
                

            },
            persistentData: {

            },
            commands: [

            ],
            synergy: [
                'warlock',
                'ranger'
            ],
            tree_level: 33
        },
        battlemage: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'irons_spellbooks:spell_power' : 1.05,
                'irons_spellbooks:cooldown_reduction' : 1.05,
                'irons_spellbooks:max_mana' : 150,
                
            },
            persistentData: {

            },
            commands: [
                
            ],
            synergy: [
                'warlock',
                'vanguard'
            ],
            tree_level: 30
        },
        conjurer: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'irons_spellbooks:cooldown_reduction' : 1.05,
                'irons_spellbooks:max_mana' : 150,
                'irons_spellbooks:summon_damage': 1.30,
                
            },
            persistentData: {

            },
            commands: [
                
            ],
            synergy: [
                'warlock',
                'shaman'
            ],
            tree_level: 60
        },
    //_________________________________________________________________________________________
        disciple: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'attributeslib:current_hp_damage': 0.02,
                'irons_spellbooks:cooldown_reduction': 1.2,
                'irons_spellbooks:fire_spell_power': 1.10,
                
            },
            persistentData: {
            },
            commands: [
                
            ],
            synergy: [
                'warlock',
                'vanguard'
            ],
            tree_level: 30
        },
        kensei: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'attributeslib:draw_speed': 1.3,
                'attributeslib:crit_chance': 0.08,
                'attributeslib:armor_pierce': 0.10,
                
            },
            persistentData: {

            },
            commands: [
                //'/execute as @p run aircombo set 4 @p'
            ],
            synergy: [
                'vanguard',
                'ranger',
            ],
            tree_level: 39
        },
        berserker: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'attributeslib:arrow_velocity': 1.20,
                'attributeslib:arrow_damage': 1.05,
                'miapi:generic.projectile_accuracy': 1.10,
                
            },
            persistentData: {

            },
            commands: [
                `/execute as @p run curios set charm @p 3`
            ],
            synergy: [
                'vanguard',
                'shaman'
            ],
            tree_level: 32
        },
    //_________________________________________________________________________________________
        mercenary: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'attributeslib:armor_shred': 0.10,
                'attributeslib:arrow_velocity': 1.10,
                'attributeslib:arrow_damage': 1.10,
                
            },
            persistentData: {

            },
            commands: [
                
            ],
            synergy: [
                'vanguard',
                'shaman',
            ],
            tree_level: 58
        },
        mystic: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'attributeslib:arrow_velocity': 1.20,
                'miapi:generic.projectile_accuracy': 2,
                'attributeslib:arrow_damage': 1.10,
            },
            persistentData: {

            },
            commands: [
                //'/execute as @p run aircombo set 6 @p',
                '/execute at @p run skillslots level set @p 4'
            ],
            synergy: [
                'ranger',
                'shaman'
            ],
            tree_level: 25
        },
        frostpiercer: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'puffish_attributes:player.knockback': 1.10,
                'attributeslib:draw_speed': 1.05,
                'obscure_api:regeneration': 0.5,
                

            },
            persistentData: {
                
            },
            commands: [
                //'/execute as @p run aircombo set 5 @p'
            ],
            synergy: [
                'warlock',
                'ranger',
            ],
            tree_level: 37
        },
    //_________________________________________________________________________________________
        nomad: {
            attributes: {
                'minecraft:generic.max_health': 25,
                'additional_attributes:fishing_luck': 0.5,
                'minecraft:generic.movement_speed': 0.102,
                'minecraft:generic.luck': 1,
                
            },
            persistentData: {
            },
            commands: [
                
            ],
            synergy: [
                'ranger',
            ],
            tree_level: 26
        },
        /**
         *         shinobi: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'feathers:feathers.feather_regen': 1.3,
                'attributeslib:dodge_chance': 1
            },
            persistentData: {
                shinobi_cooldown: 10,
                shinobi_combo: 1,
                shinobi_counter: 0,
                bald_eagle_unlocked: 1
            },
            commands: [
                
            ],
            synergy: [
                'ranger',
                'shaman'
            ]
        },
         * 
         */

        bloodripper: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'attributeslib:armor_pierce': 0.10,
                'attributeslib:prot_pierce': 0.10,
                'attributeslib:life_steal': 0.03,
                

            },
            persistentData: {

            },
            commands: [
                
            ],
            synergy: [
                'vanguard',
                'shaman'
            ],
            tree_level: 35
        },
    //_________________________________________________________________________________________
        dragonlord: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'attributeslib:crit_damage': 1.6,
                'attributeslib:crit_chance': 0.15,
                'irons_spellbooks:fire_spell_power': 1.10,
                
            },
            persistentData: {
                dragonlord_counter: 0
            },
            commands: [
                
            ],
            synergy: [

            ],
            tree_level: 223
        },
        soulbinder: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'attributeslib:armor_pierce': 0.10,
                'attributeslib:armor_shred' : 0.10,
                'attributeslib:crit_chance': 0.10,
                
            },
            persistentData: {
                soulbinder_counter: 0,
                max_pets: 3
            },
            commands: [
                
            ],
            synergy: [

            ],
            tree_level: 223
        },
        plague_doctor: {
            attributes: {
                'minecraft:generic.max_health': 20,
                'attributeslib:current_hp_damage': 0.02,
                'obscure_api:regeneration': 0.5,
                'attributeslib:dodge_chance': 0.03,
            },
            persistentData: {

            },
            commands: [
                
            ],
            synergy: [

            ],
            tree_level: 38
        },
        juggernaut: {
            tree_level: 25,
            persistentData: {

            },
            commands: [
                
            ],
            synergy: [

            ],
        }
    }
}


ItemEvents.rightClicked(`kubejs:class_loot_box`, event => {
    if (!event.player.persistentData.get('subclass_chosen')) {
        event.player.tell(Text.of([Text.of(`You must choose a Class first.`).gold()]))
        return
    }
    let subclass_name = event.player.persistentData.subclass
    let player = event.player
    Utils.server.runCommandSilent(`/execute at ${event.player.username} run loot spawn ~ ~1 ~ loot minecraft:loot_boxes/${subclass_name}`)
    Utils.server.scheduleInTicks(4, () => {
        Utils.server.runCommandSilent(`execute as ${player.username} run playsound kubejs:gambleend ambient @s ${player.x} ${player.y} ${player.z} 1 1.3`)
    })
    Utils.server.scheduleInTicks(8, () => {
        Utils.server.runCommandSilent(`execute as ${player.username} run playsound kubejs:gambleend ambient @s ${player.x} ${player.y} ${player.z} 1 1.6`)
    })
    Utils.server.scheduleInTicks(12, () => {
        Utils.server.runCommandSilent(`execute as ${player.username} run playsound kubejs:gambleend ambient @s ${player.x} ${player.y} ${player.z} 1 1.9`)
    })
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:spark 0 0.5 0 ${player.x} ${player.y+1} ${player.z} 0.5 0.5 0.5 0.25 150 force ${player.username}`)
    Utils.server.runCommandSilent(`execute as ${player.username} run playsound soulsweapons:posture_break ambient @s ${player.x} ${player.y} ${player.z} 1 1.2`)
    event.item.count -= 1; // Remove the loot box item from the player's inventory
})

const class_first_unlock = {
    'bloodripper': 'm31y1d34ugjog6e2', // Rip and Tear
    'guardian': '0obrqtqwf6f7gkkb', // Sanctified
    'disciple': 'jfvyfat76hc9ujls', // Flaming Shadows
    'berserker': 'v2l1gbwoz2nhtt38', // Fimbulwinter
    'battlemage': 'drplwpdtmo3j194o', // War path
    'nomad': 'nq5r8av12fqnlxv4', // Avarice
    'mercenary': '2kpdhejrwdlnn9jd', // Sentinel
    'kensei': 'zqsbzptq6nr5e4zs', // Viper
    'frostpiercer': 'sx5130pxmys84be5', // Frozen Shackles
    'mystic': 'eyt5h7jwjfx63ygb', // Cyclone
    'plague_doctor': 'x5huaczmmkr8lqrb', // Verminlord
    'conjurer': 'b67vjfylvvyd31b0', // Soul Siphon,
    'juggernaut': 'jbl1k4s9d2f7g1h3' // Bannerlord
}

// Subclasses
Object.entries(class_object.subclasses).forEach(([subclass_name, subclass_data]) => {
     /**
      * 
      *     ItemEvents.rightClicked(`kubejs:rune_of_the_${subclass_name}`, event => {
        // Check if the player has already subclass
        let player = event.player
        let player_username = event.player.username
        player.persistentData.putBoolean(`subclass_chosen`, true)
        player.persistentData.putInt(`total_levels`, 0)
        Utils.server.runCommandSilent(`/skillslots level set ${player_username} 4`) // set back to 1 after testing. Add progression to level it up
        let first_unlock = class_first_unlock[subclass_name]
        Utils.server.runCommandSilent(`/puffish_skills category unlock ${player.username} superior:skill_tree`)
        Utils.server.runCommandSilent(`/puffish_skills points add ${player.username} superior:skill_tree 1`)
        Utils.server.runCommandSilent(`/puffish_skills skills unlock ${player.username} superior:skill_tree ${first_unlock}`)
        //
        //Utils.server.runCommandSilent(`/puffish_skills category unlock ${player.username} superior:combat_skills`)
        // Utils.server.runCommandSilent(`/curios set ring ${player_username} 5`)
        //Utils.server.runCommandSilent(`/curios set charm ${player_username} 5`)
        // Set the attributes
        /**
         *         Object.entries(subclass_data.attributes).forEach(([attribute, value]) => {
            player.persistentData.putFloat(`${subclass_name}_attribute:${attribute}`, value)
            //Utils.server.runCommandSilent(`/attribute ${player_username} ${attribute} base set ${value}`)
            // go through the persistent data and find the attributes that have the subclass name and filter them

        })
         * 
         *

        player.persistentData.putInt(`warlock_level`, 0)
        player.persistentData.putInt(`warlock_xp`, 0)

        player.persistentData.putInt(`vanguard_level`, 0)
        player.persistentData.putInt(`vanguard_xp`, 0)

        player.persistentData.putInt(`ranger_level`, 0)
        player.persistentData.putInt(`ranger_xp`, 0)
        
        player.persistentData.putInt(`beastmaster_level`, 0)
        player.persistentData.putInt(`beastmaster_xp`, 0)
        player.persistentData.putInt(`tree_level`, subclass_data.tree_level)

        // Drop the loot
        Utils.server.runCommandSilent(`/execute at ${player_username} run loot spawn ~ ~1 ~ loot minecraft:loot_boxes/${subclass_name}_tutorial`)
        Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete 19D694CB4D9CB5F8`)
        player.persistentData.putBoolean('skilltree_available', true)
        // Remove the item
        event.item.count -= 1

        // Add the subclass to persistent data
        event.player.persistentData.putBoolean(`kubejs_class:${subclass_name}`, true)
        player.persistentData.putString('subclass', subclass_name)

        Object.entries(subclass_data.persistentData).forEach(([key, value]) => {
           // Utils.server.tell(`Added: ${key} with value: ${value}`)
            event.player.persistentData.putInt(key, value)
        })       
            Object.entries(class_object.subclasses).forEach(([subclass_name, subclass_data]) => {
                Utils.server.runCommandSilent(`/clear ${player_username} kubejs:rune_of_the_${subclass_name}`)
                Utils.server.runCommandSilent(`/kill @e[type=item,nbt={Item:{id:"kubejs:rune_of_the_${subclass_name}"}}]`)
        })
        // Loop through the respective commands and run them
        subclass_data.commands.forEach((command) => {
            Utils.server.runCommandSilent(command)
        })


    })
      * 
      */

    // Add the loot tables
    ServerEvents.genericLootTables((event) => {
        //event.addGeneric(`loot_boxes/${subclass_name}`, (table) => {})
    })
    //________________________________________________________________________
    
})


ServerEvents.customCommand('beastmaster', event => {
    Utils.server.runCommandSilent(`/puffish_skills category unlock ${event.player.username} superior:beastmaster_skills`)
    Utils.server.runCommandSilent(`/puffish_skills points add ${event.player.username} superior:beastmaster_skills 3`)
})




/**
 * 
 * Object.entries(class_object.main_classes).forEach(([class_name, class_data]) => {
    PlayerEvents.loggedIn(event => {
        let player = event.player
        if (!player.persistentData.get(`kubejs_class:${class_name}`)) return
        let order_level = player.persistentData.order_level
        let order_xp = player.persistentData.order_xp
        let xp_cap = 5000*order_level
        let formula = parseInt(order_xp / xp_cap * 100)
        let section = 0
        if (formula >= 90) {
            section = 5
        } else if (formula >= 75 && formula < 90) {
            section = 4
        } else if (formula >= 50 && formula < 75) {
            section = 3
        } else if (formula >= 20 && formula < 50) {
            section = 2
        } else if (formula >= 10 && formula < 20) {
            section = 1
        } else {
            section = 0
        }
        if (formula < 0) {
            formula = 0
        }

        // reinit the painter objects that pertains to the class
        event.player.paint({
            order_xp: {
                type: 'rectangle',
                x: 130,
                y: 110,
                w: 290,
                h: 290,
                draw: 'ingame',
                alignX: 'right',
                alignY: 'bottom',
                texture: `kubejs:textures/leveling/order/${class_name}/${section}.png`
            },
            order_symbol: {
                type: 'rectangle',
                x: -8,
                y: -71,
                w: 16,
                h: 16,
                draw: 'ingame',
                alignX: 'right',
                alignY: 'bottom',
                visible: 'true',
                texture: `kubejs:textures/item/order/${class_name}.png`
            },
            order_xp_percent: {
                type: 'text',
                text: `${formula}%`,
                scale: 0.60,
                shadow: true,
                color: '#00FF00',
                x: -20,
                y: -2,
                draw: 'ingame',
                alignX: 'right',
                alignY: 'bottom',
    
            },
        })
    })
})
 */





// Tutorial Class stuff
/**
 * Object.entries(class_object.main_classes).forEach(([class_name, class_data]) => {
    ItemEvents.rightClicked(`kubejs:${class_name}_tutorial`, event => {
        let player = event.player
        let player_username = player.username
        Utils.server.runCommandSilent(`/execute at ${player_username} run loot give ${player_username} loot minecraft:loot_boxes/${class_name}_tutorial`)
        event.item.count -= 1
        player.persistentData.putString('tutorial_order', class_name)
    })
})

Object.entries(class_object.subclasses).forEach(([subclass_name, subclass_data]) => {
    ItemEvents.rightClicked(`kubejs:rune_of_the_${subclass_name}_tutorial`, event => {
        let player = event.player
        let player_username = player.username
        Utils.server.runCommandSilent(`/execute at ${player_username} run loot spawn ~ ~1 ~ loot minecraft:loot_boxes/${subclass_name}_tutorial`)
        event.item.count -= 1
        player.persistentData.putString('tutorial_subclass', subclass_name)
        //Utils.server.runCommandSilent(`/attribute ${player_username} puffish_attributes:player.sprinting_speed 1.8`)
        // Set the attributes
        Object.entries(subclass_data.attributes).forEach(([attribute, value]) => {
            Utils.server.runCommandSilent(`/attribute ${player_username} ${attribute} ${value}`)
        })
    })
})
 */

global.class_reg = {
    guardian: {
        first_unlock: '0obrqtqwf6f7gkkb', // Sanctified
        lootbox: [
            Item.of('miapi:modular_handle', "{Damage:0,RepairCost:0,display:{Name:'{\"text\":\"Wooden Halberd\"}'},miapi_modules:'{\"module\":\"handle_polearm\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_halberd\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":4.0,\"pose\":\"bettercombat:pose_two_handed_heavy\",\"two_handed\":true,\"category\":\"halberd\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":200.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_left\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_slow\",\"volume\":0.5,\"pitch\":1.1,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":200.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_slow\",\"volume\":0.5,\"pitch\":1.3,\"randomness\":0.1}},{\"hitbox\":\"VERTICAL_PLANE\",\"damage_multiplier\":1.6,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slam\",\"swing_sound\":{\"id\":\"bettercombat:claymore_slam\",\"volume\":0.5,\"pitch\":1.2,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":2.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_stab_left\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":0.7,\"pitch\":1.1,\"randomness\":0.1}}]}}'}").enchant('ensorcellation:soulbound', 1).enchant('minecraft:mending', 1).enchant('minecraft:loyalty', 3),
            Item.of('kubejs:flickering_wand', '{Damage:0,ISB_Spells:{data:[{id:"irons_spellbooks:shield",index:0,level:1,locked:1b},{id:"irons_spellbooks:healing_circle",index:1,level:1,locked:1b}],maxSpells:2,mustEquip:0b,spellWheel:1b}}').enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
        ]
    },
    battlemage: {
        first_unlock: 'drplwpdtmo3j194o', // War path
        lootbox: [
            Item.of('irons_spellbooks:graybeard_staff', '{Damage:0,ISB_Spells:{data:[{id:"irons_spellbooks:earthquake",index:0,level:1,locked:1b},{id:"irons_spellbooks:magic_arrow",index:1,level:1,locked:1b},{id:"irons_spellbooks:gust",index:2,level:1,locked:1b}],maxSpells:3,mustEquip:0b,spellWheel:1b}}').enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
            Item.of('minecraft:shield').enchant('ensorcellation:soulbound', 1),
            Item.of('irons_spellbooks:mana_ring'),
            Item.of('irons_spellbooks:concentration_amulet'),
        ],
    },
    conjurer: {
        first_unlock: 'b67vjfylvvyd31b0', // Soul Siphon,
        lootbox: [
            Item.of('miapi:modular_sickle', "{Damage:0,level:0,levelprogress:56,miapi_modules:'{\"module\":\"handle_polearm\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"generated_block.regions_unexplored.blackwood_planks\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_slim\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_sickle\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"generated_block.regions_unexplored.blackwood_planks\\\\\"}\"},\"subModules\":{}}}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":3.625,\"pose\":\"bettercombat:pose_two_handed_polearm\",\"two_handed\":true,\"category\":\"glaive\",\"attacks\":[{\"hitbox\":\"VERTICAL_PLANE\",\"damage_multiplier\":0.8,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_vertical_right\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_quick\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"VERTICAL_PLANE\",\"damage_multiplier\":0.8,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_vertical_left\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_quick\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.4,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:glaive_slash_slow\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
            Item.of('kubejs:flickering_wand', '{Damage:0,ISB_Spells:{data:[{id:"irons_spellbooks:raise_dead",index:0,level:2,locked:1b},{id:"irons_spellbooks:sacrifice",index:1,level:1,locked:1b}],maxSpells:2,mustEquip:0b,spellWheel:1b}}').enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
        ],
    },
//_________________________________________________________________________________________
    disciple: {
        first_unlock: 'jfvyfat76hc9ujls', // Flaming Shadows
        lootbox: [
            Item.of('miapi:modular_greatsword', "{Damage:0,miapi_modules:'{\"module\":\"handle_long\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_normal\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_zweihaender\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_cross\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.875,\"pose\":\"bettercombat:pose_two_handed_sword\",\"two_handed\":true,\"category\":\"claymore\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":0.75,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:claymore_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_stab_left\",\"swing_sound\":{\"id\":\"bettercombat:claymore_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"VERTICAL_PLANE\",\"damage_multiplier\":1.25,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slam\",\"swing_sound\":{\"id\":\"bettercombat:claymore_slam\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.0}}]}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
            Item.of('kubejs:flickering_wand', '{Damage:0,ISB_Spells:{data:[{id:"irons_spellbooks:flaming_strike",index:0,level:1,locked:1b},{id:"irons_spellbooks:blaze_storm",index:1,level:1,locked:1b}],maxSpells:2,mustEquip:0b,spellWheel:1b}}').enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
        ],
    },
    kensei: {
        first_unlock: 'zqsbzptq6nr5e4zs', // Viper
        lootbox: [
            Item.of('miapi:modular_bow', "{Damage:0,miapi_modules:'{\"module\":\"bow_handle_sniper\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"bow_arms_recurve\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"bow_string_normal\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"string\\\\\"}\"},\"subModules\":{}}}}}}',weapon_attributes:'{\"attributes\":{\"attack_range\":1.25,\"pose\":\"bettercombat:pose_two_handed_bow\",\"two_handed\":true}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
            Item.of('miapi:modular_katana', "{Damage:0,miapi_modules:'{\"module\":\"handle_short\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_slim\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_katana\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_round\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.0,\"two_handed\":false,\"category\":\"sword\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:sword_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_horizontal_left\",\"swing_sound\":{\"id\":\"bettercombat:sword_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_stab\",\"swing_sound\":{\"id\":\"bettercombat:sword_slash\",\"volume\":1.0,\"pitch\":1.2,\"randomness\":0.1}}]}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
        ],
        extra_loot: [
            Item.of('32x minecraft:arrow'),
        ]
    },
    berserker: {
        first_unlock: 'v2l1gbwoz2nhtt38', // Fimbulwinter
        lootbox: [
            Item.of('miapi:modular_axe', "{Damage:0,miapi_modules:'{\"module\":\"handle_tool\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"tool_adapter\",\"moduleData\":{},\"subModules\":{\"0\":{\"module\":\"axe_throwing\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{}}}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.75,\"two_handed\":false,\"category\":\"axe\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:axe_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_horizontal_left\",\"swing_sound\":{\"id\":\"bettercombat:axe_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1).enchant('minecraft:loyalty', 3),
            Item.of('miapi:modular_axe', "{Damage:0,miapi_modules:'{\"module\":\"handle_tool\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"tool_adapter\",\"moduleData\":{},\"subModules\":{\"0\":{\"module\":\"axe_throwing\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{}}}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.75,\"two_handed\":false,\"category\":\"axe\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:axe_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":90.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_horizontal_left\",\"swing_sound\":{\"id\":\"bettercombat:axe_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1).enchant('minecraft:loyalty', 3),
        ],
    },
//_________________________________________________________________________________________
    mercenary: {
        first_unlock: '2kpdhejrwdlnn9jd', // Sentinel
        lootbox: [
            Item.of('miapi:modular_crossbow', "{Charged:0b,ChargedProjectiles:[],Damage:0,level:0,levelprogress:0,miapi_modules:'{\"module\":\"crossbow_stock_magazine\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"crossbow_arms_short\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_mangrove\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"crossbow_string_normal\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"string\\\\\"}\"},\"subModules\":{}}}},\"-1\":{\"module\":\"crossbow_attachments_styrup\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"iron\\\\\"}\"},\"subModules\":{}}}}',miapirapid_fire_crossbow:[],weapon_attributes:'{\"attributes\":{\"attack_range\":1.25,\"two_handed\":true}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
        ],
        extra_loot: [
            Item.of('32x minecraft:arrow'),
        ]
    },
    mystic: {
        first_unlock: 'eyt5h7jwjfx63ygb', // Cyclone
        lootbox: [
            Item.of('miapi:modular_spear', "{Damage:0,miapi_modules:'{\"module\":\"handle_polearm\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_spear\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":3.75,\"pose\":\"bettercombat:pose_two_handed_polearm\",\"two_handed\":true,\"category\":\"spear\",\"attacks\":[{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_stab_right\",\"swing_sound\":{\"id\":\"bettercombat:spear_stab\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1).enchant('minecraft:loyalty', 3),
        ],
    },
    frostpiercer: {
        first_unlock: 'sx5130pxmys84be5', // Frozen Shackles
        lootbox: [
            Item.of('miapi:twin_blade', "{Damage:0,miapi_modules:'{\"module\":\"handle_twin\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_socket\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_throwing_knife\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_crimson\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"guard_socket\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_sword\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_crimson\\\\\"}\"},\"subModules\":{}}}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.0,\"pose\":\"bettercombat:pose_two_handed_katana\",\"two_handed\":true,\"category\":\"twin_blade\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_switch_blade_right\",\"swing_sound\":{\"id\":\"bettercombat:sword_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:one_handed_slash_switch_blade_left\",\"swing_sound\":{\"id\":\"bettercombat:sword_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1).enchant('minecraft:loyalty', 3),
            Item.of('miapi:modular_bow', "{Damage:0,miapi_modules:'{\"module\":\"bow_handle_sniper\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"bow_arms_recurve\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"bow_string_normal\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"string\\\\\"}\"},\"subModules\":{}}}}}}',weapon_attributes:'{\"attributes\":{\"attack_range\":1.25,\"pose\":\"bettercombat:pose_two_handed_bow\",\"two_handed\":true}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
        ],
        extra_loot: [
            Item.of('48x minecraft:arrow'),
        ]
    },
//_________________________________________________________________________________________
    nomad: {
        first_unlock: 'nq5r8av12fqnlxv4', // Avarice
        lootbox: [
            Item.of('miapi:modular_scythe', "{Damage:0,miapi_modules:'{\"module\":\"handle_polearm\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"quarterstaff\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_oak\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":3.75,\"two_handed\":true,\"category\":\"battlestaff\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_rl\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_poke\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_lr\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_rl_style\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:battlestaff_lr\",\"swing_sound\":{\"id\":\"bettercombat:staff_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
        ],
        extra_loot: [
            'minecraft:white_bed',
        ]
    },
    /**
     *         shinobi: {
        first_unlock: 
    },
        */

    bloodripper: {
        first_unlock: 'm31y1d34ugjog6e2', // Rip and Tear
        lootbox: [
            Item.of('miapi:modular_dagger', "{Damage:0,level:0,levelprogress:19,miapi_modules:'{\"module\":\"handle_normal\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"iron\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_slim\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_blackstone\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_dagger\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_mangrove\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_spike\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_blackstone\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":2.0,\"two_handed\":false,\"category\":\"dagger\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"conditions\":[\"DUAL_WIELDING_SAME_CATEGORY\",\"MAIN_HAND_ONLY\"],\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.4,\"angle\":80.0,\"upswing\":0.5,\"animation\":\"bettercombat:dual_handed_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('ensorcellation:soulbound', 1).enchant('minecraft:unbreaking', 3),
            Item.of('miapi:modular_throwing_knife', "{Damage:0,level:0,levelprogress:19,miapi_modules:'{\"module\":\"handle_normal\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"iron\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"guard_slim\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_blackstone\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_throwing_knife\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_mangrove\\\\\"}\"},\"subModules\":{}}}},\"1\":{\"module\":\"pommel_spike\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_blackstone\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":1.875,\"two_handed\":false,\"category\":\"dagger\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.0,\"angle\":0.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_rl_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":60.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:dagger_lr\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"conditions\":[\"DUAL_WIELDING_SAME_CATEGORY\",\"MAIN_HAND_ONLY\"],\"hitbox\":\"FORWARD_BOX\",\"damage_multiplier\":1.4,\"angle\":80.0,\"upswing\":0.5,\"animation\":\"bettercombat:dual_handed_stab\",\"swing_sound\":{\"id\":\"bettercombat:dagger_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('ensorcellation:soulbound', 1).enchant('minecraft:unbreaking', 3).enchant('minecraft:loyalty', 1),
        ],
    },
//_________________________________________________________________________________________
    /**
     *         dragonlord: {
        first_unlock: 
    },
    soulbinder: {
        first_unlock: 
    },
        * 
        */

    plague_doctor: {
        first_unlock: 'x5huaczmmkr8lqrb', // Verminlord
        lootbox: [
            Item.of('miapi:modular_scythe', "{Damage:0,miapi_modules:'{\"module\":\"handle_polearm\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone_deepslate\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"blade_scythe\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"generated_block.regions_unexplored.black_painted_planks\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":3.75,\"pose\":\"bettercombat:pose_two_handed_scythe\",\"two_handed\":true,\"category\":\"scythe\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_right\",\"swing_sound\":{\"id\":\"bettercombat:scythe_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":150.0,\"upswing\":0.5,\"animation\":\"bettercombat:two_handed_slash_horizontal_left\",\"swing_sound\":{\"id\":\"bettercombat:scythe_slash\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('minecraft:unbreaking', 2).enchant('ensorcellation:soulbound', 1),
            Item.of('rats:rat_flute').enchant('ensorcellation:soulbound', 1).enchant('mending', 1),
        ],
    },
    juggernaut: {
        first_unlock: 'jbl1k4s9d2f7g1h3', // Bannerlord
        lootbox: [
            Item.of('miapi:modular_shovel', "{Damage:0,miapi_modules:'{\"module\":\"handle_polearm\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"wood_spruce\\\\\"}\"},\"subModules\":{\"0\":{\"module\":\"warhammer\",\"moduleData\":{\"properties\":\"{\\\\\"material\\\\\":\\\\\"stone\\\\\"}\"},\"subModules\":{}}}}',reinforce_level:0,reinforce_max:10,weapon_attributes:'{\"attributes\":{\"attack_range\":4.375,\"pose\":\"bettercombat:pose_two_handed_heavy\",\"two_handed\":true,\"category\":\"heavy_axe\",\"attacks\":[{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:doubleaxe_updown_lr\",\"swing_sound\":{\"id\":\"bettercombat:double_axe_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:doubleaxe_updown_rl\",\"swing_sound\":{\"id\":\"bettercombat:double_axe_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:doubleaxe_hori_lr\",\"swing_sound\":{\"id\":\"bettercombat:double_axe_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":120.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:doubleaxe_hori_rl\",\"swing_sound\":{\"id\":\"bettercombat:double_axe_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.0,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:doubleaxe_hori_lr\",\"swing_sound\":{\"id\":\"bettercombat:double_axe_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.1,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:doubleaxe_lrl\",\"swing_sound\":{\"id\":\"bettercombat:double_axe_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}},{\"hitbox\":\"HORIZONTAL_PLANE\",\"damage_multiplier\":1.1,\"angle\":180.0,\"upswing\":0.5,\"animation\":\"malfu_combat_animation:doubleaxe_lrl\",\"swing_sound\":{\"id\":\"bettercombat:double_axe_swing\",\"volume\":1.0,\"pitch\":1.0,\"randomness\":0.1}}]}}'}").enchant('ensorcellation:soulbound', 1).enchant('minecraft:unbreaking', 3), 
            Item.of('immersive_armors:heavy_chestplate', '{Damage:0}').enchant('ensorcellation:soulbound', 1).enchant('mending', 1),
        ],
    }
}



Object.entries(global.class_reg).forEach(([class_name, class_data]) => {
    // Register the loot table
    ServerEvents.genericLootTables((event) => {
        event.addGeneric(`loot_boxes/${class_name}`, (table) => {})
        event.addGeneric(`loot_boxes/${class_name}_extra`, (table) => {})
    })

    class_data.lootbox.forEach(loot => {
        LootJS.modifiers((event) => {
            event.addLootTableModifier(`loot_boxes/${class_name}`).addLoot(loot);
        })
    })
    if (class_data.extra_loot) {
        class_data.extra_loot.forEach(loot => {
            LootJS.modifiers((event) => {
                event.addLootTableModifier(`loot_boxes/${class_name}_extra`).addLoot(loot);
            })
        })
    }

    ServerEvents.customCommand(`unlock_class_${class_name}`, event => {
        let player = event.player
        unlock_class(player, class_name)
    })


    ItemEvents.rightClicked(event => {
        if (event.item.id != `kubejs:rune_of_the_${class_name}`) return
        let player = event.player
        unlock_class(player, class_name)
    })
})



function unlock_class (player, unlockClass) {
        let player_username = player.username
        
        let class_name = ''
        
        Object.entries(global.class_reg).forEach(([name, data]) => {
            if (name == unlockClass) class_name = name
        })
        //tell(class_name)
        let class_data = global.class_reg[class_name]
        //tell(class_data)
        // Extra loot (ex. arrows)


        Utils.server.runCommandSilent(`/puffish_skills points add ${player.username} superior:skill_tree 1`)
        Utils.server.runCommandSilent(`/puffish_skills skills unlock ${player.username} superior:skill_tree ${class_data.first_unlock}`)


        if (player.persistentData.get('subclass')) return
        if (class_data.extra_loot) {
            Utils.server.runCommandSilent(`/execute at ${player.username} run loot spawn ~ ~1 ~ loot minecraft:loot_boxes/${class_name}_extra`)
        }
        // Main Loot
        Utils.server.runCommandSilent(`/execute at ${player.username} run loot spawn ~ ~1 ~ loot minecraft:loot_boxes/${class_name}`)
    
        // Persistent Data 
        //player.persistentData.putBoolean(`subclass_chosen`, true)
        

        // Skill Slots
        Utils.server.runCommandSilent(`/skillslots level set ${player_username} 4`) // set back to 1 after testing. Add progression to level it up
        //tell(class_data.first_unlock)
        // Skill Tree unlocks
        //Utils.server.runCommandSilent(`/puffish_skills category unlock ${player.username} superior:skill_tree`)

        if (player.persistentData.getBoolean(`subclass_chosen`) != true) {
            player.persistentData.putInt(`total_levels`, 0)
            player.persistentData.putBoolean(`subclass_chosen`, true)
            // Trait Levels
            player.persistentData.putInt(`warlock_level`, 0)
            player.persistentData.putInt(`warlock_xp`, 0)

            player.persistentData.putInt(`vanguard_level`, 0)
            player.persistentData.putInt(`vanguard_xp`, 0)

            player.persistentData.putInt(`ranger_level`, 0)
            player.persistentData.putInt(`ranger_xp`, 0)
            
            player.persistentData.putInt(`beastmaster_level`, 0)
            player.persistentData.putInt(`beastmaster_xp`, 0)
            // Paint XP
            player.paint({
                vanguard: {
                    type: 'rectangle',
                    x: -112,
                    y: -3,
                    w: 16,
                    h: 16,
                    draw: 'ingame',
                    visible: true,
                    alignX: 'right',
                    alignY: 'bottom',
                    texture: 'kubejs:textures/level_rework/vanguard.png'
                },
                warlock: {
                    type: 'rectangle',
                    x: -112,
                    y: -23,
                    w: 16,
                    h: 16,
                    draw: 'ingame',
                    visible: true,
                    alignX: 'right',
                    alignY: 'bottom',
                    texture: 'kubejs:textures/level_rework/warlock.png'
                },
                marksman: {
                    type: 'rectangle',
                    x: -112,
                    y: -43,
                    w: 16,
                    h: 16,
                    draw: 'ingame',
                    visible: true,
                    alignX: 'right',
                    alignY: 'bottom',
                    texture: 'kubejs:textures/level_rework/marksman.png'
                },
                beastmaster: {
                    type: 'rectangle',
                    x: -112,
                    y: -63,
                    w: 16,
                    h: 16,
                    draw: 'ingame',
                    visible: true,
                    alignX: 'right',
                    alignY: 'bottom',
                    texture: 'kubejs:textures/level_rework/beastmaster.png'
                },
                empty_bar_vanguard: {
                    type: 'rectangle',
                    x: empty_bars.vanguard.x,
                    y: empty_bars.vanguard.y,
                    w: 256,
                    h: 256,
                    draw: 'ingame',
                    visible: true,
                    alignX: 'right',
                    alignY: 'bottom',
                    texture: `kubejs:textures/level_rework/vanguard/empty_bar.png`
                },
                empty_bar_warlock: {
                    type: 'rectangle',
                    x: empty_bars.warlock.x,
                    y: empty_bars.warlock.y,
                    w: 256,
                    h: 256,
                    draw: 'ingame',
                    visible: true,
                    alignX: 'right',
                    alignY: 'bottom',
                    texture: `kubejs:textures/level_rework/warlock/empty_bar.png`
                },
                empty_bar_marksman: {
                    type: 'rectangle',
                    x: empty_bars.marksman.x,
                    y: empty_bars.marksman.y,
                    w: 256,
                    h: 256,
                    draw: 'ingame',
                    visible: true,
                    alignX: 'right',
                    alignY: 'bottom',
                    texture: `kubejs:textures/level_rework/marksman/empty_bar.png`
                },
                empty_bar_beastmaster: {
                    type: 'rectangle',
                    x: empty_bars.beastmaster.x,
                    y: empty_bars.beastmaster.y,
                    w: 256,
                    h: 256,
                    draw: 'ingame',
                    visible: true,
                    alignX: 'right',
                    alignY: 'bottom',
                    texture: `kubejs:textures/level_rework/beastmaster/empty_bar.png`
                },
            })
        }
        // Complete the Quest
        Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete 19D694CB4D9CB5F8`)
        player.persistentData.putBoolean('skilltree_available', true)
        // Remove the item
        //event.item.count -= 1


        player.persistentData.putBoolean(`kubejs_class:${class_name}`, true)
        player.persistentData.putString('subclass', class_name)
}