    /**Valkyries wings - 2 Levels
     * §aLevel 1: While airborne, Hold SHIFT + drawing a Bow, Crossbow, or Throwable weapon, will give you a huge vertical boost and a slow falling effect
     * §aLevel 2: Killing an enemy while in the air will give you an additional use
     * §aLevel 3: Gain Angel Wings which allow you to glide
     * */


let wings_map =new WeakMap()
PlayerEvents.loggedIn(event => {
    let player = event.player
    wings_map[player.username] = 1
})


function valkyries_wings_ability (player) {
    let p = player
    if (!p.persistentData.get('valkyries_wings')) return
    let active = p.persistentData.get('valkyries_wings_active')
    p.persistentData.putBoolean('valkyries_wings_active', active == true ? false : true)
    if (p.persistentData.get('valkyries_wings_active') == true) {
        p.tell('Valkyries Wings: §aActivated§r')
    } else {
        p.tell('Valkyries Wings: §cDeactivated§r')
    }
}

ItemEvents.rightClicked(event => {
    if (!event.player.persistentData.get('valkyries_wings')) return
    if (event.player.persistentData.get('valkyries_wings_active') == false) return
    // check if the item id is a bow, trident, or throwable
    if (!event.item.id.includes('bow') && !event.item.id.includes('trident') && !event.item.id.includes('throw') && !event.item.id.includes('spear')) return 
    let player = event.player
    let level = player.persistentData.valkyries_wings
    if (player.blockStateOn.block != 'Block{minecraft:air}') return
    if (!player.shiftKeyDown) return
    if (wings_map[player.username] <= 0) return
    wings_map[player.username] -= 1
    player.potionEffects.add('levitation', 10, 15, true, true)
    player.potionEffects.add('slow_falling', 80, 0, true, true)    
    if (level != 3) return
    player.potionEffects.add('irons_spellbooks:angel_wings', 100, 0, true, true)
})


EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('valkyries_wings')) return
    if (player.persistentData.valkyries_wings < 2) return
    let check = physicalProjectileCheck(event.source)
    if (!check) return
    wings_map[player.username] += 1
    if (wings_map[player.username] > 1) {
        wings_map[player.username] = 1
    }
})

PlayerEvents.tick(event => {
    let player = event.player
    if (!player.persistentData.get('valkyries_wings')) return
    if (wings_map[player.username] == 1) return
    if (player.blockStateOn.block == 'Block{minecraft:air}') return
    wings_map[player.username] = 1
})



