


let parry_sparks = {
    1:  {
        spark_color: ['255255255 255255255 255255255'],
        spark_amount: 5
    },
    2: {
        spark_color: ['255255255 255255255 255255255'],
        spark_amount: 10
    },
    3: {
        spark_color: ['0.5 2 5'],
        spark_amount: 25
    }

}

function isBlocking(player) {
    if (player.blocking) return true
    let validNbt = ['zweihaender', 'guard_blocking', 'katana', 'longsword']
    let mainhand = player.mainHandItem
    if (mainhand) {
        if (mainhand.nbt && validNbt.some(nbt => mainhand.nbt.toString().includes(nbt))) return true
    }
    let offhand = player.offhandItem
    if (offhand) {
        if (offhand.nbt && validNbt.some(nbt => offhand.nbt.toString().includes(nbt))) return true
    }
    return false
}
    





PlayerEvents.tick(event => {
    if (!event.player.persistentData.get('base_parry')) return
    if (event.player.cooldowns.isOnCooldown('kubejs:base_parry_ability')) return
    if (event.player.persistentData.alt_parrying == true) return
    if (!event.player.blocking) {
        event.player.persistentData.putBoolean('parrying', false)
        event.player.persistentData.putInt('parry_timer', 1)
        //Utils.server.tell('Not parrying!')
    } else {
        if (event.player.persistentData.parry_timer < 3+event.player.persistentData.base_parry) {
            event.player.persistentData.putBoolean('parrying', true)
            event.player.persistentData.parry_timer += 1
            //Utils.server.tell('Parrying!')
        } else {
            event.player.persistentData.putBoolean('parrying', false)
            
           // Utils.server.tell('Parry ended!')
        }
        event.player.cooldowns.addCooldown('kubejs:base_parry_ability', 20)
    }
})

ItemEvents.rightClicked(event => {
    if (!event.item.id.includes('miapi')) return
    if (!event.player.persistentData.get('base_parry')) return
    if (event.player.cooldowns.isOnCooldown('kubejs:base_parry_ability')) return
    // if it doesnt include zweihaender or guard_blocking, return
    if (!event.item.nbt.toString().includes('zweihaender') && !event.item.nbt.toString().includes('guard_blocking') && !event.item.nbt.toString().includes('katana') && !event.item.nbt.toString().includes('longsword')) return
    event.player.persistentData.putBoolean('parrying', true)
    event.player.persistentData.putBoolean('alt_parrying', true)
    event.player.cooldowns.addCooldown('kubejs:base_parry_ability', 20)
    Utils.server.scheduleInTicks(2, () => {
        event.player.persistentData.putBoolean('parrying', false)
        event.player.persistentData.putBoolean('alt_parrying', false)
    })
})







/**
 * 
 * ItemEvents.rightClicked(event => {
    if (event.player.tags.contains('parrying')) return
    if (event.player.offhandItem.id.includes('shield')) {
        Utils.server.scheduleInTicks(1, () => {
            if (!event.player.persistentData.get('parry_counter')) {
                event.player.persistentData.putInt('parry_counter', 0)
            }
            event.player.tags.add('parrying')
            event.player.cooldowns.addCooldown('parry', 3)
            event.player.cooldowns.removeCooldown('minecraft:shield')
        //Utils.server.tell('Parrying!')
            Utils.server.scheduleInTicks(3, () => {
                event.player.tags.remove('parrying')
                //Utils.server.tell('Parry ended!')
            })
        })
        
    }
})
 */

function determineParry(player, entity, dim, source) {
    // Create a mapping of parry names to their corresponding functions and messages
    let parryMap = {
        'lightning_parry': { func: lightning_parry, message: 'Lightning parry!' },
        'frost_parry': { func: frost_parry, message: 'Frost parry!' },
        'stun_parry': { func: stun_parry, message: 'Stun parry!' },
        //'portal_parry': { func: portal_parry, message: 'Portal parry!' },
        'flaming_parry': { func: flaming_parry, message: 'Flaming parry!' },
        'stomp_parry': { func: stomp_parry, message: 'Stomp parry!' },
        'strength_parry': { func: strength_parry, message: 'Strength parry!' },
        'speed_parry': { func: (player, entity, dim, source) => speed_parry(player, entity, dim, source), message: 'Speed parry!' },
        'base_parry': { func: stun_parry, message: 'Base parry!' }
    }

    // Get the player's chosen parry
    let chosenParry = player.persistentData.chosenParry

    // Check if the player has unlocked the parry and if it matches the chosen parry
    if (player.persistentData.get(chosenParry) && parryMap[chosenParry]) {
        // Call the corresponding function for the parry
        parryMap[chosenParry].func(player, entity, dim, source)
        // Send a message to the server
        //Utils.server.tell(parryMap[chosenParry].message)
    }
}


// Choose parries by pressing the J key.

let parry_swap = {
    1: ['base_parry'],
    2: ['lightning_parry'],
    3: ['frost_parry'],
    4: ['stun_parry'],
    //'portal_parry',
    5: ['flaming_parry'],
    6: ['stomp_parry'],
    7: ['strength_parry'],
    8: ['speed_parry'],
}
// per‐player index tracker for parry swaps
const parry_map = new WeakMap();

/**
 * Cycles through the player’s unlocked parry moves in the same style as gjallarhorn_ability.
 * Wraps around both by total definitions and by how many the player actually has.
 *
 * @param {ServerPlayerEntity} player
 */
function base_parry_ability(player) {
    // must have at least the base parry unlocked to start
    //if (!player.persistentData.get('base_parry')) return;

    if (parry_map[player.username] == undefined) {
        parry_map[player.username] = 1
    } else {
        parry_map[player.username] += 1
    }
    if (parry_map[player.username] > Object.keys(parry_swap).length) {
        parry_map[player.username] = 1
    }
    let icon = parry_swap[parry_map[player.username]]
    paint_ability_cycle(player, icon, 'base_parry')

    // 5) play a parry sound
    Utils.server.runCommandSilent(
        `/execute at ${player.username} run playsound minecraft:item.shield.block ambient @s ~ ~ ~ 1 1`
    );

    // 6) store the currently-selected parry name
    player.persistentData.putString('current_parry', icon);
}






/**
 * 
 * NetworkEvents.dataReceived("global.jKeySpecial.consumeClick", (e) => {
    let player = e.player;

    // Check if the player has at least the base parry unlocked
    if (!player.persistentData.get('base_parry')) return;

    // Initialize player parry state if not present
    if (parry_map[player.username] === undefined) {
        parry_map[player.username] = 0 // Start with 0 to ensure first increment puts it at index 1
    } else {
        parry_map[player.username] += 1
    }

    // Loop back to the start if we go past the last parry
    if (parry_map[player.username] >= parry_swap.length) {
        parry_map[player.username] = 0
    }

    let starting_index = parry_map[player.username]
    let found_unlocked_parry = false

    // Loop to find the next unlocked parry
    while (!found_unlocked_parry) {
        let current_parry_index = parry_map[player.username]
        let current_parry = parry_swap[current_parry_index]

        // Check if player has unlocked this parry
        if (player.persistentData.get(current_parry)) {
            found_unlocked_parry = true
        } else {
            parry_map[player.username] += 1
            if (parry_map[player.username] >= parry_swap.length) {
                parry_map[player.username] = 0
            }
        }

        // Stop infinite loop if we've looped back to where we started
        if (parry_map[player.username] === starting_index) {
            break // Prevents infinite loops if no parries are unlocked
        }
    }

    // Display the currently selected parry
    let current_parry_index = parry_map[player.username]
    let icon = parry_swap[current_parry_index]
    paint_ability(player, icon, 1, 'parrySwap')
    /**
     *     let x = -22
    let y = -74
    if (player.persistentData.get('kubejs_class:plague_doctor')) {
        x = -10
        y = -90
    }
    let paint_data = {}
    paint_data['parrySwap'] = {
        type: 'rectangle',
        x: x,
        y: y,
        w: 15,
        h: 15,
        draw: 'ingame',
        alignX: 'right',
        alignY: 'bottom',
        visible: 'true',
        texture: `kubejs:textures/icons/skill_tree/parry_swap/${icon}.png`
    }

    let paint_key = {}
    player.paint(paint_data)

     * 
     */

    //player.tell(`You have selected ${icon}!`)
   // player.persistentData.putString('chosenParry', icon)
    //Utils.server.tell(player.persistentData.chosenParry)
//})


EntityEvents.hurt('player', event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    let player = event.entity
    //if (!player.persistentData.get('base_parry')) return
    if (!event.source.actual) return

        // Check if the player is parrying or alt-parrying
    if (!player.persistentData.parrying && !player.persistentData.alt_parrying) return
    pushEntity(player, event.source.actual, 20)
    parry_effect(player, event.source.actual)
    stun_parry(player, event.source.actual, event.level.dimension)
})
    






/**
 * 
 * EntityEvents.hurt('player', event => {
    let player = event.entity
    if (!player.persistentData.get('base_parry')) return
    if (!event.source.actual) return

    // Check if the player is parrying or alt-parrying
    if (!player.persistentData.parrying && !player.persistentData.alt_parrying) {
        player.persistentData.parry_counter = 0
        return
    }

    // Get dimension, entity, and crosshair location
    let dim = event.level.dimension
    let entity = event.level.getEntity(event.source.actual.uuid)
    let crosshair_location = getCrosshairLocation(player)

    if (entity.tags.contains('boss')) {
        bossParryEffect(entity, crosshair_location)
        event.cancel()
        return
    }

    // Determine max parry count based on player's abilities
    let max_parry_count = player.persistentData.get('parry_mastery') ? 2 : 3

    // Increment parry counter
    player.persistentData.parry_counter = (player.persistentData.parry_counter || 0) + 1
    let parryCount = player.persistentData.parry_counter

    // Calculate sound effect pitch based on parry progress
    let sound_effect = 1 + ((parryCount - 1) / (max_parry_count - 1)) * 0.6 // Interpolates pitch from 1 to 1.6 dynamically

    // Define spark logic using lookup instead of repeated conditionals
    let sparkConfig = parry_sparks[Math.min(parryCount, 3)] // Cap to max index 3
    if (sparkConfig) {
        playParryEffect(player, entity, crosshair_location, sparkConfig, sound_effect, parryCount, max_parry_count)
    }

    // Check if the parry has reached its max state
    if (parryCount >= max_parry_count) {
        determineParry(player, entity, dim, event.source)
        player.persistentData.parry_counter = 0
    }

    event.cancel()
})

 * 
 * 
 */

/**
 * Handles particle effects, sound, and entity push for the parry.
 */
function parry_effect(player, entity) {
    let crosshair_location = getCrosshairLocation(player)
    Utils.server.runCommandSilent(`/execute at ${player.username} run playsound alexsmobs:fly_idle ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.2`)
    
    // Display particle effect
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:spark 1 1 1 ${crosshair_location.x} ${crosshair_location.y-0.25} ${crosshair_location.z} 0.1 0.1 0.1 0.1 15`)
}

/**
 * Calculate crosshair location based on player's pitch and yaw.
 */
function getCrosshairLocation(player) {
    let x_rad = player.pitch * JavaMath.PI / 180
    let y_rad = player.yaw * JavaMath.PI / 180
    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    return {
        x: player.x + dirV.x * 1.5,
        y: player.y + 1.5 + dirV.y * 1.5,
        z: player.z + dirV.z * 1.5
    }
}

/**
 * Handle the visual and sound effects for boss parry.
 */
function bossParryEffect(entity, crosshair_location) {
    entity.playSound(`alexsmobs:fly_idle`, 100, 1)
    Utils.server.runCommandSilent(`/execute in ${entity.level.dimension} run particle irons_spellbooks:spark 0.5 2 5 ${crosshair_location.x} ${crosshair_location.y} ${crosshair_location.z} 0.2 0.2 0.2 0.2 50`)
}

/**
 * Handles particle effects, sound, and entity push for the parry.
 */
function playParryEffect(player, entity, crosshair_location, sparkConfig, sound_effect, parryCount, max_parry_count) {
    if (!sparkConfig) return

    let { spark_color, spark_amount } = sparkConfig
    // Play parry sound
    entity.playSound(`alexsmobs:fly_idle`, 4, sound_effect)

    // Push the player to simulate parry impact
    if (parryCount < max_parry_count) {
        pushEntity(player, entity, 15)
    }

    // Display particle effect
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:spark ${spark_color} ${crosshair_location.x} ${crosshair_location.y} ${crosshair_location.z} 0.2 0.2 0.2 0.2 ${spark_amount}`)

    if (player.persistentData.get('parry_mastery_complete')) return
    if (!player.persistentData.get('parry_mastery_counter')) {
        player.persistentData.putInt('parry_mastery_counter', 1)
    } else {
        player.persistentData.parry_mastery_counter += 1
    }
    if (player.persistentData.parry_mastery_counter < 15000) return
    player.tell('Parry mastery unlocked!')
    player.persistentData.putInt('parry_mastery_complete', 1)
    player.persistentData.putInt('parry_mastery', 1)
}

/**
 * Push an entity away from the player multiple times to create a parry effect.
 */
function pushEntity(player, entity, times) {
    for (let i = 0; i < times; i++) {
        player.push(entity)
    }
}



EntityEvents.hurt('player', event => {
    let player = event.server.getPlayer(event.entity.uuid)
    player.persistentData.putInt('parry_counter', 0)
})
//_____________________________________________________________________________________________________________________






//_____________________________________________________________________________________________________________________
function lightning_parry(player, entity, dim) { // 5 levels
    let username = player.username
    let level = player.persistentData.lightning_parry
    entity.potionEffects.add(`alexscaves:stunned`, 18, 1, true, true)
    entity.potionEffects.add(`minecells:stunned`, 18, 1, true, true)
    Utils.server.scheduleInTicks(1, () => {
        Utils.server.runCommandSilent(`/execute in ${dim} run cast ${username} shockwave ${level}`)
    })
    if (level < 3) return
    entity.potionEffects.add(`irons_spellbooks:rend`, 40*level, level-3, true, true)
}
//_____________________________________________________________________________________________________________________
function frost_parry(player, entity, dim) { //5 levels
    let level = player.persistentData.frost_parry
    entity.potionEffects.add(`mowziesmobs:frozen`, 20*level, 1, true, true)
    if (level < 3) return
    player.potionEffects.add('strength', 40, 2)
    if (level < 5) return
    entity.tags.add('frost_parry_enemy')
}

EntityEvents.death(event => {
    if (!event.entity.tags.contains('frost_parry_enemy')) return
    if (!event.source.player) return
    let player = event.source.player
    if (player.persistentData.frost_parry < 5) return
    spreadEffect(player, event.entity, 'mowziesmobs:frozen', 15, 10*player.persistentData.frost_parry, 1)
})

//_____________________________________________________________________________________________________________________
function stomp_parry(player, entity, dim) { // 10 levels
    //entity.potionEffects.add(`alexscaves:stunned`, 40, 1, true, true)
   // entity.potionEffects.add(`minecells:stunned`, 40, 1, true, true)
    let level = player.level
    let username = player.username
    let player_x = player.x
    let player_y = player.y
    let player_z = player.z
    entity.knockback(1, 0.5, 1)
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${username} stomp`)

    if (player.persistentData.stomp_parry < 2) return
    entity.potionEffects.add(`irons_spellbooks:rend`, 80, 1, true, true)
    if (player.persistentData.stomp_parry < 3) return
    player.tags.add('stomp_parry')
    Utils.server.scheduleInTicks(40, () => {
        player.tags.remove('stomp_parry')
    })
}

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.tags.contains('stomp_parry')) return
    if (!event.source.immediate.type.includes('stomp')) return
    let entity = event.entity
    let level = event.level
    // loop 20 times
    for (let i = 0; i < 30; i++) {
        player.push(entity)
    }
    if (player.persistentData.stomp_parry < 4) return
    entity.potionEffects.add('levitation', 30, 5)


    if (player.persistentData.stomp_parry < 5) return
    Utils.server.scheduleInTicks(20, () => {
        //2 lightning for every level past 5
        let strikes = 2 * (player.persistentData.stomp_parry - 4)
        // loop equal to the amount of strikes
        for (let i = 0; i < strikes; i++) {
            event.level.spawnLightning(entity.x, entity.y, entity.z, false)
        }
    })
})
//_____________________________________________________________________________________________________________________

function strength_parry(player, entity, dim) { //3 levels
    player.potionEffects.add('strength', 40, 2)
    if (player.persistentData.strength_parry < 2) return
    player.potionEffects.add('haste', 40, 2)
    if (player.persistentData.strength_parry < 3) return
    entity.potionEffects.add(`alexscaves:stunned`, 40, 1, true, true)
    entity.potionEffects.add(`minecells:stunned`, 40, 1, true, true)

}



//_____________________________________________________________________________________________________________________
function speed_parry(player, entity, dim, source) { //3 levels
    physicalProjectileCheck(source)
    player.potionEffects.add('speed', 60, 1, true, true)
    if (player.persistentData.speed_parry < 2) return
    entity.potionEffects.add('slowness', 60, 1)
    if (player.persistentData.speed_parry < 3) return
    player.potionEffects.add('irons_spellbooks:true_invisibility', 60, 1, true, true)
    player.potionEffects.add('cofh_core:true_invisibility', 60, 1, true, true)
}
//_____________________________________________________________________________________________________________________
function stun_parry(player, entity, dim) { //5 levels
    //let dur = 40*player.persistentData.base_parry
    let dur = 40
    entity.potionEffects.add(`alexscaves:stunned`, dur, 1, true, true)
    entity.potionEffects.add(`minecells:stunned`, dur, 1, true, true)
    if (player.persistentData.base_parry < 3) return
    entity.potionEffects.add(`irons_spellbooks:rend`, 80, 1, true, true)
}
//_____________________________________________________________________________________________________________________
function portal_parry(player, entity, dim) { //1 level
    let first_yaw = player.yaw
    let first_pitch = player.pitch
    entity.potionEffects.add(`alexscaves:stunned`, 80, 1, true, true)
    entity.potionEffects.add(`minecells:stunned`, 80, 1, true, true)
   // let dim = event.level.dimension
    let username = player.username
    let x = player.x
    let y = player.y
    let z = player.z
    let yaw = player.yaw
    let pitch = -90
    player.teleportTo(dim, x, y, z, yaw, pitch)
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${username} portal`)
    Utils.server.scheduleInTicks(10, () => {
        x = player.x
        y = player.y
        z = player.z
        Utils.server.runCommandSilent(`/teleport ${player.username} ${x} ${y} ${z} facing entity ${entity.uuid}`)
        yaw = player.yaw
        pitch = 20
        player.teleportTo(dim, x, y, z, yaw, pitch)
        Utils.server.runCommandSilent(`/execute in ${dim} run cast ${username} portal`)
        //loop 30 times
        Utils.server.scheduleInTicks(10, () => {
            Utils.server.runCommandSilent(`/execute in ${dim} run cast ${username} gust 3`)
            Utils.server.scheduleInTicks(90, () => {
                Utils.server.runCommandSilent(`/kill @e[type=irons_spellbooks:portal]`)
            })
            //for (let i = 0; i < 30; i++) {
            //    player.push(entity)
           // }
        })

    })
}
//_____________________________________________________________________________________________________________________
function flaming_parry (player, entity, dim) { //5 levels
    let username = player.username
    let level = player.persistentData.flaming_parry
    if (level < 5) {
        Utils.server.runCommandSilent(`/execute in ${dim} run cast ${username} flaming_strike ${level}`)
    } else {
        shadow_parry(player, entity, dim)
    }
}

function shadow_parry(player, entity, dim) {
    let username = player.username
    entity.potionEffects.add('levitation', 8, 20)
    entity.potionEffects.add('slow_falling', 30, 20)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle minecraft:smoke ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 0.01 5000`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound irons_spellbooks:cast.abyssal_shroud master ${player.username} ${player.x} ${player.y} ${player.z} 100`)
        // add a check for §aLevel 2 for this line
        entity.potionEffects.add(`irons_spellbooks:rend`, 80, 1, true, true)
    Utils.server.scheduleInTicks(10, () => {
        entity.potionEffects.add(`alexscaves:stunned`, 20, 1)
        entity.potionEffects.add(`minecells:stunned`, 20, 1)
        Utils.server.runCommandSilent(`/execute in ${dim} run cast ${username} flaming_strike ${player.persistentData.flaming_parry}`)
        let player_x = player.x
        let player_y = player.y
        let player_z = player.z
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:smoke ${player_x} ${player_y} ${player_z} 0.5 0.5 0.5 0.1 1000`)
        Utils.server.scheduleInTicks(6, () => {
            Utils.server.runCommandSilent(`/teleport ${player.username} ${entity.x-2} ${entity.y} ${entity.z} facing entity ${entity.uuid}`)
            player.potionEffects.add('slow_falling', 20, 8)
            Utils.server.scheduleInTicks(4, () => {
                Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:flame ${entity.x} ${entity.y} ${entity.z} 0.5 0.5 0.5 2 500`)
            })
            Utils.server.scheduleInTicks(15, () => {
                Utils.server.runCommandSilent(`/teleport ${player.username} ${player_x} ${player_y} ${player_z} facing entity ${entity.uuid}`)
                //Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:smoke ${player_x} ${player_y} ${player_z} 0.5 0.5 0.5 1 1000`)
            })
        })
    })
}
//_____________________________________________________________________________________________________________________

/**
 * function base_parry (player, entity, dim) {
    let username = player.username
    let level = player.persistentData.base_parry
    let amp = 3-level
    if (amp < 0) { amp = 0 }
    entity.potionEffects.add('slowness', 20*level, amp, true, true)
    // loop 30 times for each level
    for (let i = 0; i < 30*level; i++) {
        player.push(entity)
    }
}

 */










/**
 * Parry skills
 *  - Longer Parry window
 *  - Longer stun
 *  - Haste effect after parry
 *  - Strength effect after parry
 *  - Being able to stun bosses
 *  - Better knockback
 * 
 * PlayerEvents.tick(event => {
    if (!event.player.sprinting) return
    if (!event.player.blocking) return
    if (event.player.cooldowns.isOnCooldown('bash')) return
    let player = event.player
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    player.setMotion(dirV.x * 2, dirV.y * 0.4, dirV.z * 2)
    player.cooldowns.addCooldown('bash', 10)
    Utils.server.tell('Bash!')
})
 */


// Choose your parry by pressing the J key to cycle through the parries


