// Kill rotting stalkers when the player isnt insane
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.entity.player) return
    if (event.source.actual.type != 'sanitydim:rotting_stalker') return
    if (event.entity.potionEffects.isActive('kubejs:insanity')) return
    event.source.directEntity.kill()
    event.cancel()
})




ItemEvents.rightClicked('kubejs:devils_deal', event => {
    goInsane(event.player)
    event.item.count -= 1
    Utils.server.scheduleInTicks(20 * 30, () => {
        removeInsanity(event.player)
    })
})

EntityEvents.hurt('sanitydim:sneaking_terror', event => {
    if (!event.source.player) return
    if (event.source.player.potionEffects.isActive('kubejs:insanity')) return
	event.entity.kill()
})




function goInsane(player) {
    Utils.server.runCommandSilent(`effect give ${player.username} kubejs:insanity infinite 0 false`)
    Utils.server.runCommandSilent(`effect give ${player.username} cofh_core:sundered infinite 1 false`)
    player.setSanity(0)
}

function removeInsanity(player) {
    Utils.server.runCommandSilent(`effect clear ${player.username} kubejs:insanity`)
    Utils.server.runCommandSilent(`effect clear ${player.username} cofh_core:sundered`)
    player.setSanity(100)
}



/**
 * Returns a boolean indicating if the player is insane or not
 * @param {*} player The player to check
 * @returns 
 */
function isInsane(player) {
    if (player.getSanity() <= 0) {
        return true
    } else {
        return false
    }
}




PlayerEvents.respawned(event => {
    Utils.server.runCommandSilent(`/sanity set ${event.player.username} 100`)
    let insanePlayers = event.server.entities.filter(entity => entity.isPlayer() && entity.potionEffects.isActive('kubejs:insanity'))
    let num = insanePlayers.length
    if (num != 0) return
    // Kill all sanitydim:rotting_stalker
    event.server.entities.filter(entity => entity.id == 'sanitydim:rotting_stalker').forEach(entity => {
        entity.kill()
    })
})
