/**
 * Killing a monster with an arrow will drop Arrows. Higher levels will drop stronger arrows and a random special Arrow. 15 Second Cooldown
 * Level 1: 1x Arrow
 * Level 2: 2x Arrow
 * Level 3: 1x Copper Arrow, 1x Arrow
 * Level 4: 2x Copper Arrow
 * Level 5: 2x Copper Arrow, 1x Arrow. Special Arrows: Flint Magnetic, Flint Tracking
 * Level 6: 3x Copper Arrow. Special Arrows: Flint Magnetic, Flint Tracking, Flint Freezing
 * Level 7: 3x Copper Arrow, 1x Iron Arrow. Special Arrows: Flint Magnetic, Flint Tracking, Flint Freezing, Flint Lightning
 * Level 8: 2x Copper Arrow, 2x Iron Arrow. Special Arrows: Flint Magnetic, Flint Tracking, Flint Freezing, Flint Lightning, Flint Explosive
 * Level 9: 1x Copper Arrow, 3x Iron Arrow. Special Arrows: Iron Magnetic, Iron Tracking, Iron Freezing, Iron Lightning, Iron Explosive
 * Level 10: 4x Iron Arrow. Special Arrows: 2x Iron Magnetic, 2x Iron Tracking, 2x Iron Freezing, 2x Iron Lightning, 2x Iron Explosive
 * 
 */




let hunters_bounty_elemental = {
    5: ['xtraarrows:flint_magnetic_arrow', 'xtraarrows:flint_tracking_arrow'],
    6: ['xtraarrows:flint_magnetic_arrow', 'xtraarrows:flint_tracking_arrow', 'xtraarrows:flint_freezing_arrow'],
    7: ['xtraarrows:flint_magnetic_arrow', 'xtraarrows:flint_tracking_arrow', 'xtraarrows:flint_freezing_arrow', 'xtraarrows:flint_lightning_arrow'],
    8: ['xtraarrows:flint_magnetic_arrow', 'xtraarrows:flint_tracking_arrow', 'xtraarrows:flint_freezing_arrow', 'xtraarrows:flint_lightning_arrow', 'xtraarrows:flint_explosive_arrow'],
    9: ['xtraarrows:iron_magnetic_arrow', 'xtraarrows:iron_tracking_arrow', 'xtraarrows:iron_freezing_arrow', 'xtraarrows:iron_lightning_arrow', 'xtraarrows:iron_explosive_arrow'],
    10: ['xtraarrows:iron_magnetic_arrow', 'xtraarrows:iron_tracking_arrow', 'xtraarrows:iron_freezing_arrow', 'xtraarrows:iron_lightning_arrow', 'xtraarrows:iron_explosive_arrow'],

}

function spawnItem (item, count, spawnEntity) {
    Utils.server.runCommandSilent(`execute in ${spawnEntity.level.dimension} run summon minecraft:item ${spawnEntity.x} ${spawnEntity.y} ${spawnEntity.z} {Item:{id:"${item}",Count:${count}}}`)
}


/* ────────────────────────────────────────────────────────────────
   Hunters Bounty – on-kill reward logic
   ──────────────────────────────────────────────────────────────── */
EntityEvents.death(event => {
    if (!event.source.player) return                     // Only player kills
    if (!event.entity.isMonster()) return                    // Only hostile mobs
    if (isAlly(event.source.player, event.entity)) return
    if (event.entity.maxHealth < 4) return               // Ignore very weak mobs
    let player = event.source.player
    if (!player.persistentData.get('hunters_bounty')) return
    if (isSkillCoolingDown(player, 'hunters_bounty')) return
    let level = player.persistentData.hunters_bounty

    /* -----------------------------------------------------------
       ⇢ 0. Check if kill was NOT made with a projectile
       ----------------------------------------------------------- */
    if (!arrowCheck(event.source)) {
        spawnItem('minecraft:arrow', 1, event.entity)    // Consolation arrow
    } else {
        /* -------------------------------------------------------
           ⇢ 1. Drop standard bounty items for this level
             New format:  { quantity : [ 'itemA', 'itemB', … ] }
           ------------------------------------------------------- */
            Utils.server.runCommandSilent(`/execute at ${event.entity.uuid} run loot spawn ~ ~1 ~ loot minecraft:loot_boxes/hunters_bounty_level_${level}`)


        /* -------------------------------------------------------
           ⇢ 2. Elemental bonus drops at lvl 5+
           ------------------------------------------------------- */
        if (level >= 5) {
            let pool = hunters_bounty_elemental[level] // array of IDs
            let roll = pool[Math.floor(Math.random() * pool.length)]
            spawnItem(roll, 1, event.entity)
            if (level === 10) spawnItem(roll, 1, event.entity) // extra at lvl 10
        }
    }
    // 5 second cooldown
    addSkillCooldown(player, 'hunters_bounty', 100)

})



