

function spreadEffect(attacker, reciever, effect, box_bounds, duration, amplifier) {
    let dim = reciever.level
    let box = AABB.of(reciever+box_bounds, reciever+box_bounds, reciever+box_bounds, reciever-box_bounds, reciever-box_bounds, reciever-box_bounds)
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent != attacker) {
            if (ent.isMonster()) {
                applyEffect(ent, effect, duration, amplifier)
            }
        }
    })

}


/**
 * 
 * @param {*} source The source of the event
 * @returns If the source is an arrow. False if not.
 */
function arrowCheck(source) {
    //console.log(source)
    if (!source.indirect) return false
    if (source.immediate.type.includes('throw')) return false
    if (source.toString().includes('arrow')) return true
    if (source.immediate.nbt.toString().includes('miapi:modular_arrow')) return true
    if (source.immediate.type.toString().includes('arrow')) return true
    return false
}
/**
 * Projectile Check includes:
 * - Arrows
 * - Bolts
 * - Tridents
 * - Throwables
 * - Shurikens
 * - Kunai
 * - Bullets
 * - Projectiles
 * - Spells
 */
function anyProjectileCheck(source) {
    if (source.indirect) {
        if (source.immediate.type.includes('summoned')) return false
        if (!source.immediate.type.includes('arrow') && !source.immediate.type.includes('bolt') && !source.immediate.type.includes('trident') && !source.immediate.type.includes('throw') && !source.immediate.type.includes('shuriken') && !source.immediate.type.includes('kunai') && !source.immediate.type.includes('bullet') && !source.immediate.type.includes('projectile') && !isSpellDamageSource(source)) {
            return false
        } else {
            return true
        }
    } else {
        return false
    }
}



/**
 * Physical Projectile Check includes:
 * - Arrows
 * - Bolts
 * - Tridents
 * - Throwables
 * - Shurikens
 * - Kunai
 * - Bullets
 * - Projectiles
 */

let physicalProjectileTypes = [
    'arrow', 'bolt', 'trident', 'thrown', 'shuriken', 'kunai', 'bullet', 'projectile', 'throw'
]
function physicalProjectileCheck(source) {
    if (source.indirect) {
        if (source.immediate.type.toString().includes('irons_spellbooks')) return false; // irons spellbooks are not physical projectiles, they are spellbooks
        if (arrowCheck(source)) return true
        if (throwableCheck(source)) return true
    } else {
        return false
    }
}

/**
 * 
 * @param {*} source the source of the hurt event. Almost always event.source
 * @param {*} sourcesToCheckFor This is what will determine True or False. Options are:
 * - spell (damage from any spell, including summoning spells)
 * - beast (pets from the beastmaster totem)
 * - specter (summoned creatures from spells)
 * - arrow (only arrows)
 * - throwable (only thrown items)
 * - melee (melee attacks. Also, some spells like flaming strike will use this)
 * - ranged (ranged attacks)
 * @param {*} playerOnlySources If true, only sources that are DIRECTLY from the player will be considered. If false, for example, ranged attacks from summons will return true for ranged 
 * @returns 
 */
function classifyDamageSource(source, sourceToCheckFor, playerOnlySources) {
  let sources = []
  if (isSpellDamageSource(source)) sources.push('spell')

  if (source.actual.persistentData && source.actual.persistentData.getString('owner') && source.actual.potionEffects && source.actual.potionEffects.isActive('kubejs:beast')) {
      sources.push('beast')
  }
  if (source.actual.persistentData && source.actual.persistentData.getString('owner') && source.actual.potionEffects && source.actual.potionEffects.isActive('kubejs:specter')) {
      sources.push('specter')
  }

  if (source.immediate.persistentData && source.immediate.persistentData.getString('owner') && source.immediate.potionEffects && source.immediate.potionEffects.isActive('kubejs:beast')) {
      sources.push('beast')
  }
  if (source.immediate.persistentData && source.immediate.persistentData.getString('owner') && source.immediate.potionEffects && source.immediate.potionEffects.isActive('kubejs:specter')) {
      sources.push('specter')
  }


    
  if (source.indirect) {
    if (arrowCheck(source)) sources.push('arrow')
    if (throwableCheck(source)) sources.push('throwable')
    if (!isSpellDamageSource(source) && 
    sources.includes('arrow') || sources.includes('throwable')) {
        sources.push('ranged')
    }
  } else {
    sources.push('melee')
  }

  if (playerOnlySources) {
    if (sources.includes('specter') || sources.includes('beast')) return false
  }

  return sources.includes(sourceToCheckFor)
}

EntityEvents.hurt(event => {
    if (!event.source) return
    if (!event.source.actual) return
    if (!event.source.indirect) return
    //Utils.server.tell(`is indirect: ${event.source.indirect}`)
    if (!event.source.actual.persistentData.getString('owner')) return
    if (!event.source.immediate.type.toString().includes('tossed_item')) return
    let owner = event.server.getPlayer(event.source.actual.persistentData.getString('owner'))
    if (!owner) return
    let damage = event.damage
    let monkey = event.source.actual.uuid
    Utils.server.runCommandSilent(`/damage ${event.entity.uuid} ${damage} minecraft:arrow by ${monkey} from ${owner.username}`)
    console.log(`/kill ${event.source.immediate.uuid}`)
    Utils.server.runCommandSilent(`/kill ${event.source.immediate.uuid}`)
    event.cancel()
})


EntityEvents.hurt(event => {
    if (!event.source) return
    if (!event.source.actual) return
    if (!arrowCheck(event.source)) return
    if (!event.source.actual.type.toString().includes('summoned')) return
    if (event.source.actual.potionEffects && event.source.actual.potionEffects.isActive('kubejs:specter')) {
        let owner = event.server.getPlayer(event.source.actual.persistentData.getString('owner'))
        let damage = event.damage
        let skeleton = event.source.actual.uuid
        Utils.server.runCommandSilent(`/damage ${event.entity.uuid} ${damage} minecraft:arrow by ${skeleton} from ${owner.username}`)
        console.log(`/kill ${event.source.immediate.uuid}`)
        Utils.server.runCommandSilent(`/kill ${event.source.immediate.uuid}`)
        event.cancel()
    }
})




/**
 * Lesser Projectile Check includes:
 *  - Arrows
 *  - Bolts
 *  - Tridents
 *  - Throwables
 */
function lesserphysicalProjectileCheck(source) {
    if (source.indirect) {
        if (!source.immediate.type.includes('arrow') && !source.immediate.type.includes('bolt') && !source.immediate.type.includes('trident') && !source.immediate.type.includes('throw')) {
            return false
        } else {
            return true
        }
    } else {
        return false
    }
}

/**
 * Throwables Check includes:
 *  - Tridents
 *  - Throwables
 * 
 */
function oldThrowableCheck(source) {
    //if (source.immediate == null || source.immediate.type == null) return false; // If the immediate type is null, return false
    if (source.indirect) {
        if (source.immediate.type.includes('throw') || source.immediate.type.includes('trident')) {
            return true
        } else {
            return false
        }
    } else {
        return false
    }
}

function throwableCheck(source) {
    //if (source.immediate == null || source.immediate.type == null) return false; // If the immediate type is null, return false
    if (source.indirect) {
        if (isSpellDamageSource(source)) return false
        if (arrowCheck(source)) return false
        return true
    } else {
        return false
    }
}


/**
 * Handle Projectile Ricochet: Ricochets the projectile off of the target and towards another enemy
 *  - projectileType: The type of projectile to ricochet between enemies
 *  - base_chance: The base chance of the ability to trigger. This is multiplied by the level of the ability to get the final chance.
 *  - base_damage: The base damage of the ability. This is multiplied by the level of the ability to get the final damage.
 *  - base_ricochets: The base number of ricochets the ability can have. This is multiplied by the level of the ability to get the final number of ricochets.
 *  - base_range: The base range of the ability. This is multiplied by the level of the ability to get the final range.
 *  - level: The level of the ability to use. Usually the level of the player's ability.
 *  - glowing: Whether or not the projectile should glow.
 * 
 * 
 */

function handleProjectileRicochet(event, projectileType, base_chance, base_damage, base_ricochets, base_range, level) {

    let player = event.source.player;
    let chance = base_chance * level;
    if (Math.random() * 100 > chance) return;

    let x = event.entity.getX();
    let y = event.entity.getY();
    let z = event.entity.getZ();

    let range = base_range * level;
    let box = AABB.of(x + range, y + 2, z + range, x - range, y - 2, z - range);

    let dim = event.level;
    let entitiesWithin = dim.getEntitiesWithin(box).filter(e => e.isMonster());

    // Damage of each projectile
    let damage = base_damage * level;

    // Maximum number of ricochets
    let max_ricochets = base_ricochets * level;

    let count = 0;
    let enemies = [];

    entitiesWithin.forEach(ent => {
        if (ent.isMonster()) {
            if (count > max_ricochets) return;
            count++;
            enemies.push(ent);
        }
    });

    if (enemies.length === 0) return;

    enemies.forEach((enemy, index) => {
        let nextEnemy = enemies[index + 1];
        if (!nextEnemy) return;

        Utils.server.scheduleInTicks(4 * (index + 1), () => {
            let projectile = dim.createEntity(projectileType);
            projectile.setPos(enemy.getX(), enemy.getY(), enemy.getZ());
            projectile.tags.add('Ricochet');

            let dir = {
                x: nextEnemy.getX() - enemy.getX(),
                y: nextEnemy.getY() + 1.5 - enemy.getY(),
                z: nextEnemy.getZ() - enemy.getZ()
            };

            let dirLength = Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);
            if (dirLength > 0) {
                projectile.setMotion(
                    (dir.x / dirLength) * 2.2,
                    (dir.y / dirLength) * 2.2,
                    (dir.z / dirLength) * 2.2
                );
            }

            projectile.mergeNbt(`{Owner:${player.username}, NoGravity:true, Damage:${damage}, Tags:["Owner:${player.username}"]}`);
            projectile.spawn();
            projectile.playSound('bosses_of_mass_destruction:comet_shoot', 10, 2);
            Utils.server.scheduleInTicks(40, () => {
                projectile.kill();
            });
        });
    });
}



function multiDropStaggered (target, item, nbt, player, count) {
    for (let i = 0; i < count; i++) {
        Utils.server.scheduleInTicks(10*i, () => {
            if (!target.alive) return
            let entity = target.level.createEntity(item)
            // random number between -30 and 30
            let randomX = Math.floor(Math.random() * 60) - 30
            let randomZ = Math.floor(Math.random() * 60) - 30
            entity.x = target.x+randomX
            entity.y = target.y+30
            entity.z = target.z+randomZ
            entity.mergeNbt(nbt)
            entity.mergeNbt({
                Owner: player.username,
                LeftOwner:true,
                Tags: ['primal_retribution']
            })
            entity.tags.add(`Target:${target.uuid}`)
            entity.spawn()
        })
    }
}
function multiShotStaggered (target, item, nbt, player, count, spawnEntity) {
    for (let i = 0; i < count; i++) {
        Utils.server.scheduleInTicks(8*i, () => {
            if (!target.alive) return
            let entity = target.level.createEntity(item)
            entity.x = spawnEntity.x
            entity.y = spawnEntity.y+1
            entity.z = spawnEntity.z
            entity.mergeNbt(nbt)
            entity.mergeNbt({
                Owner: player.username,
                LeftOwner:true,
                Tags: ['primal_retribution']
            })
            entity.tags.add(`Target:${target.uuid}`)
            entity.spawn()
        })
    }
}



/**
 * Spawns a number of split projectiles from an original projectile when it hits a target.
 * Each split projectile is aimed at a nearby enemy within a specified range.
 *
 * @param {Entity} originalProjectile - The projectile that triggered the split (usually the one that hit the enemy).
 * @param {number} splitCount - The number of new projectiles to spawn and target other enemies.
 * @param {string} projectileType - The entity ID of the projectile to spawn (e.g., "minecraft:arrow").
 * @param {number} base_damage - Base damage that each split projectile will deal.
 * @param {number} base_range - Base range to search for valid enemy targets, scaled by level.
 * @param {number} level - Level multiplier for scaling damage and range.
 */

function handleProjectileSplit(originalProjectile, splitCount, projectileType, base_damage, base_range, level) {
    let dim = originalProjectile.level;
    let player = originalProjectile.owner;

    // Get coordinates of the impact or origin point of the split
    let x = originalProjectile.getX();
    let y = originalProjectile.getY();
    let z = originalProjectile.getZ();
    
    // Define the area to search for enemies around the original impact location
    let range = base_range * level;
    let box = AABB.of(x + range, y + 1.5, z + range, x - range, y - 1.5, z - range);

    // Filter for hostile entities excluding the one that was already hit (if known)
    let entitiesWithin = dim.getEntitiesWithin(box).filter(e => e.isMonster());

    // Return early if no other valid targets are nearby
    if (entitiesWithin.length == 0) return;

    // Calculate damage dealt by split projectiles
    let damage = base_damage * level;

    // Only take as many targets as allowed by splitCount
    let count = 0;
    // Loop through each target and spawn a projectile directed toward it
    entitiesWithin.forEach((target) => {
        if (target.isMonster()) {
            count++;
            if (count <= splitCount) {
                Utils.server.scheduleInTicks(count, () => {
                    // Create the new projectile at the impact point
                    let newProj = dim.createEntity(projectileType);


                    // Compute directional vector from original projectile to target
                    let dir = {
                        x: target.getX() - x,
                        y: target.getY() + 1.5 - y, // Aim for upper body
                        z: target.getZ() - z
                    };
                    let length = Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);

                    let normDir = {
                        x: dir.x / length,
                        y: dir.y / length,
                        z: dir.z / length
                    };

                    // Offset spawn position by 1 block in direction of the target
                    let spawnX = x + normDir.x*2;
                    let spawnY = y + normDir.y*2;
                    let spawnZ = z + normDir.z*2;


                    // Normalize the direction vector and scale velocity
                    let dirLength = Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);
                    if (dirLength > 0) {
                        newProj.setMotion(
                            (dir.x / dirLength) * 1.5,
                            (dir.y / dirLength) * 1.5,
                            (dir.z / dirLength) * 1.5
                        );
                    }
                    newProj.setPos(spawnX, spawnY, spawnZ);
                    newProj.tags.add('Split');
                    // Set ownership, gravity settings, and damage
                    newProj.mergeNbt(`{Owner:"${player.username}", Damage:${damage}, Glowing:true, Tags:["Owner:${player.username}"]}`);
                    newProj.spawn();

                    // Play a firing sound effect
                    //newProj.playSound('bosses_of_mass_destruction:comet_shoot', 8, 2);

                    // Remove the projectile after 40 ticks to avoid buildup
                    Utils.server.scheduleInTicks(40, () => {
                        newProj.kill();
                    });
                });
            }
        }
    })
        
}


/**
 * @param {*} skill_level The level of the skill being checked
 * @param {*} event The event needed for the functions within this one
 * @param {*} type Can be 'arrow' or 'throwable'. It is what the base level check will look for. It will default to 1
 * @param {*} physicalCheckLevel The level that it should check for any physical projectile to be used. Usually 3
 * @param {*} anyCheckLevel The level that it would allow for any projectile to be used including spells. Usually 5
 */
function levelBetterProjectileCheck(skill_level, event, type, physicalCheckLevel, anyCheckLevel) {
    let trigger = false
    if (skill_level <= physicalCheckLevel) {
        //console.log(`skill level less than physical check level`)
        if (type == 'throwable') {
            //console.log(`throwable: ${throwable}`)
            return throwableCheck(event.source)
        } else if (type == 'arrow') {
            let arrow = arrowCheck(event.source)
            //console.log(`arrow: ${arrow}`)
            return arrow
        }
    }
    
    if (skill_level >= physicalCheckLevel && skill_level < anyCheckLevel) {
        if (physicalProjectileCheck(event.source)) {
            trigger = true
            //console.log(`physicalProjectileCheck passed`)
            return trigger
        }
    } 

    if (skill_level >= anyCheckLevel) {
        if (anyProjectileCheck(event.source)) {
            trigger = true
            //console.log(`anyProjectileCheck passed`)
            return trigger
        }
        
    }

    return trigger
}
