/**
 * Cold Snap
 *  - 2% chance to freeze an enemy when hitting them. Chance and strength increases with each level.
 */

// §aLevel 1: Freeze the enemy for 2 seconds
// §aLevel 3: Freeze the enemy for 4 seconds, apply Rend (-5% armor per level) for 4 seconds
EntityEvents.hurt(event => {
    if (!event.source.player) return;
    let player = event.source.player;
    if (event.entity.tags.contains('boss')) return
    if (!player.persistentData.get('kubejs_ability:cold_snap')) return;
    // 10% chance
    if (Math.random() > 0.02*player.persistentData.cold_snap) return;
    event.entity.potionEffects.add('mowziesmobs:frozen', 40*player.persistentData.cold_snap, 0)
    if (player.persistentData.cold_snap < 3) return
    event.entity.potionEffects.add('irons_spellbooks:rend', 40*player.persistentData.cold_snap, player.persistentData.cold_snap)
})


