//_______________________________________________________________________________________________________________________
//Essence of Whispers: Go insane and gain strength, haste, and invisibility for 2 minutes

/**
 * New Essence of Whispers:
 *  - Effect lasts for 1 minute
 *  - Player gains strength and haste for the entire duration
 *  - You also gain invis but lose it when attacking something.
 *  - If you dont hit anything for 5 seconds, you gain invis again
 */



/**
 * 
 * ItemEvents.pickedUp('kubejs:essence_of_whispers', event => {
    event.player.persistentData.putInt('eow_invis', 0)
})

ItemEvents.rightClicked('kubejs:essence_of_whispers', event => {
    //if (!event.player.persistentData.get('kubejs_class:shaman')) return
    let player = event.player
    let player_username = event.player.username
    Utils.server.runCommandSilent(`/sanity set ${player_username} 0`)
    Utils.server.runCommandSilent(`/stopsound ${player_username} music`)
    player.potionEffects.add('irons_spellbooks:true_invisibility', 1200, 1, true, false)
    player.potionEffects.add('minecraft:strength', 1200, 1, true, false)
    player.potionEffects.add('minecraft:haste', 1200, 1, true, false)
    player.tags.add('eow')
    player.tags.add('insane')
    player.cooldowns.addCooldown(event.item, 2400) // 2400 ticks = 2 minutes
    Utils.server.scheduleInTicks(1200, () => {
        Utils.server.runCommandSilent(`/sanity set ${player_username} 100`)
        player.tags.remove('insane')
        player.tags.remove('eow')
    })
})


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.tags.contains('eow')) return
    let player = event.source.player
    Utils.server.runCommandSilent(`/effect clear ${player.username} irons_spellbooks:true_invisibility`)
    player.tags.add('eow_no_invis')
    player.persistentData.eow_invis = 0
})

PlayerEvents.tick(event => {
    if (!event.player.tags.contains('eow_no_invis')) return
    let player = event.player
    player.persistentData.eow_invis++
    if (player.persistentData.eow_invis < 100) return
    player.persistentData.eow_invis = 0
    player.potionEffects.add('irons_spellbooks:true_invisibility', 1200, 1, true, false)
    player.tags.remove('eow_no_invis')
})



PlayerEvents.respawned(event => {
    let player = event.player
    //if (!player.persistentData.get('kubejs_class:mystic')) return
    player.tags.remove('insane')
    Utils.server.runCommandSilent(`/sanity set ${player.username} 100`)
})



//_______________________________________________________________________________________________________________________
//Essence of Aether
ItemEvents.rightClicked('kubejs:essence_of_aether', event => {
    let player = event.player
    let player_x = player.x
    let player_y = player.y
    let player_z = player.z

    let box = AABB.of(player_x+10, player_y+2, player_z+10, player_x-10, player_y-2, player_z-10)
    let dim = event.level
    let ent_counter = 1
    let entitiesWithin = dim.getEntitiesWithin(box).filter(entity => entity.isMonster())
    if (entitiesWithin.length == 0) return
    player.tags.add('essence_of_aether')
    Utils.server.scheduleInTicks(1000, () => {
       player.tags.remove('essence_of_aether')
    })
    entitiesWithin.forEach(near_player => {
        if (near_player == player) return
        if (near_player.tags.contains('tamed_beast')) return
        let uuid = near_player.uuid
        ent_counter++
        if (ent_counter > 10) return
        event.server.scheduleInTicks(21*ent_counter, () => {
            if (near_player.health > 0) {
                Utils.server.runCommandSilent(`/teleport ${player.username} ${near_player.x-2} ${near_player.y} ${near_player.z} facing entity ${uuid}`)
                player.setOnGround
                Utils.server.scheduleInTicks(2, () => {
                    let dim = event.level.dimension
                    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${player.username} divine_smite`)
                })
            }
        })
    })
    player.cooldowns.addCooldown(event.item, 12000)
})




EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.tags.contains('essence_of_aether')) return
    if (player.magicData.castingSpellId != 'irons_spellbooks:divine_smite') return
    //Utils.server.tell(player.magicData.castSource)
    if (player.magicData.castSource != 'COMMAND') return
    let ent = event.entity
    ent.potionEffects.add('levitation', 10, 10, true, true)
    Utils.server.scheduleInTicks(15, () => {
        if (ent.health < 100) {
            let x = ent.x
            let y = ent.y
            let z = ent.z
            ent.kill()
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexscaves:amber_monolith ${x} ${y} ${z} 0.5 0.5 0.5 1000000 2000 force @a`)
            ent.playSound('irons_spellbooks:cast.generic.lightning', 100, 1)
        }
    })
})

//_______________________________________________________________________________________________________________________
// Frost
// Ranger
ItemEvents.rightClicked('kubejs:essence_of_frost', event => {
    //if (!event.player.persistentData.get('kubejs_class:mystic')) return
    let player = event.player
    player.tags.add('essence_of_frost')
    //player.cooldowns.addCooldown(event.item, 4200)
    Utils.server.scheduleInTicks(600, () => {
        player.tags.remove('essence_of_frost')
    })
})



EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    let entity = event.entity
    if (!entity.maxHealth > 75) return
    // Check player class
    //if (!player.persistentData.get('kubejs_class:mystic')) return
    if (!player.tags.contains('essence_of_frost')) return
    if (!event.source.indirect) return
    //if (event.source.immediate.type != 'miapi:thrown_item') return
    entity.potionEffects.add('levitation', 40, 3)
    entity.tags.add('frostbite')
    entity.potionEffects.add('glowing', 30, 0)
    event.server.scheduleInTicks(25, () => {
        if (!entity.alive) return
        let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${player.username} ray_of_frost`)
    })
    event.server.scheduleInTicks(40, () => {
        entity.tags.remove('frostbite')
    })
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    //if (!player.persistentData.get('kubejs_class:mystic')) return
    let entity = event.entity
    if (event.entity.maxHealth > 75) return
    if (!player.tags.contains('essence_of_frost')) return
    //Utils.server.tell(player.magicData.castingSpellId)
    if (!player.magicData.castingSpellId.includes('ray_of_frost')) return
    if (!entity.tags.contains('frostbite')) return
    entity.kill()
})
 * 
 * 
 * 
 * 
 */







