// Runs every tick for each player
PlayerEvents.tick(event => {
  let player = event.player
  //if (player.level.isClientSide()) return // server-side only
  

  // Access Forge capabilities NBT (where Combat Dash stores its player variables)
  const nbt = player.nbt
  const caps = nbt.ForgeCaps
  if (!caps || !caps["combat_dash:player_variables"]) return

  const dashCaps = caps["combat_dash:player_variables"]
  const dashCooldown = dashCaps.DashCooldown ?? 0

  // Use persistentData to track dash state across ticks
  const data = player.persistentData
  const prevCooldown = data.getDouble
    ? data.getDouble("combat_dash_lastCooldown")
    : (data.combat_dash_lastCooldown || 0)

  // Detect a dash: DashCooldown decreased since last tick
  if (dashCooldown < prevCooldown) {
    // Start / refresh a short "dashing" window (in ticks)
    if (data.putInt) {
      data.putInt("combat_dash_dashingTicks", 10) // ~0.5s at 20 tps
    } else {
      data.combat_dash_dashingTicks = 10
    }
  }

  // Store current cooldown for next tick comparison
  if (data.putDouble) {
    data.putDouble("combat_dash_lastCooldown", dashCooldown)
  } else {
    data.combat_dash_lastCooldown = dashCooldown
  }
  //Utils.server.tell(player.speed)
  // Read and decrement our dashing timer
  let dashingTicks = data.getInt
    ? data.getInt("combat_dash_dashingTicks")
    : (data.combat_dash_dashingTicks || 0)

  if (dashingTicks > 0) {
    dashingTicks--

    if (data.putInt) {
      data.putInt("combat_dash_dashingTicks", dashingTicks)
    } else {
      data.combat_dash_dashingTicks = dashingTicks
    }
    
    if (!player.persistentData.getBoolean('is_dashing')) {
        applyEffect(player, 'kubejs:dashing', 20, 0, 'dashing', player)
        player.persistentData.putBoolean('is_dashing', true)
        //Utils.server.tell(player.persistentData.is_dashing)
        Utils.server.scheduleInTicks(20, () => {
            player.persistentData.putBoolean('is_dashing', false)
        })
        return
    }
    //Utils.server.tell(player.speed)
      // Touch detection while dashing
  if (player.persistentData.getBoolean('is_dashing')) {
    let p = player
    let radius = 1.5
    let box = AABB.of(p.x + radius, p.y + 1, p.z + radius, p.x - radius, p.y - 1, p.z - radius)
    let mobs = p.level.getEntitiesWithin(box).filter(e => !isAlly(p, e) && !e.tags.contains('boss') && e.pickable && e.isAlive() && e.persistentData.getBoolean('hit_by_dash') != true)
    if (mobs.length > 0) {
      let ent = mobs[0]
      //if (ent.tags.contains('boss')) return
      //if (ent.persistentData.getBoolean('hit_by_dash') == true) return
      
        // Compute lateral (side) direction relative to player facing
        let dx = ent.x - p.x
        let dz = ent.z - p.z
        let y_rad = p.yaw * JavaMath.PI / 180

        // Forward and Right vectors from player yaw
        let fx = -Math.sin(y_rad), fz = Math.cos(y_rad)
        let rx =  Math.cos(y_rad),  rz = Math.sin(y_rad)

        // Determine which side the target is on using dot with Right
        let sideDot  = dx * rx + dz * rz
        let sideSign = sideDot >= 0 ? 1 : -1

        // Knockback strength
        let strength = Number(player.speed) * 40

        // Strong forward bias, very light lateral push
        let lateralWeight  = 0.10
        let forwardWeight  = 0.90

        let vx = (rx * sideSign * lateralWeight + fx * forwardWeight) * strength
        let vz = (rz * sideSign * lateralWeight + fz * forwardWeight) * strength

      if (typeof ent.setMotion === 'function') {
        ent.setMotion(vx, 0.25, vz)
      } else {
        ent.addMotion(vx, 0.25, vz)
      }
      
      Utils.server.runCommandSilent(`/execute in ${p.level.dimension} run playsound kubejs:dash_smash ambient ${p.username} ${ent.x.toFixed(2)} ${ent.y.toFixed(2)} ${ent.z.toFixed(2)} 0.4 1.1`)
      // Bright yellow spark (R,G,B = 5,5,0)
      // Loop 4 times
      for (let i = 0; i < 4; i++) {
        Utils.server.scheduleInTicks(2*i, () => {
          Utils.server.runCommandSilent(`/execute in ${p.level.dimension} run particle clanginghowl:vertical_electric_shock 1.25 3 ${ent.x} ${ent.y+ent.eyeHeight} ${ent.z} 0 0 0 0.5 1`)
        })
      }
      applyEffect(ent, 'minecraft:slowness', 60, 0, 'dashing', p)
      ent.persistentData.putBoolean('hit_by_dash', true)
      Utils.server.runCommandSilent(`/damage ${ent.uuid} 5 minecraft:player_attack by ${p.username}`)
      Utils.server.scheduleInTicks(25, () => {
          ent.persistentData.putBoolean('hit_by_dash', false)
      })
    }
  }
  }
})
